function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/factory/impl/WidgetNodesToUxModelFactory
 */
define(['baja!', 'bajaux/model/UxModel', 'Promise', 'nmodule/bajaui/rc/ux/WebWidget', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/uxBuilder/rc/util/uxBuilderUtils', 'nmodule/webEditors/rc/servlets/registry'], function (baja, UxModel, Promise, WebWidget, asyncUtils, uxBuilderUtils, registry) {
  'use strict';

  var doRequire = asyncUtils.doRequire;
  var getAgentOnInfo = registry.getAgentOnInfo;
  var $getWidgetWrapperType = uxBuilderUtils.$getWidgetWrapperType;

  /**
   * This factory converts `bajaui:Widget` instances (typically from the palette) into `UxModel`
   * instances for insertion into the Widget Tree.
   *
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/factory/impl/WidgetNodesToUxModelFactory
   * @implements module:nmodule/uxBuilder/rc/ux/factory/UxModelFactory
   */
  return /*#__PURE__*/function () {
    function WidgetNodesToUxModelFactory() {
      _classCallCheck(this, WidgetNodesToUxModelFactory);
    }
    return _createClass(WidgetNodesToUxModelFactory, [{
      key: "canConvert",
      value:
      /**
       * @param {Array.<baja.Object>} objects
       * @returns {boolean} true if all objects are `bajaui:Widget`s
       */
      function canConvert(objects) {
        return objects.every(function (o) {
          return baja.hasType(o, 'bajaui:Widget');
        });
      }

      /**
       * @param {Array.<baja.Component>} widgets
       * @returns {Promise.<Array.<module:bajaux/model/UxModel>>}
       */
    }, {
      key: "convert",
      value: function convert(widgets) {
        var _this = this;
        var typeSpecs = widgets.map(function (w) {
          return String(w.getType());
        });
        return toUxMediaConstructors(typeSpecs).then(function (ctors) {
          return Promise.all(ctors.map(function (ctor, i) {
            var name = widgets[i].getName();
            var widget = _this.$clone(widgets[i]);
            var kidWidgets = [];
            var bindings = [];
            var properties = {};
            var metadata = {};
            if (typeSpecs[i] !== 'bajaui:NullWidget') {
              metadata.typeSpec = typeSpecs[i];
              metadata.pxDataTypeSpec = typeSpecs[i];
            }
            widget.getSlots().properties().each(function (slot) {
              // Include linkedPropertyPaths in the metadata when such slot is available in the widget.
              if (String(slot) === 'linkedPropertyPaths') {
                metadata.linkedPropertyPaths = JSON.parse(widget.get(slot));
                return;
              }

              // don't include non-Px values here: remember this is in response to the user dropping
              // a node onto the widget tree - they aren't editing *the pane*, they're editing *the
              // px file*. the widget tree reflects the contents of the px file.
              if (_this.$shouldBeOmittedFromPxData(widget, slot)) {
                return;
              }
              var val = widget.get(slot);
              if (val.getType().is('bajaui:Widget')) {
                kidWidgets.push(val);
              } else if (val.getType().is('bajaui:Binding')) {
                bindings.push(val);
              } else {
                properties[slot] = val;
              }
            });
            return $getWidgetWrapperType(widget.getType()).then(function (agentTypeSpec) {
              if (agentTypeSpec) {
                properties.js = baja.Ord.make('view:' + agentTypeSpec);
                ctor = WebWidget;
              }
              return _this.convert(kidWidgets);
            }).then(function (kids) {
              return UxModel.make({
                name: name,
                type: ctor,
                properties: properties,
                metadata: metadata,
                kids: kids,
                bindings: bindings
              });
            });
          }));
        });
      }

      /**
       * TODO: when we implement copy/paste for real, this may get fleshed out more.
       * WidgetCloningFactory calls through to BPxEditor#cloneWidget, which has a lot more complexity
       * than we have here. but i'm hopeful that in practice, none of it will be needed - it's copying
       * over a bunch of state that we don't maintain in the browser.
       *
       * @private
       * @param {baja.Component} widget
       * @returns {baja.Component}
       */
    }, {
      key: "$clone",
      value: function $clone(widget) {
        return widget.newCopy();
      }

      /**
       * return true if this child component is not considered to be part of Px data.
       *
       * this will have significant overlap with the implementation of PxEncoder.java, especially in
       * relation to encodeAs() returning NEVER. we want this to match pretty close because our
       * UxModel in the browser should reflect "the px data as sent to us by UxBuilderServlet," so we
       * don't want to pollute it with stuff that the UxBuilderServlet hides from us in the first
       * place. BScrollPane.hscrollBar etc.
       *
       * for now, in practice, we'll only omit transient values. PxEncoder also omits values that are
       * set to their defaults; it's ok not to omit them at drop-time because the user can always
       * manually enter the default value before saving. they will still get removed from the Px data
       * when it's saved on the server. non-transient widget kids we assume are UxMedia compatible
       * unless/until we need to support non-UxMedia widgets in UxBuilder.
       *
       * @private
       * @param {baja.Component} widget
       * @param {baja.Slot} slot
       * @returns {boolean}
       */
    }, {
      key: "$shouldBeOmittedFromPxData",
      value: function $shouldBeOmittedFromPxData(widget, slot) {
        return !!(widget.getFlags(slot) & baja.Flags.TRANSIENT);
      }
    }]);
  }();

  /**
   * @param {Array.<string|Type>} typeSpecs type specs of widgets that have UxMedia equivalents
   * (e.g. bajaui:Label)
   * @returns {Promise.<Array.<function>>} constructors of UxMedia widgets (e.g. Label.js)
   */
  function toUxMediaConstructors(typeSpecs) {
    return findUxMediaTypes(typeSpecs).then(function (types) {
      return Promise.all(types.map(function (type) {
        return doRequire(type.getJsId(), type.getJsDependencies());
      }));
    });
  }

  /**
   * @param {Array.<string|Type>} widgetTypes
   * @returns {Promise.<Array.<string>>}
   */
  function findUxMediaTypes(widgetTypes) {
    return getAgentOnInfo(widgetTypes.map(String), {
      is: 'bajaux:IJavaScriptWidget'
    }).then(function (typeInfoArrays) {
      return baja.importTypes(typeInfoArrays.map(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 1),
          typeInfo = _ref2[0];
        return typeInfo.type;
      }));
    });
  }
});
