function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/factory/impl/NavNodesToUxModelFactory
 */
define(['baja!', 'nmodule/uxBuilder/rc/ux/make/MakeWidget'], function (baja, MakeWidget) {
  'use strict';

  /**
   * This factory converts NavNodes to UxModel instances by showing the Make Widget dialog.
   *
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/factory/impl/NavNodesToUxModelFactory
   * @implements module:nmodule/uxBuilder/rc/ux/factory/UxModelFactory
   */
  return /*#__PURE__*/function () {
    function NavNodesToUxModelFactory() {
      _classCallCheck(this, NavNodesToUxModelFactory);
    }
    return _createClass(NavNodesToUxModelFactory, [{
      key: "canConvert",
      value:
      /**
       * @param {Array.<baja.NavNode>} navNodes
       * @returns {boolean} true if all are `baja:INavNode`s
       */
      function canConvert(navNodes) {
        return navNodes.every(function (n) {
          return baja.hasType(n, 'baja:INavNode');
        });
      }

      /**
       * Shows the MakeWidget dialog to allow the user to configure how these NavNodes are converted
       * to UxModels.
       * @param {Array.<baja.NavNode>} navNodes
       * @param {Object} [params] the object literal containing the method's arguments
       * @returns {Promise.<Array.<module:bajaux/model/UxModel>>}
       */
    }, {
      key: "convert",
      value: function convert(navNodes, params) {
        return MakeWidget.showFor(navNodes, params);
      }
    }]);
  }();
});
