function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/factory/impl/ImageNodesToUxModelFactory
 */

define(['baja!', 'baja!bajaui:Layout', 'Promise', 'bajaux/model/UxModel', 'nmodule/gx/rc/baja/Image', 'nmodule/webEditors/rc/util/htmlUtils', 'nmodule/bajaui/rc/ux/Label'], function (baja, types, Promise, UxModel, Image, htmlUtils, Label) {
  'use strict';

  var calculateImageDimensions = htmlUtils.calculateImageDimensions;

  /**
   * This factory converts 'gx:Image' instances into 'UxModel' instances for insertion into the widget tree
   * @since Niagara 4.15
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/factory/impl/ImageNodesToUxModelFactory
   * @implements module:nmodule/uxBuilder/rc/ux/factory/UxModelFactory
   */
  return /*#__PURE__*/function () {
    function ImageNodesToUxModelFactory() {
      _classCallCheck(this, ImageNodesToUxModelFactory);
    }
    return _createClass(ImageNodesToUxModelFactory, [{
      key: "canConvert",
      value:
      /**
       * @param objects
       * @returns {boolean} true if all the given objects images
       */
      function canConvert(objects) {
        return objects.every(function (object) {
          return baja.hasType(object, 'baja:IFile') && object.getMimeType().startsWith('image/');
        });
      }

      /**
       * Creates UxModels from the supplied image Files
       * @param {Array.<baja.file.File>} files the image Files to be converted
       * @returns {Promise.<Array.<module:bajaux/model/UxModel>>}
       */
    }, {
      key: "convert",
      value: function convert(files) {
        var x = 0;
        var y = 0;
        var promises = [];
        return Promise.all(files.map(function (file) {
          return calculateImageDimensions(file.getReadUri());
        })).then(function (sizes) {
          files.forEach(function (file, index) {
            var width = sizes[index][0];
            var height = sizes[index][1];
            promises.push(UxModel.make({
              type: Label,
              metadata: {
                typeSpec: 'bajaui:Label',
                pxDataTypeSpec: 'bajaui:Label'
              },
              properties: {
                image: Image.make([file.getOrdInSession()]),
                layout: baja.$('bajaui:Layout', x + ',' + y + ',' + width + ',' + height)
              }
            }));
            y = y + height;
          });
          return Promise.all(promises);
        });
      }
    }]);
  }();
});
