function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module:nmodule/uxBuilder/rc/ux/factory/UxModelFactory
 */
define(['Promise', 'underscore', 'nmodule/js/rc/asyncUtils/asyncUtils'], function (Promise, _, asyncUtils) {
  'use strict';

  var once = _.once;
  var doRequire = asyncUtils.doRequire,
    reduceAsync = asyncUtils.reduceAsync;

  // in the future, query registry for more (e.g. for the seriesTransform ones).
  var retrieveAllUxModelFactoryConstructors = once(function () {
    return doRequire(['nmodule/uxBuilder/rc/ux/factory/impl/WidgetNodesToUxModelFactory', 'nmodule/uxBuilder/rc/ux/factory/impl/ImageNodesToUxModelFactory', 'nmodule/uxBuilder/rc/ux/factory/impl/PxIncludeNodesToUxModelFactory', 'nmodule/uxBuilder/rc/ux/factory/impl/NavNodesToUxModelFactory']);
  });

  /**
   * UxModelFactory provides facilities for accepting objects from various sources (nav tree,
   * palette, etc.) and converting them into UxModels that can then be inserted into the Widget
   * Tree.
   *
   * @interface
   * @alias module:nmodule/uxBuilder/rc/ux/factory/UxModelFactory
   */
  return /*#__PURE__*/function () {
    function UxModelFactory() {
      _classCallCheck(this, UxModelFactory);
    }
    return _createClass(UxModelFactory, [{
      key: "canConvert",
      value:
      /**
       * @abstract
       * @param objects
       * @returns {boolean|Promise.<boolean>} true if all the given objects can be successfully
       * converted into UxModels
       */
      function canConvert(objects) {
        throw new Error('Must override method');
      }

      /**
       * @abstract
       * @param {*} objects
       * @param {Object} params
       * @returns {Promise.<Array.<module:bajaux/model/UxModel>|null>}
       * Resolves a falsy value if the conversion was cancelled.
       * Can resolve either an Array of UxModels or an UxMwConfig result object.
       *  - UxModel be will be converted from the given objects that can then be inserted into the Widget Tree.
       *  - If a pxProperties attribute is provided, the pxProperties will be updated as well.
       */
    }, {
      key: "convert",
      value: function convert(objects, params) {
        throw new Error('Must override method');
      }

      /**
       * @param {Array.<baja.Object>} objects
       * @returns {Promise.<module:nmodule/uxBuilder/rc/ux/factory/UxModelFactory|undefined>} a
       * UxModelFactory capable of converting the given objects
       */
    }], [{
      key: "forInserting",
      value: function forInserting(objects) {
        return retrieveAllUxModelFactoryConstructors().then(function (factoryCtors) {
          return reduceAsync(factoryCtors, function (foundInstance, CtorToTry) {
            if (foundInstance) {
              return foundInstance;
            }
            var instance = new CtorToTry();
            return Promise.resolve(instance.canConvert(objects)).then(function (success) {
              return success && instance;
            });
          });
        }).then(function (instance) {
          return instance || undefined;
        });
      }

      /**
       * Convert the given objects into UxModels for insertion into the page.
       *
       * @param {Array.<baja.Object>} objects
       * @param {module:nmodule/uxBuilder/rc/ux/commands/ReplaceUxModelCommand~ReplaceParams} [params]
       * @param {Array.<string>} [params.names] specify names if desired, otherwise auto-generated
       * names will be used
       * @returns {Promise.<Array.<module:bajaux/model/UxModel>|undefined>} to be resolved with the
       * converted UxModels, or with undefined if the conversion was not completed (e.g. user clicked
       * cancel)
       */
    }, {
      key: "toUxModels",
      value: function toUxModels(objects) {
        var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        return UxModelFactory.forInserting(objects).then(function (factory) {
          if (!factory) {
            throw new Error("cannot insert values [".concat(objects.join(), "]"));
          }
          return factory.convert(objects, params);
        });
      }
    }]);
  }();
});
