function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/commands/reorder/AbstractReorderCommand
 */
define(['bajaux/commands/Command', 'Promise', 'underscore', 'nmodule/uxBuilder/rc/util/uxBuilderUtils', 'nmodule/uxBuilder/rc/ux/commands/ReplaceUxModelCommand', 'nmodule/uxBuilder/rc/ux/model/UxModelTreeNode'], function (Command, Promise, _, uxBuilderUtils, ReplaceUxModelCommand, UxModelTreeNode) {
  'use strict';

  var isEqual = _.isEqual,
    noop = _.noop;
  var getCommonParentNode = uxBuilderUtils.getCommonParentNode,
    isFreeFormPane = uxBuilderUtils.isFreeFormPane,
    isReversed = uxBuilderUtils.isReversed,
    isUxModelEditable = uxBuilderUtils.isUxModelEditable,
    isUxModelLocked = uxBuilderUtils.isUxModelLocked;

  /**
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/commands/reorder/AbstractReorderCommand
   * @extends module:bajaux/commands/Command
   */
  return /*#__PURE__*/function (_Command) {
    function AbstractReorderCommand() {
      var _this;
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var nodes = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
      var pxLayers = arguments.length > 2 ? arguments[2] : undefined;
      _classCallCheck(this, AbstractReorderCommand);
      _this = _callSuper(this, AbstractReorderCommand, [Object.assign({
        func: function func() {
          return _this.$doReorder();
        }
      }, params)]);
      _this.$forceDisable = params.enabled === false;
      _this.setNodes(nodes, pxLayers);
      return _this;
    }

    /**
     * Update which nodes this command will operate on.
     *
     * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodes
     * @param {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxLayer>} [pxLayers] used to determine
     * whether these nodes should have reordering disabled due to being on a locked layer
     */
    _inherits(AbstractReorderCommand, _Command);
    return _createClass(AbstractReorderCommand, [{
      key: "setNodes",
      value: function setNodes(nodes) {
        var pxLayers = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
        this.$nodes = nodes;
        this.setEnabled(!this.$forceDisable && !!nodes.length && shareSameReorderableParent(nodes) && allEditable(nodes, pxLayers));
      }

      /**
       * The reorder commands are not themselves undoable, but delegate to ReplaceUxModelCommand,
       * which is undoable.
       *
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$doReorder",
      value: function $doReorder() {
        var _this2 = this;
        var nodes = this.$nodes;
        var parentNode = nodes[0].getParent();
        var parentModel = parentNode.value();
        var isInReversedPane = isReversed(parentModel);
        var allSiblingModels = parentModel.getKids();
        if (isInReversedPane) {
          allSiblingModels.reverse();
        }
        var indicesToMove = [];
        allSiblingModels.forEach(function (node, index) {
          var foundKid = nodes.find(function (kid) {
            return kid.value().getName() === node.getName();
          });
          if (foundKid) {
            indicesToMove.push(index);
          }
        });
        var reorderedSiblingModels = this.$reorderModels(indicesToMove, allSiblingModels.slice());
        if (isEqual(namesOf(allSiblingModels), namesOf(reorderedSiblingModels))) {
          return Promise.resolve();
        }
        if (isInReversedPane) {
          reorderedSiblingModels.reverse();
        }
        return Promise.all([parentModel.clone({
          kids: reorderedSiblingModels
        }), UxModelTreeNode.formatDisplayNames(nodes).then(function (formattedText) {
          return _this2.$getUndoRedoText(formattedText);
        })]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
            clonedModel = _ref2[0],
            _ref2$ = _ref2[1],
            _ref2$2 = _ref2$ === void 0 ? {} : _ref2$,
            redoText = _ref2$2.redoText,
            undoText = _ref2$2.undoText;
          return ReplaceUxModelCommand.add(parentNode.getParent(), [clonedModel], {
            names: [clonedModel.getName()],
            redoText: redoText,
            undoText: undoText,
            /*
            there may be a nicer way to do this - the default behavior of editing a node in the tree
            is to ensure it's selected - we don't want to do this because we're already working on
            selected nodes and NavTree reorder events already maintain selected status.
             */
            onRedo: noop
          });
        });
      }

      /**
       * @protected
       * @abstract
       * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodes
       * @returns {Promise.<{ redoText: string, undoText: string }>}
       */
    }, {
      key: "$getUndoRedoText",
      value: function $getUndoRedoText(nodes) {}

      /**
       * @protected
       * @abstract
       * @param {number[]} indicesToMove
       * @param {Array} arr
       */
    }, {
      key: "$reorderModels",
      value: function $reorderModels(indicesToMove, arr) {}
    }]);
  }(Command);
  function namesOf(models) {
    return models.map(function (model) {
      return model.getName();
    });
  }
  function shareSameReorderableParent(nodes) {
    var commonParent = getCommonParentNode(nodes);
    return commonParent && isFreeFormPane(commonParent.value());
  }
  function allEditable(nodes, pxLayers) {
    return nodes.every(function (node) {
      var uxModel = node.value();
      return isUxModelEditable(uxModel) && !isUxModelLocked(uxModel, pxLayers || []);
    });
  }
});
