function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

define(['baja!', 'bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'lex!uxBuilder', 'nmodule/uxBuilder/rc/util/uxBuilderUtils', 'nmodule/uxBuilder/rc/ux/AddConverterWidget', 'nmodule/webEditors/rc/fe/feDialogs'], function (baja, Command, CommandGroup, lexs, uxBuilderOrdUtils, AddConverterWidget, feDialogs) {
  'use strict';

  var $newBindingCopy = uxBuilderOrdUtils.$newBindingCopy;

  /**
   * API Status: **Private**
   * @exports nmodule/uxBuilder/rc/ux/commands/propertiesContextMenuCommands
   */
  var exports = {};
  var _lexs = _slicedToArray(lexs, 1),
    uxBuilderLex = _lexs[0];

  /**
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/commands/propertiesContextMenuCommands~AddConverterCommand
   * @extends module:bajaux/commands/Command
   */
  exports.AddConverterCommand = /*#__PURE__*/function (_Command) {
    /**
     * 
     * @param {String} propertyName 
     * @param {String} to converter `to` type spec 
     * @param {Array.<module:nmodule/bajaui/rc/baja/binding/Binding>} bindings
     * @param {module:nmodule/webEditors/rc/wb/PropertySheetRow} row the right-clicked row
     * @param {boolean} canAnimate 
     * @param {module:bajaux/Widget} propertiesWidget the owner widget to add/update a converter
     */
    function _class(propertyName, to, bindings, row, canAnimate, propertiesWidget) {
      _classCallCheck(this, _class);
      return _callSuper(this, _class, [{
        module: 'uxBuilder',
        lex: 'PropertiesWidget.commands.animate',
        enabled: canAnimate,
        func: function func() {
          return feDialogs.showFor({
            title: uxBuilderLex.get('PropertiesWidget.commands.animate.displayName'),
            value: {
              propertyName: propertyName,
              bindings: bindings,
              to: to
            },
            formFactor: 'compact',
            type: AddConverterWidget
          }).then(function (readValue) {
            if (readValue) {
              var selectedBinding = readValue.selectedBinding,
                converterValue = readValue.converterValue;
              var _ref = bindings.find(function (_ref2) {
                  var key = _ref2.key;
                  return key === selectedBinding;
                }) || {},
                key = _ref.key,
                bindingValue = _ref.bindingValue;
              var updatedBinding = $newBindingCopy(bindingValue),
                updatedValue = converterValue.newCopy(true);
              if (!updatedBinding.has(propertyName)) {
                updatedBinding.add({
                  slot: propertyName,
                  value: updatedValue
                });
              } else {
                updatedBinding.set({
                  slot: propertyName,
                  value: updatedValue
                });
              }
              return propertiesWidget.$doAnimateProperty(row, {
                key: key,
                value: updatedBinding
              });
            }
          });
        }
      }]);
    }
    _inherits(_class, _Command);
    return _createClass(_class);
  }(Command);

  /**
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/commands/propertiesContextMenuCommands~DeleteConverterCommand
   * @extends module:bajaux/commands/Command
   */
  exports.DeleteConverterCommand = /*#__PURE__*/function (_Command2) {
    /**
     * 
     * @param {module:nmodule/webEditors/rc/wb/PropertySheetRow} row the right-clicked row
     * @param {boolean} canUnanimate 
     * @param {module:bajaux/Widget} propertiesWidget the owner widget to add/update a converter
     */
    function _class2(row, canUnanimate, propertiesWidget) {
      _classCallCheck(this, _class2);
      return _callSuper(this, _class2, [{
        module: 'uxBuilder',
        lex: 'PropertiesWidget.commands.unanimate',
        enabled: canUnanimate,
        func: function func() {
          return propertiesWidget.$doUnanimateProperty(row);
        }
      }]);
    }
    _inherits(_class2, _Command2);
    return _createClass(_class2);
  }(Command);

  /**
   * @class
   * @inner
   * @alias module:nmodule/uxBuilder/rc/ux/commands/propertiesContextMenuCommands~LinkPxPropertyCommand
   * @extends module:bajaux/commands/Command
   */
  var LinkPxPropertyCommand = /*#__PURE__*/function (_Command3) {
    function LinkPxPropertyCommand(pxPropertyName, canLink, doLink) {
      _classCallCheck(this, LinkPxPropertyCommand);
      return _callSuper(this, LinkPxPropertyCommand, [{
        displayName: pxPropertyName,
        enabled: canLink,
        func: function func() {
          return doLink(pxPropertyName);
        }
      }]);
    }
    _inherits(LinkPxPropertyCommand, _Command3);
    return _createClass(LinkPxPropertyCommand);
  }(Command);
  /**
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/commands/propertiesContextMenuCommands~UnlinkPxPropertyCommand
   * @extends module:bajaux/commands/Command
   */
  exports.UnlinkPxPropertyCommand = /*#__PURE__*/function (_Command4) {
    function _class3(contextRow, propertiesWidget) {
      _classCallCheck(this, _class3);
      return _callSuper(this, _class3, [{
        module: 'uxBuilder',
        lex: 'PropertiesWidget.commands.unlink',
        func: function func() {
          return propertiesWidget.$doUnlinkFromPxProperty(contextRow);
        }
      }]);
    }
    _inherits(_class3, _Command4);
    return _createClass(_class3);
  }(Command);

  /**
   * Makes a 'Link' command group with sub commands for each PxProperty
   * @param {module:nmodule/uxBuilder/rc/ux/UxBuilderPropertySheetRow} contextRow
   * @param {String} targetType 
   * @param {module:nmodule/uxBuilder/rc/ux/sidebars/PropertiesWidget} propertiesWidget 
   * @returns {module:bajaux/commands/CommandGroup}
   */
  exports.makeLinkCommandGroup = function (contextRow, targetType, propertiesWidget) {
    var linkCmdGroup = new CommandGroup({
      displayName: uxBuilderLex.get('PropertiesWidget.commands.link.displayName'),
      icon: uxBuilderLex.get('PropertiesWidget.commands.link.icon')
    });
    var pxProperties = propertiesWidget.properties().getValue('pxProperties', {});
    var doLink = function doLink(pxPropertyName) {
      return propertiesWidget.$doLinkToPxProperty(contextRow, pxPropertyName);
    };
    Object.entries(pxProperties).forEach(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 2),
        pxPropertyName = _ref4[0],
        value = _ref4[1].value;
      var canLink = baja.hasType(value, targetType);
      linkCmdGroup.add(new LinkPxPropertyCommand(pxPropertyName, canLink, doLink));
    });
    return linkCmdGroup;
  };
  return exports;
});
