function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/commands/align/AlignCenterVerticallyCommand
 */

define(['lex!uxBuilder', 'Promise', 'nmodule/uxBuilder/rc/ux/commands/align/AbstractAlignCommand'], function (lexs, Promise, AbstractAlignCommand) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    uxBuilderLex = _lexs[0];

  /**
   * Aligns the selected widgets centered vertically
   * @since Niagara 4.15
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/commands/align/AlignCenterVerticallyCommand
   * @extends module:nmodule/uxBuilder/rc/ux/commands/align/AbstractAlignCommand
   */
  return /*#__PURE__*/function (_AbstractAlignCommand) {
    function AlignCenterVerticallyCommand() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var nodes = arguments.length > 1 ? arguments[1] : undefined;
      _classCallCheck(this, AlignCenterVerticallyCommand);
      return _callSuper(this, AlignCenterVerticallyCommand, [Object.assign({
        module: 'uxBuilder',
        lex: 'WidgetTree.command.align.middle'
      }, params), nodes]);
    }

    /**
     * @override
     * @private
     * @returns {{ redoText: string, undoText: string }}
     */
    _inherits(AlignCenterVerticallyCommand, _AbstractAlignCommand);
    return _createClass(AlignCenterVerticallyCommand, [{
      key: "$getUndoRedoText",
      value: function $getUndoRedoText(formattedNames) {
        return {
          redoText: uxBuilderLex.get('WidgetTree.command.align.middle.redo', formattedNames),
          undoText: uxBuilderLex.get('WidgetTree.command.align.middle.undo', formattedNames)
        };
      }

      /**
       * @override
       * @inheritDoc
       */
    }, {
      key: "$getAlignedUxModels",
      value: function $getAlignedUxModels() {
        var _this = this;
        var boundingClientRectsOfAllUxModels = this.$getBoundingClientRectsOfUxModels();
        var topMostY = Math.min.apply(Math, _toConsumableArray(boundingClientRectsOfAllUxModels.map(function (_ref) {
          var rect = _ref.rect;
          return rect.y;
        })));
        var bottomMostY = Math.max.apply(Math, _toConsumableArray(boundingClientRectsOfAllUxModels.map(function (_ref2) {
          var rect = _ref2.rect;
          return rect.y + rect.h;
        })));
        var centerPointY = (topMostY + bottomMostY) / 2;
        return Promise.all(boundingClientRectsOfAllUxModels.map(function (_ref3) {
          var uxModel = _ref3.uxModel,
            rect = _ref3.rect;
          var midPoint = (rect.y + (rect.y + rect.h)) / 2;
          var delta = midPoint - rect.y;
          rect.y = centerPointY - delta;
          return _this.$translateUxModelToNewRect({
            uxModel: uxModel,
            rect: rect
          });
        }));
      }
    }]);
  }(AbstractAlignCommand);
});
