function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/commands/align/AbstractAlignCommand
 */

define(['baja!', 'bajaux/commands/Command', 'Promise', 'underscore', 'nmodule/bajaui/rc/ux/CanvasPane', 'nmodule/bajaui/rc/ux/shape/Shape', 'nmodule/uxBuilder/rc/util/uxBuilderUtils', 'nmodule/uxBuilder/rc/util/wysiwygUtils', 'nmodule/uxBuilder/rc/ux/commands/ReplaceUxModelCommand', 'nmodule/uxBuilder/rc/ux/model/UxModelTreeNode'], function (baja, Command, Promise, _, CanvasPane, Shape, uxBuilderUtils, wysiwygUtils, ReplaceUxModelCommand, UxModelTreeNode) {
  'use strict';

  var noop = _.noop;
  var getCommonParentNode = uxBuilderUtils.getCommonParentNode,
    isUxModelEditable = uxBuilderUtils.isUxModelEditable,
    isUxModelLocked = uxBuilderUtils.isUxModelLocked;
  var _$translateUxModelToNewRect = wysiwygUtils.$translateUxModelToNewRect,
    _$getBoundingClientRectsOfUxModels = wysiwygUtils.$getBoundingClientRectsOfUxModels;

  /**
   * Abstract class to handle the shared logic for the align commands
   * @since Niagara 4.15
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/commands/align/AbstractAlignCommand
   * @extends module:bajaux/commands/Command
   */
  return /*#__PURE__*/function (_Command) {
    /**
     * @param {Object} params the commands parameters for this command
     * @param {Array<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} [nodes]
     * @param {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxLayer>} [pxLayers]
     */
    function AbstractAlignCommand() {
      var _this;
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var nodes = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
      var pxLayers = arguments.length > 2 ? arguments[2] : undefined;
      _classCallCheck(this, AbstractAlignCommand);
      _this = _callSuper(this, AbstractAlignCommand, [Object.assign({
        func: function func() {
          return _this.$doAlign();
        }
      }, params)]);
      _this.$forceDisabled = params.enabled === false;
      _this.$transferWidget = params.transferWidget;
      _this.setNodes(nodes, pxLayers);
      return _this;
    }

    /**
     * Update which nodes these commands will operate on.
     * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodes
     * @param {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxLayer>} [pxLayers] used to determine
     * whether these nodes should have reordering disabled due to being on a locked layer
     */
    _inherits(AbstractAlignCommand, _Command);
    return _createClass(AbstractAlignCommand, [{
      key: "setNodes",
      value: function setNodes(nodes) {
        var pxLayers = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
        this.$nodes = nodes;
        this.$models = nodes.map(function (node) {
          return node.value();
        });
        this.$parentNode = nodes[0] && nodes[0].getParent();
        this.setEnabled(nodes.length >= 2 && !this.$forceDisabled && !!nodes.length && getCommonParentNode(nodes) && this.$parentNode && this.$parentNode.value().$represents(CanvasPane) && allEditable(nodes, pxLayers));
      }

      /**
       * Returns the aligned UxModels.
       * @protected
       * @abstract
       * @returns {Array.<module:bajaux/model/UxModel>}
       */
    }, {
      key: "$getAlignedUxModels",
      value: function $getAlignedUxModels() {}

      /**
       * Returns the array of uxModel and their bounding rect wrapped in an object.
       * @protected
       * @returns {Array.<{uxModel: {module:bajaux/model/UxModel}, rect: {module:nmodule/bajaui/rc/baja/Layout~Rectangle}}>}
       */
    }, {
      key: "$getBoundingClientRectsOfUxModels",
      value: function $getBoundingClientRectsOfUxModels() {
        return _$getBoundingClientRectsOfUxModels(this.$getController(), this.$models);
      }

      /**
       * @protected
       * @param {object} obj
       * @param {module:bajaux/model/UxModel} obj.uxModel
       * @param {module:nmodule/bajaui/rc/baja/Layout~Rectangle} obj.rect
       * @returns {Promise.<module:bajaux/model/UxModel>}
       */
    }, {
      key: "$translateUxModelToNewRect",
      value: function $translateUxModelToNewRect(_ref) {
        var uxModel = _ref.uxModel,
          rect = _ref.rect;
        return _$translateUxModelToNewRect({
          uxModel: uxModel,
          rect: rect,
          controller: this.$getController()
        });
      }

      /**
       * @protected
       * @returns {module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayController}
       */
    }, {
      key: "$getController",
      value: function $getController() {
        return this.$transferWidget.$getPxStudio().$getPxOverlayController();
      }

      /**
       * The align commands are not themselves undoable, but delegate to ReplaceUxModelCommand,
       * which is undoable.
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$doAlign",
      value: function $doAlign() {
        var _this2 = this;
        var nodes = this.$nodes;
        var parentNode = this.$parentNode;
        var parentModel = this.$parentNode && this.$parentNode.value();
        return this.$getAlignedUxModels().then(function (models) {
          var alignedModels = models;
          var alignedModelNames = alignedModels.map(function (models) {
            return models.getName();
          });
          var kids = parentModel.getKids();
          alignedModels = kids.map(function (kid) {
            var idx = alignedModelNames.indexOf(kid.getName());
            if (idx !== -1) {
              return alignedModels[idx];
            }
            return kid;
          });
          return Promise.all([parentModel.clone({
            kids: alignedModels
          }), UxModelTreeNode.formatDisplayNames(nodes).then(function (formattedText) {
            return _this2.$getUndoRedoText(formattedText);
          })]);
        }).then(function (_ref2) {
          var _ref3 = _slicedToArray(_ref2, 2),
            clonedModel = _ref3[0],
            _ref3$ = _ref3[1],
            _ref3$2 = _ref3$ === void 0 ? {} : _ref3$,
            redoText = _ref3$2.redoText,
            undoText = _ref3$2.undoText;
          return ReplaceUxModelCommand.add(parentNode.getParent(), [clonedModel], {
            names: [clonedModel.getName()],
            redoText: redoText,
            undoText: undoText,
            onRedo: noop
          });
        });
      }

      /**
       * Returns the undo/redo text for the align command
       * @protected
       * @abstract
       * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodes
       * @returns {{ redoText: string, undoText: string }}
       */
    }, {
      key: "$getUndoRedoText",
      value: function $getUndoRedoText(nodes) {}
    }]);
  }(Command);

  /**
   * Returns true if the models for the supplied nodes are editable and not on a locked layer
   * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodes
   * @param {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxLayer>} pxLayers
   * @returns {boolean}
   */
  function allEditable(nodes, pxLayers) {
    return nodes.every(function (node) {
      var uxModel = node.value();
      return isUxModelEditable(uxModel) && !isUxModelLocked(uxModel, pxLayers || []);
    });
  }
});
