function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/commands/ReplaceUxModelCommand
 */
define(['lex!uxBuilder', 'bajaux/commands/Command', 'bajaux/model/UxModel', 'Promise', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/uxBuilder/rc/util/uxBuilderUtils', 'nmodule/uxBuilder/rc/util/uxModelUtils', 'nmodule/webEditors/rc/fe/baja/util/compUtils'], function (lexs, Command, UxModel, Promise, asyncUtils, uxBuilderUtils, uxModelUtils, compUtils) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    uxBuilderLex = _lexs[0];
  var reduceAsync = asyncUtils.reduceAsync;
  var generateUniqueNames = uxBuilderUtils.generateUniqueNames,
    getDesiredName = uxBuilderUtils.getDesiredName,
    requestSelection = uxBuilderUtils.requestSelection;
  var withKidsAdded = uxModelUtils.withKidsAdded;
  var formatDisplayNames = compUtils.formatDisplayNames;

  /**
   * This Command's job is to swap some nodes in the Widget Tree (source of truth for Px structure)
   * with some other ones.
   *
   * We do the swap, rather than just mutating the UxModel, for two reasons:
   *
   * 1. It helps ensure that rerenders happen as expected. If the same UxModel instance gets loaded
   *    into a widget in the Px page, even if it's been mutated, spandrel won't see a diff and no
   *    changes will be applied. If it's a new instance, the diff happens.
   * 2. It makes undo/redo easier: just hold onto the whole previous instance and swap it back in
   *    on an undo.
   *
   * This behavior relies on the cloning of UxModels working in a correct, well-defined way.
   *
   * We do an array of put-ops all at once, rather than one op per command, so we can do things like
   * select 10 labels and set all their backgrounds to red, and have that be one undoable operation
   * rather than have to click undo 10 times.
   *
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/commands/ReplaceUxModelCommand
   * @extends module:bajaux/commands/Command
   */
  var ReplaceUxModelCommand = /*#__PURE__*/function (_Command) {
    /**
     * @param {Array.<module:nmodule/uxBuilder/rc/ux/commands/ReplaceUxModelCommand~ReplaceOp>} ops
     * @param {module:nmodule/uxBuilder/rc/ux/commands/ReplaceUxModelCommand~ReplaceParams} [params]
     */
    function ReplaceUxModelCommand(ops) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      _classCallCheck(this, ReplaceUxModelCommand);
      var onRedo = params.onRedo,
        onUndo = params.onUndo,
        undoText = params.undoText,
        redoText = params.redoText;
      return _callSuper(this, ReplaceUxModelCommand, [Object.assign({
        undoable: function undoable() {
          return reifyOps(ops).then(function (ops) {
            var oldModels = ops.map(function (_ref) {
              var parentNode = _ref.parentNode,
                name = _ref.name;
              return parentNode.value().get(name);
            });
            var newNodes;

            // we have to use reduce for the case when parent and child are being changed at the
            // same time. if they run in parallel, the new child UxModel might get inserted into the
            // wrong parent UxModel and get lost.
            return {
              redo: function redo() {
                return reduceAsync(ops, function (newNodes, _ref2) {
                  var parentNode = _ref2.parentNode,
                    model = _ref2.model,
                    name = _ref2.name;
                  return parentNode.replaceKid(name, model).then(function () {
                    return parentNode.getKid(name);
                  }).then(function (kid) {
                    return [].concat(_toConsumableArray(newNodes), [kid]);
                  });
                }, []).then(function (nodes) {
                  newNodes = nodes;
                  return onRedo && onRedo(nodes);
                });
              },
              undo: function undo() {
                return reduceAsync(ops, function (_, _ref3, i) {
                  var parentNode = _ref3.parentNode,
                    model = _ref3.model,
                    name = _ref3.name;
                  return parentNode.replaceKid(name, oldModels[i]);
                }).then(function () {
                  return onUndo && onUndo(newNodes);
                });
              },
              undoText: undoText,
              redoText: redoText
            };
          });
        }
      }, params)]);
    }

    /**
     * Developers: you probably don't want to call this directly - call `parentNode.insert()`
     * instead, which has some extra smarts.
     *
     * Add the given models to the specified parent node. The new nodes will request selection after
     * they are added, and when re-removed on undo, the selection will be cleared.
     *
     * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} parentNode
     * @param {Array.<module:bajaux/model/UxModel|module:bajaux/model/UxModel~UxModelParams>} models
     * @param {module:nmodule/uxBuilder/rc/ux/commands/ReplaceUxModelCommand~ReplaceParams} [params]
     * @param {Array.<string>} [params.names] the names to assign to the new nodes. will be
     * auto-generated if omitted.
     * @returns {Promise}
     */
    _inherits(ReplaceUxModelCommand, _Command);
    return _createClass(ReplaceUxModelCommand, null, [{
      key: "add",
      value: function add(parentNode, models) {
        var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
        var names = params.names,
          _onRedo = params.onRedo,
          onUndo = params.onUndo;
        var parentName = parentNode.getName();
        var grandparentNode = parentNode.getParent();
        if (!grandparentNode) {
          return Promise.reject(new Error('ReplaceUxModelCommand cannot add to an unparented node'));
        }
        var modelToAddTo = parentNode.value();
        return Promise.all(models.map(function (model) {
          return UxModel.make(model);
        })).then(function (models) {
          if (!names) {
            var existingNames = namesOf(parentNode.value().getKids());
            names = generateUniqueNames(existingNames, models.map(function (newKid) {
              return getDesiredName(newKid);
            }));
          }
          if (names.length !== models.length) {
            throw new Error(uxBuilderLex.get('errors.namesToUxModelLengthMismatch', models.length, names.length));
          }
          return Promise.all(models.map(function (model, i) {
            return model.clone({
              name: names[i]
            });
          }));
        }).then(function (newModels) {
          return withKidsAdded(modelToAddTo, newModels);
        }).then(function (model) {
          var displayNames = formatDisplayNames(names);
          var handleNewKidsOf = function handleNewKidsOf(newParentNode, handle) {
            return Promise.all(names.map(function (name) {
              return newParentNode.getKid(name);
            })).then(function (newKids) {
              return handle(newKids);
            });
          };
          return new ReplaceUxModelCommand([{
            parentNode: grandparentNode,
            model: model
          }], Object.assign({
            redoText: uxBuilderLex.get('commands.add.redoText', displayNames, parentName),
            undoText: uxBuilderLex.get('commands.add.undoText', displayNames, parentName)
          }, params, {
            onRedo: function onRedo(_ref4) {
              var _ref5 = _slicedToArray(_ref4, 1),
                addedNode = _ref5[0];
              return handleNewKidsOf(addedNode, _onRedo || requestSelection);
            },
            onUndo: onUndo
            // no requestDeselection needed - nodes are automatically deselected on removal from the tree
          })).invoke();
        });
      }

      /**
       * Replaces the UxModel in the parent node that match with the model name.
       * 
       * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} parentNode
       * @param {String} name UxModel name that is yet to be replaced
       * @param {module:bajaux/model/UxModel|module:bajaux/model/UxModel} renamedUxModel
       * @param {module:nmodule/uxBuilder/rc/ux/commands/ReplaceUxModelCommand~ReplaceParams} [params]
       * @returns {Promise}
       */
    }, {
      key: "replace",
      value: function replace(parentNode, name, renamedUxModel) {
        var params = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
        var grandParentNode = parentNode.getParent();
        var parentModel = parentNode.value();
        var kids = parentModel.getKids();
        kids = kids.map(function (kid) {
          if (kid.getName() === name) {
            return renamedUxModel;
          }
          return kid;
        });
        return parentModel.clone({
          kids: kids
        }).then(function (newParentModel) {
          return new ReplaceUxModelCommand([{
            parentNode: grandParentNode,
            model: newParentModel
          }], params).invoke();
        });
      }

      /**
       * @constructor
       * @returns {Function}
       * @see module:nmodule/uxBuilder/rc/ux/commands/ReplaceUxModelCommand~AddCommand
       */
    }, {
      key: "AddCommand",
      get: function get() {
        return AddCommand;
      }
    }]);
  }(Command);
  /**
   * @class AddCommand
   * @memberOf module:nmodule/uxBuilder/rc/ux/commands/ReplaceUxModelCommand
   * @extends module:bajaux/commands/Command
   */
  var AddCommand = /*#__PURE__*/function (_Command2) {
    /**
     * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} parentNode
     * @param {Array.<module:bajaux/model/UxModel>} models
     * @param {module:nmodule/uxBuilder/rc/ux/commands/ReplaceUxModelCommand~ReplaceParams} params
     */
    function AddCommand(parentNode, models, params) {
      _classCallCheck(this, AddCommand);
      return _callSuper(this, AddCommand, [Object.assign({
        func: function func() {
          // just call insert(): UxModelTreeNode itself handles some extra "add a node" logic and
          // just circles back around to ReplaceUxModelCommand anyway
          return parentNode.insert(models.map(function (object) {
            return {
              object: object
            };
          }), params);
        }
      }, params)]);
    }
    _inherits(AddCommand, _Command2);
    return _createClass(AddCommand);
  }(Command);
  function reifyOps(ops) {
    return Promise.all(ops.map(function (_ref6) {
      var parentNode = _ref6.parentNode,
        model = _ref6.model,
        name = _ref6.name;
      return UxModel.make(model).then(function (model) {
        return {
          parentNode: parentNode,
          model: model,
          name: name || model.getName()
        };
      });
    }));
  }
  function namesOf(nodes) {
    return nodes.map(function (n) {
      return n.getName();
    });
  }
  return ReplaceUxModelCommand;
});

/**
 * Represents one "put" operation: place a new UxModel as a child of the given Widget Tree node.
 *
 * @typedef {object} module:nmodule/uxBuilder/rc/ux/commands/ReplaceUxModelCommand~ReplaceOp
 * @property {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} parentNode
 * @property {module:bajaux/model/UxModel} model the new UxModel that should be stored under
 * `name`.
 * @property {string} name
 */

/**
 * @typedef {object} module:nmodule/uxBuilder/rc/ux/commands/ReplaceUxModelCommand~ReplaceParams
 * @property {string|function} [redoText]
 * @property {string|function} [undoText]
 * @property {function(Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>)} [onRedo] a
 * function that will receive the created or updated UxModelTreeNodes to select
 * @property {function(Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>)} [onUndo] a
 * function that will receive the created or updated UxModelTreeNodes to select
 */
