function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/commands/RemovePaneCommand
 */

define(['baja!', 'baja!bajaui:Layout', 'bajaux/commands/Command', 'bajaux/model/UxModel', 'Promise', 'nmodule/bajaui/rc/ux/CanvasPane', 'nmodule/bajaui/rc/ux/NullWidget', 'nmodule/js/rc/asyncUtils/asyncUtils'], function (baja, types, Command, UxModel, Promise, CanvasPane, NullWidget, asyncUtils) {
  'use strict';

  var reduceAsync = asyncUtils.reduceAsync;

  /**
   * Removes the Pane from the selected widgets. This works for both BorderPanes and ResponsivePanes.
   * Any pane that is storing its main content as a child called 'content' can use this command. 
   * @since Niagara 4.15
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/commands/RemovePaneCommand
   * @extends module:/bajaux/commands/Command
   */
  var RemovePaneCommand = /*#__PURE__*/function (_Command) {
    /**
     * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} selectedNodes
     * @param {module:nmodule/uxBuilder/rc/ux/commands/RemovePaneCommand~RemovePaneParams} params
     */

    function RemovePaneCommand(selectedNodes, params) {
      var _this;
      _classCallCheck(this, RemovePaneCommand);
      return _this = _callSuper(this, RemovePaneCommand, [Object.assign({
        undoable: function undoable() {
          return _this.$makeUndoable(selectedNodes, params);
        }
      }, params)]);
    }

    /**
     * @protected
     * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} selectedNodes
     * @param {object} params
     * @param {string|function} [params.redoText]
     * @param {string|function} [params.undoText]
     * @returns {Promise.<module:bajaux/commands/Command~Undoable>}
     */
    _inherits(RemovePaneCommand, _Command);
    return _createClass(RemovePaneCommand, [{
      key: "$makeUndoable",
      value: function $makeUndoable(selectedNodes) {
        var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          redoText = _ref.redoText,
          undoText = _ref.undoText;
        var undoPaneRemoveOps;
        var paneOps = makePaneOps(selectedNodes);
        return Promise.resolve({
          redo: function redo() {
            undoPaneRemoveOps = [];
            return reduceAsync(paneOps, function (_, _ref2) {
              var parentNode = _ref2.parentNode,
                namesToRemovePane = _ref2.namesToRemovePane;
              var grandparent = parentNode.getParent();
              var originalParentModel = parentNode.value();
              var parentName = originalParentModel.getName();
              return withPanesRemoved(originalParentModel, namesToRemovePane).then(function (parentWithoutPane) {
                undoPaneRemoveOps.push({
                  parentNode: grandparent,
                  model: originalParentModel,
                  name: parentName
                });
                return grandparent.replaceKid(parentName, parentWithoutPane);
              });
            });
          },
          undo: function undo() {
            return reduceAsync(undoPaneRemoveOps.reverse(), function (_, _ref3) {
              var parentNode = _ref3.parentNode,
                model = _ref3.model,
                name = _ref3.name;
              return parentNode.replaceKid(name, model);
            });
          },
          undoText: undoText,
          redoText: redoText
        });
      }

      /**
       * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} selectedNodes
       * @param {module:nmodule/uxBuilder/rc/ux/commands/RemovePaneCommand~RemovePaneParams} [params]
       * @returns {Promise}
       */
    }], [{
      key: "removePane",
      value: function removePane(selectedNodes, params) {
        return new RemovePaneCommand(selectedNodes, params).invoke();
      }
    }]);
  }(Command);
  /**
   * Given the nodes to remove a pane from, turn them into an array of PaneOps:  each one will add a
   * parent of selected nodes, with a clone that has the panes removed
   * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} selectedNodes
   * @returns {Array.<module:nmodule/uxBuilder/rc/ux/commands/AddPaneCommand~PaneOp>}
   */
  function makePaneOps(selectedNodes) {
    return coalesceRemovePanes(selectedNodes).sort(function (a, b) {
      return deepestToShallowest(a.parentNode, b.parentNode);
    });
  }

  /**
   * Group the nodes to remove panes from by their parent nodes.  That is: if removing a pane to three
   * children of one parent, that's one PaneOp for that parent.
   * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} selectedNodes
   * @returns {Array.<module:nmodule/uxBuilder/rc/ux/commands/AddPaneCommand~PaneOp>}
   */
  function coalesceRemovePanes(selectedNodes) {
    var parentPathMap = {};
    selectedNodes.slice().sort(shallowestToDeepest).forEach(function (node) {
      var parentNode = node.getParent();
      var parentPathStr = parentNode.getFullPath().join('/');
      var paneObj = parentPathMap[parentPathStr] || (parentPathMap[parentPathStr] = {
        namesToRemovePane: [],
        parentNode: parentNode
      });
      paneObj.namesToRemovePane.push(node.getName());
    });
    return Object.values(parentPathMap);
  }
  function withPanesRemoved(parentModel, namesToRemovePane) {
    var children = parentModel.getKids();
    return Promise.all(children.map(function (child) {
      if (namesToRemovePane.includes(child.getName())) {
        return removePane(parentModel, child);
      }
      return child;
    })).then(function (newChildren) {
      newChildren = newChildren.filter(function (child) {
        return child !== undefined && child !== null && child.getType() !== NullWidget;
      });
      return parentModel.clone({
        kids: newChildren
      });
    });
  }
  function removePane(parentModel, node) {
    var name = node.getName();
    var layout = parentModel.$represents(CanvasPane) ? node.getProperties().layout : baja.$("bajaui:Layout");
    var content = node.getKids().filter(function (kid) {
      return kid.getName() === 'content';
    })[0];
    if (content) {
      return content.clone({
        name: name,
        properties: {
          layout: layout
        }
      });
    } else if (name !== 'root') {
      return UxModel.make({
        type: NullWidget,
        name: name,
        metadata: {
          typeSpec: 'bajaui:NullWidget',
          pxDataTypeSpec: 'bajaui:NullWidget'
        },
        properties: {
          layout: layout
        }
      });
    }
  }
  function shallowestToDeepest(a, b) {
    return a.getFullPath().length - b.getFullPath().length;
  }
  function deepestToShallowest(a, b) {
    return -shallowestToDeepest(a, b);
  }
  return RemovePaneCommand;
});

/**
 * Represents one "remove pane" operation: remove a pane from some children of a given WidgetTree node
 *
 * @typedef {object} module:nmodule/uxBuilder/rc/ux/commands/RemovePaneCommand~PaneOp
 * @property {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} parentNode
 * @property {Array.<string>} namesToRemovePane
 */

/**
 * @typedef {object} module:nmodule/uxBuilder/rc/ux/commands/RemovePaneCommand~RemovePaneParams
 * @property {string|function} [redoText]
 * @property {string|function} [undoText]
 * @property {function(Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>)} [onNewNodes] a function that will
 * be called when the main pane is removed from widgets.
 */
