function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/commands/PxRenameCommand
 */

define(['lex!', 'lex!uxBuilder', 'bajaux/commands/Command', 'nmodule/uxBuilder/rc/util/uxBuilderEvents', 'nmodule/webEditors/rc/fe/feDialogs'], function (lex, lexs, Command, uxBuilderEvents, feDialogs) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    uxBuilderLex = _lexs[0];
  var ALL = Command.flags.ALL;

  /**
   * This command is used to rename selected rows from the Px Properties or Layers widget edit tables.
   *
   * @since Niagara 4.15
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/commands/PxRenameCommand
   * @extends module:bajaux/commands/Command
   * @see module:nmodule/webEditors/rc/wb/table/Table
   * @param {Function} getTable a function that returns the target table for this command
   * @param {String} [params.colName='name'] the name of the column to be edited to rename the row
   * @param {String} [params.module='uxBuilder'] the name of the module to look up the commands lexicon entries
   * @param {String} [params.lex='UxBuilder.commands.rename'] the lexicon key to look up the command with
   * @param {Command.flags} [params.flags] Any special Command flags for the command
   * @param {Boolean} [params.undoable] true if the command should be undoable
   */
  return /*#__PURE__*/function (_Command) {
    function PxRenameCommand(getTable) {
      var _this;
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      _classCallCheck(this, PxRenameCommand);
      var _params$colName = params.colName,
        colName = _params$colName === void 0 ? 'name' : _params$colName,
        _params$flags = params.flags,
        flags = _params$flags === void 0 ? ALL : _params$flags,
        _params$module = params.module,
        module = _params$module === void 0 ? 'uxBuilder' : _params$module,
        _params$lex = params.lex,
        lex = _params$lex === void 0 ? 'UxBuilder.commands.rename' : _params$lex,
        undoable = params.undoable;
      _this = _callSuper(this, PxRenameCommand, [{
        flags: flags,
        module: module,
        lex: lex,
        func: function func() {
          return _this.$handleRename(getTable);
        },
        undoable: undoable && function () {
          var model = getTable().getModel();
          var nameBeforeWeRenamed,
            nameAfterWeRenamed,
            call = 0,
            allRowsBefore = model.getRows(),
            allrowsAfter;
          var table = getTable();
          var selection = table.$getSelection();
          var rows = selection.getSelectedElements(model.getRows());
          return {
            undo: function undo() {
              rows[0].getSubject().name.value = nameBeforeWeRenamed;
              return model.clearRows().then(function () {
                model.insertRows(allRowsBefore);
                getTable().setModified(true);
              });
            },
            redo: function redo() {
              if (call === 0) {
                call++;
                nameBeforeWeRenamed = rows[0].getSubject().name.value;
                return _this.$handleRename(getTable).then(function () {
                  nameAfterWeRenamed = rows[0].getSubject().name.value;
                  allrowsAfter = model.getRows();
                });
              }
              rows[0].getSubject().name.value = nameAfterWeRenamed;
              return model.clearRows().then(function () {
                model.insertRows(allrowsAfter);
                getTable().setModified(true);
              });
            },
            redoText: function redoText() {
              return uxBuilderLex.get('PxLayersWidget.commands.rename.redoText', nameBeforeWeRenamed, nameAfterWeRenamed);
            },
            undoText: function undoText() {
              return uxBuilderLex.get('PxLayersWidget.commands.rename.undoText', nameAfterWeRenamed, nameBeforeWeRenamed);
            }
          };
        },
        enabled: false
      }]);
      _this.$colName = colName;
      _this.$module = module;
      _this.$lex = lex;

      /**
       * When called determines if the command should be enabled or not.
       * @private
       */
      _this.$updateEnabled = function () {
        var selectedRows = getTable().getSelectedRows();
        _this.setEnabled(selectedRows.length === 1);
      };
      return _this;
    }

    /**
     * Loads values for the title and error message from the lexicon
     * @private
     * @returns {Promise}
     */
    _inherits(PxRenameCommand, _Command);
    return _createClass(PxRenameCommand, [{
      key: "$loadTextFromLex",
      value: function $loadTextFromLex() {
        var _this2 = this;
        return lex.module(this.$module).then(function (moduleLex) {
          var title = moduleLex.get(_this2.$lex + ".title");
          var dupErr = moduleLex.get(_this2.$lex + ".errors.duplicate");
          var emptyErr = moduleLex.get(_this2.$lex + ".errors.emptyName");
          if (!title) {
            title = uxBuilderLex.get("UxBuilder.commands.rename.title");
          }
          if (!dupErr) {
            dupErr = uxBuilderLex.get("UxBuilder.commands.rename.errors.duplicate");
          }
          if (!emptyErr) {
            emptyErr = uxBuilderLex.get("UxBuilder.commands.rename.errors.emptyName");
          }
          _this2.$title = title;
          _this2.$dupErr = dupErr;
          _this2.$emptyErr = emptyErr;
        });
      }

      /**
       * Prompts for a new name and applies it to the selected row in the table
       * @private
       * @param {Function} getTable a function that returns the target table for this command
       * @returns {Promise}
       */
    }, {
      key: "$handleRename",
      value: function $handleRename(getTable) {
        var _this3 = this;
        var table = getTable();
        var row = table.getSelectedRows()[0];
        var subject = row.getSubject();
        var editColumn = subject[this.$colName];
        var oldName = editColumn.value;
        return this.$loadTextFromLex().then(function () {
          return _this3.$promptForNewName(table, oldName);
        }).then(function (newName) {
          if (newName) {
            editColumn.value = newName;
            return table.read().then(function (updatedTable) {
              return table.loadAndModify(updatedTable);
            }).then(function () {
              return table.trigger('rowsRenamed', [row], [oldName]);
            });
          }
        });
      }

      /**
       * @private
       * @param {module:nmodule/webEditors/rc/wb/table/Table} table
       * @param {string} oldName
       * @returns {Promise.<string|null>}
       */
    }, {
      key: "$promptForNewName",
      value: function $promptForNewName(table, oldName) {
        var _this4 = this;
        var row = table.getSelectedRows()[0];
        return feDialogs.showFor({
          value: oldName,
          title: this.$title,
          formFactor: 'mini',
          validate: function validate(newName) {
            return _this4.$validateInput(newName, table, row);
          }
        });
      }

      /**
       * Compares the new name to the names already in the table, to make sure the new name is unique
       * @private
       * @param {String} newName the new name for the row
       * @param {module:nmodule/webEditors/rc/wb/table/Table} table the table holding the rows to be edited
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row the row that is being edited
       */
    }, {
      key: "$validateInput",
      value: function $validateInput(newName, table, row) {
        var _this5 = this;
        var model = table.getModel();
        var selectedIndex = model.getRowIndex(row);
        var rows = model.getRows();
        rows.forEach(function (row, index) {
          if (index !== selectedIndex) {
            var testSubject = row.getSubject();
            var testColumn = testSubject[_this5.$colName];
            var testName = testColumn.value;
            if (!newName) {
              throw new Error(_this5.$emptyErr);
            }
            if (testName === newName) {
              throw new Error(_this5.$dupErr);
            }
          }
        });
      }
    }]);
  }(Command);
});
