function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/commands/ModifyUxModelCommand
 */
define(['bajaux/commands/Command', 'bajaux/model/UxModel', 'Promise', 'nmodule/js/rc/asyncUtils/asyncUtils'], function (Command, UxModel, Promise, asyncUtils) {
  'use strict';

  var reduceAsync = asyncUtils.reduceAsync;

  /**
   * This Command's job is to swap some nodes in the Widget Tree (source of truth for Px structure)
   * with some other ones.
   *
   * We do the swap, rather than just mutating the UxModel, for two reasons:
   *
   * 1. It helps ensure that rerenders happen as expected. If the same UxModel instance gets loaded
   *    into a widget in the Px page, even if it's been mutated, spandrel won't see a diff and no
   *    changes will be applied. If it's a new instance, the diff happens.
   * 2. It makes undo/redo easier: just hold onto the whole previous instance and swap it back in
   *    on an undo.
   *
   * This behavior relies on the cloning of UxModels working in a correct, well-defined way.
   *
   * We do an array of modify-ops all at once, rather than one op per command, so we can do things like
   * select 10 labels and set all their backgrounds to red, and have that be one undoable operation
   * rather than have to click undo 10 times.
   *
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/commands/ModifyUxModelCommand
   * @extends module:bajaux/commands/Command
   */
  return /*#__PURE__*/function (_Command) {
    /**
     * @param {Array.<module:nmodule/uxBuilder/rc/ux/commands/ModifyUxModelCommand~ModifyOp>} ops
     * @param {module:nmodule/uxBuilder/rc/ux/commands/ModifyUxModelCommand~ModifyParams} [params]
     */
    function ModifyUxModelCommand(ops) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      _classCallCheck(this, ModifyUxModelCommand);
      var onNewNodes = params.onNewNodes,
        undoText = params.undoText,
        redoText = params.redoText;
      return _callSuper(this, ModifyUxModelCommand, [Object.assign({
        undoable: function undoable() {
          return reifyOps(ops).then(function (ops) {
            var oldModels = ops.map(function (_ref) {
              var parentNode = _ref.parentNode,
                model = _ref.model;
              return parentNode.value().get(model.getName());
            });

            // we have to use reduce for the case when parent and child are being changed at the
            // same time. if they run in parallel, the new child UxModel might get inserted into the
            // wrong parent UxModel and get lost.
            return {
              redo: function redo() {
                var modifiedKidNodes = [];
                return reduceAsync(ops, function (_, _ref2) {
                  var parentNode = _ref2.parentNode,
                    model = _ref2.model;
                  return parentNode.modifyKid(model.getName(), model, true).then(function (existingKidNode) {
                    return modifiedKidNodes.push(existingKidNode);
                  });
                }).then(function () {
                  modifiedKidNodes.forEach(function (node) {
                    return node.treeModified();
                  });
                  return onNewNodes && onNewNodes();
                });
              },
              undo: function undo() {
                var modifiedKidNodes = [];
                return reduceAsync(ops, function (_, _ref3, i) {
                  var parentNode = _ref3.parentNode,
                    model = _ref3.model;
                  return parentNode.modifyKid(model.getName(), oldModels[i], true).then(function (existingKidNode) {
                    return modifiedKidNodes.push(existingKidNode);
                  });
                }).then(function () {
                  modifiedKidNodes.forEach(function (node) {
                    return node.treeModified();
                  });
                  return onNewNodes && onNewNodes();
                });
              },
              undoText: undoText,
              redoText: redoText
            };
          });
        }
      }, params)]);
    }

    /**
     * @param {Array.<module:nmodule/uxBuilder/rc/ux/commands/ModifyUxModelCommand~ModifyOp>} modifyOps
     * @param {module:nmodule/uxBuilder/rc/ux/commands/ModifyUxModelCommand~ModifyParams} [params]
     * @returns {Promise}
     */
    _inherits(ModifyUxModelCommand, _Command);
    return _createClass(ModifyUxModelCommand, null, [{
      key: "modify",
      value: function modify(modifyOps, params) {
        return new ModifyUxModelCommand(modifyOps, params).invoke();
      }
    }]);
  }(Command);
  function reifyOps(ops) {
    return Promise.all(ops.map(function (_ref4) {
      var parentNode = _ref4.parentNode,
        model = _ref4.model;
      return UxModel.make(model).then(function (model) {
        return {
          parentNode: parentNode,
          model: model
        };
      });
    }));
  }
});

/**
 * Represents one "modify" operation: replace the attributes of the UxModel at the given
 * UxModelTreeNode with the attributes of the given UxModel. The kids of the UxModel will not be
 * considered or changed.
 *
 * @typedef {object} module:nmodule/uxBuilder/rc/ux/commands/ModifyUxModelCommand~ModifyOp
 * @property {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} parentNode
 * @property {module:bajaux/model/UxModel} model the new UxModel to apply to the child of the
 * parent node that has its same name.
 */

/**
 * @typedef {object} module:nmodule/uxBuilder/rc/ux/commands/ModifyUxModelCommand~ModifyParams
 * @property {string|function} [redoText]
 * @property {string|function} [undoText]
 * @property {function()} [onNewNodes] a function that will be called when the modify is done
 */
