function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/commands/GoToSourceCommand
 */
define(['baja!', 'lex!uxBuilder', 'jquery', 'bajaux/Widget', 'bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'nmodule/bajaui/rc/rpc/uxBuilder', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/menu/CommandGroupContextMenu', 'nmodule/webEditors/rc/wb/mixin/textEditorMixIn'], function (baja, lexs, $, Widget, Command, CommandGroup, uxBuilder, feDialogs, CommandGroupContextMenu, textEditorMixIn) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    uxBuilderLex = _lexs[0];

  /**
   * A command for showing the GoToSource commands.
   *
   * @class
   * @alias nmodule/uxBuilder/rc/ux/commands/GoToSourceCommand
   * @extends module:bajaux/commands/Command
   * @since Niagara 4.15
   */
  var GoToSourceCommand = /*#__PURE__*/function (_Command) {
    /**
     * @param {module:nmodule/uxBuilder/rc/ux/UxBuilder} uxBuilder
     */
    function GoToSourceCommand(uxBuilder) {
      var _this;
      _classCallCheck(this, GoToSourceCommand);
      _this = _callSuper(this, GoToSourceCommand, [{
        module: 'uxBuilder',
        lex: 'UxBuilder.commands.gotoSourceMenu'
      }]);
      _this.$uxBuilder = uxBuilder;
      return _this;
    }

    /**
     * @param {JQuery.Event} event
     * @returns {Promise}
     */
    _inherits(GoToSourceCommand, _Command);
    return _createClass(GoToSourceCommand, [{
      key: "invokeFromEvent",
      value: function invokeFromEvent(event) {
        var _this2 = this;
        var viewSourceXml = new Command({
          module: 'uxBuilder',
          lex: 'UxBuilder.commands.viewSource',
          func: function func() {
            return uxBuilder.fromPxOrd(_this2.$uxBuilder.$ord, true, true).then(function (xml) {
              return feDialogs.showFor({
                dom: $("<div class='-t-GoToSource-XmlViewer ux-fullscreen'></div>"),
                type: XmlViewer,
                value: xml,
                readonly: true,
                title: uxBuilderLex.get('UxBuilder.commands.viewSource.displayName'),
                buttons: ['ok'],
                progressCallback: function progressCallback(msg, editor) {
                  if (msg === 'initialized') {
                    var jq = editor.$dlg.jq();
                    jq.find('.js-dialog').addClass('-t-GoToSource-fullHeight');
                    jq.find('.js-dialog-content-wrapper').addClass('-t-GoToSource-fullHeight');
                  }
                }
              });
            });
          }
        });
        var gotoSourceCommand = new Command({
          module: 'uxBuilder',
          lex: 'UxBuilder.commands.gotoSource',
          func: function func() {
            return _this2.$uxBuilder.$ord.resolve({
              lease: true
            }).then(function (target) {
              var pxFileOrd;
              var viewId = target.view && target.view.id;
              var component = target.getComponent();
              if (viewId && component) {
                pxFileOrd = component.get(viewId).get('pxFile');
              } else if (viewId === "uxBuilder:UxBuilder") {
                pxFileOrd = _this2.$uxBuilder.$ord;
              }
              if (!pxFileOrd) {
                throw new Error(uxBuilderLex.get('UxBuilder.commands.gotoSource.error', viewId));
              }
              pxFileOrd = baja.Ord.make(pxFileOrd + "|view:webEditors:TextFileEditor").normalize();
              return window.niagara.env.hyperlink(pxFileOrd);
            });
          }
        });
        var group = new CommandGroup({
          commands: [viewSourceXml, gotoSourceCommand]
        });
        return CommandGroupContextMenu.show({
          event: event,
          group: group
        });
      }
    }]);
  }(Command);
  /**
   * @class
   * @inner
   */
  var XmlViewer = /*#__PURE__*/function (_Widget) {
    function XmlViewer() {
      var _this3;
      _classCallCheck(this, XmlViewer);
      _this3 = _callSuper(this, XmlViewer, arguments);
      textEditorMixIn(_this3);
      return _this3;
    }

    /**
     * @param {String} xml
     */
    _inherits(XmlViewer, _Widget);
    return _createClass(XmlViewer, [{
      key: "doLoad",
      value: function doLoad(xml) {
        this.$initEditor('xml');
        var renderer = this.$editor.renderer;

        // makes the cursor invisible
        renderer.$cursorLayer.element.style.opacity = 0;

        // removes the gutter, and therefore the line numbers
        renderer.setShowGutter(false);
        this.$setEditorReadOnly(true);
        this.$setEditorText(xml);
      }
    }]);
  }(Widget);
  return GoToSourceCommand;
});
