function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/commands/DuplicateUxModelCommand
 */
define(['baja!', 'baja!bajaui:Layout', 'lex!uxBuilder', 'bajaux/commands/Command', 'bajaux/model/UxModel', 'Promise', 'nmodule/bajaui/rc/ux/CanvasPane', 'nmodule/bajaui/rc/ux/shape/Line', 'nmodule/bajaui/rc/ux/shape/Path', 'nmodule/bajaui/rc/ux/shape/Polygon', 'nmodule/bajaui/rc/ux/shape/Shape', 'nmodule/gx/rc/baja/PathGeom', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/uxBuilder/rc/util/uxBuilderUtils', 'nmodule/uxBuilder/rc/util/uxModelUtils', 'nmodule/uxBuilder/rc/util/wysiwygUtils', 'nmodule/webEditors/rc/fe/baja/util/compUtils'], function (baja, Types, lexs, Command, UxModel, Promise, CanvasPane, Line, Path, Polygon, Shape, PathGeom, asyncUtils, uxBuilderUtils, uxModelUtils, wysiywgUtils, compUtils) {
  'use strict';

  var MoveTo = PathGeom.MoveTo;
  var _lexs = _slicedToArray(lexs, 1),
    uxBuilderLex = _lexs[0];
  var reduceAsync = asyncUtils.reduceAsync;
  var formatDisplayNames = compUtils.formatDisplayNames;
  var generateUniqueNames = uxBuilderUtils.generateUniqueNames,
    getDesiredName = uxBuilderUtils.getDesiredName,
    requestSelection = uxBuilderUtils.requestSelection;
  var withKidsAdded = uxModelUtils.withKidsAdded;
  var applySnapToPoint = wysiywgUtils.applySnapToPoint;

  /**up
   * This command will duplicate some UxModelTreeNodes.
   *
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/commands/DuplicateUxModelCommand
   * @extends module:bajaux/commands/Command
   */
  var DuplicateUxModelCommand = /*#__PURE__*/function (_Command) {
    /**
     * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodesToDuplicate
     * @param {module:nmodule/uxBuilder/rc/ux/commands/DuplicateUxModelCommand~DuplicateParams} params
     */
    function DuplicateUxModelCommand(nodesToDuplicate) {
      var _this;
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      _classCallCheck(this, DuplicateUxModelCommand);
      var getDisplayNames = function getDisplayNames() {
        return Promise.all(nodesToDuplicate.map(function (node) {
          return node.toDisplay();
        })).then(function (displayNames) {
          return formatDisplayNames(displayNames);
        });
      };
      _this = _callSuper(this, DuplicateUxModelCommand, [Object.assign({
        module: 'uxBuilder',
        lex: 'WidgetTree.command.duplicateNodes',
        undoable: function undoable() {
          var undoDuplicateOps;
          return {
            redo: function redo() {
              undoDuplicateOps = [];

              // since the decision was made to disable to the duplicate if the parents of the selected
              // nodes were different, we can use the parent of the first node
              var parentNode = nodesToDuplicate[0].getParent();
              var grandparent = parentNode.getParent();
              var originalParentModel = parentNode.value();
              var parentName = originalParentModel.getName();
              var existingNames = parentNode.value().getKids().map(function (m) {
                return m.getName();
              });
              var nameMap = [];
              return Promise.all(nodesToDuplicate.map(function (node) {
                var newProperties = {};
                var nodeValue = node.value();
                var origName = nodeValue.getName();
                var newName = generateUniqueNames(existingNames, [getDesiredName(nodeValue, true)])[0];
                existingNames.push(newName);
                newProperties.name = newName;
                if (parentNode.represents(CanvasPane)) {
                  var snapSize = _this.$snapSize;
                  var offSet = snapSize || 10;
                  if (node.represents(Shape)) {
                    var newGeom;
                    if (snapSize) {
                      newGeom = _this.$applySnapToGeom(node, snapSize);
                    } else {
                      var currentGeom = nodeValue.getProperties().geom;
                      newGeom = currentGeom.translate(offSet, offSet);
                    }
                    newProperties.properties = {
                      geom: newGeom
                    };
                  } else {
                    var currLayout = nodeValue.getProperties().layout;
                    var point = {
                      x: currLayout.getX() + offSet,
                      y: currLayout.getY() + offSet
                    };
                    if (snapSize) {
                      point = applySnapToPoint(snapSize, point);
                    }
                    newProperties.properties = {
                      layout: nodeValue.getProperties().layout.moveTo(point.x, point.y)
                    };
                  }
                }
                nameMap.push({
                  newName: newName,
                  origName: origName
                });
                return nodeValue.clone(newProperties);
              })).then(function (clones) {
                return withKidsAdded(originalParentModel, clones);
              }).then(function (parentWithNewKids) {
                undoDuplicateOps.push({
                  parentNode: grandparent,
                  model: originalParentModel,
                  name: parentName
                });
                return grandparent.replaceKid(parentName, parentWithNewKids);
              }).then(function () {
                return grandparent.getKid(parentName);
              }).then(function (parent) {
                return Promise.all(nameMap.map(function (_ref) {
                  var newName = _ref.newName;
                  return parent.getKid(newName);
                }));
              }).then(function (newNodes) {
                return requestSelection(newNodes);
              });
            },
            undo: function undo() {
              return reduceAsync(undoDuplicateOps.reverse(), function (_, _ref2) {
                var parentNode = _ref2.parentNode,
                  model = _ref2.model,
                  name = _ref2.name;
                return parentNode.replaceKid(name, model);
              });
            },
            undoText: function undoText() {
              return getDisplayNames().then(function (displayNames) {
                return uxBuilderLex.get({
                  key: 'commands.duplicate.undoText',
                  args: [displayNames]
                });
              });
            },
            redoText: function redoText() {
              return getDisplayNames().then(function (displayNames) {
                return uxBuilderLex.get({
                  key: 'commands.duplicate.redoText',
                  args: [displayNames]
                });
              });
            }
          };
        }
      }, params)]);
      _this.$snapSize = params.snapSize;
      return _this;
    }

    /**
     * @private
     * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} node
     * @param {Number} snapSize
     */
    _inherits(DuplicateUxModelCommand, _Command);
    return _createClass(DuplicateUxModelCommand, [{
      key: "$applySnapToGeom",
      value: function $applySnapToGeom(node, snapSize) {
        var nodeValue = node.value();
        var geom = nodeValue.getProperties().geom;
        var startPoint;
        var newPoint = {};
        var deltaX = 0;
        var deltaY = 0;
        if (node.represents(Path)) {
          // Must at least have 2 segments
          var segments = geom.$getSegments();
          if (segments.length < 2) {
            throw new Error(uxBuilderLex.get('commands.duplicate.error.path.number.segments'));
          }

          // First segment must be an absolute moveto
          var firstSegment = geom.$getSegmentByIndex(0);
          if (!(firstSegment instanceof MoveTo && firstSegment.getAbsolute())) {
            throw new Error(uxBuilderLex.get('commands.duplicate.error.path.first.segment'));
          }
          var point = firstSegment.getPoint();
          startPoint = {
            x: point.x(),
            y: point.y()
          };
        } else if (node.represents(Polygon)) {
          var _point = geom.getPoints()[0];
          startPoint = {
            x: _point.x(),
            y: _point.y()
          };
        } else if (node.represents(Line)) {
          startPoint = {
            x: geom.x1(),
            y: geom.y1()
          };
        } else {
          startPoint = {
            x: geom.x(),
            y: geom.y()
          };
        }
        newPoint.x = startPoint.x + snapSize;
        newPoint.y = startPoint.y + snapSize;
        newPoint = applySnapToPoint(snapSize, newPoint);
        deltaX = newPoint.x - startPoint.x;
        deltaY = newPoint.y - startPoint.y;
        return geom.translate(deltaX, deltaY);
      }

      /**
       * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodesToDuplicate
       * @param {module:nmodule/uxBuilder/rc/ux/commands/DuplicateUxModelCommand~DuplicateParams} [params]
       * @returns {Promise}
       */
    }], [{
      key: "duplicate",
      value: function duplicate(nodesToDuplicate, params) {
        return new DuplicateUxModelCommand(nodesToDuplicate, params).invoke();
      }
    }]);
  }(Command);
  return DuplicateUxModelCommand;
});

/**
 * @typedef {object} module:nmodule/uxBuilder/rc/ux/commands/DuplicateUxModelCommand~DuplicateParams
 */
