function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/commands/DeleteUxModelCommand
 */
define(['lex!uxBuilder', 'bajaux/commands/Command', 'bajaux/model/UxModel', 'Promise', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/uxBuilder/rc/util/uxBuilderUtils', 'nmodule/uxBuilder/rc/ux/model/UxModelTreeNode'], function (lexs, Command, UxModel, Promise, asyncUtils, uxBuilderUtils, UxModelTreeNode) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    uxBuilderLex = _lexs[0];
  var reduceAsync = asyncUtils.reduceAsync;
  var requestSelection = uxBuilderUtils.requestSelection;

  /**
   * This command will delete some UxModelTreeNodes.
   *
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/commands/DeleteUxModelCommand
   * @extends module:bajaux/commands/Command
   */
  var DeleteUxModelCommand = /*#__PURE__*/function (_Command) {
    /**
     * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodesToDelete
     * @param {module:nmodule/uxBuilder/rc/ux/commands/DeleteUxModelCommand~DeleteParams} params
     */
    function DeleteUxModelCommand(nodesToDelete) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      _classCallCheck(this, DeleteUxModelCommand);
      var deleteOps = makeDeleteOps(nodesToDelete);
      return _callSuper(this, DeleteUxModelCommand, [Object.assign({
        module: 'uxBuilder',
        lex: 'WidgetTree.command.deleteNodes',
        undoable: function undoable() {
          var undoReplaceOps;

          // we have to use reduce for the case when parent and child are being deleted at the
          // same time. if they run in parallel, the clone we insert in place of the parent
          // might still include a copy of the deleted child, and the delete call would get missed.
          return UxModelTreeNode.formatDisplayNames(nodesToDelete).then(function (formattedNames) {
            return {
              redo: function redo() {
                undoReplaceOps = [];
                return reduceAsync(deleteOps, function (_, _ref) {
                  var parentNode = _ref.parentNode,
                    namesToDelete = _ref.namesToDelete;
                  var grandparent = parentNode.getParent();
                  var originalParentModel = parentNode.value();
                  var parentName = originalParentModel.getName();
                  return withoutKids(originalParentModel, namesToDelete).then(function (parentMinusSomeKids) {
                    undoReplaceOps.push({
                      parentNode: grandparent,
                      model: originalParentModel,
                      name: parentName
                    });
                    return grandparent.replaceKid(parentName, parentMinusSomeKids);
                  });
                });
              },
              undo: function undo() {
                return reduceAsync(undoReplaceOps.reverse(), function (_, _ref2) {
                  var parentNode = _ref2.parentNode,
                    model = _ref2.model,
                    name = _ref2.name;
                  return parentNode.replaceKid(name, model);
                }).then(function () {
                  return requestSelection(nodesToDelete);
                });
              },
              redoText: function redoText() {
                return uxBuilderLex.get('commands.delete.redoText', formattedNames);
              },
              undoText: function undoText() {
                return uxBuilderLex.get('commands.delete.undoText', formattedNames);
              }
            };
          });
        }
      }, params)]);
    }

    /**
     * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodesToDelete
     * @param {module:nmodule/uxBuilder/rc/ux/commands/DeleteUxModelCommand~DeleteParams} [params]
     * @returns {Promise}
     */
    _inherits(DeleteUxModelCommand, _Command);
    return _createClass(DeleteUxModelCommand, null, [{
      key: "delete",
      value: function _delete(nodesToDelete, params) {
        return new DeleteUxModelCommand(nodesToDelete, params).invoke();
      }
    }]);
  }(Command);
  /**
   * Given the nodes to delete, turn them into an array of ReplaceOps: each one will replace a
   * parent of the deleted nodes, with a clone that has the deleted nodes removed.
   *
   * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodesToDelete
   * @returns {Array.<module:nmodule/uxBuilder/rc/ux/commands/DeleteUxModelCommand~DeleteOp>}
   */
  function makeDeleteOps(nodesToDelete) {
    // delete from bottom to top so clones of higher widgets don't accidentally include not-yet-deleted
    // children and put them back in.
    return coalesceDeletes(nodesToDelete).sort(function (a, b) {
      return deepestToShallowest(a.parentNode, b.parentNode);
    });
  }

  /**
   * Group the nodes to delete by their parent nodes. That is: if deleting three children of one
   * parent, that's one ReplaceOp for that parent minus the three nodes, not three individual
   * ReplaceOps.
   *
   * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodesToDelete
   * @returns {Array.<module:nmodule/uxBuilder/rc/ux/commands/DeleteUxModelCommand~DeleteOp>}
   */
  function coalesceDeletes(nodesToDelete) {
    var parentPathMap = {};
    function isAlreadyDeleting(nodeToDelete) {
      var parentNode = nodeToDelete.getParent();
      var parentPath = parentNode ? parentNode.getFullPath() : [];
      var obj = parentPathMap[parentPath.join('/')];
      return obj && obj.namesToDelete.includes(nodeToDelete.getName());
    }
    function isAlreadyDeletingAnAncestor(nodeToDelete) {
      while (nodeToDelete = nodeToDelete.getParent()) {
        if (isAlreadyDeleting(nodeToDelete)) {
          return true;
        }
      }
    }

    // coalesce from top to bottom, so we can tell if we're deleting a parent node, we don't have to
    // process any deletes for its children.
    nodesToDelete.slice().sort(shallowestToDeepest).forEach(function (node) {
      if (isAlreadyDeletingAnAncestor(node)) {
        return;
      }
      var parentNode = node.getParent();
      var parentPathStr = parentNode.getFullPath().join('/');
      var deleteObj = parentPathMap[parentPathStr] || (parentPathMap[parentPathStr] = {
        namesToDelete: [],
        parentNode: parentNode
      });
      deleteObj.namesToDelete.push(node.getName());
    });
    return Object.values(parentPathMap);
  }
  function withoutKids(parentModel, namesToDelete) {
    var siblings = parentModel.getKids();
    var survivingSiblings = siblings.filter(function (sibling) {
      return !namesToDelete.includes(sibling.getName());
    });
    return parentModel.clone({
      kids: survivingSiblings
    });
  }
  function shallowestToDeepest(a, b) {
    return a.getFullPath().length - b.getFullPath().length;
  }
  function deepestToShallowest(a, b) {
    return -shallowestToDeepest(a, b);
  }
  return DeleteUxModelCommand;
});

/**
 * Represents one "delete" operation: delete some children of the given WidgetTree node.
 *
 * @typedef {object} module:nmodule/uxBuilder/rc/ux/commands/DeleteUxModelCommand~DeleteOp
 * @property {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} parentNode
 * @property {Array.<string>} namesToDelete
 */

/**
 * @typedef {object} module:nmodule/uxBuilder/rc/ux/commands/DeleteUxModelCommand~DeleteParams
 * @property {string|function} [redoText]
 * @property {string|function} [undoText]
 */
