function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/commands/AddPaneCommand
 */

define(['baja!', 'baja!bajaui:Layout,bajaui:LayerTag', 'bajaux/commands/Command', 'Promise', 'nmodule/bajaui/rc/ux/CanvasPane', 'nmodule/js/rc/asyncUtils/asyncUtils'], function (baja, types, Command, Promise, CanvasPane, asyncUtils) {
  'use strict';

  var reduceAsync = asyncUtils.reduceAsync;

  /**
   * Adds an extra Pane to the selected widgets.
   * @since Niagara 4.15
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/commands/AddPaneCommand
   * @extends module:bajaux/commands/Command
   * @abstract
   */
  var AddPaneCommand = /*#__PURE__*/function (_Command) {
    /**
     * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} selectedNodes
     * @param {module:nmodule/uxBuilder/rc/ux/commands/AddPaneCommand~AddPaneParams} params
     */
    function AddPaneCommand(selectedNodes) {
      var _this;
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      _classCallCheck(this, AddPaneCommand);
      return _this = _callSuper(this, AddPaneCommand, [Object.assign({
        undoable: function undoable() {
          return _this.$makeUndoable(selectedNodes, params);
        }
      }, params)]);
    }

    /**
     * @private
     * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} selectedNodes
     * @param {object} params
     * @param {string|function} [params.redoText]
     * @param {string|function} [params.undoText]
     * @returns {Promise.<module:bajaux/commands/Command~Undoable>}
     */
    _inherits(AddPaneCommand, _Command);
    return _createClass(AddPaneCommand, [{
      key: "$makeUndoable",
      value: function $makeUndoable(selectedNodes, _ref) {
        var _this2 = this;
        var redoText = _ref.redoText,
          undoText = _ref.undoText;
        var paneOps = makePaneOps(selectedNodes);
        var undoAddOps;
        return Promise.resolve({
          redo: function redo() {
            undoAddOps = [];
            return reduceAsync(paneOps, function (_, _ref2) {
              var parentNode = _ref2.parentNode,
                namesToAddPane = _ref2.namesToAddPane;
              var grandparent = parentNode.getParent();
              var originalParentModel = parentNode.value();
              var parentName = originalParentModel.getName();
              return _this2.$makePane(originalParentModel, namesToAddPane).then(function (parentWithBorders) {
                undoAddOps.push({
                  parentNode: grandparent,
                  model: originalParentModel,
                  name: parentName
                });
                return grandparent.replaceKid(parentName, parentWithBorders);
              });
            });
          },
          undo: function undo() {
            return reduceAsync(undoAddOps.reverse(), function (_, _ref3) {
              var parentNode = _ref3.parentNode,
                model = _ref3.model,
                name = _ref3.name;
              return parentNode.replaceKid(name, model);
            });
          },
          undoText: undoText,
          redoText: redoText
        });
      }

      /**
       * Override this method to make a UxModel with the Pane you want to create.
       * Note that the Pane must support a kid named "content" for its inner content.
       * @param {Object} [params] the object literal for the method's arguments.
       * @param {String} [params.name]
       * @param {module:nmodule/bajaui/rc/baja/Layout} [params.layout]
       * @param {Array<module:bajaux/model/UxModel>} [kids]
       * @returns {Promise<module:bajaux/model/UxModel>}
       * @abstract
       */
    }, {
      key: "makePane",
      value: function makePane() {
        var _ref4 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          name = _ref4.name,
          _ref4$layout = _ref4.layout,
          layout = _ref4$layout === void 0 ? baja.$("bajaui:Layout") : _ref4$layout,
          kids = _ref4.kids;
        throw new Error('not implemented');
      }

      /**
       * @private
       * @param {module:bajaux/model/UxModel} parentModel
       * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} node
       * @returns {Promise.<module:bajaux/model/UxModel>}
       */
    }, {
      key: "$addPane",
      value: function $addPane(parentModel, node) {
        var _this3 = this;
        var name = node.getName();
        var nodeProps = node.getProperties();
        var layout = parentModel.$represents(CanvasPane) ? nodeProps.layout : baja.$("bajaui:Layout");
        var layerTag = nodeProps.LayerTag;
        var layerName = layerTag ? layerTag.getLayerName() : '';
        return node.clone({
          name: 'content'
        }).then(function (content) {
          return _this3.makePane({
            name: name,
            layout: layout,
            layerName: layerName,
            kids: {
              content: content
            }
          });
        });
      }

      /**
       *
       * @private
       * @param {module:bajaux/model/UxModel} parentModel
       * @param {Array.<String>} namesToAddPane
       * @returns {Promise}
       */
    }, {
      key: "$makePane",
      value: function $makePane(parentModel, namesToAddPane) {
        var _this4 = this;
        var children = parentModel.getKids();

        //if we get 0 children, then just add a BorderPane/ResponsivePane
        if (children.length === 0) {
          return this.makePane({
            name: namesToAddPane[0]
          }).then(function (newBorder) {
            return parentModel.clone({
              kids: [newBorder]
            });
          });
        }
        return Promise.all(children.map(function (child) {
          if (namesToAddPane.includes(child.getName())) {
            return _this4.$addPane(parentModel, child);
          }
          return child;
        })).then(function (newChildren) {
          return parentModel.clone({
            kids: newChildren
          });
        });
      }
    }]);
  }(Command);
  /**
   * Given the nodes to add a Pane to, turn them into an array of PaneOps:  each one will add a
   * parent of selected nodes, with a clone that has the Pane added.
   * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} selectedNodes
   * @returns {Array.<module:nmodule/uxBuilder/rc/ux/commands/AddPaneCommand~PaneOp>}
   */
  function makePaneOps(selectedNodes) {
    return coalesceAddPane(selectedNodes).sort(function (a, b) {
      return deepestToShallowest(a.parentNode, b.parentNode);
    });
  }

  /**
   * Group the nodes to add Panes to by their parent nodes.  That is: if adding a Pane to three
   * children of one parent, that's one PaneOp for that parent.
   * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} selectedNodes
   * @returns {Array.<module:nmodule/uxBuilder/rc/ux/commands/AddPaneCommand~PaneOp>}
   */
  function coalesceAddPane(selectedNodes) {
    var parentPathMap = {};
    selectedNodes.slice().sort(shallowestToDeepest).forEach(function (node) {
      var parentNode = node.getParent();
      var parentPathStr = parentNode.getFullPath().join('/');
      var paneObj = parentPathMap[parentPathStr] || (parentPathMap[parentPathStr] = {
        namesToAddPane: [],
        parentNode: parentNode
      });
      paneObj.namesToAddPane.push(node.getName());
    });
    return Object.values(parentPathMap);
  }
  function shallowestToDeepest(a, b) {
    return a.getFullPath().length - b.getFullPath().length;
  }
  function deepestToShallowest(a, b) {
    return -shallowestToDeepest(a, b);
  }
  return AddPaneCommand;
});

/**
 * Represents one "add pane" operation: add a Border pane or a Responsive Pane to some children of a given WidgetTree node
 *
 * @typedef {object} module:nmodule/uxBuilder/rc/ux/commands/AddPaneCommand~PaneOp
 * @property {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} parentNode
 * @property {Array.<string>} namesToAddPane
 */

/**
 * @typedef {object} module:nmodule/uxBuilder/rc/ux/commands/AddPaneCommand~AddPaneParams
 * @property {string|function} [redoText]
 * @property {string|function} [undoText]
 * @property {function(Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>)} [onNewNodes] a function that will
 * be called when the additional pane is added to widgets, or with the original nodes when the
 * add is undone.
 */
