function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toArray(r) { return _arrayWithHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableRest(); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx UxModel.jsx */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/UxBuilder
 */
define(['baja!', 'baja!gx:Color,tagdictionary:NeqlizeMode', 'lex!uxBuilder', 'log!nmodule.uxBuilder.ux.UxBuilder', 'bajaux/spandrel', 'bajaux/Widget', 'bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'bajaux/commands/ToggleCommand', 'bajaux/commands/ToggleCommandGroup', 'bajaux/model/UxModel', 'bajaux/util/CommandButtonGroup', 'bajaux/util/SaveCommand', 'jquery', 'Promise', 'underscore', 'nmodule/bajaui/rc/util/sideBarUtils', 'nmodule/bajaui/rc/ux/RootContainer', 'nmodule/bajaui/rc/ux/LabelPane', 'nmodule/bajaui/rc/ux/SplitPane', 'nmodule/bajaui/rc/ux/Terrace', 'nmodule/bajaui/rc/ux/TitlePane', 'nmodule/bajaui/rc/ux/WebWidget', 'nmodule/bajaui/rc/rpc/uxBuilder', 'nmodule/bajaui/rc/util/pxUtils', 'nmodule/bajaui/rc/util/TogglePxEditModeCommand', 'nmodule/bajaui/rc/util/UserDataOptionsCommand', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/js/rc/asyncUtils/promiseMux', 'nmodule/uxBuilder/rc/util/uxBuilderContextMenu', 'nmodule/uxBuilder/rc/util/uxBuilderEvents', 'nmodule/uxBuilder/rc/util/uxBuilderOrdUtils', 'nmodule/uxBuilder/rc/util/uxBuilderUtils', 'nmodule/uxBuilder/rc/ux/commands/DeleteUxModelCommand', 'nmodule/uxBuilder/rc/ux/commands/GoToSourceCommand', 'nmodule/uxBuilder/rc/ux/commands/ModifyUxModelCommand', 'nmodule/uxBuilder/rc/ux/commands/ReplaceUxModelCommand', 'nmodule/uxBuilder/rc/ux/commands/reorder/MoveDownCommand', 'nmodule/uxBuilder/rc/ux/commands/reorder/MoveToBottomCommand', 'nmodule/uxBuilder/rc/ux/commands/reorder/MoveToTopCommand', 'nmodule/uxBuilder/rc/ux/commands/reorder/MoveUpCommand', 'nmodule/uxBuilder/rc/ux/model/UxModelTreeNode', 'nmodule/uxBuilder/rc/ux/sidebars/BoundOrdsEditor', 'nmodule/uxBuilder/rc/ux/sidebars/PropertiesWidget', 'nmodule/uxBuilder/rc/ux/sidebars/PxLayersWidget', 'nmodule/uxBuilder/rc/ux/sidebars/PxPropertiesWidget', 'nmodule/uxBuilder/rc/ux/sidebars/WidgetTree', 'nmodule/uxBuilder/rc/ux/UxBuilderOptions', 'nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/util/storageUtil', 'nmodule/webEditors/rc/wb/commands/ContextMenuCommand', 'nmodule/webEditors/rc/wb/table/Table', 'nmodule/webEditors/rc/wb/table/EditTable', 'nmodule/webEditors/rc/wb/util/TransferDataManager'], function (baja, types, lexs, log, spandrel, Widget, Command, CommandGroup, ToggleCommand, ToggleCommandGroup, UxModel, CommandButtonGroup, SaveCommand, $, Promise, _, sidebarUtils, RootContainer, LabelPane, SplitPane, Terrace, TitlePane, WebWidget, uxBuilder, pxUtils, TogglePxEditModeCommand, UserDataOptionsCommand, asyncUtils, promiseMux, uxBuilderContextMenu, uxBuilderEvents, uxBuilderOrdUtils, uxBuilderUtils, DeleteUxModelCommand, GoToSourceCommand, ModifyUxModelCommand, ReplaceUxModelCommand, MoveDownCommand, MoveToBottomCommand, MoveToTopCommand, MoveUpCommand, UxModelTreeNode, BoundOrdsEditor, PropertiesWidget, PxLayersWidget, PxPropertiesWidget, WidgetTree, UxBuilderOptions, PxArtisanStudio, feDialogs, storageUtil, ContextMenuCommand, Table, EditTable, TransferDataManager) {
  'use strict';

  var logSevere = log.severe.bind(log);
  var DESELECTION_REQUESTED = uxBuilderEvents.DESELECTION_REQUESTED,
    DROP_REQUESTED = uxBuilderEvents.DROP_REQUESTED,
    ORD_REPLACEMENT_REQUESTED = uxBuilderEvents.ORD_REPLACEMENT_REQUESTED,
    SELECTION_REQUESTED = uxBuilderEvents.SELECTION_REQUESTED,
    TREE_MODIFIED = uxBuilderEvents.TREE_MODIFIED;
  var UX_BUILDER_DIMENSIONS_KEY = baja.getUserName() + '.uxBuilder.dimensions';
  var PREV_UX_BUILDER_DIMENSIONS_KEY = baja.getUserName() + '.uxBuilder.prevDimensions';
  var DEFAULT_DIVIDER_WIDTH = 6;
  var BLANK_ICON = 'module://icons/x16/blank.png';
  var CHECK_ICON = 'module://icons/x16/whiteIcons/check.png';
  var UX_BUILDER_FPS = 20;
  var TERRACE_WIDGET_NAMES = ['boundOrds', 'widgetTree', 'pxProperties', 'pxLayers', 'properties'];
  var MAIN_SIDE_BAR = 'pxWidget';
  var ROW_SELECTION_CHANGED_EVENT = Table.ROW_SELECTION_CHANGED_EVENT;
  var CELL_MODIFIED_EVENT = EditTable.CELL_MODIFIED_EVENT;
  var ALL_PANES = [MAIN_SIDE_BAR].concat(TERRACE_WIDGET_NAMES);
  var find = _.find,
    isEmpty = _.isEmpty,
    isEqual = _.isEqual,
    mapObject = _.mapObject,
    omit = _.omit,
    throttle = _.throttle,
    without = _.without;
  var _lexs = _slicedToArray(lexs, 1),
    uxBuilderLex = _lexs[0];
  var debounceAsync = asyncUtils.debounceAsync;
  var DIVIDERS_MOVED_EVENT = Terrace.DIVIDERS_MOVED_EVENT;
  var promptForChanges = PropertiesWidget.promptForChanges;
  var ACTIVATED_EVENT = WidgetTree.ACTIVATED_EVENT;
  var applyPxLayersToUxModel = uxBuilderUtils.applyPxLayersToUxModel,
    cloneWithChanges = uxBuilderUtils.cloneWithChanges,
    isUxModelEditable = uxBuilderUtils.isUxModelEditable,
    nodePathRelativeToRoot = uxBuilderUtils.nodePathRelativeToRoot,
    reconstitutePxProperties = uxBuilderUtils.reconstitutePxProperties,
    withInitialPxPropertyData = uxBuilderUtils.withInitialPxPropertyData,
    withPxPropertyDeleted = uxBuilderUtils.withPxPropertyDeleted,
    withPxPropertyRenamed = uxBuilderUtils.withPxPropertyRenamed,
    withUniqueNames = uxBuilderUtils.withUniqueNames;
  var getDefaultSidebarStates = sidebarUtils.getDefaultSidebarStates,
    setSidebarsOffset = sidebarUtils.setSidebarsOffset,
    $getDefaultStatesInAbsolute = sidebarUtils.$getDefaultStatesInAbsolute,
    $makeSidebarState = sidebarUtils.$makeSidebarState,
    getMaximizedPercent = sidebarUtils.getMaximizedPercent,
    getRestorePercent = sidebarUtils.getRestorePercent;
  var RESTORE_PERCENT = getRestorePercent();
  var MAXIMIZED_PERCENT = getMaximizedPercent();
  var MAX_EXPANSION_PERCENT = 88;
  var MIN_EXPANSION_PERCENT = 3;
  var getLocalStorage = storageUtil.getLocalStorage;
  var PxStudioWrapper = PxArtisanStudio.PxStudioWrapper;
  var ZOOM_INCREMENT = 0.2;
  var MAX_ZOOM_LIMIT = 10;
  var MIN_ZOOM_LIMIT = 0.4;
  var DEFAULT_ZOOM = 1;
  var DEFAULT_GRID_LINE_SIZE = 1.1;
  var MAX_GRID_LINE_SIZE = 3.1;

  /*
  just for UxBuilder purposes: prevent SplitPanes from doing layout calculations until they are
  actually taking up space on the screen. not confident enough that this is the right fix to try
  to apply globally across all SplitPanes yet.
   */
  var $ready = function $ready(splitPane) {
    var jq = splitPane.jq();
    return !!(jq.width() * jq.height());
  };
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-UxBuilder',
        showGrid: {
          value: true,
          hidden: true,
          "transient": true
        },
        gridSize: {
          value: 10,
          hidden: true,
          "transient": true
        },
        gridColor: {
          value: baja.$('gx:Color', '#40404040'),
          hidden: true,
          "transient": true
        },
        gridLineSize: {
          value: DEFAULT_GRID_LINE_SIZE,
          hidden: true,
          "transient": true
        },
        zoom: {
          value: DEFAULT_ZOOM,
          hidden: true,
          "transient": true
        },
        useSnap: {
          value: true,
          hidden: true,
          "transient": true
        },
        snapSize: {
          value: 10,
          hidden: true,
          "transient": true
        },
        showHatch: {
          value: true,
          hidden: true,
          "transient": true
        },
        hatchColor: {
          value: baja.$('gx:Color', '#40404040'),
          hidden: true,
          "transient": true
        },
        preserveIdentities: {
          value: false,
          hidden: true,
          "transient": true
        },
        animateBindings: {
          value: true,
          hidden: true,
          "transient": true
        },
        neqlizeMode: {
          value: baja.$('tagdictionary:NeqlizeMode', 'traverseIfPossible'),
          hidden: true,
          "transient": true
        },
        neqlizeExcludedRelations: {
          value: '',
          hidden: true,
          "transient": true
        },
        useServiceExcludedRelations: {
          value: true,
          hidden: true,
          "transient": true
        },
        neqlizeExcludedTags: {
          value: '',
          hidden: true,
          "transient": true
        },
        useServiceExcludedTags: {
          value: true,
          hidden: true,
          "transient": true
        },
        pxMediaTypeName: {
          value: 'UxMedia',
          hidden: true,
          "transient": true
        },
        showSideBar: {
          value: true,
          hidden: true,
          "transient": true
        },
        showBoundOrds: {
          value: true,
          hidden: true,
          "transient": true
        },
        showWidgetTree: {
          value: true,
          hidden: true,
          "transient": true
        },
        showPxProperties: {
          value: true,
          hidden: true,
          "transient": true
        },
        showPxLayers: {
          value: true,
          hidden: true,
          "transient": true
        },
        showProperties: {
          value: true,
          hidden: true,
          "transient": true
        },
        activePen: {
          value: null,
          hidden: true,
          "transient": true
        }
      },
      moduleName: 'uxBuilder',
      keyName: 'UxBuilder'
    };
  };

  /**
   * @param {boolean} isMaximized
   * @returns {{displayName: String, icon: String, description: String}}
   */
  function getLexValue(isMaximized) {
    var restoreOrMaximize = isMaximized ? 'sidebarMaximize' : 'sidebarRestore';
    return {
      icon: uxBuilderLex.get("UxBuilder.".concat(restoreOrMaximize, ".icon")),
      description: uxBuilderLex.get("UxBuilder.".concat(restoreOrMaximize, ".description")),
      displayName: uxBuilderLex.get("UxBuilder.".concat(restoreOrMaximize, ".displayName"))
    };
  }

  /**
   * @returns {boolean}
   */
  function isSidebarMaximized(cmd) {
    var iconUris = baja.Icon.make(uxBuilderLex.get('UxBuilder.sidebarMaximize.icon')).getImageUris();
    return iconUris.reduce(function (accumulator, icon) {
      return icon === (cmd && cmd.getIcon()) || accumulator;
    }, false);
  }

  /**
   * @param {module:bajaux/Properties} properties
   * @returns {Object.<String, number>}
   */
  function getDefaultUserRatios(properties) {
    var ratios = {};
    var visibleWidgets = TERRACE_WIDGET_NAMES.filter(function (widget) {
      return properties.getValue("show".concat(widget.capitalizeFirstLetter()));
    });
    visibleWidgets.forEach(function (widget) {
      ratios[widget] = 100 / visibleWidgets.length;
    });
    return ratios;
  }

  /**
   * Sets the properties from sidebar state to UxBuilder's properties.
   *
   * @param {module:nmodule/uxBuilder/rc/ux/UxBuilder} self
   */
  function setSidebarPropertiesFromStates(self) {
    // Initializes properties to show/hide the sideBars and Terrace.
    var states = self.$getSavedStates();
    var showProperties = ['sideBar', 'boundOrds', 'widgetTree', 'pxLayers', 'pxProperties', 'properties'];
    showProperties.forEach(function (prop) {
      var visible;
      if (prop === 'sideBar') {
        visible = !states['pxWidget'].isMaximized;
      } else {
        visible = !!(states[prop] && states[prop].visible);
      }
      self.properties().setValue("show".concat(prop.capitalizeFirstLetter()), visible);
    });
  }

  /**
   * Returns the raw parsed json of the states from localStorage.
   *
   * @returns {{states: Object.<String, SidebarState>}|undefined}
   */
  function getRawSavedStates() {
    var json;
    try {
      json = getLocalStorage().getItem(UX_BUILDER_DIMENSIONS_KEY);
      json = json && JSON.parse(json);
    } catch (e) {
      logSevere(e);
    }
    return json;
  }

  /**
   * @param {String} propertyName
   * @param {boolean} isSelected
   * @param {module:bajaux/Widget} widget
   */
  function saveToggledState(propertyName, isSelected, widget) {
    if (propertyName === 'showSideBar') {
      // When sidebar is toggled, reset the dividePosition of the pxWidget and save the pxWidget's state.
      widget.$getSplitPane().properties().setValue('dividerPosition', isSelected ? RESTORE_PERCENT : MAXIMIZED_PERCENT);
      widget.$savePxWidgetState();
    } else {
      var states = widget.$getSavedStates();
      var widgetName = propertyName.split('show')[1];
      widgetName = widgetName.charAt(0).toLowerCase() + widgetName.slice(1);
      if (isSelected) {
        // When Terrace's sidebar is toggled, then make a default sidebar state.
        states[widgetName] = $makeSidebarState();
      } else {
        // When it is un-toggled, then delete the state.
        delete states[widgetName];
      }
      // Get the default user ratios and save toggled states.
      var ratios = getDefaultUserRatios(widget.properties());
      widget.$saveStates({
        states: states,
        ratios: ratios
      });
    }
  }

  /**
   * @param {Object.<String, SidebarState> } states
   * @returns {boolean}
   */
  function validateStates(states) {
    if (!states) {
      return false;
    }
    return Object.keys(states).includes(MAIN_SIDE_BAR);
  }

  /**
   * @param {Array.<module:nmodule/webEditors/rc/wb/table/model/Row>} selectedRows
   * @param {module:bajaux/model/UxModel} uxModel
   * @returns {boolean}
   */
  function doesNodeHaveSelectedPxLayers(selectedRows, uxModel) {
    var selectedLayerNames = selectedRows.map(function (row) {
      return row.getSubject().name.value;
    });
    var layer = uxModel.getProperties().LayerTag;
    var layerName = layer && layer.get('layerName');
    return layerName && selectedLayerNames.includes(layerName);
  }

  /**
   * @param {Array.<module:nmodule/webEditors/rc/wb/table/model/Row>} selectedRows
   * @param {module:bajaux/model/UxModel} uxModel
   * @returns {boolean}
   */
  function doesNodeHaveSelectedBoundOrds(selectedRows, uxModel) {
    var boundOrds = uxBuilderUtils.$getBoundOrdsFromUxModel(uxModel);
    var selectedBoundOrds = selectedRows.map(function (row) {
      return row.getSubject();
    });
    var isInProperties = selectedBoundOrds.find(function (selectedBoundOrd) {
      return boundOrds.find(function (boundOrd) {
        return boundOrd.equivalent(selectedBoundOrd);
      });
    });
    return !!isInProperties;
  }

  /**
   * @param {Array.<module:nmodule/webEditors/rc/wb/table/model/Row>} selectedRows
   * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} uxModelTreeNode
   * @returns {boolean}
   */
  function doesNodeHaveSelectedPxProperties(selectedRows, uxModelTreeNode) {
    var selectedPxProperties = selectedRows.map(function (row) {
      return row.getSubject();
    });
    var pathAfterRoot = nodePathRelativeToRoot(uxModelTreeNode),
      treeNodePath = [pathAfterRoot];
    var bindings = uxModelTreeNode.value().getBindingList().getBindings();
    bindings.forEach(function (binding) {
      var bindingPath = pathAfterRoot.slice();
      bindingPath.push(binding.getName());
      treeNodePath.push(bindingPath);
    });
    return !!selectedPxProperties.find(function (pxProperty) {
      var targets = pxProperty.targets;
      targets = targets.value;
      return targets.find(function (targetPath) {
        targets = targetPath.slice(0, targetPath.length - 1);
        return treeNodePath.some(function (treeNodePath) {
          return isEqual(treeNodePath, targets);
        });
      });
    });
  }

  /**
   * @class
   * @inner
   * @extends module:bajaux/commands/ToggleCommand
   * @alias module:nmodule/uxBuilder/rc/ux/UxBuilder~TogglePropertyCommand
   */
  var TogglePropertyCommand = /*#__PURE__*/function (_ToggleCommand) {
    function TogglePropertyCommand(widget, displayName, propertyName) {
      var _this;
      _classCallCheck(this, TogglePropertyCommand);
      var selected = widget.properties().getValue(propertyName);
      var icon = selected ? CHECK_ICON : BLANK_ICON;
      var toggleAndRerender = function toggleAndRerender(propertyName) {
        _this.toggle();
        var isSelected = _this.isSelected();
        widget.properties().setValue(propertyName, isSelected);
        saveToggledState(propertyName, isSelected, widget);
        return widget.rerender().then(function () {
          return _this.setIcon(isSelected ? CHECK_ICON : BLANK_ICON);
        });
      };
      return _this = _callSuper(this, TogglePropertyCommand, [{
        displayName: displayName,
        selected: selected,
        icon: icon,
        func: function func() {
          return toggleAndRerender(propertyName);
        }
      }]);
    }
    _inherits(TogglePropertyCommand, _ToggleCommand);
    return _createClass(TogglePropertyCommand, [{
      key: "safeToHideIcon",
      value: function safeToHideIcon() {
        return false;
      }
    }, {
      key: "hideAfterInvoke",
      value: function hideAfterInvoke() {
        return false;
      }
    }]);
  }(ToggleCommand);
  /**
   * @class
   * @inner
   * @extends module:bajaux/commands/ToggleCommand
   * @alias module:nmodule/uxBuilder/rc/ux/UxBuilder~DrawingToolsToggleCommand
   */
  var DrawingToolsToggleCommand = /*#__PURE__*/function (_ToggleCommand2) {
    function DrawingToolsToggleCommand(uxBuilder) {
      var _this2;
      _classCallCheck(this, DrawingToolsToggleCommand);
      return _this2 = _callSuper(this, DrawingToolsToggleCommand, [{
        module: 'uxBuilder',
        lex: 'commands.addGeometry',
        selected: !!uxBuilder.properties().getValue('activePen'),
        enabled: !uxBuilder.isReadonly(),
        func: function func() {
          return uxBuilder.$makeDrawingToolsGroup(_assertThisInitialized(_this2));
        }
      }]);
    }
    _inherits(DrawingToolsToggleCommand, _ToggleCommand2);
    return _createClass(DrawingToolsToggleCommand);
  }(ToggleCommand);
  /**
   * @class
   * @extends module:bajaux/spandrel
   * @alias module:nmodule/uxBuilder/rc/ux/UxBuilder
   */
  return /*#__PURE__*/function (_spandrel) {
    function UxBuilder(params) {
      var _this3;
      _classCallCheck(this, UxBuilder);
      _this3 = _callSuper(this, UxBuilder, [{
        params: params,
        defaults: widgetDefaults()
      }]);

      /**
       * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} selectedNodes
       * @returns {Promise.<boolean>} this should resolve a truthy value if the user made property
       * changes to the selected nodes.
       */
      _this3.$editPropertiesFunc = function (selectedNodes) {
        return _this3.$showWidgetPropsInDialog(selectedNodes)["catch"](logSevere);
      };
      // we'll keep the ID at the top-level, rather than regenerating it in the studio wrapper, to
      // avoid unnecessary rerenders.
      _this3.$id = _this3.generateId();
      _this3.$removedRowModels = [];
      _this3.$removedPxLayerRows = [];
      // Merge the UxBuilder properties with localStorage states.
      setSidebarPropertiesFromStates(_this3);
      _this3.$moveCommands = [new MoveToTopCommand(), new MoveUpCommand(), new MoveDownCommand(), new MoveToBottomCommand()];
      _this3.$changeSelectedPaths = promiseMux({
        coalesce: false,
        exec: function exec(changes) {
          return _this3.$doChangeSelectedPaths(changes).then(function () {
            return changes;
          }); // number of resolve promises must match input, per promiseMux
        }
      });

      /*
      the paths to the nodes that the user has selected in the nav tree. These are relative
      to the root node, matching the slot path to that widget in the original Px (`[]` for root
      node; `[ 'content' ]` for content of root ScrollPane, etc.)
       originally, this data lived in state. it was removed because changing a state value triggers a
      full rerender, and certain widgets (PropertiesWidget especially) are slow to complete a full
      rerender. this resulted in unacceptable jank when selecting widgets.
       when you're using state binding, you usually don't want additional values floating around
      outside of state. this is because that data can change during a rerender, with spandrel
      unaware, and result in inconsistencies. we'll accept it here specifically for performance
      reasons. if future spikes can get child widgets rerendering faster, this would ideally go back
      into state.
      */
      _this3.$selectedPaths = [];

      /*
      refreshing the properties widget is slow. we have to do it in response to widget properties
      changing, but they change *a lot*, so debounce to ensure it doesn't happen too often.
       */
      _this3.$refreshPropertiesWidgetSoon = debounceAsync(function () {
        return _this3.$refreshPropertiesWidget();
      }, 250);
      return _this3;
    }
    _inherits(UxBuilder, _spandrel);
    return _createClass(UxBuilder, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this4 = this,
          _arguments = arguments;
        // Add bajaux-design-time to let Widget know that it is in design mode.
        dom.addClass(Widget.css.designTime);
        var undoManager = Command.$getGlobalUndoManager();
        return UxBuilderOptions.make().then(function (options) {
          return _this4.applyUserOptions(options);
        }).then(function () {
          return _superPropGet(UxBuilder, "doInitialize", _this4, 3)(_arguments);
        }).then(function () {
          if (undoManager) {
            //wiping the undo/redo stack at this point because when we enter the UxBuilder any items
            //in the stack can not be applied anymore
            return undoManager.wipe();
          }
        });
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        var undoManager = Command.$getGlobalUndoManager();
        return _superPropGet(UxBuilder, "doDestroy", this, 3)(arguments).then(function () {
          if (undoManager) {
            //wiping the undo/redo stack at this point because when we leave the UxBuilder any items
            //in the stack can not be applied anymore
            return undoManager.wipe();
          }
        });
      }

      /**
       * @private
       * @param {Object.<String, SidebarState>} states
       * @returns {boolean}
       */
    }, {
      key: "$isDividerMovable",
      value: function $isDividerMovable(states) {
        return !Object.keys(states).reduce(function (accumulator, key) {
          return states[key].isMaximized || accumulator;
        }, false);
      }

      /**
       * @private
       * @returns {boolean}
       */
    }, {
      key: "$isBaseOrdAFileScheme",
      value: function $isBaseOrdAFileScheme() {
        return this.$ord.parse().get('file') !== null;
      }

      /**
       * @returns {Promise.<module:nmodule/uxBuilder/rc/ux/UxBuilder~UxBuilderState>}
       */
    }, {
      key: "toState",
      value: function toState() {
        var _this5 = this;
        var currReadonly = this.state().readonly;
        var ord = this.$ord;
        return uxBuilder.fromPxOrd(ord, true).then(function (_ref) {
          var _ref$pxReadonly = _ref.pxReadonly,
            pxReadonly = _ref$pxReadonly === void 0 ? false : _ref$pxReadonly,
            rootUxModelData = _ref.modelData,
            pxProperties = _ref.pxProperties,
            layers = _ref.layers;
          return createWrapperNode(rootUxModelData, pxProperties).then(function (wrapperNode) {
            // selection request events bubble up to the topmost node - the wrapper.
            wrapperNode.on(SELECTION_REQUESTED, function (nodeToSelect, action) {
              return _this5.selectPath(nodePathRelativeToRoot(nodeToSelect), action)["catch"](logSevere);
            });
            wrapperNode.on(DESELECTION_REQUESTED, function (nodeToDeselect) {
              return _this5.deselectPath(nodePathRelativeToRoot(nodeToDeselect))["catch"](logSevere);
            });
            wrapperNode.on(DROP_REQUESTED, function (nodeToInsertInto, objectsToInsert) {
              return _this5.$insert(nodeToInsertInto, objectsToInsert.map(function (object) {
                return {
                  object: object
                };
              }))["catch"](function (err) {
                return feDialogs.error(err);
              });
            });
            wrapperNode.on(TREE_MODIFIED, function (node) {
              var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
                silent = _ref2.silent;
              if (!_this5.isReadonly() && !silent) {
                _this5.setModified(true);
              }
              _this5.$refreshPropertiesWidgetSoon();
              return _this5.rerender();
            });
            return {
              readonly: currReadonly || pxReadonly,
              pxProperties: pxProperties,
              pxLayers: layers,
              wrapperNode: wrapperNode,
              baseOrd: ord,
              fileBased: _this5.$isBaseOrdAFileScheme()
            };
          });
        });
      }

      /**
       * Returns the saved states from local storage if available.
       * If not it will return the default states for sidebars.
       * @private
       * @returns {Object<String, SidebarState>}
       */
    }, {
      key: "$getSavedStates",
      value: function $getSavedStates() {
        var json = getRawSavedStates();
        // When localStorage is empty return the default sidebars in relative offsetPercents.
        if (!json || isEmpty(json.states) || !validateStates(json.states)) {
          return getDefaultSidebarStates(ALL_PANES, {
            name: MAIN_SIDE_BAR,
            offsetPercent: RESTORE_PERCENT
          });
        }
        var updatedPercents = {};
        var states = mapObject(json.states, function (value, key) {
          if (key !== MAIN_SIDE_BAR) {
            updatedPercents[key] = value.offsetPercent;
          }
          value.orientation = baja.$('bajaui:Orientation', value.orientation.$ordinal);
          return value;
        });
        // Set the new offsetPercent derived from updated-absolute-sidebar-pecents to the states.
        return setSidebarsOffset(states, {
          mainSidebar: {
            name: MAIN_SIDE_BAR
          },
          updatedPercents: updatedPercents
        });
      }

      /**
       * @private
       * @param {String} sidebarName
       * @param {boolean} isMaximized
       * @returns {Promise}
       */
    }, {
      key: "$saveSidebarsAndRerender",
      value: function $saveSidebarsAndRerender(sidebarName, isMaximized) {
        var states = this.$getSavedStates();
        var defaultStates = {
          states: $getDefaultStatesInAbsolute()
        };
        var defaultStatesJson = JSON.stringify(defaultStates);
        // If sidebar is maximized, then save its previous state in local storage and,
        // set the maximized sidebar absolute dimension to occupy major chunk of the Terrace.
        if (isMaximized) {
          mapObject(states, function (state, key) {
            if (key !== MAIN_SIDE_BAR) {
              state.isMaximized = false;
              if (key === sidebarName) {
                state.offsetPercent = MAX_EXPANSION_PERCENT;
                state.isMaximized = true;
                var prevJson = getLocalStorage().getItem(UX_BUILDER_DIMENSIONS_KEY) || defaultStatesJson;
                getLocalStorage().setItem(PREV_UX_BUILDER_DIMENSIONS_KEY, prevJson);
              } else {
                state.offsetPercent = MIN_EXPANSION_PERCENT;
              }
              return state;
            }
          });
        } else {
          // If sidebar is restored from it's maximized state,
          // then apply the previous dimensions to all sidebars and rerender.
          var json = getLocalStorage().getItem(PREV_UX_BUILDER_DIMENSIONS_KEY);
          states = (json && JSON.parse(json) || defaultStates).states;
          mapObject(states, function (state, key) {
            if (key !== MAIN_SIDE_BAR) {
              state.isMaximized = false;
              return state;
            }
          });
        }

        // After states were evaluated, save them to the local storage and rerender.
        getLocalStorage().setItem(UX_BUILDER_DIMENSIONS_KEY, JSON.stringify({
          states: states
        }));
        return this.rerender();
      }

      /**
       * Saves the sidebar dimensions to local storage.
       *
       * @private
       * @param {Object} [params]
       * @param {Object.<String, SidebarState>} params.states
       * @param {Object.<String, number>} [params.ratios]
       */
    }, {
      key: "$saveStates",
      value: function $saveStates() {
        var _this6 = this;
        var _ref3 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          states = _ref3.states,
          _ref3$ratios = _ref3.ratios,
          ratios = _ref3$ratios === void 0 ? {} : _ref3$ratios;
        try {
          states = mapObject(states, function (state, key) {
            // Set the absolute user ratios to the Terrace's sidebar states.
            // These ratios will never have MAIN_SIDE_BAR.
            if (ratios[key]) {
              state.offsetPercent = ratios[key];
            }
            // When saving states, always save the latest pxWidget state, this helps while toggling.
            if (key === 'pxWidget') {
              var _this6$properties$toV = _this6.properties().toValueMap(),
                showSideBar = _this6$properties$toV.showSideBar,
                showBoundOrds = _this6$properties$toV.showBoundOrds,
                showWidgetTree = _this6$properties$toV.showWidgetTree,
                showPxProperties = _this6$properties$toV.showPxProperties,
                showPxLayers = _this6$properties$toV.showPxLayers,
                showProperties = _this6$properties$toV.showProperties;
              state.isMaximized = !(showSideBar && (showBoundOrds || showWidgetTree || showPxProperties || showPxLayers || showProperties));
              var offsetPercent = state.offsetPercent !== MAXIMIZED_PERCENT ? state.offsetPercent : RESTORE_PERCENT;
              state.offsetPercent = state.isMaximized ? MAXIMIZED_PERCENT : offsetPercent;
            }
            return state;
          });
          getLocalStorage().setItem(UX_BUILDER_DIMENSIONS_KEY, JSON.stringify({
            states: states
          }));
        } catch (e) {
          logSevere(e);
        }
      }

      /**
       * Saves the pxWidget properties to the localStorage.
       *
       * @private
       */
    }, {
      key: "$savePxWidgetState",
      value: function $savePxWidgetState() {
        var _this$$getSplitPane$p = this.$getSplitPane().properties().toValueMap(),
          orientation = _this$$getSplitPane$p.orientation,
          dividerPosition = _this$$getSplitPane$p.dividerPosition;
        var _this$properties$toVa = this.properties().toValueMap(),
          showSideBar = _this$properties$toVa.showSideBar,
          showBoundOrds = _this$properties$toVa.showBoundOrds,
          showWidgetTree = _this$properties$toVa.showWidgetTree,
          showPxProperties = _this$properties$toVa.showPxProperties,
          showPxLayers = _this$properties$toVa.showPxLayers,
          showProperties = _this$properties$toVa.showProperties;
        var isMaximized = !(showSideBar && (showBoundOrds || showWidgetTree || showPxProperties || showPxLayers || showProperties));
        var json = getRawSavedStates();
        var states;
        if (!json || isEmpty(json.states) || !validateStates(json.states)) {
          states = $getDefaultStatesInAbsolute();
        } else {
          states = json.states;
        }
        states[MAIN_SIDE_BAR] = sidebarUtils.$makeSidebarState({
          orientation: orientation,
          offsetPercent: isMaximized ? MAXIMIZED_PERCENT : dividerPosition,
          visible: true,
          // By default, pxWidget is always visible.
          isMaximized: isMaximized
        });
        getLocalStorage().setItem(UX_BUILDER_DIMENSIONS_KEY, JSON.stringify({
          states: states
        }));
      }

      /**
       * @private
       * @param {module:bajaux/model/UxModel} uxModel
       * @returns {Promise<module:bajaux/model/UxModel>}
       */
    }, {
      key: "$makeUxModelForDisplay",
      value: function $makeUxModelForDisplay(uxModel) {
        var _this$state = this.state(),
          pxLayers = _this$state.pxLayers;
        return uxModel.clone().then(function (clone) {
          return applyPxLayersToUxModel(clone, pxLayers).then(function () {
            return clone;
          });
        });
      }

      /**
       * @private
       * @param {Function} filterFunction
       * @param {module:nmodule/webEditors/rc/wb/table/Table} table
       * @returns {Promise.<Array<module:nmodule/webEditors/rc/wb/tree/TreeNode>>}
       */
    }, {
      key: "$doSideBarRowSelected",
      value: function $doSideBarRowSelected(filterFunction, table) {
        var widgetTree = getSidebar(this.$getEditPane(), WidgetTree);
        if (widgetTree) {
          return uxBuilderUtils.expandToHighlightMatchingNodes(widgetTree, function (treeNode) {
            return filterFunction(table.getSelectedRows(), treeNode.value());
          });
        }
      }

      /**
       * @private
       * @param {module:nmodule/uxBuilder/rc/ux/UxBuilder~UxBuilderState} state
       * @param {module:bajaux/model/UxModel} displayModel
       * @returns {module:bajaux/spandrel~SpandrelData}
       */
    }, {
      key: "$makeTerrace",
      value: function $makeTerrace(_ref4, displayModel) {
        var _this7 = this;
        var wrapperNode = _ref4.wrapperNode,
          pxProperties = _ref4.pxProperties,
          pxLayers = _ref4.pxLayers,
          baseOrd = _ref4.baseOrd,
          fileBased = _ref4.fileBased;
        var _this$properties$toVa2 = this.properties().toValueMap(),
          showBoundOrds = _this$properties$toVa2.showBoundOrds,
          showWidgetTree = _this$properties$toVa2.showWidgetTree,
          showPxProperties = _this$properties$toVa2.showPxProperties,
          showPxLayers = _this$properties$toVa2.showPxLayers,
          showProperties = _this$properties$toVa2.showProperties;
        var states = this.$getSavedStates();
        var moveableDivider = this.$isDividerMovable(states);
        var rootNode = getRootNode(wrapperNode);
        var unselect = function unselect(key, command) {
          _this7.properties().setValue(key, false);
          command.setSelected(false);
          command.setIcon(BLANK_ICON);
          saveToggledState(key, false, _this7);
        };
        return UxModel.jsx(Terrace, {
          name: "widget2",
          properties: {
            states: states,
            moveableDivider: moveableDivider,
            $ready: $ready
          },
          lax: true /* TODO: 65372 */,
          on: _defineProperty({}, DIVIDERS_MOVED_EVENT, function (e, terrace, ratios) {
            return throttle(function () {
              return _this7.$saveStates({
                states: states,
                ratios: ratios
              });
            }, 1000 / UX_BUILDER_FPS, {
              leading: false
            })();
          })
        }, showBoundOrds && UxModel.jsx(TitlePane, {
          name: "boundOrds",
          className: "-t-UxBuilder-boundOrds -t-UxBuilder-sidebar",
          properties: {
            moduleName: 'uxBuilder',
            keyName: 'BoundOrdsEditor',
            headerCommands: [this.$maxRestoreBoundOrdsCmd],
            hideTitlePane: function hideTitlePane() {
              return unselect('showBoundOrds', _this7.$boundOrdsToggleCommand);
            }
          }
        }, UxModel.jsx(BoundOrdsEditor, {
          name: "content",
          value: displayModel,
          properties: {
            baseOrd: baseOrd,
            fileBased: fileBased,
            pxLayers: pxLayers,
            getRootNode: function getRootNode() {
              return rootNode;
            }
          },
          on: _defineProperty(_defineProperty({}, ORD_REPLACEMENT_REQUESTED, function (event, widget, fromToObjArray, lexKey) {
            var model = getRootNode(wrapperNode).value();
            uxBuilderOrdUtils.visitToReplaceOneOrdWithAnother({
              model: model,
              widget: _this7,
              fromToObjArray: fromToObjArray,
              lexKey: lexKey
            })["catch"](function (error) {
              return feDialogs.error(error);
            });
          }), ROW_SELECTION_CHANGED_EVENT, function (event, table) {
            return _this7.$doSideBarRowSelected(doesNodeHaveSelectedBoundOrds, table);
          })
        })), showWidgetTree && UxModel.jsx(TitlePane, {
          name: "widgetTree",
          className: "-t-UxBuilder-widgetTree -t-UxBuilder-sidebar",
          properties: {
            moduleName: 'uxBuilder',
            keyName: 'WidgetTree',
            headerCommands: [this.$maxRestoreWidgetTreeCmd],
            hideTitlePane: function hideTitlePane() {
              return unselect('showWidgetTree', _this7.$widgetTreeToggleCommand);
            }
          }
        }, UxModel.jsx(WidgetTree, {
          name: "content"
          // TODO: NCCB-65370
          ,
          onUxModify: function onUxModify() {
            return _this7.rerender();
          },
          value: getRootContainerNode(wrapperNode),
          on: _defineProperty({}, ACTIVATED_EVENT, function (e, tree, activatedTree) {
            var activatedNode = activatedTree.value();
            if (_this7.$canEditNode(activatedNode)) {
              _this7.$editPropertiesFunc([activatedNode])
              // NCCB-67910: test verifying this works
              //.then((result) => result && tree.refreshCommandStatus())
              ["catch"](logSevere);
            }
          }),
          properties: {
            hideRoot: true,
            editPropertiesFunc: this.$editPropertiesFunc,
            baseOrd: baseOrd,
            pxLayers: pxLayers,
            moveCommands: this.$moveCommands
          }
        })), showPxProperties && UxModel.jsx(TitlePane, {
          name: "pxProperties",
          lax: true //TODO NCCB-65372
          ,
          className: "-t-UxBuilder-pxProperties -t-UxBuilder-sidebar",
          properties: {
            moduleName: 'uxBuilder',
            keyName: 'PxPropertiesWidget',
            headerCommands: [this.$maxRestorePxPropertiesCmd],
            hideTitlePane: function hideTitlePane() {
              return unselect('showPxProperties', _this7.$pxPropertiesToggleCommand);
            }
          }
        }, UxModel.jsx(PxPropertiesWidget, {
          name: "content",
          lax: true //TODO NCCB-65372
          ,
          value: pxProperties,
          on: _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty({}, ROW_SELECTION_CHANGED_EVENT, function (event, table) {
            var widgetTree = getSidebar(_this7.$getEditPane(), WidgetTree);
            if (widgetTree) {
              return uxBuilderUtils.expandToHighlightMatchingNodes(widgetTree, function (treeNode) {
                return doesNodeHaveSelectedPxProperties(table.getSelectedRows(), treeNode);
              });
            }
          }), "rowsRenamed", function rowsRenamed(e, table, _ref8, _ref9) {
            var _ref10 = _slicedToArray(_ref8, 1),
              row = _ref10[0];
            var _ref11 = _slicedToArray(_ref9, 1),
              oldName = _ref11[0];
            var newName = row.getSubject().name.value;
            return _this7.$renamePxProperty(oldName, newName);
          }), "rowsRemoved", function rowsRemoved(e, table, _ref12) {
            var _ref13 = _slicedToArray(_ref12, 1),
              row = _ref13[0];
            var removedName = row.getSubject().name.value;
            return _this7.$removePxProperty(removedName);
          }), "rowsAdded", function rowsAdded(e, table, _ref14) {
            var _ref15 = _slicedToArray(_ref14, 1),
              row = _ref15[0];
            var _row$getSubject = row.getSubject(),
              name = _row$getSubject.name,
              value = _row$getSubject.value;
            return _this7.$addPxProperty(name.value, value.value);
          }), CELL_MODIFIED_EVENT, function (e, table, _ref16) {
            var row = _ref16.row;
            var name = row.name,
              value = row.value;
            return _this7.$addPxProperty(name.value, value.value);
          })
        })), showPxLayers && UxModel.jsx(TitlePane, {
          name: "pxLayers",
          className: "-t-UxBuilder-pxLayers -t-UxBuilder-sidebar",
          properties: {
            moduleName: 'uxBuilder',
            keyName: 'PxLayersWidget',
            headerCommands: [this.$maxRestorePxLayersCmd],
            hideTitlePane: function hideTitlePane() {
              return unselect('showPxLayers', _this7.$pxLayersToggleCommand);
            }
          }
        }, UxModel.jsx(PxLayersWidget, {
          name: "content",
          value: pxLayers,
          on: _defineProperty({}, ROW_SELECTION_CHANGED_EVENT, function (event, table) {
            return _this7.$doSideBarRowSelected(doesNodeHaveSelectedPxLayers, table);
          }),
          onUxModifiedValue: function onUxModifiedValue(pxLayers) {
            var oldPxLayers = _this7.state().pxLayers;
            var removedPxLayers = [];
            var newPxLayers = [];
            var table = _this7.$getPxLayersSideBar().$getEditTable().$getTable();
            var removeRows = false;
            var newRows = false;
            oldPxLayers.forEach(function (oldLayer) {
              if (!find(pxLayers, function (pxLayer) {
                return pxLayer.name === oldLayer.name;
              })) {
                removedPxLayers.push(oldLayer);
                removeRows = true;
              }
            });
            pxLayers.forEach(function (pxLayer) {
              if (!find(oldPxLayers, function (oldPxLayer) {
                return oldPxLayer.name === pxLayer.name;
              })) {
                newPxLayers.push(pxLayer);
                newRows = true;
              }
            });
            var uxModel = getRootNode(_this7.state().wrapperNode).value();
            return Promise.all([removeRows && !newRows && uxBuilderUtils.removePxLayers(uxModel, removedPxLayers, _this7.$removedRowModels, _this7.$removedPxLayerRows), removeRows && newRows && uxBuilderUtils.renamePxLayers(uxModel, removedPxLayers, newPxLayers), !removeRows && newRows && uxBuilderUtils.addPxLayers(uxModel, newPxLayers, _this7.$removedRowModels, _this7.$removedPxLayerRows)]).then(function () {
              return _this7.state({
                pxLayers: pxLayers
              });
            }).then(function () {
              return _this7.$doSideBarRowSelected(doesNodeHaveSelectedPxLayers, table);
            });
          }
        })), showProperties && UxModel.jsx(TitlePane, {
          name: "properties",
          className: "-t-UxBuilder-properties -t-UxBuilder-sidebar",
          lax: true // TODO: 65372
          ,
          properties: {
            moduleName: 'uxBuilder',
            keyName: 'PropertiesWidget',
            headerCommands: [this.$maxRestorePropertiesCmd],
            hideTitlePane: function hideTitlePane() {
              return unselect('showProperties', _this7.$propertiesToggleCommand);
            }
          }
        }, UxModel.jsx(PropertiesWidget, {
          name: "content",
          lax: true // TODO: 65372
          ,
          value: [] // for performance reasons never reload PropertiesWidget as part of rerender process - see TREE_MODIFIED handler
          ,
          properties: {
            pxLayers: pxLayers,
            pxProperties: pxProperties,
            baseOrd: baseOrd
          },
          onUxModifiedValue: function onUxModifiedValue(changes, e, propertiesWidget) {
            var nodes = propertiesWidget.value();
            return _this7.$applyChangesToNodes(nodes, changes).then(function () {
              return _this7.rerender();
            });
          }
        })));
      }

      /**
       * UxBuilder never loads an actual value, only by ORD. `resolve()` will resolve that ORD and
       * convert it to the UxModel and other necessary data derived from that ORD.
       *
       * @param {string|baja.Ord} ord
       * @returns {Promise}
       */
    }, {
      key: "resolve",
      value: function resolve(ord) {
        var _this8 = this;
        if (this.$ord) {
          return Promise.reject(new Error('invariant: resolve() should only be called once'));
        }
        ord = baja.Ord.make(ord);

        // the commands need to know the original ord...
        return this.$makeCommands(ord).then(function () {
          // but the UxModel and PxWidget need to have /uxBuilder stripped out.
          // this is because if /uxBuilder is present, the request for Px data will fail.
          // it needs to be requested straight from the actual Px view.
          ord = _this8.$ord = TogglePxEditModeCommand.removeUxBuilderFromViewId(ord);
        });
      }

      /**
       * @param {module:nmodule/uxBuilder/rc/ux/UxBuilderOptions} [options]
       * @returns {Promise}
       */
    }, {
      key: "applyUserOptions",
      value: function applyUserOptions(options) {
        var properties = this.properties();
        properties.setValue('showGrid', options.getShowGrid());
        properties.setValue('gridSize', options.getGridSize());
        properties.setValue('gridColor', options.getGridColor());
        properties.setValue('showHatch', options.getShowHatch());
        properties.setValue('useSnap', options.getUseSnap());
        properties.setValue('snapSize', options.getSnapSize());
        properties.setValue('hatchColor', options.getHatchColor());
        properties.setValue('preserveIdentities', options.getPreserveIdentities());
        this.$setUxBuilderOptionsForUxModelTreeNode(options);
        return this.$refreshWidgetTreeForPreserveIdentities();
      }

      /**
       * @private
       * @param {module:nmodule/uxBuilder/rc/ux/UxBuilderOptions} options
       */
    }, {
      key: "$setUxBuilderOptionsForUxModelTreeNode",
      value: function $setUxBuilderOptionsForUxModelTreeNode(options) {
        //Hack to avoid network call
        UxModelTreeNode.$getUxBuilderOptions = function () {
          return Promise.resolve(options);
        };
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$refreshWidgetTreeForPreserveIdentities",
      value: function $refreshWidgetTreeForPreserveIdentities() {
        var _this9 = this;
        var widgetTree = this.$getWidgetTree();
        return Promise["try"](function () {
          return widgetTree && widgetTree.value().visit(function (node) {
            return _this9.$emitRenamedOnParent(node);
          });
        });
      }

      /**
       * @private
       * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} node
       */
    }, {
      key: "$emitRenamedOnParent",
      value: function $emitRenamedOnParent(node) {
        var nodeName = node.getName();
        node.getParent().emit('renamed', nodeName, nodeName);
      }

      /**
       * @private
       * @param {boolean} isMaximized
       * @param {String} widgetName
       * @returns {module:bajaux/commands/Command}
       */
    }, {
      key: "$makeMaximizeRestoreCommand",
      value: function $makeMaximizeRestoreCommand(isMaximized, widgetName) {
        var self = this;
        var _getLexValue = getLexValue(isMaximized),
          icon = _getLexValue.icon,
          description = _getLexValue.description,
          displayName = _getLexValue.displayName;
        return new Command({
          icon: icon,
          description: description,
          displayName: displayName,
          func: function func() {
            var _getLexValue2 = getLexValue(!isSidebarMaximized(this)),
              icon = _getLexValue2.icon,
              description = _getLexValue2.description,
              displayName = _getLexValue2.displayName;
            this.setDisplayNameFormat(displayName);
            this.setDescriptionFormat(description);
            this.setIcon(icon);
            return self.$saveSidebarsAndRerender(widgetName, isSidebarMaximized(this));
          }
        });
      }

      /**
       * Dynamically creates sidebar max and restore commands derived from available localStorage states.
       *
       * @private
       */
    }, {
      key: "$makeMaxRestoreCommandsForSidebars",
      value: function $makeMaxRestoreCommandsForSidebars() {
        var _this10 = this;
        var states = this.$getSavedStates();
        Object.keys(states).forEach(function (key) {
          if (key === 'pxWidget') {
            return;
          }
          _this10["$maxRestore".concat(key.capitalizeFirstLetter(), "Cmd")] = _this10.$makeMaximizeRestoreCommand(states[key].isMaximized, key);
        });
      }

      /**
       * @private
       * @param {Number} zoom
       * @returns {Promise}
       */
    }, {
      key: "$updateZoomGridLineSizeAndRerender",
      value: function $updateZoomGridLineSizeAndRerender(zoom) {
        var gridLineSize = Math.round(zoom) <= MIN_ZOOM_LIMIT ? MAX_GRID_LINE_SIZE : DEFAULT_GRID_LINE_SIZE;
        this.properties().setValue('gridLineSize', gridLineSize);
        this.properties().setValue('zoom', zoom);
        return this.rerender();
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$zoomIn",
      value: function $zoomIn() {
        var zoomValue;
        var zoom = this.properties().getValue('zoom');
        if ((zoomValue = zoom + ZOOM_INCREMENT) >= MAX_ZOOM_LIMIT) {
          zoom = MAX_ZOOM_LIMIT - ZOOM_INCREMENT;
        } else {
          zoom = zoomValue;
        }
        return this.$updateZoomGridLineSizeAndRerender(zoom);
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$zoomOut",
      value: function $zoomOut() {
        var zoomValue;
        var zoom = this.properties().getValue('zoom');
        if ((zoomValue = zoom - ZOOM_INCREMENT) < ZOOM_INCREMENT) {
          zoom = ZOOM_INCREMENT;
        } else {
          zoom = zoomValue;
        }
        return this.$updateZoomGridLineSizeAndRerender(zoom);
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$resetZoom",
      value: function $resetZoom() {
        return this.$updateZoomGridLineSizeAndRerender(DEFAULT_ZOOM);
      }

      /**
       * @private
       * @param {baja.Ord} ord
       * @returns {Promise}
       */
    }, {
      key: "$makeCommands",
      value: function $makeCommands(ord) {
        var _this11 = this;
        return TogglePxEditModeCommand.make(ord, this).then(function (togglePxEditModeCommand) {
          var commandGroup = _this11.getCommandGroup();

          //add SaveCommand to the builder's command group
          commandGroup.add(new SaveCommand());

          //add ZoomIn, ZoomOut and ZoomReset commands. ZoomIn and Zoom are uxBuilder due to accelerator conflicts
          _this11.$zoomInCommand = new Command({
            module: 'uxBuilder',
            lex: 'commands.zoomIn',
            func: function func() {
              return _this11.$zoomIn();
            }
          });
          _this11.$zoomOutCommand = new Command({
            module: 'uxBuilder',
            lex: 'commands.zoomOut',
            func: function func() {
              return _this11.$zoomOut();
            }
          });
          _this11.$resetZoomCommand = new Command({
            module: 'bajaui',
            lex: 'commands.zoomReset',
            func: function func() {
              return _this11.$resetZoom();
            }
          });
          commandGroup.add(_this11.$zoomInCommand).add(_this11.$zoomOutCommand).add(_this11.$resetZoomCommand);

          //add ToggleCommandGroup to the builder's command group
          _this11.$toggleCommandGroup = _this11.$makeToggleCommandGroup();
          commandGroup.add(new ContextMenuCommand({
            module: 'uxBuilder',
            lex: 'UxBuilder.sideBarMenu',
            makeCommandGroup: function makeCommandGroup() {
              return _this11.$toggleCommandGroup;
            }
          }));

          //add Drawing tools
          commandGroup.add(_this11.$makeDrawingToolsToggleCommand());
          if (togglePxEditModeCommand) {
            commandGroup.add(togglePxEditModeCommand);
          }
          _this11.$goToSourceCommand = new GoToSourceCommand(_this11);
          commandGroup.add(_this11.$goToSourceCommand);

          // add UserDataOptionsCommand to the builder's command group
          commandGroup.add(new UserDataOptionsCommand({
            description: uxBuilderLex.get('UxBuilderOptions.title'),
            type: UxBuilderOptions,
            view: _this11
          }));

          // make commands to restore and maximize sidebars.
          _this11.$makeMaxRestoreCommandsForSidebars();
        });
      }

      /**
       * @private
       * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} node
       * @returns {boolean}
       */
    }, {
      key: "$canEditNode",
      value: function $canEditNode(node) {
        return isUxModelEditable(node.value());
      }

      /**
       * @private
       * @returns {module:nmodule/bajaui/rc/ux/SplitPane}
       */
    }, {
      key: "$getSplitPane",
      value: function $getSplitPane() {
        return this.queryWidget('splitPane');
      }

      /**
       * @private
       * @returns {module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxStudioWrapper|null}
       */
    }, {
      key: "$getPxStudio",
      value: function $getPxStudio() {
        var splitPane = this.$getSplitPane();
        if (!splitPane) {
          return null;
        }
        return splitPane.$getWidget1();
      }

      /**
       * @private
       * @returns {module:nmodule/bajaui/rc/ux/PxWidget}
       */
    }, {
      key: "$getPxWidget",
      value: function $getPxWidget() {
        return this.$getPxStudio().$getPxWidget();
      }

      /**
       * @private
       * @returns {module:nmodule/bajaui/rc/ux/Terrace|null}
       */
    }, {
      key: "$getEditPane",
      value: function $getEditPane() {
        var splitPane = this.$getSplitPane();
        if (!splitPane) {
          return null;
        }
        return splitPane.$getWidget2();
      }

      /**
       * This returns the WidgetTree holding the root widget of the Px page, since that's what
       * external callers will be interested in. There's actually a dummy WidgetTree above this one
       * that holds the wrapper node.
       *
       * Protip: when calling `setSelectedPath` on this tree, the path should start with `'root'`
       * since NavTree expects the loaded node to be included in the path, so it can self-select. When
       * calling `getDescendent` on its `value()`, `'root'` should *not* be included in that path.
       *
       * @private
       * @returns {module:nmodule/uxBuilder/rc/ux/sidebars/WidgetTree|null}
       */
    }, {
      key: "$getWidgetTree",
      value: function $getWidgetTree() {
        var editPane = this.$getEditPane();
        if (!editPane) {
          return null;
        }
        var contentWidgets = editPane.$getKidWidgets().filter(function (kidWidget) {
          return kidWidget.$getContentWidget() instanceof WidgetTree;
        });
        if (contentWidgets.length) {
          return contentWidgets[0].$getContentWidget().$getKids()[0];
        }
        return null;
      }

      /**
       * Returns the properties widget
       * @private
       * @returns {module:nmodule/uxBuilder/rc/ux/sidebars/PropertiesWidget|null}
       */
    }, {
      key: "$getPropertiesSideBar",
      value: function $getPropertiesSideBar() {
        return getSidebar(this.$getEditPane(), PropertiesWidget);
      }

      /**
       * @private
       * @returns {module:nmodule/uxBuilder/rc/ux/sidebars/PxPropertiesWidget|null}
       */
    }, {
      key: "$getPxPropertiesSideBar",
      value: function $getPxPropertiesSideBar() {
        return getSidebar(this.$getEditPane(), PxPropertiesWidget);
      }

      /**
       * @private
       * @returns {module:nmodule/uxBuilder/rc/ux/sidebars/PxLayersWidget|null}
       */
    }, {
      key: "$getPxLayersSideBar",
      value: function $getPxLayersSideBar() {
        return getSidebar(this.$getEditPane(), PxLayersWidget);
      }

      /**
       * @private
       * @returns {module:nmodule/uxBuilder/rc/ux/sidebars/BoundOrdsEditor|null}
       */
    }, {
      key: "$getBoundOrdsSideBar",
      value: function $getBoundOrdsSideBar() {
        return getSidebar(this.$getEditPane(), BoundOrdsEditor);
      }

      /**
       * Shows the widget properties for the given UxModel in the widget tree.
       * Will be replaced going forward with actual Properties dialog.
       *
       * @private
       * @param {Array<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} uxModelTreeNodes
       * @returns {Promise.<boolean>} truthy if the user committed changes in the dialog; falsy if
       * cancelled
       */
    }, {
      key: "$showWidgetPropsInDialog",
      value: function $showWidgetPropsInDialog(uxModelTreeNodes) {
        var _this12 = this;
        var _this$state2 = this.state(),
          _this$state2$pxLayers = _this$state2.pxLayers,
          pxLayers = _this$state2$pxLayers === void 0 ? [] : _this$state2$pxLayers,
          _this$state2$pxProper = _this$state2.pxProperties,
          pxProperties = _this$state2$pxProper === void 0 ? {} : _this$state2$pxProper,
          baseOrd = _this$state2.baseOrd;
        return promptForChanges(uxModelTreeNodes, {
          readonly: this.isReadonly(),
          pxLayers: pxLayers,
          pxProperties: pxProperties,
          baseOrd: baseOrd
        }).then(function (changes) {
          if (!changes) {
            return;
          }
          return _this12.$applyChangesToNodes(uxModelTreeNodes, changes).then(function () {
            return true;
          });
        });
      }

      /**
       * @private
       * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} uxModelTreeNodes
       * @param {module:nmodule/uxBuilder/rc/ux/sidebars/PropertiesWidget~WidgetNodeChanges} changes
       * @returns {Promise}
       */
    }, {
      key: "$applyChangesToNodes",
      value: function $applyChangesToNodes(uxModelTreeNodes, changes) {
        var _this13 = this;
        var uxModels = uxModelTreeNodes.map(function (node) {
          return node.value();
        });
        return Promise.all([cloneWithChanges(uxModels, changes), UxModelTreeNode.formatDisplayNames(uxModelTreeNodes)]).then(function (_ref19) {
          var _ref20 = _slicedToArray(_ref19, 2),
            clones = _ref20[0],
            formattedNames = _ref20[1];
          var ops = uxModelTreeNodes.map(function (node, i) {
            var model = clones[i];
            return {
              parentNode: node.getParent(),
              model: model,
              name: model.getName()
            };
          });
          return ModifyUxModelCommand.modify(ops, {
            redoText: function redoText() {
              return uxBuilderLex.get('commands.editProperties.redoText', formattedNames);
            },
            undoText: function undoText() {
              return uxBuilderLex.get('commands.editProperties.undoText', formattedNames);
            },
            onNewNodes: function onNewNodes() {
              _this13.setModified(true);
              return _this13.rerender();
            }
          });
        });
      }

      /**
       * @override
       * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} subject the node into which
       * we're pasting
       * @param {Object} pasteParams params with info about the data being pasted
       * @returns {Promise}
       */
    }, {
      key: "insertTransferData",
      value: function insertTransferData(subject, pasteParams) {
        // Strip links when the matching PxProperty is unavailable.
        this.$stripLinksAndLayers(pasteParams);
        return this.$insert(subject, pasteParams);
      }

      /**
       * @override
       * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodes the nodes which we are copying.
       * @returns <Promise.<{module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNodeEnvelope}>>
       */
    }, {
      key: "getTransferData",
      value: function getTransferData(nodes) {
        var _this$state3 = this.state(),
          pxProperties = _this$state3.pxProperties;
        return UxModelTreeNode.toEnvelope(nodes, {
          pxProperties: pxProperties
        });
      }

      /**
       * For the Cut Command, copy the widgets and pre-emptively delete the widgets (just like BPxTree.java#removeTransferData)
       * @override
       * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} subject
       * @param {Object} [params] the object literal containing the method's arguments
       * @param {module:nmodule/webEditors/rc/wb/util/TransferWidget} [params.transferWidget]
       * @returns {Promise}
       */
    }, {
      key: "removeTransferData",
      value: function removeTransferData(subject, params) {
        return TransferDataManager.getInstance().cut(subject, params).then(function () {
          return DeleteUxModelCommand["delete"](subject);
        });
      }

      /**
       * @private
       * @param {Object} params The parametes for the function
       * @param {Number} [params.snapSize] the snap size to be applied, undefined if the snap is not to be applied
       * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} [params.nodes]
       * @returns {Promise.<module:bajaux/commands/CommandGroup>}
       */
    }, {
      key: "$makeContextMenuCommandGroup",
      value: function $makeContextMenuCommandGroup(params) {
        var _this14 = this;
        var nodes = params.nodes;
        var snapSize = params.snapSize;
        var transferWidget = this;
        var readonly = this.isReadonly();
        var editPropertiesFunc = this.$editPropertiesFunc;
        var pxLayers = this.state().pxLayers;
        var beforeInsert = this.$beforeInsert;
        return Promise.all([Promise["try"](function () {
          return nodes || _this14.$getSelectedNodes();
        }), UxModelTreeNode.$getUxBuilderOptions()]).then(function (_ref21) {
          var _ref22 = _slicedToArray(_ref21, 2),
            nodes = _ref22[0],
            options = _ref22[1];
          return uxBuilderContextMenu.makeContextMenuCommandGroupForWidgetNodes(nodes, {
            editPropertiesFunc: editPropertiesFunc,
            pxLayers: pxLayers,
            readonly: readonly,
            snapSize: snapSize,
            transferWidget: transferWidget,
            beforeInsert: beforeInsert,
            preserveIdentities: options.getPreserveIdentities()
          });
        });
      }

      /**
       * @private
       * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} nodeToInsertInto
       * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode~InsertOp>|object} insertOps
       * @returns {Promise}
       */
    }, {
      key: "$insert",
      value: function $insert(nodeToInsertInto, insertOps) {
        //do not process an insert, if the WidgetTree is readonly
        if (this.isReadonly()) {
          return Promise.resolve();
        }
        var _this$state4 = this.state(),
          baseOrd = _this$state4.baseOrd,
          pxProperties = _this$state4.pxProperties,
          pxLayers = _this$state4.pxLayers;
        return nodeToInsertInto.insert(insertOps, {
          baseOrd: baseOrd,
          pxProperties: pxProperties,
          pxLayers: pxLayers,
          beforeInsert: this.$beforeInsert
        });
      }

      /**
       * It will strip links and layers when they are not matched with the node that is being pasted onto.
       * @private
       * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode~InsertOp>|object} insertOps
       * @returns {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode~InsertOp>|object}
       */
    }, {
      key: "$stripLinksAndLayers",
      value: function $stripLinksAndLayers(insertOps) {
        var _this15 = this;
        var mark = insertOps.mark;
        if (mark) {
          var nodes = mark.nodes;
          nodes.forEach(function (node) {
            _this15.$stripPxProperties(node);
            _this15.$stripPxLayers(node);
          });
        }
        return insertOps;
      }

      /**
       * Strips pxLayers from the copied context when such pxLayers are unavailable in the pasted context.
       *
       * @private
       * @param {Object} json
       */
    }, {
      key: "$stripPxLayers",
      value: function $stripPxLayers(json) {
        var _this16 = this;
        var _this$state5 = this.state(),
          pxLayers = _this$state5.pxLayers;
        Object.entries(json.p).forEach(function (_ref23) {
          var _ref24 = _slicedToArray(_ref23, 2),
            _ref24$ = _ref24[1],
            n = _ref24$.n,
            v = _ref24$.v,
            t = _ref24$.t;
          // When I do not have pxLayers from the copied context, then no further pxLayer filtering is required.
          // v.s will host an array of pxLayers associated with the copied widget tree node.
          if (t === 'bajaui:LayerTag' && v.s) {
            var layers = [];
            v.s.forEach(function (layer) {
              if (pxLayers.find(function (pxLayer) {
                return pxLayer.name === layer.v;
              })) {
                layers.push(layer);
              }
            });
            v.s = layers;
          }
        });
        // When I have kids, I wish to strip their pxLayers.
        if (!isEmpty(json.k)) {
          json.k.forEach(function (k) {
            return _this16.$stripPxLayers(k);
          });
        }
      }

      /**
       * Strips pxProperties from the copied context when such pxProperties are unavailable in the pasted context.
       *
       * @private
       * @param {Object} json
       */
    }, {
      key: "$stripPxProperties",
      value: function $stripPxProperties(json) {
        var _this17 = this;
        var _this$state6 = this.state(),
          pxProperties = _this$state6.pxProperties;
        var isPropertiesFound = Object.entries(json.p).filter(function (_ref25) {
          var _ref26 = _slicedToArray(_ref25, 2),
            obj = _ref26[1];
          return !isEmpty(Object.entries(json.l).filter(function (_ref27) {
            var _ref28 = _slicedToArray(_ref27, 1),
              name = _ref28[0];
            return name === obj.n;
          }));
        });

        // Strips property links for the widgetProps
        if (!isEmpty(isPropertiesFound)) {
          isPropertiesFound.forEach(function (_ref29) {
            var _ref30 = _slicedToArray(_ref29, 2),
              index = _ref30[0],
              obj = _ref30[1];
            var propName = json.l[obj.n];
            // When linked property is found, check if such "named" property already exists in the paste context.
            // If such property exists, check for its type.
            // When the type of the existing pxProperty and the link did not match, then delete the link, this will ensure that the wrong data is not copied from the link.
            if (!propName || !(pxProperties[propName] && pxProperties[propName].value.getType().getTypeSpec() === obj.t)) {
              delete json.l[obj.n];
            }
          });
        }

        // Strips binding links
        Object.entries(json.bnd).filter(function (_ref31) {
          var _ref32 = _slicedToArray(_ref31, 2),
            index = _ref32[0],
            obj = _ref32[1];
          // When Binding does not have an Ord Property and none of the properties are linked,
          // then obj.s will not be undefined, in that case skip strip.
          if (!obj.s) {
            return;
          }
          // Filter pxProperties which have the same name as the linked pxProperty.
          var bindingName = obj.t.split(':')[1] + (parseInt(index) || '') + '/';
          var bindingLinkedPxProperties = Object.entries(obj.s).filter(function (_ref33) {
            var _ref34 = _slicedToArray(_ref33, 2),
              attr = _ref34[1];
            return !!pxProperties[json.l[bindingName + attr.n]];
          });
          // When linked pxProperties are available in the binding, check for its type.
          if (!isEmpty(bindingLinkedPxProperties)) {
            bindingLinkedPxProperties.forEach(function (_ref35) {
              var _ref36 = _slicedToArray(_ref35, 2),
                index = _ref36[0],
                ob = _ref36[1];
              // For each linked PxProperty find the name of the pxProperty and delete the link if type is different.
              var linkName = bindingName + ob.n;
              var pxPropertyValue = json.l[linkName];
              if (pxPropertyValue) {
                if (ob.t !== pxProperties[pxPropertyValue].value.getType().getTypeSpec()) {
                  // Delete the link in json if the types are different for the same named pxProperty.
                  delete json.l[linkName];
                  obj.s.splice(index, 1);
                } else {
                  // When the types are similar, then copy the value of pxProperty.
                  ob.v = pxProperties[pxPropertyValue].value.encodeToString();
                }
              }
            });
          } else {
            // When no pxProperties are available find the linked binding properties and remove them from json.
            Object.keys(json.l).filter(function (key) {
              return key.indexOf(bindingName) !== -1;
            }).forEach(function (key) {
              return delete json.l[key];
            });
          }
        });
        // When I have kids, I wish to strip their pxProperties.
        if (!isEmpty(json.k)) {
          json.k.forEach(function (k) {
            return _this17.$stripPxProperties(k);
          });
        }
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$refreshPropertiesWidget",
      value: function $refreshPropertiesWidget() {
        var _this18 = this;
        var propertiesWidget = this.$getPropertiesSideBar();
        var pxLayers = this.state().pxLayers;
        return this.$getSelectedNodes().then(function (nodes) {
          _this18.$moveCommands.forEach(function (cmd) {
            return cmd.setNodes(nodes, pxLayers);
          });
          if (!propertiesWidget) {
            return;
          }
          var jq = propertiesWidget.jq();
          if (!jq || !jq.length) {
            return;
          }
          var focusInPropertiesWidget = $.contains(jq[0], document.activeElement);
          return !focusInPropertiesWidget && propertiesWidget.load(nodes);
        });
      }

      /**
       * Set the currently selected paths, and ensure that all necessary spots are updated
       * accordingly (widget tree nodes, properties sidebar, and painted rectangles).
       *
       * @private
       * @param {string[][]} selectedPaths the new selected paths, relative to root
       * @returns {Promise}
       */
    }, {
      key: "$setSelectedPaths",
      value: function $setSelectedPaths(selectedPaths) {
        this.$selectedPaths = selectedPaths;
        var widgetTree = this.$getWidgetTree();
        var studio = this.$getPxStudio();
        this.$refreshPropertiesWidgetSoon();
        return Promise.all([widgetTree && widgetTree.$setSelectedPaths(selectedPaths), studio && studio.$updateSelectedWidgets()]);
      }

      /**
       * @param {string[]} path path to select (relative to root)
       * @param {'exclusive' | 'toggle' | 'ensure'} [action='exclusive']
       * @returns {Promise}
       * @see {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode#requestSelection}
       */
    }, {
      key: "selectPath",
      value: function selectPath(path) {
        var action = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'exclusive';
        // see mux'd function in constructor
        return this.$changeSelectedPaths([action].concat(_toConsumableArray(path)).join());
      }

      /**
       * @param {string[]} path path to select (relative to root)
       * @returns {Promise}
       */
    }, {
      key: "deselectPath",
      value: function deselectPath(path) {
        // see mux'd function in constructor
        return this.$changeSelectedPaths(['deselect'].concat(_toConsumableArray(path)).join());
      }

      /**
       * @private
       * @param {string[]} changes
       * @returns {Promise}
       */
    }, {
      key: "$doChangeSelectedPaths",
      value: function $doChangeSelectedPaths(changes) {
        /*
        changes are strings to work with promiseMux, which uses string encoding to coalesce calls
         */
        var join = function join(arr) {
          return arr.join(',');
        };
        var split = function split(str) {
          return str ? str.split(',') : [];
        }; // because '' splits to [ '' ]

        // toString em so without() works
        var newSelectedPaths = this.$selectedPaths.map(join);
        changes.forEach(function (change) {
          var _split = split(change),
            _split2 = _toArray(_split),
            op = _split2[0],
            path = _split2.slice(1);
          var joined = join(path);
          switch (op) {
            case 'exclusive':
              newSelectedPaths = [joined];
              break;
            case 'toggle':
              if (newSelectedPaths.includes(joined)) {
                newSelectedPaths = without(newSelectedPaths, joined);
              } else {
                newSelectedPaths.push(joined);
              }
              break;
            case 'ensure':
              if (!newSelectedPaths.includes(joined)) {
                newSelectedPaths = [joined];
              }
              break;
            case 'deselect':
              newSelectedPaths = without(newSelectedPaths, joined);
              break;
          }
        });
        return this.$setSelectedPaths(newSelectedPaths.map(split));
      }

      /**
       * @private
       * @returns {module:bajaux/commands/CommandGroup}
       */
    }, {
      key: "$makeToggleCommandGroup",
      value: function $makeToggleCommandGroup() {
        var _this19 = this;
        var makeTogglePropertyCommand = function makeTogglePropertyCommand(displayName, propertyName) {
          return new TogglePropertyCommand(_this19, displayName, propertyName);
        };
        return new CommandGroup({
          commands: [this.$sideBarToggleCommand = makeTogglePropertyCommand(uxBuilderLex.get('UxBuilder.sideBar.displayName'), 'showSideBar'), this.$boundOrdsToggleCommand = makeTogglePropertyCommand(uxBuilderLex.get('BoundOrdsEditor.displayName'), 'showBoundOrds'), this.$widgetTreeToggleCommand = makeTogglePropertyCommand(uxBuilderLex.get('WidgetTree.displayName'), 'showWidgetTree'), this.$pxPropertiesToggleCommand = makeTogglePropertyCommand(uxBuilderLex.get('PxPropertiesWidget.displayName'), 'showPxProperties'), this.$pxLayersToggleCommand = makeTogglePropertyCommand(uxBuilderLex.get('PxLayersWidget.displayName'), 'showPxLayers'), this.$propertiesToggleCommand = makeTogglePropertyCommand(uxBuilderLex.get('PropertiesWidget.displayName'), 'showProperties')]
        });
      }

      /**
       * @private
       * @returns {module:nmodule/uxBuilder/rc/ux/UxBuilder~DrawingToolsToggleCommand} 
       */
    }, {
      key: "$makeDrawingToolsToggleCommand",
      value: function $makeDrawingToolsToggleCommand() {
        return new DrawingToolsToggleCommand(this);
      }

      /**
       * @private
       * @returns {module:bajaux/commands/ToggleCommandGroup} 
       */
    }, {
      key: "$makeDrawingToolsGroup",
      value: function $makeDrawingToolsGroup(toggleCmd) {
        var _this20 = this;
        var studio = this.$getPxStudio(),
          controller = studio.$getPxOverlayController();
        var activePen = this.properties().getValue('activePen');
        var cmdGroup = new ToggleCommandGroup({
          commands: [{
            module: 'uxBuilder',
            lex: 'commands.addPolygon',
            value: 'polygon',
            selected: activePen === 'polygon'
          }, {
            module: 'uxBuilder',
            lex: 'commands.addPath',
            value: 'path',
            selected: activePen === 'path'
          }, {
            module: 'uxBuilder',
            lex: 'commands.addPoint',
            value: 'addPoint',
            selected: activePen === 'addPoint'
          }, {
            module: 'uxBuilder',
            lex: 'commands.deletePoint',
            value: 'deletePoint',
            selected: activePen === 'deletePoint'
          }],
          onChange: function onChange(value) {
            _this20.properties().setValue('activePen', value);
            toggleCmd.setSelected(!!value);
            return controller.$startDrawingTracker(value);
          }
        });
        return feDialogs.showFor({
          type: CommandButtonGroup,
          value: cmdGroup,
          formFactor: 'mini',
          properties: {
            toolbar: true,
            rootCssClass: '-t-UxBuilder-DrawingToolPicker'
          },
          buttons: [{
            name: 'ok'
          }, {
            name: 'select',
            displayName: uxBuilderLex.get('commands.normalTool.displayName'),
            handler: function handler() {
              _this20.properties().setValue('activePen', null);
              toggleCmd.setSelected(false);
              return Promise.all([_this20.$setSelectedPaths([]), controller.$resetDrawingTracker()]);
            }
          }]
        });
      }

      /**
       * Toggles widgets' highlight status when a tree is selected or deselected
       *
       * @private
       * @param {module:nmodule/uxBuilder/rc/ux/sidebars/WidgetTree} selectedTree
       * @param {boolean} highlighted
       * @returns {Promise}
       */
    }, {
      key: "$setHighlightStatus",
      value: function $setHighlightStatus(selectedTree, highlighted) {
        var selectedTreeValue = selectedTree.value();
        return highlighted && this.$handleTabbedPane(selectedTreeValue);
      }

      /**
       * Determines if the selected node is on a TabbedPane and if so makes sure the LabelPane the
       * widget is on is selected and visible, calling the setSelectedIndex on the TabbedPane
       * @private
       * @param uxModelTreeNode
       * @returns {Promise}
       */
    }, {
      key: "$handleTabbedPane",
      value: function $handleTabbedPane(uxModelTreeNode) {
        var labelPane;
        var tabbedPane;
        var index;
        var node = uxModelTreeNode;
        while (true) {
          if (!node) {
            break;
          }
          if (node.represents(LabelPane)) {
            labelPane = node;
            break;
          }
          node = node.getParent();
        }
        if (labelPane) {
          tabbedPane = labelPane.getParent();
          return tabbedPane.getKids().then(function (labelPanes) {
            index = labelPanes.findIndex(function (pane) {
              return pane === labelPane;
            });
            tabbedPane.getLastBuiltWidget().setSelectedIndex(index);
          });
        }
      }

      /**
       * Saves the updated px file to the disk
       * @returns {Promise}
       */
    }, {
      key: "doSave",
      value: function doSave() {
        // When you have errors in modified rows of the PropertiesWidget,
        // then set the modified to false, reset the errors and return.
        var propertiesWidget = this.$getPropertiesSideBar();
        var readErrorStr = propertiesWidget && propertiesWidget.$getReadErrorsAsString();
        if (!isEmpty(readErrorStr)) {
          return Promise.reject(readErrorStr);
        }
        var _this$state7 = this.state(),
          wrapperNode = _this$state7.wrapperNode,
          baseOrd = _this$state7.baseOrd,
          pxLayers = _this$state7.pxLayers;
        var _this$state8 = this.state(),
          pxProperties = _this$state8.pxProperties;
        var uxModelTreeNode = getRootNode(wrapperNode);
        return UxModelTreeNode.$getUxBuilderOptions().then(function (options) {
          return uxBuilder.save({
            baseOrd: baseOrd,
            pxLayers: pxLayers,
            pxProperties: reconstitutePxProperties(uxModelTreeNode.value(), pxProperties),
            uxModelTreeNode: uxModelTreeNode,
            preserveIdentities: options.getPreserveIdentities()
          }).then(function () {
            return uxBuilder.$removeFromServletMemoizeCache(baseOrd);
          }).then(function () {
            return propertiesWidget && propertiesWidget.$clearModified();
          });
        });
      }

      /**
       * @private
       * @param {string} oldPxPropertyName
       * @param {string} newPxPropertyName
       * @returns {Promise}
       */
    }, {
      key: "$renamePxProperty",
      value: function $renamePxProperty(oldPxPropertyName, newPxPropertyName) {
        var _this21 = this;
        var _this$state9 = this.state(),
          oldPxProperties = _this$state9.pxProperties,
          wrapperNode = _this$state9.wrapperNode;
        var rootContainerNode = getRootContainerNode(wrapperNode);
        var newPxProperties = {};
        Object.entries(oldPxProperties).forEach(function (_ref37) {
          var _ref38 = _slicedToArray(_ref37, 2),
            oldName = _ref38[0],
            oldValueObj = _ref38[1];
          if (oldName === oldPxPropertyName) {
            newPxProperties[newPxPropertyName] = oldValueObj;
          } else {
            newPxProperties[oldName] = oldValueObj;
          }
        });
        return withPxPropertyRenamed(rootContainerNode.value(), oldPxPropertyName, newPxPropertyName).then(function (model) {
          return _this21.$swapPxProperties({
            oldPxProperties: oldPxProperties,
            newPxProperties: newPxProperties,
            model: model,
            redoText: uxBuilderLex.get('PxPropertiesWidget.commands.rename.redoText', oldPxPropertyName, newPxPropertyName),
            undoText: uxBuilderLex.get('PxPropertiesWidget.commands.rename.undoText', newPxPropertyName, oldPxPropertyName)
          });
        });
      }

      /**
       * @private
       * @param {string} removedName
       * @returns {Promise}
       */
    }, {
      key: "$removePxProperty",
      value: function $removePxProperty(removedName) {
        var _this22 = this;
        var _this$state10 = this.state(),
          oldPxProperties = _this$state10.pxProperties,
          wrapperNode = _this$state10.wrapperNode;
        var rootContainerNode = getRootContainerNode(wrapperNode);
        var newPxProperties = omit(oldPxProperties, removedName);
        return withPxPropertyDeleted(rootContainerNode.value(), removedName).then(function (model) {
          return _this22.$swapPxProperties({
            oldPxProperties: oldPxProperties,
            newPxProperties: newPxProperties,
            model: model,
            redoText: uxBuilderLex.get('PxPropertiesWidget.commands.remove.redoText', removedName),
            undoText: uxBuilderLex.get('PxPropertiesWidget.commands.remove.undoText', removedName)
          });
        });
      }

      /**
       * @private
       * @param {string} pxPropertyName
       * @param {baja.Value} value
       * @returns {Promise}
       */
    }, {
      key: "$addPxProperty",
      value: function $addPxProperty(pxPropertyName, value) {
        var _this23 = this;
        var _this$state11 = this.state(),
          oldPxProperties = _this$state11.pxProperties,
          wrapperNode = _this$state11.wrapperNode;
        var rootContainerNode = getRootContainerNode(wrapperNode);
        var existing = oldPxProperties[pxPropertyName];
        var newPxProperties = Object.assign({}, oldPxProperties, _defineProperty({}, pxPropertyName, {
          value: value,
          targets: existing ? existing.targets.slice() : []
        }));
        return Promise.all([rootContainerNode.value().clone(),
        // just for consistency
        value.toString({})]).then(function (_ref39) {
          var _ref40 = _slicedToArray(_ref39, 2),
            model = _ref40[0],
            display = _ref40[1];
          return _this23.$swapPxProperties({
            oldPxProperties: oldPxProperties,
            newPxProperties: newPxProperties,
            model: model,
            redoText: uxBuilderLex.get('PxPropertiesWidget.commands.add.redoText', pxPropertyName, value),
            undoText: uxBuilderLex.get('PxPropertiesWidget.commands.add.undoText', pxPropertyName)
          });
        });
      }

      /**
       * @private
       * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxProperties} params.oldPxProperties
       * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxProperties} params.newPxProperties
       * @param {module:bajaux/model/UxModel} params.model model with PxProperties applied
       * @param {string} params.redoText
       * @param {string} params.undoText
       */
    }, {
      key: "$swapPxProperties",
      value: function $swapPxProperties(params) {
        var _this24 = this;
        var oldPxProperties = params.oldPxProperties,
          newPxProperties = params.newPxProperties,
          model = params.model,
          redoText = params.redoText,
          undoText = params.undoText;
        var _this$state12 = this.state(),
          wrapperNode = _this$state12.wrapperNode;
        var rootContainerNode = getRootContainerNode(wrapperNode);
        return new ReplaceUxModelCommand([{
          parentNode: wrapperNode,
          model: model,
          name: rootContainerNode.getName()
        }], {
          onRedo: function onRedo() {
            return _this24.state({
              pxProperties: newPxProperties
            });
          },
          onUndo: function onUndo() {
            return _this24.state({
              pxProperties: oldPxProperties
            });
          },
          redoText: redoText,
          undoText: undoText
        }).invoke();
      }

      /**
       * Returns a list of selected widgets
       * @private
       * @returns {Promise.<Array.<module:bajaux/Widget>>}
       */
    }, {
      key: "$getSelectedWidgets",
      value: function $getSelectedWidgets() {
        return this.$getSelectedNodes().then(function (nodes) {
          return nodes.map(function (node) {
            return node.getLastBuiltWidget();
          });
        });
      }

      /**
       * @private
       * @returns {Promise.<Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>>}
       */
    }, {
      key: "$getSelectedNodes",
      value: function $getSelectedNodes() {
        var _this$state13 = this.state(),
          wrapperNode = _this$state13.wrapperNode;
        var rootNode = getRootNode(wrapperNode);
        return Promise.all(this.$selectedPaths.map(function (path) {
          return rootNode.getDescendent(path);
        })).then(function (nodes) {
          return nodes.filter(function (node) {
            return node;
          });
        });
      }
    }]);
  }(spandrel(function (value, state) {
    var wrapperNode = state.wrapperNode,
      pxProperties = state.pxProperties,
      baseOrd = state.baseOrd,
      properties = state.properties,
      self = state.self,
      pxLayers = state.pxLayers;
    var gridColor = properties.gridColor,
      gridSize = properties.gridSize,
      hatchColor = properties.hatchColor,
      showGrid = properties.showGrid,
      showHatch = properties.showHatch,
      gridLineSize = properties.gridLineSize,
      zoom = properties.zoom;
    var id = self.$id;
    var states = self.$getSavedStates();
    // isMaximized property of the pxWidget state defines the sidebar's visibility aka 'showSideBar'.
    // See $savePxWidgetState() on how isMaximized is defined.
    var _states$pxWidget = states.pxWidget,
      orientation = _states$pxWidget.orientation,
      offsetPercent = _states$pxWidget.offsetPercent,
      isMaximized = _states$pxWidget.isMaximized;
    var dividerWidth = isMaximized ? 0 : DEFAULT_DIVIDER_WIDTH;
    return self.$makeUxModelForDisplay(getRootNode(wrapperNode).value()).then(function (displayModel) {
      return [UxModel.jsx(SplitPane, {
        spandrelKey: "splitPane",
        className: "-t-UxBuilder-SplitPane",
        lax: true,
        properties: {
          orientation: orientation,
          dividerPosition: offsetPercent,
          dividerWidth: dividerWidth,
          moveableDivider: !isMaximized
        },
        onUxPropertyChanged: function onUxPropertyChanged(e, ed, name) {
          // Upon any changes to the dividerPosition of the pxWidget's SplitPane, save it's state.
          if (name === 'dividerPosition') {
            self.$savePxWidgetState();
          }
        }
      }, UxModel.jsx(PxStudioWrapper, {
        name: "widget1",
        value: displayModel,
        className: "-t-UxBuilder-PxStudioWrapper",
        properties: {
          baseOrd: baseOrd,
          id: id,
          /*
          PxWidget still wants to render using the big pxProperties blob as
          source-of-truth for the pxProperty values for each widget. we have all
          the info we need right here to apply the pxProperty overrides directly,
          but to keep a consistent code path when rendering, we'll go ahead and
          build up the blob and pass it in.
           */
          pxProperties: reconstitutePxProperties(displayModel, pxProperties),
          pxLayers: pxLayers,
          uxBuilder: self
        }
      }), !isMaximized && self.$makeTerrace(state, displayModel)), showGrid && makeGridStyle({
        gridColor: gridColor,
        gridSize: gridSize,
        id: id,
        gridLineSize: gridLineSize
      }), showHatch && makeHatchStyle({
        hatchColor: hatchColor,
        id: id
      }), makeZoomStyle(zoom)];
    });
  }));
  function makeGridStyle(_ref41) {
    var gridColor = _ref41.gridColor,
      gridSize = _ref41.gridSize,
      id = _ref41.id,
      gridLineSize = _ref41.gridLineSize;
    return UxModel.jsx("style", {
      className: "-t-UxBuilder-grid-style"
    }, "\n      #".concat(id, " .-t-CanvasPane-viewPane {\n        background-size: ").concat(gridSize, "px ").concat(gridSize, "px;\n        background-image:\n          linear-gradient(to right, ").concat(gridColor, " ").concat(gridLineSize, "px, transparent ").concat(gridLineSize, "px),\n          linear-gradient(to bottom, ").concat(gridColor, " ").concat(gridLineSize, "px, transparent ").concat(gridLineSize, "px);\n        box-shadow: inset -1px -1px 0 0 ").concat(gridColor, ";\n      }\n    "));
  }
  function makeHatchStyle(_ref42) {
    var hatchColor = _ref42.hatchColor,
      id = _ref42.id;
    return UxModel.jsx("style", {
      className: "-t-UxBuilder-hatch-style"
    }, "\n      #".concat(id, " .-t-CanvasPane-child:not(.ux-Shape)::after {\n        content: '';\n        position: absolute;\n        top: 0;\n        right: 0;\n        bottom: 0;\n        left: 0;\n        pointer-events: none;\n        background-size: 5px 5px;\n        background-position 2.5px 2.5px;\n        background-image:\n          linear-gradient(-45deg, transparent 45%, ").concat(hatchColor, " 50%, transparent 55%, transparent 100%);\n      }\n    "));
  }
  function makeZoomStyle(zoom) {
    return UxModel.jsx("style", {
      className: "-t-UxBuilder-zoom-style"
    }, "\n      .-t-UxBuilder-ZoomPane {\n      zoom: ".concat(zoom, "\n      }\n    "));
  }
  function getSidebar(terrace, ctor) {
    if (terrace instanceof Terrace) {
      var titlePane = terrace.findChildWidget(function (kid) {
        return kid instanceof TitlePane && kid.$getContentWidget() instanceof ctor;
      });
      return titlePane ? titlePane.$getContentWidget() : null;
    } else {
      return null;
    }
  }
  function createWrapperNode(rootUxModelData, pxProperties) {
    return UxModel.make(Object.assign(rootUxModelData, {
      name: 'root'
    })).then(function (rootModel) {
      return withInitialPxPropertyData(rootModel, pxProperties);
    }).then(function (rootNode) {
      return UxModel.make({
        type: RootContainer,
        name: 'rootContainer',
        kids: [rootNode]
      });
    }).then(function (model) {
      /*
      design call: names of individual px nodes are not sent down if they're not in the .px file
      to begin with. we assign them here.
      reason: if we have to auto-generate names in the browser for the new nodes we add, and they
      have to match the auto-generated names from px editor, then we might as well auto-generate
      for all of them.
       */
      return withUniqueNames(model);
    }).then(function (rootModel) {
      return UxModelTreeNode.make({
        name: 'px',
        type: Widget,
        kids: [rootModel]
      });
    }).then(function (wrapperNode) {
      /*
      the default behavior for a UxModelTreeNode is for its kids not to officially be loaded until
      its corresponding Widget has been built.
      since this is just a dummy node, no widget will be painted, so we just short-circuit that
      behavior and allow it to expand to the root widget instantly.
       */
      wrapperNode.mayHaveKids = function () {
        return true;
      };
      wrapperNode.$loadKids = function () {
        return Promise.resolve(wrapperNode.$kids);
      };
      return wrapperNode;
    });
  }

  /**
   * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} wrapperNode the wrapper node in
   * the UxBuilder's state
   * @returns {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} its one kid node representing
   * the root widget of the Px page
   */
  function getRootNode(wrapperNode) {
    // safe for UxModelTreeNode since it's fully loaded sync; most TreeNodes should use async getKid
    return getRootContainerNode(wrapperNode).$kids[0];
  }

  /**
   * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} wrapperNode the wrapper node in
   * the UxBuilder's state
   * @returns {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} its one kid node representing
   * the RootContainer for the px page
   */
  function getRootContainerNode(wrapperNode) {
    return wrapperNode.$kids[0];
  }
});

/**
 * The current state of the UxBuilder at any one time.
 *
 * The "sources of truth" of the UxBuilder are `uxModelTreeNode`, `pxLayers`, and `pxProperties`. As
 * the page designer makes changes to the page, those changes are saved to these three values. They
 * will then be applied to the `PxWidget` to display the current page configuration to the page
 * designer, in real time.
 *
 * (As of NCCB-68099, `wrapperNode` is now source-of-truth for "which widget properties are
 * linked to which Px Properties". `pxProperties` is just source-of-truth for which Px Properties
 * exist, and their values.)
 *
 * Think of the `PxWidget` as _read-only_. Changes are made to `uxModelTreeNode`, `pxLayers`, and
 * `pxProperties`. The `PxWidget` only displays their current values.
 *
 * @typedef {object} module:nmodule/uxBuilder/rc/ux/UxBuilder~UxBuilderState
 *
 * @property {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxLayer>} pxLayers
 * @property {module:nmodule/bajaui/rc/rpc/uxBuilder~PxProperties} pxProperties
 * @property {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} wrapperNode a "dummy" wrapper
 * node whose purpose is to hold one child UxModelTreeNode, named `rootContainer`. This
 * RootContainer holds the root widget of the actual Px data. These wrapper nodes exist so they can
 * be replaced like any other node in the case where you are inserting a new widget as the root of a
 * completely empty Px page.
 *
 * @property {baja.Ord} baseOrd the resolved ORD the UxBuilder has loaded, to be used to resolve
 * relative ORDs within bindings
 * @property {boolean} fileBased will be true if pxEditor is invoked on a px file.
 */
