function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

define(['bajaux/model/UxModel', 'Promise', 'underscore'], function (UxModel, Promise, _) {
  'use strict';

  var result = _.result;
  var INSTANCE_SYMBOL = Symbol('instance');
  var UX_MODEL_DEFAULTS_SYMBOL = Symbol('uxModelDefaults');

  /**
   * API Status: **Private**
   * @exports nmodule/uxBuilder/rc/util/uxModelUtils
   */
  var exports = {};

  /**
   * @param {module:bajaux/model/UxModel} uxModel
   * @returns {module:bajaux/Widget}
   */
  exports.getInstance = function (uxModel) {
    var instance = uxModel[INSTANCE_SYMBOL];
    if (instance) {
      return instance;
    }
    var Ctor = uxModel.getType();
    return uxModel[INSTANCE_SYMBOL] = new Ctor(uxModel.toSpandrel());
  };

  /**
   * @param {module:bajaux/model/UxModel} uxModel
   * @returns {module:bajaux/model/UxModel~UxModelParams} data that can be used to construct a
   * UxModel representing the widget's default children
   */
  exports.getUxModelDefaults = function (uxModel) {
    var defs = uxModel[UX_MODEL_DEFAULTS_SYMBOL];
    if (defs) {
      return defs;
    }
    return uxModel[UX_MODEL_DEFAULTS_SYMBOL] = result(exports.getInstance(uxModel), '$uxModelDefaults') || {};
  };

  /**
   * @param {module:bajaux/model/UxModel} uxModel
   * @returns {Promise.<Array.<module:bajaux/model/UxModel>>}
   */
  exports.getDefaultKidModels = function (uxModel) {
    return UxModel.make(Object.assign({
      type: uxModel.getType()
    }, exports.getUxModelDefaults(uxModel))).then(function (defsModel) {
      return defsModel.getKids();
    });
  };

  /**
   * @param {module:bajaux/model/UxModel} uxModel
   * @returns {Promise.<Array.<module:bajaux/model/UxModel>>} an array of the UxModel's configured
   * children. If any `uxModelDefaults` kids are not configured, new instances will be inserted into
   * the right place.
   */
  exports.getKidModelsIncludingDefaults = function (uxModel) {
    return exports.getDefaultKidModels(uxModel).then(function (defaultKids) {
      return withDefaultsInserted(uxModel.getKids(), defaultKids);
    });
  };

  /**
   * @param {module:bajaux/model/UxModel} uxModel
   * @param {Array.<module:bajaux/model/UxModel|module:bajaux/model/UxModel~UxModelParams>} kidsToAdd
   * @returns {Promise.<module:bajaux/model/UxModel>}
   */
  exports.withKidsAdded = function (uxModel, kidsToAdd) {
    return Promise.all([Promise.all(kidsToAdd.map(function (kid) {
      return UxModel.make(kid);
    })), exports.getDefaultKidModels(uxModel)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        kidsToAdd = _ref2[0],
        defaultKids = _ref2[1];
      var existingKids = uxModel.getKids();
      var existingNames = namesOf(existingKids);
      var desiredNames = namesOf(withDefaultsInserted(existingKids, defaultKids));
      var newKids = _toConsumableArray(existingKids);
      kidsToAdd.forEach(function (kidToAdd) {
        var newName = kidToAdd.getName();
        var existingIndex = existingNames.indexOf(newName);
        if (existingIndex >= 0) {
          newKids[existingIndex] = kidToAdd;
        } else {
          newKids.push(kidToAdd);
        }
        if (!desiredNames.includes(newName)) {
          desiredNames.push(newName);
        }
      });
      newKids.sort(function (a, b) {
        return desiredNames.indexOf(a.getName()) - desiredNames.indexOf(b.getName());
      });
      return uxModel.clone({
        kids: newKids
      });
    });
  };
  function withDefaultsInserted(myKids, defaultKids) {
    var namesIGot = namesOf(myKids);
    var allKids = _toConsumableArray(myKids);
    defaultKids.forEach(function (defaultKid, i) {
      if (!namesIGot.includes(defaultKid.getName())) {
        allKids.splice(i, 0, defaultKid);
      }
    });
    return allKids;
  }
  function namesOf(nodes) {
    return nodes.map(function (n) {
      return n.getName();
    });
  }
  return exports;
});
