function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

define(['baja!', 'baja!bajaui:LayerStatus,bajaui:LayerTag,baja:ConversionLink,bajaui:ValueBinding', 'lex!bajaux,uxBuilder', 'log!nmodule.uxBuilder.rc.util.uxBuilderUtils', 'bajaux/Properties', 'bajaux/Widget', 'bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'bajaux/dragdrop/NavNodeEnvelope', 'bajaux/model/UxModel', 'Promise', 'underscore', 'nmodule/bajaui/rc/baja/Layout', 'nmodule/bajaui/rc/rpc/uxBuilder', 'nmodule/bajaui/rc/ux/BaseDashboardPane', 'nmodule/bajaui/rc/ux/BorderPane', 'nmodule/bajaui/rc/ux/ConstrainedPane', 'nmodule/bajaui/rc/ux/NullWidget', 'nmodule/bajaui/rc/ux/CanvasPane', 'nmodule/bajaui/rc/ux/EdgePane', 'nmodule/bajaui/rc/ux/ExpandablePane', 'nmodule/bajaui/rc/ux/FlowPane', 'nmodule/bajaui/rc/ux/GridPane', 'nmodule/bajaui/rc/ux/Label', 'nmodule/bajaui/rc/ux/LabelPane', 'nmodule/bajaui/rc/ux/Picture', 'nmodule/bajaui/rc/ux/PxInclude', 'nmodule/bajaui/rc/ux/ResponsivePane', 'nmodule/bajaui/rc/ux/ScrollPane', 'nmodule/bajaui/rc/ux/SplitPane', 'nmodule/bajaui/rc/ux/TabbedPane', 'nmodule/bajaui/rc/ux/TransformPane', 'nmodule/bajaui/rc/ux/WebWidget', 'nmodule/bajaui/rc/ux/shape/Shape', 'nmodule/uxBuilder/rc/ux/make/mwUtils', 'nmodule/uxBuilder/rc/ux/model/UxModelTreeNodeEnvelope', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/servlets/registry', 'nmodule/webEditors/rc/wb/PropertySheet', 'nmodule/webEditors/rc/wb/menu/Separator', 'nmodule/webEditors/rc/wb/tree/NavTree', 'nmodule/webEditors/rc/wb/tree/TreeNode'], function (baja, types, lexs, log, Properties, Widget, Command, CommandGroup, NavNodeEnvelope, UxModel, Promise, _, Layout, uxBuilder, BaseDashboardPane, BorderPane, ConstrainedPane, NullWidget, CanvasPane, EdgePane, ExpandablePane, FlowPane, GridPane, Label, LabelPane, Picture, PxInclude, ResponsivePane, ScrollPane, SplitPane, TabbedPane, TransformPane, WebWidget, Shape, mwUtils, UxModelTreeNodeEnvelope, typeUtils, fe, registry, PropertySheet, Separator, NavTree, TreeNode) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 2),
    bajauxLex = _lexs[0],
    uxBuilderLex = _lexs[1];
  var logFine = log.fine.bind(log);
  var constant = _.constant,
    isEqual = _.isEqual,
    isString = _.isString,
    mapObject = _.mapObject,
    omit = _.omit,
    pluck = _.pluck,
    range = _.range,
    some = _.some,
    uniq = _.uniq;
  var hasType = baja.hasType;
  var _require = require('bajaScript/baja/comp/compUtil'),
    getComplexAndSlotFromPath = _require.getComplexAndSlotFromPath;
  var getAgentOnInfo = registry.getAgentOnInfo;
  var allSameType = typeUtils.allSameType;
  var fromPxOrd = uxBuilder.fromPxOrd;
  var setFrozenFacets = mwUtils.setFrozenFacets;
  var DEFAULT_WIDGET_DISPLAY_NAME = bajauxLex.get('widget.displayName');
  var LAYER_STATUS_INVISIBLE = baja.$('bajaui:LayerStatus').get('invisible');
  var REVERSED_PANES = [BorderPane, CanvasPane, ConstrainedPane, EdgePane, ExpandablePane, LabelPane, ResponsivePane, ScrollPane, SplitPane, TransformPane];
  var FREE_FORM_PANES = [CanvasPane, FlowPane, GridPane, TabbedPane];
  var NODE_SYMBOL = Symbol('UxModelTreeNode');
  var getFreeFormPanes = function getFreeFormPanes() {
    var id = 'nmodule'.toLowerCase() + '/report/rc/fe/ReportPane';
    var ReportPane = require.defined(id) && require(id);
    var panes = [].concat(FREE_FORM_PANES);
    if (ReportPane) {
      panes.push(ReportPane);
    }
    return panes;
  };
  var uniqByString = function uniqByString(arr) {
    return uniq(arr, false, String);
  };

  // This is an object that contains the types in string format and the properties that are
  // to be added for that particular type.  If a subclass and the superclass of the subclass
  // have different properties and both appear in this list, make sure the subclass is before
  // the superclass
  var ADDITIONAL_PROPERTIES = {
    'baja:Ord': {
      chooseView: true,
      allowHyperlink: false
    },
    'bajaui:Layout': {
      min: -1000,
      max: 10000
    },
    'gx:Size': {
      min: 0,
      max: 10000
    },
    'bajaui:LayerTag': {
      enablePopOut: false
    },
    'baja:String': {
      escapeNewLines: true
    } //see BStringCE.java#escape
  };

  //We are skipping the call to BWidget subclasses to obtain their agents. Those overrides are just re-recorded here.
  //This keys should be duplicated in test:TypeCheckTest.verifyWidgetAgentOverrides to ensure it stays up-to-date
  //with any java changes.
  var BINDING_PREFERENCES = {
    "bajaui:Widget": "bajaui:ValueBinding",
    "bajaui:BoundTable": "bajaui:TableBinding",
    "bajaui:Button": "kitPx:ActionBinding",
    "chart:Chart": "chart:ValueChartBinding",
    "kitPx:BoundLabel": "kitPx:BoundLabelBinding",
    "workbench:WbFieldEditor": "workbench:WbFieldEditorBinding",
    "workbench:WbView": "workbench:WbViewBinding"
  };

  /**
   * API Status: **Private**
   * @exports nmodule/uxBuilder/rc/util/uxBuilderUtils
   */
  var exports = {};

  /**
   * @private
   * @returns {Array.<module:bajaux/Widget>}
   */
  exports.$getPanes = function () {
    return [].concat(REVERSED_PANES, _toConsumableArray(getFreeFormPanes()), [BaseDashboardPane]);
  };

  /**
   * @param {Object} obj
   * @returns {boolean} true if an input Object is of type bajaui:LayerTag
   */
  exports.isLayerTag = function (obj) {
    return baja.hasType(obj, 'bajaui:LayerTag');
  };

  /**
   * For a particular type, adjust the default properties to be displayed on the UxBuilder.
   * If any properties are already set, those values will be used.
   *
   * @param {Type} type
   * @param {Object} [properties]
   * @returns {Object}
   */
  exports.getUxBuilderProperties = function (type, properties) {
    for (var _i = 0, _Object$entries = Object.entries(ADDITIONAL_PROPERTIES); _i < _Object$entries.length; _i++) {
      var _Object$entries$_i = _slicedToArray(_Object$entries[_i], 2),
        typeSpec = _Object$entries$_i[0],
        props = _Object$entries$_i[1];
      if (type.is(typeSpec)) {
        properties = Object.assign(Object.assign({}, props), properties || {});
      }
    }
    return properties;
  };

  /**
   * @param {module:bajaux/model/UxModel} uxModel
   * @returns {Promise.<Array.<baja.Ord>>} all ORDs present in the UxModel, including duplicates and
   * nulls. see: `PxIncludeManager#findOrds`
   */
  exports.findOrds = function (uxModel) {
    var ords = [];
    return uxModel.visit(function (model) {
      ords.push.apply(ords, _toConsumableArray(getWidgetOrdProperties(model)));
      ords.push.apply(ords, _toConsumableArray(getBindingOrdProperties(model)));
    }).then(function () {
      return ords;
    });
  };

  /**
   * @param {module:bajaux/model/UxModel} uxModel
   * @returns {Promise.<Array.<string>>} unique set of all ORD variables present in the UxModel.
   * see: `BVariablesCE#findIncludeVars`
   */
  exports.getAllOrdVariables = function (uxModel) {
    return exports.findOrds(uxModel).then(function (ords) {
      var result = [];
      ords.forEach(function (ord) {
        return result.push.apply(result, _toConsumableArray(ord.getVariables()));
      });
      return uniq(result);
    });
  };

  /**
   * Sorts the widget's properties by its keys.
   *
   * @param {Object} widgetProps
   * @returns {Object} sorted widget properties.
   */
  exports.sortWidgetProperties = function (widgetProps) {
    var layer = uxBuilderLex.get('WidgetTree.properties.layerTag.label');
    return Object.keys(widgetProps).sort(function (a, b) {
      var aName = exports.isLayerTag(widgetProps[a].value) ? layer : a;
      var bName = exports.isLayerTag(widgetProps[b].value) ? layer : b;
      return aName.toLowerCase().localeCompare(bName.toLowerCase());
    }).reduce(function (obj, key) {
      obj[key] = widgetProps[key];
      return obj;
    }, {});
  };

  /**
   * Converts a Properties instance into a JSON object that JSONPropertySheet will like.
   * @param {module:bajaux/Properties} properties
   * @param {boolean} sidebarReadonly should the sidebar be readonly
   * @returns {Promise.<object>} object ready to load into a JSONPropertySheet
   */
  exports.formatPropertiesForSidebar = function (properties, sidebarReadonly) {
    var layerDisplay = uxBuilderLex.get('WidgetTree.properties.layerTag.label');
    var names = range(0, properties.size()).map(function (i) {
      return properties.get(i, 'name');
    }).filter(isString);
    return Promise.all(names.map(function (name) {
      var prop = properties.get(name);
      if (prop["transient"]) {
        return;
      }
      var readonly = prop.readonly,
        hidden = prop.hidden,
        metadata = prop.metadata,
        displayName = prop.displayName,
        moduleName = prop.moduleName;
      return Promise.all([decodeValue(prop), decodeMetadata(metadata)]).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
          value = _ref2[0],
          properties = _ref2[1];
        return {
          name: name,
          value: value,
          readonly: readonly,
          hidden: hidden,
          displayName: displayName,
          moduleName: moduleName,
          properties: properties
        };
      }).then(function (prop) {
        //hide all private properties like "$quiet"
        if (prop.name.startsWith("$")) {
          prop.hidden = true;
          return prop;
        }
        if (exports.isLayerTag(prop.value)) {
          prop.displayName = layerDisplay;
          return prop;
        }

        //resolve the displayName and store it as the displayName attribute to prepare it for the JSONPropertySheet
        return properties.toDisplayName(prop.name).then(function (displayName) {
          prop.readonly = readonly || sidebarReadonly;
          prop.displayName = displayName;
          return prop;
        });
      });
    })).then(function (results) {
      var obj = {};
      results.forEach(function (result) {
        if (result) {
          var name = result.name,
            value = result.value,
            readonly = result.readonly,
            hidden = result.hidden,
            _properties = result.properties,
            displayName = result.displayName;
          obj[name] = {
            value: value,
            readonly: readonly,
            hidden: hidden,
            properties: _properties,
            displayName: displayName
          };
        }
      });
      return obj;
    });
  };

  /**
   * @param {module:bajaux/Widget} widget
   * @returns {module:bajaux/model/UxModel}
   */
  exports.getModel = function (widget) {
    return UxModel["in"](widget);
  };

  /**
   * Allow traversing from a UxModel used to build a widget in the Px preview, back to the
   * node from which that widget came.
   *
   * @param {module:bajaux/model/UxModel|module:bajaux/Widget|module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} uxModel the
   * model, or the widget instance or tree node holding the model
   * @returns {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode|*} the node holding this model,
   * or falsy if the given value did not originate from a UxModelTreeNode
   */
  exports.getOriginatingNode = function (uxModel) {
    if (uxModel instanceof TreeNode) {
      return uxModel;
    }
    uxModel = uxModel instanceof Widget ? UxModel["in"](uxModel) : uxModel;
    return uxModel && uxModel.getProperties()[NODE_SYMBOL];
  };

  /**
   * @private
   * @param {module:bajaux/model/UxModel} uxModel
   * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} node
   */
  exports.$setOriginatingNode = function (uxModel, node) {
    uxModel.getProperties()[NODE_SYMBOL] = node;
  };

  /**
   * @param {module:bajaux/model/UxModel} uxModel
   * @returns {boolean} True when uxModel is not a NullWidget, or it is a NullWidget with pxDataTypeSpec metadata.
   */
  exports.isUxModelEditable = function (uxModel) {
    //UxModel is editable when uxModel is not a NullWidget.
    if (!uxModel.$represents(NullWidget)) {
      return true;
    }
    //UxModel is editable when uxModel is a NullWidget and has metadata of the pxDataTypeSpec.
    return !!uxModel.getMetadata().pxDataTypeSpec;
  };

  /**
   * determines if the layer the widget is attached to is locked or not
   * @param {module:bajaux/model/UxModel} uxModel
   * @param {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxLayer>} pxLayers
   * @returns {boolean} True when uxModel is not a NullWidget, or it is a NullWidget with pxDataTypeSpec metadata.
   */
  exports.isUxModelLocked = function (uxModel, pxLayers) {
    var layerTag = uxModel.getProperties().LayerTag;
    var locked = false;
    if (layerTag) {
      var pxLayer = pxLayers.find(function (pxLayer) {
        return layerTag.getLayerName() === pxLayer.name;
      });
      var normal = baja.$('bajaui:LayerStatus').get('normal');
      if (pxLayer && pxLayer.status !== normal) {
        locked = true;
      }
    }
    return locked;
  };

  /**
   * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodes
   * @returns {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode|null} the common parent node,
   * or null if they do not share a common parent
   */
  exports.getCommonParentNode = function (nodes) {
    if (!nodes.length) {
      return null;
    }
    var parent = nodes[0].getParent();
    return nodes.every(function (node) {
      return node.getParent() === parent;
    }) ? parent : null;
  };

  /**
   * Convert paste data to the insert operations to apply to the target node.
   *
   * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} targetNode
   * @param {module:nmodule/webEditors/rc/wb/commands/PasteCommand~PasteParams} pasteParams
   * @returns {Promise.<Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode~InsertOp>>}
   */
  exports.pasteToInsertOps = function (targetNode, pasteParams) {
    var mark = pasteParams.mark;
    var mimeType = mark.mimeType,
      nodes = mark.nodes;
    if (mimeType === 'niagara/navnodes') {
      return new NavNodeEnvelope(nodes).toValues().then(function (navNodes) {
        return navNodes.map(function (object) {
          return {
            object: object
          };
        });
      });
    } else if (mimeType === 'niagara/ux-model-tree-node') {
      return UxModelTreeNodeEnvelope.make(nodes, {
        parent: targetNode
      }).then(function (envelope) {
        return envelope.toValues();
      }).then(function (arr) {
        return arr.map(function (_ref3) {
          var widget = _ref3.widget;
          return {
            object: widget
          };
        });
      });
    } else {
      return Promise.reject(new Error(uxBuilderLex.get('errors.unknownMimeType', mimeType)));
    }
  };

  /**
   * Returns true if the uxModel node's children can be reversed.
   *
   * @param {module:bajaux/model/UxModel} uxModel
   * @returns {boolean}
   */
  exports.isReversed = function (uxModel) {
    return some(REVERSED_PANES, function (type) {
      return uxModel.$represents(type);
    });
  };

  /**
   * Returns true if the uxModel is a FreeForm-Pane.
   * A FreeForm-Pane is, to which, you can add arbitrary and non-named child widgets.
   *
   * @param {module:bajaux/model/UxModel} uxModel
   * @returns {boolean}
   */
  exports.isFreeFormPane = function (uxModel) {
    return some(getFreeFormPanes(), function (type) {
      return uxModel.$represents(type);
    });
  };

  /**
   * @param {module:bajaux/model/UxModel} uxModel
   * @returns {boolean} true if this UxModel represents a NullWidget node in the Px tree
   */
  exports.isNullWidget = function (uxModel) {
    var _uxModel$getMetadata = uxModel.getMetadata(),
      pxDataTypeSpec = _uxModel$getMetadata.pxDataTypeSpec;
    return uxModel.getType() === NullWidget && !(pxDataTypeSpec && pxDataTypeSpec !== 'bajaui:NullWidget');
  };

  /**
   * @param {module:bajaux/model/UxModel} uxModel
   * @returns {boolean} True if node is one of the panes used by the UxBuilder.
   */
  exports.isPane = function (uxModel) {
    return some(exports.$getPanes(), function (type) {
      return uxModel.$represents(type);
    });
  };

  /**
   * If the widget is a 'WebWidget' instance and the uxModel metadata confirms that widget has both a 'pxDataTypeSpec` and 'typeSpec' set to
   * "workbench:WebWidget", then the properties of the WebWidget's inner content will be returned. If this is not `WebWidget` or the metadata is not set this way,
   * then `undefined` will be returned to indicate that there are no WebWidget properties to process.
   * @param {module:bajaux/Widget} [widget]
   * @param {module:bajaux/model/UxModel} [uxModel]
   * @returns {module:bajaux/Properties|undefined}
   */
  exports.getWebWidgetProperties = function (widget, uxModel) {
    if (!widget || !uxModel) {
      return;
    }
    var uxModelMetaData = uxModel.getMetadata();
    var isFullWebWidget = widget instanceof WebWidget && uxModelMetaData.pxDataTypeSpec === "workbench:WebWidget" && uxModelMetaData.typeSpec === "workbench:WebWidget";
    if (!isFullWebWidget) {
      return;
    }

    // since in the MakeWidget we have not loaded the WebWidget into a dom, we can not yet get the
    // content widget because it does not exist
    if (widget.jq()) {
      var contentWidget = widget.$getContentWidget();
      if (!contentWidget) {
        return;
      }
      var contentProperties = contentWidget.properties();
      var metaProperties = {};
      for (var i = 0; i < contentProperties.size(); i++) {
        var contentProperty = contentProperties.get(i);
        var name = contentProperty.name;
        if (!widget.properties().get(name)) {
          metaProperties[name] = contentProperty;
          metaProperties[name].userDefined3 = true;
        }
      }
      uxModel.$addWebWidgetMetaProperties(metaProperties);
      return contentProperties;
    }
  };

  /**
   * For the given Component, create the equivalent Properties for its visible `baja:Simple` children.
   * if the component does not have any existing property, then keep it in properties, but just hide it.
   * @param {baja:Component} comp
   * @param {module:bajaux/Widget} [widget]
   * @param {module:bajaux/model/UxModel} [uxModel]
   * @returns {module:bajaux/Properties}
   */
  exports.normalizeProperties = function (comp, widget, uxModel) {
    var uxModelProps = uxModel && uxModel.getProperties();
    var webWidgetProperties = exports.getWebWidgetProperties(widget, uxModel);
    var existingProps = Object.assign({}, uxModelProps);
    var newProps = [];
    comp.getSlots().properties().each(function (slot) {
      var value = comp.get(slot);
      if (slot.getFlags() & baja.Flags.HIDDEN || !(baja.hasType(value, 'baja:Simple') || baja.hasType(value, 'baja:Struct'))) {
        return;
      }
      var name = slot.getName();
      var metaProperty = uxModel && uxModel.$getMetaPropertyInfo(name);
      var metadata;
      var facets = comp.getFacets(slot);
      if (facets !== baja.Facets.DEFAULT) {
        metadata = facets.toObject();
      }

      //if readonly is undefined after the below, it means that we either do not have the
      //metaProperty or the metaProperty.readonly is not set.  Both can indicate an issue with the widget
      var readonly = metaProperty && metaProperty.readonly;
      if (comp.getFlags(slot) & baja.Flags.READONLY) {
        readonly = true;
      }
      var displayName = comp.getDisplayName(slot);
      newProps.push({
        name: name,
        value: value,
        metadata: metadata,
        readonly: readonly,
        displayName: displayName
      });
      delete existingProps[name];
    });
    var propsToReturn = Properties.extend(newProps, uxModelProps);
    if (webWidgetProperties) {
      propsToReturn = Properties.extend(propsToReturn, webWidgetProperties);
    }
    var dynamicProps = [];

    //if any objects left, hide them unless it's the layerTag.
    Object.entries(existingProps).forEach(function (_ref4) {
      var _ref5 = _slicedToArray(_ref4, 2),
        name = _ref5[0],
        value = _ref5[1];
      var metaProperty = uxModel.$getMetaPropertyInfo(name);
      if (metaProperty && metaProperty.hidden) {
        return;
      }
      var hidden = true;
      if (webWidgetProperties) {
        var propDef = webWidgetProperties.get(name);
        hidden = !!propDef.hidden;
      }
      var isLayerTag = name === "LayerTag" && value.getType().is('bajaui:LayerTag');
      //When the property is a LayerTag set the hidden flag to false.
      if (isLayerTag) {
        hidden = false;
      }

      // Add the props to the list when the slot is either hidden, or it is a LayerTag.
      if (hidden || isLayerTag) {
        dynamicProps.push({
          name: name,
          value: value,
          hidden: hidden,
          "transient": hidden
        });
      }
    });
    propsToReturn = Properties.extend(propsToReturn, new Properties(dynamicProps));
    return propsToReturn;
  };

  /**
   * Accepts a list of UxModelTreeNodes and reduces to a Properties object by determining
   * the intersection of properties matching in name, type and metadata.
   *
   * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodes
   * @returns {Promise.<module:bajaux/Properties>}
   */
  exports.getMergedProperties = function (nodes) {
    var getProps = function getProps(node) {
      return exports.getFilteredProps(node);
    };
    if (nodes.length === 1) {
      var _nodes = _slicedToArray(nodes, 1),
        node = _nodes[0];
      var props = getProps(node);
      if (node.represents(PxInclude)) {
        return processPxIncludeVariablesAndProperties(node.value(), props);
      } else {
        return Promise.resolve(props);
      }
    }
    return Promise.resolve(nodes.reduce(function (props, node) {
      var intersection = function intersection(p1, p2) {
        var p1Props = p1.get();
        var filtered = p1Props.filter(function (p) {
          var name = p.name,
            typeSpec = p.typeSpec;
          //The get below returns null if there is no default value, while the default value is
          //undefined.  This is what caused the major problem of no properties being shown.
          var p1DefaultValue = p1.getDefaultValue(name);
          var p2DefaultValue = p2.getDefaultValue(name);
          var p1Value = p1.getValue(name);
          var p2Value = p2.getValue(name);
          var propInP2 = p2.get(name);
          var sameType = true;
          if ((p1DefaultValue === null || p2DefaultValue === null) && p1Value !== null && p2Value !== null) {
            sameType = allSameType([p1Value, p2Value]);
          }
          return propInP2 && exports.$isEqual(p1DefaultValue, p2DefaultValue) && sameType && p2.get(name, 'typeSpec') === typeSpec && isEqual(p1.getMetadata(name), p2.getMetadata(name));
        });
        return new Properties(filtered.map(function (p) {
          var name = p.name,
            defaultValue = p.defaultValue;
          if (!isEqual(p1.getValue(name), p2.getValue(name))) {
            //from what I can the WB has access to a default value, which means there could be a
            //difference in the value used here
            p.value = defaultValue !== undefined ? defaultValue : p.value;
          }
          return p;
        }));
      };
      var p1Props = getProps(node);
      if (node.represents(PxInclude)) {
        // PxInclude variables cannot be group-edited.
        p1Props.add({
          name: 'variables',
          value: baja.Facets.DEFAULT,
          readonly: true
        });
      }
      if (props.get().length === 0) {
        return p1Props;
      }
      return intersection(p1Props, props);
    }, new Properties()));
  };

  /**
   * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} node
   * @returns {module:bajaux/Properties} the filtered properties suitable for showing in the
   * Properties widget (no widgets, bindings, or hidden props)
   */
  exports.getFilteredProps = function (node) {
    var parentNode = node.getParent();
    var uxModel = node.value();
    var widget = node.getLastBuiltWidget();
    var uxModelProps = uxModel.getProperties();
    if (uxModel.getMetadata().pxDataTypeSpec) {
      var _uxModel$getMetadata2 = uxModel.getMetadata(),
        pxDataTypeSpec = _uxModel$getMetadata2.pxDataTypeSpec;
      uxModelProps = exports.normalizeProperties(baja.$(pxDataTypeSpec), widget, uxModel);
    }
    var props = Properties.extend(widget && widget.properties(), uxModelProps);
    var names = props.get().map(function (p) {
      return p.name;
    });
    var isShape = node.represents(Shape);
    var isWebWidget = node.represents(WebWidget);
    var isOnCanvasPane = parentNode && parentNode.represents(CanvasPane);
    return props.subset(names.filter(function (name) {
      var value = props.getValue(name);
      if (isShape && hasType(value, 'bajaui:Layout') || !isOnCanvasPane && hasType(value, 'bajaui:Layout') || isWebWidget && (name === 'styleClasses' || name === 'styleId')) {
        return false;
      }
      return !isWidget(value) && !isBinding(value) && !props.get(name, 'hidden');
    }));
  };

  /**
   * Returns a list of all available binding types for a node. The type of the
   * original widget backing this node is the one used to fetch all its
   * registered binding agents.
   *
   * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} node
   * @returns {Promise.<Array.<module:nmodule/webEditors/rc/servlets/registry~TypeInfo>>}
   */
  exports.getBindingTypesFor = function (node) {
    var uxModel = node.value(),
      _uxModel$getMetadata3 = uxModel.getMetadata(),
      pxDataTypeSpec = _uxModel$getMetadata3.pxDataTypeSpec;
    if (!pxDataTypeSpec) {
      return Promise.resolve([]);
    }
    return Promise.all([getAgentOnInfo(pxDataTypeSpec, {
      is: 'bajaui:Binding'
    }), baja.importTypes([pxDataTypeSpec])]).then(function (_ref6) {
      var _ref7 = _slicedToArray(_ref6, 1),
        typeInfo = _ref7[0];
      Object.keys(BINDING_PREFERENCES).forEach(function (key) {
        if (baja.lt(pxDataTypeSpec).is(key)) {
          exports.$toTop(typeInfo, BINDING_PREFERENCES[key]);
        }
      });
      return typeInfo;
    });
  };

  /**
   * @private
   * @param {Array.<module:nmodule/webEditors/rc/servlets/registry~TypeInfo>} typeInfo
   * @param {String} agentType
   */
  exports.$toTop = function (typeInfo, agentType) {
    var index = typeInfo.findIndex(function (info) {
      return info.type === agentType;
    });
    var valueForTop = typeInfo[index];
    if (index > 0) {
      typeInfo.splice(index, 1);
      typeInfo.unshift(valueForTop);
    }
  };

  /**
   * Attempt to check if two values are equal. Values could be of any Javascript native type or a Baja type.
   *
   * @private
   * @param {*} value1
   * @param {*} value2
   * @returns {boolean} true if the values are equal
   */
  exports.$isEqual = function (value1, value2) {
    //if either value is null, then it automatically matches the other value
    if (value1 === null || value2 === null) {
      return true;
    }
    if (baja.hasType(value1) && baja.hasType(value2)) {
      return value1.equivalent(value2);
    }
    return isEqual(value1, value2);
  };

  /**
   * @private
   * @returns {Promise.<Array.<baja.Component>>} array of BWidget components
   * be used to create new widgets through the right-click menu
   */
  exports.$retrieveNewWidgetsBog = function () {
    return baja.importTypes(['bajaui:BorderPane', 'bajaui:Label', 'bajaui:Picture']).then(function () {
      return [baja.$('bajaui:Label', {
        layout: Layout.make({
          x: 0,
          y: 0,
          w: 100,
          h: 20
        })
      }), baja.$('bajaui:Picture', {
        layout: Layout.make({
          x: 0,
          y: 0,
          w: 100,
          h: 100
        })
      }), baja.$('bajaui:BorderPane', {
        layout: Layout.make({
          x: 0,
          y: 0,
          w: 100,
          h: 100
        })
      })];
    });
  };

  /**
   * Creates a CommandGroup for adding a new widget to an existing UxModelTreeNode.
   *
   * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} parentNode the tree node
   * that will receive a new widget
   * @param {object} [params]
   * @param {string} [params.name] the name that the new widget will have (e.g. `content` if you are
   * right-clicking the empty "content" node of a pane). Omit to auto-generate a name when adding to
   * a freeform pane.
   * @param {function} [params.beforeInsert] a function to run on the UxModels immediately before
   * they are inserted into the UxModelTreeNode.
   * @returns {module:bajaux/commands/CommandGroup}
   */
  exports.makeNewWidgetCommandGroup = function (parentNode) {
    var _ref8 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      name = _ref8.name,
      beforeInsert = _ref8.beforeInsert;
    return exports.$retrieveNewWidgetsBog().then(function (newWidgets) {
      return Promise.all(newWidgets.map(function (widget) {
        return Promise.resolve(widget.getType().getDisplayName({})).then(function (displayName) {
          return new Command({
            displayName: displayName,
            func: function func() {
              return parentNode.insert([{
                object: widget
              }], {
                beforeInsert: beforeInsert,
                names: name && [name]
              });
            }
          });
        });
      }));
    }).then(function (commands) {
      commands.splice(2, 0, new Separator());
      return new CommandGroup({
        displayName: '%lexicon(uxBuilder:WidgetTree.command.new.displayName)%',
        commands: commands
      });
    });
  };

  /**
   * Request the selection of a specified swath of nodes.
   * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodesToSelect
   * @param {boolean} [modified]
   */
  exports.requestSelection = function (nodesToSelect, modified) {
    return Promise.all(nodesToSelect.map(function (node, i) {
      return node.requestSelection(modified || !!i ? 'toggle' : 'exclusive'); // set the first, add the rest
    }));
  };

  /**
   * @param {module:bajaux/model/UxModel} uxModel
   * @param {module:bajaux/Widget} [instance]
   * @returns {Promise.<String>}
   */
  exports.resolveWidgetDisplayName = function (uxModel, instance) {
    var _uxModel$getMetadata4 = uxModel.getMetadata(),
      pxDataTypeSpec = _uxModel$getMetadata4.pxDataTypeSpec;
    if (!pxDataTypeSpec) {
      if (instance) {
        return instance.toDisplayName();
      }
      var Ctor = uxModel.getType();
      if (Ctor) {
        return new Ctor(uxModel.toSpandrel()).toDisplayName();
      } else {
        return Promise.resolve(DEFAULT_WIDGET_DISPLAY_NAME);
      }
    }
    return baja.importTypes([pxDataTypeSpec]).then(function (_ref9) {
      var _ref10 = _slicedToArray(_ref9, 1),
        pxDataType = _ref10[0];
      //Remove spaces for now to match other widget no spaces in displayNames (TODO NCCB-64610)
      return pxDataType.getDisplayName().replace(/ /g, '');
    });
  };

  /**
   * @param {Array.<string>} existingNames
   * @param {Array.<string>} desiredNames
   * @returns {Array.<string>} names closely matching desiredNames but not conflicting with any of
   * existingNames
   */
  exports.generateUniqueNames = function (existingNames, desiredNames) {
    var comp = baja.$('baja:Component', existingNames.reduce(function (obj, name) {
      obj[baja.SlotPath.escape(name)] = '';
      return obj;
    }, {}));
    return desiredNames.map(function (desiredName) {
      var uniqueName = comp.getUniqueName(baja.SlotPath.escape(desiredName));
      comp.add({
        slot: uniqueName,
        value: ''
      });
      return baja.SlotPath.unescape(uniqueName);
    });
  };

  /**
   * @param {module:bajaux/model/UxModel} uxModel
   * @returns {Promise.<module:bajaux/model/UxModel>}
   */
  exports.withUniqueNames = function (uxModel) {
    var getDesiredName = exports.getDesiredName,
      withUniqueNames = exports.withUniqueNames;
    var existingNames = [];
    var desiredNames = [];
    var uniqueNames;
    var replacements = [];
    return Promise["try"](function () {
      uxModel.getKids().forEach(function (kid) {
        var name = kid.getName();
        if (baja.SlotPath.isValidName(name)) {
          existingNames.push(name);
          replacements.push(function () {
            return withUniqueNames(kid);
          });
        } else {
          var i = desiredNames.length;
          desiredNames.push(getDesiredName(kid));
          replacements.push(function () {
            return withUniqueNames(kid).then(function (kid) {
              return kid.clone({
                name: uniqueNames[i]
              });
            });
          });
        }
      });
      uniqueNames = exports.generateUniqueNames(existingNames, desiredNames);
      return Promise.all(replacements.map(function (f) {
        return f();
      }));
    }).then(function (kids) {
      return uxModel.clone({
        kids: kids
      });
    });
  };

  /**
   * When adding a new UxModel child, we compute a desired name for it that will work well when
   * written back up into native Px world. This name will either be the model's already-configured
   * name, or based on the `pxDataTypeSpec`'s type name (same as a new slot would be added to a
   * BComponent).
   *
   * @param {module:bajaux/model/UxModel} uxModel
   * @param {boolean} [genNewName] tells the function not to use the current name, but generate a new one
   * @returns {string}
   */
  exports.getDesiredName = function (uxModel, genNewName) {
    var name = uxModel.getName();
    if (!genNewName && baja.SlotPath.isValidName(name)) {
      return name;
    }
    var _uxModel$getMetadata5 = uxModel.getMetadata(),
      pxDataTypeSpec = _uxModel$getMetadata5.pxDataTypeSpec;
    if (!pxDataTypeSpec) {
      throw new Error('cannot generate name if pxDataTypeSpec not present');
    }
    return pxDataTypeSpec.split(':')[1];
  };

  /**
   * Generates a unique name for a new binding based on the exising names.
   * @param {Array<String>} bindingNameList
   * @param {module:nmodule/bajaui/rc/baja/binding/Binding} newBinding
   * @returns {string}
   */
  exports.generateUniqueBindingName = function (bindingNameList, newBinding) {
    var baseName = newBinding.getType().getTypeSpec().split(':')[1];
    var newName = baseName;
    var idx = 0;
    while (bindingNameList.includes(newName)) {
      idx++;
      newName = baseName + idx;
    }
    return newName;
  };

  /**
   * Performs a shallow clone of a UxModel, including cloning any Bindings it contains, but *not*
   * its children. Its children will be the *same* instances.
   *
   * The purpose of this is to swap a node in the Widget Tree for a new UxModel instance with
   * updated values when the user makes an edit. To undo, the old instance can be swapped back in,
   * in the same way. By not cloning children, we don't disturb child nodes in the Widget Tree to
   * which we did not make changes.
   *
   * @param {module:bajaux/model/UxModel} uxModel
   * @param {module:bajaux/model/UxModel~UxModelParams} [params] any additional params to merge in
   * @returns {Promise.<module:bajaux/model/UxModel>}
   */
  exports.shallowCloneUxModel = function (uxModel, params) {
    return shallowClone(uxModel, params);
  };

  /**
   * @param {module:bajaux/model/UxModel} uxModel
   * @param {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxLayer>} pxLayers
   * @returns {Promise}
   */
  exports.applyPxLayersToUxModel = function (uxModel, pxLayers) {
    return uxModel.visit(function (model) {
      var properties = model.getProperties();
      var LayerTag = properties.LayerTag;
      if (baja.hasType(LayerTag, 'bajaui:LayerTag')) {
        var layer = pxLayers.find(function (layer) {
          return layer.name === LayerTag.getLayerName();
        });
        if (layer && layer.status.equals(LAYER_STATUS_INVISIBLE)) {
          properties.visible = false;
        }
      }
    });
  };

  /**
   * @param {module:nmodule/bajaui/rc/baja/binding/Binding} binding
   * @param {Object.<string, baja.Value>} [bindingChanges] a map from slot path (`/`-separated) to
   * new values to set on the clone
   * @returns {Promise.<module:nmodule/bajaui/rc/baja/binding/Binding>}
   */
  exports.cloneBinding = function (binding) {
    var bindingChanges = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var clone = cloneBinding(binding);
    return applyValueMapToComponent(clone, bindingChanges).then(function () {
      return clone;
    });
  };

  /**
   * @param {Array.<module:bajaux/model/UxModel>} models
   * @param {module:nmodule/uxBuilder/rc/ux/sidebars/PropertiesWidget~WidgetNodeChanges} changes
   * @returns {Promise.<Array.<module:bajaux/model/UxModel>>}
   */
  exports.cloneWithChanges = function (models, changes) {
    return Promise.all(models.map(function (model) {
      return cloneModelWithChanges(model, changes);
    }));
  };

  /**
   * Visit all the nodes and reset the layerTag if it's currently set to one of the removed layerNames.
   * @param {module:bajaux/model/UxModel} uxModel
   * @param {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxLayer>} removedPxLayers
   * @param {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxLayer>} removedRowModels  note: param will
   * be modified
   * @param {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxLayer>} removedPxLayerRows  note: param will
   * be modified
   * @returns {Promise}
   */
  exports.removePxLayers = function (uxModel, removedPxLayers, removedRowModels, removedPxLayerRows) {
    return uxModel.visit(function (model) {
      var properties = model.getProperties();
      var LayerTag = properties.LayerTag;
      if (baja.hasType(LayerTag, 'bajaui:LayerTag')) {
        var layer = removedPxLayers.find(function (layer) {
          return layer.name === LayerTag.getLayerName();
        });
        if (removedPxLayers[0].name === LayerTag.getLayerName()) {
          removedRowModels.push(model);
          removedPxLayerRows.push(removedPxLayers[0]);
        }
        if (layer) {
          properties.LayerTag = baja.$("bajaui:LayerTag");
        }
      }
    });
  };

  /**
   * Visit all the nodes and reset the layerTag if it's currently set to the first removed layerName, set it to the new layer name.
   * @param {module:bajaux/model/UxModel} uxModel
   * @param {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxLayer>} removedPxLayers
   * @param {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxLayer>} newPxLayers
   * @returns {Promise}
   */
  exports.renamePxLayers = function (uxModel, removedPxLayers, newPxLayers) {
    var oldName = removedPxLayers[0].name;
    var newName = newPxLayers[0].name;
    return uxModel.visit(function (model) {
      var properties = model.getProperties();
      var LayerTag = properties.LayerTag;
      if (baja.hasType(LayerTag, 'bajaui:LayerTag')) {
        if (LayerTag.getLayerName() === oldName) {
          LayerTag.setLayerName(newName);
        }
      }
    });
  };

  /**
   * Visit all the nodes and set the layerTag if it was removed, set it back to it original Px layer name.
   * (This function is only for when the px layer is removed and the undo command is executed.)
   * @param {module:bajaux/model/UxModel} uxModel
   * @param {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxLayer>} newPxLayers
   * @param {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxLayer>} removedRowModels note: param will
   * be modified
   * @param {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxLayer>} removedPxLayerRows note: param will
   * be modified
   * @returns {Promise}
   */
  exports.addPxLayers = function (uxModel, newPxLayers, removedRowModels, removedPxLayerRows) {
    var newName = newPxLayers[0].name;
    var getOriginatingNode = exports.getOriginatingNode;
    return uxModel.visit(function (model) {
      var properties = model.getProperties();
      var LayerTag = properties.LayerTag;
      if (baja.hasType(LayerTag, 'bajaui:LayerTag') && removedPxLayerRows.length > 0) {
        var isMatch = getOriginatingNode(model).getFullPath().join() === getOriginatingNode(removedRowModels[removedRowModels.length - 1]).getFullPath().join();
        if (isMatch && removedPxLayerRows[removedPxLayerRows.length - 1].name === newName) {
          LayerTag.setLayerName(newName);
          removedRowModels.pop();
          removedPxLayerRows.pop();
        }
      }
    });
  };

  /**
   * Give the UxModel initial knowledge of which of its properties are linked to which Px
   * Properties. This knowledge then becomes part of the UxModel itself, so that it can be edited
   * over time on a per-node basis by the user (typically via right-click->Link on PropertiesWidget)
   *
   * Call it one time, on the first load of the UxModel into the UxBuilder.
   *
   * @param {module:bajaux/model/UxModel} uxModel the source-of-truth UxModel representing the root
   * of the Px file's widget tree
   * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxProperties} pxProperties the Px Properties,
   * including the targets to which they are linked, as configured in the Px page at load time.
   * @returns {Promise.<module:bajaux/model/UxModel>} a clone of the input UxModel with Px Property
   * data initialized
   */
  exports.withInitialPxPropertyData = function (uxModel, pxProperties) {
    // (the clone is not necessary for the initialization, but keeping it for consistency across these
    // px property functions)

    var pxPropertiesArray = [];
    Object.entries(pxProperties).forEach(function (_ref11) {
      var _ref12 = _slicedToArray(_ref11, 2),
        name = _ref12[0],
        targets = _ref12[1].targets;
      targets.forEach(function (propertyPath) {
        return pxPropertiesArray.push({
          pxPropertyName: name,
          propertyPath: propertyPath
        });
      });
    });
    var isFor = function isFor(kidName) {
      return function (_ref13) {
        var propertyPath = _ref13.propertyPath;
        return propertyPath[0] === kidName;
      };
    };
    function withDataApplied(model, pxPropertiesArray) {
      var linkedPropertyPaths = {};
      var entriesForMyKids = [];
      pxPropertiesArray.forEach(function (entry) {
        var pxPropertyName = entry.pxPropertyName,
          propertyPath = entry.propertyPath;
        var _propertyPath = _slicedToArray(propertyPath, 1),
          slotName = _propertyPath[0];
        if (propertyPath.length === 1) {
          // it's for me
          linkedPropertyPaths[slotName] = pxPropertyName;
          return;
        }
        var kid = model.get(slotName);
        if (kid) {
          if (isBinding(kid)) {
            // it's for my binding
            linkedPropertyPaths[propertyPath.join('/')] = pxPropertyName;
          } else {
            // it's for a kid widget
            entriesForMyKids.push(entry);
          }
        }
      });
      return Promise.all(model.getKids().map(function (kid) {
        var pxPropertiesForKid = entriesForMyKids.filter(isFor(kid.getName())).map(function (_ref14) {
          var pxPropertyName = _ref14.pxPropertyName,
            propertyPath = _ref14.propertyPath;
          return {
            pxPropertyName: pxPropertyName,
            propertyPath: propertyPath.slice(1)
          };
        });
        return withDataApplied(kid, pxPropertiesForKid);
      })).then(function (kids) {
        return shallowClone(model, {
          metadata: {
            linkedPropertyPaths: linkedPropertyPaths
          },
          kids: kids
        });
      });
    }
    return withDataApplied(uxModel, pxPropertiesArray);
  };

  /**
   * @private
   * @param {module:bajaux/model/UxModel} uxModel
   * @returns {Object.<string, string>} mapping of property path strings to the names of the Px
   * Properties to which they are linked
   */
  exports.$getLinkedPropertyPaths = function (uxModel) {
    return getLinkedPropertyPaths(uxModel);
  };

  /**
   * Applies the linked Px Properties to the actual properties of the UxModel about to be rendered
   * in the PxWidget preview.
   *
   * @param {module:bajaux/model/UxModel} uxModel the display UxModel about to be rendered in the
   * PxWidget preview, already containing knowledge about which of their widget properties are
   * linked to which Px Properties
   * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxProperties} pxProperties configured Px
   * Properties (only their values will be used)
   * @returns {Promise.<module:bajaux/model/UxModel>} a clone of the input UxModel with the Px
   * Property values applied
   */
  exports.withPxPropertiesApplied = function withPxPropertiesApplied(uxModel, pxProperties) {
    var overrides = getPxPropertyOverrideValues(uxModel, pxProperties);
    return Promise.all(uxModel.getKids().map(function (kid) {
      return withPxPropertiesApplied(kid, pxProperties);
    })).then(function (kids) {
      return shallowClone(uxModel, {
        kids: kids
      });
    }).then(function (clone) {
      Object.entries(overrides).forEach(function (_ref15) {
        var _ref16 = _slicedToArray(_ref15, 2),
          pathString = _ref16[0],
          value = _ref16[1];
        var path = pathString.split('/');
        var _path = _slicedToArray(path, 1),
          slotName = _path[0];
        if (path.length === 1) {
          clone.getProperties()[slotName] = value;
        } else {
          var binding = clone.get(slotName);
          binding.set({
            slot: path[1],
            value: value
          });
        }
      });
      return clone;
    });
  };

  /**
   * Links individual properties of this UxModel to the specified Px Properties.
   *
   * @param {module:bajaux/model/UxModel} uxModel
   * @param {Object.<string, string|*> | undefined} [propertyPaths] a mapping of property paths (/-separated) to the
   * names of the Px Properties to which they are linked. Set the value to falsy to indicate that
   * that property path should be _unlinked_ from the Px Property.
   * @returns {Promise.<module:bajaux/model/UxModel>} a clone of the UxModel with the property
   * linked
   */
  exports.withPropertyPathsLinked = function (uxModel, propertyPaths) {
    var linkedPropertyPaths = getLinkedPropertyPaths(uxModel);
    Object.entries(propertyPaths || {}).forEach(function (_ref17) {
      var _ref18 = _slicedToArray(_ref17, 2),
        propertyPath = _ref18[0],
        pxPropertyName = _ref18[1];
      if (pxPropertyName) {
        linkedPropertyPaths[propertyPath] = pxPropertyName;
      } else {
        delete linkedPropertyPaths[propertyPath];
      }
    });
    return shallowClone(uxModel, {
      metadata: {
        linkedPropertyPaths: linkedPropertyPaths
      }
    });
  };

  /**
   * When a Px Property is renamed, find all UxModels that are linked to it and update them with the
   * new name.
   * @param {module:bajaux/model/UxModel} uxModel
   * @param {string} oldName
   * @param {string} newName
   * @returns {Promise.<module:bajaux/model/UxModel>} a clone of the input UxModel with the Px
   * Property renamed in itself and all descendents
   */
  exports.withPxPropertyRenamed = function (uxModel, oldName, newName) {
    var linkedPropertyPaths = getLinkedPropertyPaths(uxModel);
    Object.entries(linkedPropertyPaths).forEach(function (_ref19) {
      var _ref20 = _slicedToArray(_ref19, 2),
        propertyPath = _ref20[0],
        pxPropName = _ref20[1];
      if (pxPropName === oldName) {
        linkedPropertyPaths[propertyPath] = newName;
      }
    });
    return Promise.all(uxModel.getKids().map(function (kid) {
      return exports.withPxPropertyRenamed(kid, oldName, newName);
    })).then(function (kids) {
      return shallowClone(uxModel, {
        metadata: {
          linkedPropertyPaths: linkedPropertyPaths
        },
        kids: kids
      });
    });
  };

  /**
   * When a Px Property is removed, find all UxModels that are linked to it and unlink them.
   *
   * @param {module:bajaux/model/UxModel} uxModel
   * @param {string} deletedName the name of the Px Property that was deleted
   * @returns {Promise.<module:bajaux/model/UxModel>} a clone of the input UxModel with the Px
   * Property unlinked in itself and all descendents
   */
  exports.withPxPropertyDeleted = function withPxPropertyDeleted(uxModel, deletedName) {
    return Promise.all(uxModel.getKids().map(function (kid) {
      return withPxPropertyDeleted(kid, deletedName);
    })).then(function (kids) {
      var linkedPropertyPaths = omit(getLinkedPropertyPaths(uxModel), function (pxPropertyName) {
        return pxPropertyName === deletedName;
      });
      return shallowClone(uxModel, {
        kids: kids,
        metadata: {
          linkedPropertyPaths: linkedPropertyPaths
        }
      });
    });
  };

  /**
   * @param {module:bajaux/model/UxModel} uxModel the source-of-truth UxModel representing the root
   * of the Px file's widget tree
   * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxProperties} pxProperties configured Px
   * Properties (only their values will be used)
   * @returns {Promise.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxProperties>} new Px Properties,
   * with targets correctly saved based on which UxModels have properties linked
   */
  exports.reconstitutePxProperties = function (uxModel, pxProperties) {
    var newPxProperties = mapObject(pxProperties, function (_ref21) {
      var value = _ref21.value;
      return {
        value: value,
        targets: []
      };
    });
    function reconstitute(uxModel, pathToMe) {
      var linkedPropertyPaths = getLinkedPropertyPaths(uxModel);
      Object.entries(linkedPropertyPaths).forEach(function (_ref22) {
        var _ref23 = _slicedToArray(_ref22, 2),
          pathString = _ref23[0],
          pxPropertyName = _ref23[1];
        var pxProp = pxProperties[pxPropertyName];
        if (!pxProp) {
          logFine('widget ' + uxModel.getName() + ' still linked to a Px Property that was deleted');
          return;
        }
        newPxProperties[pxPropertyName].targets.push([].concat(_toConsumableArray(pathToMe), _toConsumableArray(pathString.split('/'))));
      });
      uxModel.getKids().forEach(function (kid) {
        return reconstitute(kid, [].concat(_toConsumableArray(pathToMe), [kid.getName()]));
      });
    }
    reconstitute(uxModel, []);
    return newPxProperties;
  };

  /**
   * Will relativize the boundOrd with respect to it's baseOrd.
   *
   * @param {baja.Ord} baseOrd
   * @param {baja.Ord} boundOrd
   * @returns {baja.Ord}
   */
  exports.relativizeOrd = function (baseOrd, boundOrd) {
    var _validateAndGetOrdPar = validateAndGetOrdParts(baseOrd, boundOrd),
      baseNames = _validateAndGetOrdPar.baseNames,
      boundNames = _validateAndGetOrdPar.boundNames,
      tailQuery = _validateAndGetOrdPar.tailQuery;
    var backupPartOfOrd = getBackupStr(baseNames, boundNames);
    var stringPartOfOrd = getOrdStr(baseNames, boundNames);

    //If there are any relative nodes, append / between backedUpOrd and stringPartOfOrd
    if (backupPartOfOrd.endsWith('..') && stringPartOfOrd.length) {
      stringPartOfOrd = '/' + stringPartOfOrd;
    }
    var relativizedOrd = 'slot:' + backupPartOfOrd + stringPartOfOrd + tailQuery;
    return baja.Ord.make(relativizedOrd);
  };

  /**
   * @private
   * @param {module:bajaux/model/UxModel} uxModel
   * @returns {Array.<baja.Ord>}
   */
  exports.$getBoundOrdsFromUxModel = function (uxModel) {
    var boundOrds = [];
    if (uxModel.$represents(PxInclude)) {
      boundOrds.push.apply(boundOrds, _toConsumableArray(getWidgetOrdProperties(uxModel)));
    }
    boundOrds.push.apply(boundOrds, _toConsumableArray(getBindingOrdProperties(uxModel)));
    return uniqByString(boundOrds.filter(function (ord) {
      return !ord.isNull();
    }));
  };

  /**
   * Finds all matching nodes for the input treeNode and filterFunction.
   * Optional matchedNodes array can be passed to get pass by value updates on the matched nodes.
   *
   * @param {module:nmodule/webEditors/rc/wb/tree/TreeNode} treeNode
   * @param {Function} filterFunction
   * @param {Array.<module:nmodule/webEditors/rc/wb/tree/TreeNode>} [matchedNodes]
   * @returns {Promise.<Array.<module:nmodule/webEditors/rc/wb/tree/TreeNode>>}
   */
  exports.findAllMatchingNodes = function (treeNode, filterFunction) {
    var matchedNodes = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
    return treeNode.getKids().then(function (kids) {
      //Apply filterFunction and proceed with recursion for all available kids.
      return Promise.all(kids.map(function (kid) {
        return Promise.resolve(filterFunction(kid)).then(function (result) {
          if (result) {
            matchedNodes.push(kid);
          }
        });
      })).then(function () {
        return Promise.all(kids.map(function (kid) {
          return exports.findAllMatchingNodes(kid, filterFunction, matchedNodes);
        }));
      });
    }).then(function () {
      return matchedNodes;
    });
  };

  /**
   * The paths of nodes from the Widget Tree include extra ancestors 'px' and 'rootContainer' to
   * allow for node-replacement operations on the root node itself. This function removes those, as
   * well as the 'root' node from the Px data itself, to return a path relative to the root of the
   * Px page itself.
   * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} treeNode a node from the Widget
   * Tree
   * @returns {Array.<string>} the array of node names relative to the root of the Px page, suitable
   * for use in PxProperty targets and such.
   */
  exports.nodePathRelativeToRoot = function (treeNode) {
    // chop off 'px', 'rootContainer', 'root'
    return treeNode.getFullPath().slice(3);
  };

  /**
   * The paths of nodes from the Widget Tree include extra ancestors 'px' and 'rootContainer' to
   * allow for selection. This function removes those to return a path relative to the rootContainer of the
   * Px page itself.
   * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} treeNode a node from the Widget
   * Tree
   * @returns {Array.<string>} the array of node names relative to the rootContainer of the Px page, suitable
   * for use in selectPath calls.
   */
  exports.nodePathRelativeToRootContainer = function (treeNode) {
    // chop off 'px', 'rootContainer'
    return treeNode.getFullPath().slice(2);
  };

  /**
   * Loads the bound ords into a map
   *
   * @private
   * @param {module:bajaux/model/UxModel} uxModel the UxModel to be processed
   * @returns {Promise.<Array.<baja.Ord>>}
   */
  exports.$getBoundOrdsFromUxModelTree = function (uxModel) {
    var boundOrds = [];
    return uxModel.visit(function (model) {
      return boundOrds.push.apply(boundOrds, _toConsumableArray(exports.$getBoundOrdsFromUxModel(model)));
    }).then(function () {
      return uniqByString(boundOrds);
    });
  };

  /**
   * Stores the bindings into the map
   *
   * @param {module:bajaux/model/UxModel} uxModel the UxModel to find binding ORD properties from
   * @returns {Array.<baja.Ord>}
   */
  function getBindingOrdProperties(uxModel) {
    var ords = [];
    uxModel.getBindingList().getBindings().forEach(function (binding) {
      binding.getSlots().is('baja:Ord').eachValue(function (ord) {
        ords.push(ord);
      });
    });
    return ords;
  }

  /**
   * @param {module:bajaux/model/UxModel} uxModel the UxModel to find widget ORD properties from
   * @returns {Array.<baja.Ord>}
   */
  function getWidgetOrdProperties(uxModel) {
    var ords = [];
    Object.values(uxModel.getProperties()).forEach(function (value) {
      if (baja.hasType(value, 'baja:Ord')) {
        ords.push(value);
      }
    });
    return ords;
  }
  function cloneBinding(binding) {
    var clone = binding.newCopy(true);
    clone.getName = constant(binding.getName());
    return clone;
  }

  /**
   * @param {Object} metadata
   * @returns {Promise}
   */
  function decodeMetadata(metadata) {
    if (!metadata) {
      return Promise.resolve();
    }
    var decoded = {};
    return Promise.all(Object.keys(metadata).map(function (name) {
      var _metadata$name = metadata[name],
        value = _metadata$name.value,
        typeSpec = _metadata$name.typeSpec;
      return baja.importTypes([typeSpec]).then(function () {
        return baja.$(typeSpec).decodeAsync(value);
      }).then(function (value) {
        decoded[name] = value;
      });
    })).then(function () {
      return decoded;
    });
  }

  /**
   * @param {Object} webProp
   * @returns {Promise}
   */
  function decodeValue(webProp) {
    var typeSpec = webProp.typeSpec,
      value = webProp.value;
    if (!typeSpec || value === undefined) {
      return Promise.resolve(value);
    }
    if (baja.hasType(value) && value.getType().getTypeSpec() !== 'baja:String') {
      return Promise.resolve(value);
    }
    return baja.importTypes([typeSpec]).then(function () {
      return baja.$(typeSpec).decodeAsync(value);
    });
  }

  /**
   * Expands and highlights the node that matches with the filterFunction.
   *
   * @param {module:nmodule/webEditors/rc/wb/tree/NavTree} navTree
   * @param {Function} filterFunction Function can return a boolean or a Promise. Resolved value will be used as the match assertion.
   * @returns {Promise.<Array.<module:nmodule/webEditors/rc/wb/tree/TreeNode>>|Promise}
   */
  exports.expandToHighlightMatchingNodes = function (navTree, filterFunction) {
    if (!(navTree instanceof NavTree) || !(filterFunction instanceof Function)) {
      return Promise.reject(new Error('Invalid input.'));
    }
    var depth = navTree.value().getFullPath().length - 1;

    //Clear any selected nodes in the navTree.
    navTree.clearSelection();
    var matchedNodes = [];
    //Find all matching nodes starting from the parent node.
    return exports.findAllMatchingNodes(navTree.value(), filterFunction, matchedNodes).then(function () {
      var selectedPaths = matchedNodes.map(function (node) {
        return node.getFullPath().slice(depth);
      });
      //Select the nodes that are matched with filterFunction.
      return Promise.all(selectedPaths.map(function (path) {
        return navTree.setSelectedPath(path, {
          modified: true
        });
      }));
    });
  };

  /**
   * Indicates that the given UxModels should be placed at the given point. If there are multiple
   * UxModels to move, place them in a bounding box that encloses them all, and move the upper-left
   * corner of that bounding box to the given point.
   *
   * @param {{ x: number, y: number }} [point] x and y coordinates to place the models at, relative
   * to the CanvasPane itself (`bajaui:Layout` coordinates)
   * @param {Array.<module:bajaux/model/UxModel>} models
   * @param {module:nmodule/bajaui/rc/ux/CanvasPane} canvasPane
   * @param {Number} [snapSize] the snap size to use, undefined if no snap is to be applied
   * @returns {Promise.<Array.<module:bajaux/model/UxModel>>} clones of the input UxModels with
   * updated layout properties
   */
  exports.repositionedAtPoint = function (point, models, canvasPane, snapSize) {
    if (!point) {
      return Promise.resolve(models);
    }
    var canvasPoints = models.map(function (model) {
      return canvasPane.$getPositionRelativeToViewPane(model.getProperties().layout);
    });
    var minX = Math.min.apply(Math, _toConsumableArray(pluck(canvasPoints, 'x')));
    var minY = Math.min.apply(Math, _toConsumableArray(pluck(canvasPoints, 'y')));
    var dx = point.x - minX;
    var dy = point.y - minY;
    return Promise.all(models.map(function (model, i) {
      var layout = model.getProperties().layout;
      var canvasPoint = canvasPoints[i];
      var isShape = model.$represents(Shape);
      var x = canvasPoint.x + dx;
      var y = canvasPoint.y + dy;
      if (snapSize) {
        x = Math.floor(x / snapSize) * snapSize;
        y = Math.floor(y / snapSize) * snapSize;
      }
      if (isShape) {
        var geom = model.getProperties().geom;
        return model.clone({
          properties: {
            geom: geom.translate(x, y)
          }
        });
      } else {
        return model.clone({
          properties: {
            layout: layout.moveTo(x, y)
          }
        });
      }
    }));
  };

  /**
   * @private
   * @param {baja.Value} value
   * @param {module:nmodule/webEditors/rc/fe/fe~FeParams} config
   * @returns {Promise}
   */
  exports.$resolveConstructorOrPropertySheet = function (value, config) {
    return fe.params(Object.assign({
      value: value
    }, config)).then(function (params) {
      return params.getWidgetConstructor();
    }).then(function (ctor) {
      return ctor || value.getType().isComplex() && PropertySheet;
    });
  };

  /**
   * @private
   * @param {module:nmodule/bajaui/rc/baja/binding/Binding} originalBinding
   * @param {object} [param]
   * @param {boolean} [param.exact=true]
   * @returns {module:nmodule/bajaui/rc/baja/binding/Binding}
   */
  exports.$newBindingCopy = function (originalBinding) {
    var _ref24 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      _ref24$exact = _ref24.exact,
      exact = _ref24$exact === void 0 ? true : _ref24$exact;
    var bindingCopy = originalBinding.newCopy(exact);
    bindingCopy.setOrdTarget(originalBinding.getOrdTarget());
    return bindingCopy;
  };

  /**
   * determines if the property value equals the default value
   * @private
   * @param {Object} defaultValue the default value for the property
   * @param {Object} propValue the value of the property
   * @returns {boolean}
   */
  exports.$equalsDefault = function (defaultValue, propValue) {
    if (defaultValue === null || propValue === null) {
      return defaultValue === propValue;
    }
    var defaultType = baja.hasType(defaultValue) ? defaultValue.getType() : undefined;
    var valueType = baja.hasType(propValue) ? propValue.getType() : undefined;

    // in this case if the defaultValue and the propValue are both Number we want to compare the values
    // export.isEquals does not do this
    if (defaultType && valueType && defaultType.isNumber() && valueType.isNumber()) {
      return defaultValue.valueOf() === propValue.valueOf();
    }
    return exports.$isEqual(defaultValue, propValue);
  };

  /**
   * Resolves to the type spec for the default agent of the type, if there is one.  Otherwise, it
   * resolves to null.
   * @private
   * @param {Type} type the type of the widget
   * @returns {Promise<String|null>} A promise that will resolve to the default agent typeSpec for
   * the supplied type or null if there is not an agent
   */
  exports.$getWidgetWrapperType = function (type) {
    // TODO: NCCB-46659: special cases - due to limitation these need to be handled in a special manner
    var specialCases = {
      "ace:AceWireSheet": "wiresheet:WebWiresheet",
      "pxEditor:PxEditor": "uxBuilder:UxBuilder",
      "wbutil:CategorySheet": "webEditors:UxCategoryBrowser",
      "wbutil:CategoryBrowser": "webEditors:UxCategoryBrowser",
      "wiresheet:WireSheet": "wiresheet:WebWiresheet",
      "platform:PlatformServiceProperties": "webEditors:MultiSheet",
      "videoDriver:VideoAlarmConsoleSettingPropertySheet": "webEditors:MultiSheet",
      "workbench:PropertySheet": "webEditors:MultiSheet"
    };
    function hasJsWidgetAlready(agents) {
      var hasJsWidget = false;
      agents.forEach(function (agent) {
        if (agent.isJavaScriptWidget && !agent.isNullWidget) {
          hasJsWidget = true;
        }
      });
      return hasJsWidget;
    }
    var typeSpec = type.getTypeSpec();
    if (!type.is("bajaui:Widget") || type.is("bajaui:NullWidget")) {
      return Promise.resolve(null);
    }
    return Promise.all([baja.registry.getAgents("type:" + typeSpec), baja.registry.getAgents("type:bajaui:Widget")]).then(function (_ref25) {
      var _ref26 = _slicedToArray(_ref25, 2),
        agents = _ref26[0],
        widgetAgents = _ref26[1];
      //TODO: NCCB-46659 due to special handling in the Java code, these types are not resolving correctly
      if (specialCases.hasOwnProperty(typeSpec)) {
        return specialCases[typeSpec];
      }

      // remove all the agents that are both in the list of agents for the type spec supplied and the agents of a 'bajaui:Widget'
      widgetAgents.forEach(function (widgetAgent) {
        agents = agents.filter(function (agent) {
          return agent.typeSpec !== widgetAgent.typeSpec;
        });
      });

      // set some properties in the agents used later.
      agents.forEach(function (agent) {
        var agentType = baja.lt(agent.typeSpec);
        agent.isNullWidget = agentType.is('bajaui:UxNullWidget');
        agent.isJavaScriptWidget = agentType.is('bajaux:IJavaScriptWidget');
        agent.isView = agentType.is("web:IJavaScript") && agentType.is("web:IFormFactor");
      });
      if (hasJsWidgetAlready(agents)) {
        return null;
      }
      agents = agents.filter(function (agent) {
        return agent.isView && !agent.isNullWidget;
      });
      return agents.length === 0 ? null : agents[0].typeSpec;
    });
  };

  /**
   * Reorders the kids of a reversible node.
   *
   * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodes
   * @returns {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>}
   */
  exports.reorderKidsForReversibleParentPane = function (nodes) {
    var groupByParent = {};
    nodes && nodes.forEach(function (node) {
      var parent = node.getParent();
      var fullPath = parent.getFullPath().join();
      // Group nodes by the parent's full path.
      if (!groupByParent[fullPath]) {
        groupByParent[fullPath] = {
          parent: parent,
          kids: []
        };
      }
      groupByParent[fullPath].kids.push(node);
    });
    // Kids of a reversible pane will be reversed.
    var returnNodes = [];
    Object.entries(groupByParent).forEach(function (_ref27) {
      var _ref28 = _slicedToArray(_ref27, 2),
        _ref28$ = _ref28[1],
        parent = _ref28$.parent,
        kids = _ref28$.kids;
      if (exports.isReversed(parent.value())) {
        kids.reverse();
      }
      returnNodes.push.apply(returnNodes, _toConsumableArray(kids));
    });
    return returnNodes;
  };

  /**
   * Sets up the properties the converter with the additional UxBuilder Properties.
   *
   * @param {baja.Struct} converterValue
   * @param {baja.Value} [from]
   * @param {baja.Value} [to]
   * @param {module:baja/ord/OrdTarget} [fromTarget]
   * @param {baja.Component} [binding]
   * @param {String} [targetSlotName]
   */
  exports.configureConverterWithUxBuilderProperties = function (converterValue, from, to, fromTarget, binding, targetSlotName) {
    var frozenFacetsNeeded = false;
    var frozenFacetsObject = {};
    var converterValueFacet = baja.Facets.DEFAULT;
    if (baja.hasType(converterValue, 'converters:IEnumToSimple') && baja.hasType(from)) {
      var _range = baja.Enum.getFacetsFromIEnum(from).get('range');
      converterValueFacet = baja.Facets.make({
        range: _range
      });
    }
    converterValue.getSlots().properties().toArray().forEach(function (slot) {
      var val = converterValue.get(slot);
      var type = val.getType();
      var frozenFacetsPath = 'conversionLink/converter/' + slot.getName();
      var isSimpleMap = type.is('converters:NumericToSimpleMap') || type.is('converters:EnumToSimpleMap');
      if (isSimpleMap && hasType(to)) {
        type = to.getType();
        frozenFacetsPath = 'conversionLink/converter/map';
      }
      var additionalProperties = exports.getUxBuilderProperties(type);
      if (additionalProperties) {
        if (isSimpleMap) {
          converterValueFacet = baja.Facets.make(converterValueFacet, additionalProperties);
        } else {
          frozenFacetsObject[frozenFacetsPath] = baja.Facets.make(additionalProperties);
          frozenFacetsNeeded = true;
        }
      }
    });
    if (converterValueFacet.getKeys().length > 0) {
      frozenFacetsObject['conversionLink/converter'] = converterValueFacet;
      frozenFacetsNeeded = true;
    }
    var facetsMap = baja.FacetsMap.make(frozenFacetsObject);
    var parent = binding && binding.newCopy() || baja.$('bajaui:ValueBinding');
    if (hasType(to) && targetSlotName) {
      addOrSet(parent, {
        slot: targetSlotName,
        value: to
      });
    }
    var sourceSlotName = "";
    var sourceOrd = baja.Ord.DEFAULT;
    if (fromTarget) {
      var isComponent = fromTarget.getSlotInComponent() === null && fromTarget.getComponent();
      sourceSlotName = isComponent ? fromTarget.getComponent().getName() : fromTarget.getSlotInComponent();
      sourceOrd = getSourceOrd(fromTarget);
    }
    var conversionLink = baja.$('baja:ConversionLink', {
      converter: converterValue,
      sourceSlotName: sourceSlotName,
      sourceOrd: sourceOrd,
      targetSlotName: targetSlotName
    });
    parent.add({
      slot: 'conversionLink',
      value: conversionLink
    });
    if (frozenFacetsNeeded) {
      setFrozenFacets(parent, facetsMap);
    }
  };

  /**
   * @param {baja.Component} comp
   * @param {Object} params Object literal
   * @param {String} params.slot the name of the Slot.
   * @param {baja.Value} params.value the value to add or set.
   *
   * @see baja.Component#add
   * @see baja.Complex#set
   * @return {Promise}
   */
  function addOrSet(comp, params) {
    var slot = params.slot;
    if (comp.get(slot) === null) {
      return comp.add(params);
    } else {
      return comp.set(params);
    }
  }

  /**
   * @param {module:baja/ord/OrdTarget} fromTarget
   * @returns {baja.Ord}
   */
  function getSourceOrd(fromTarget) {
    if (!fromTarget) {
      return baja.Ord.DEFAULT;
    }
    var isComponent = fromTarget.getSlotInComponent() === null && fromTarget.getComponent();
    if (isComponent) {
      return fromTarget.getComponent().getParent() && fromTarget.getComponent().getParent().getNavOrd() || baja.Ord.DEFAULT;
    }
    return fromTarget.getComponent() && fromTarget.getComponent().getNavOrd() || baja.Ord.DEFAULT;
  }
  function isWidget(value) {
    return baja.hasType(value, 'bajaui:Widget');
  }
  function isBinding(value) {
    return baja.hasType(value, 'bajaui:Binding');
  }

  /**
   * Returns string representation of the folder backup required for relativization.
   *
   * @param {Array.<String>} baseNames
   * @param {Array.<String>} boundNames
   * @returns {String}
   */
  function getBackupStr(baseNames, boundNames) {
    var backupStr = '';
    for (var i = 0; i < baseNames.length; i++) {
      if (baseNames[i] !== boundNames[i]) {
        for (var j = baseNames.length; j > i; j--) {
          if (j - 1 === i) {
            backupStr = '..' + backupStr;
          } else {
            backupStr = '/..' + backupStr;
          }
        }
        break;
      }
    }
    return backupStr;
  }

  /**
   * Returns string representation of folder structure for relativization.
   *
   * @param {Array.<String>} baseNames
   * @param {Array.<String>} boundNames
   * @returns {String}
   */
  function getOrdStr(baseNames, boundNames) {
    var ordStr = '';
    for (var i = 0; i < boundNames.length; i++) {
      if (boundNames[i] !== baseNames[i]) {
        for (var j = i; j < boundNames.length; j++) {
          if (ordStr.length) {
            ordStr += '/';
          }
          ordStr += boundNames[j];
        }
        break;
      }
    }
    return ordStr;
  }

  /**
   * Validates the baseOrd and boundOrd to relativize.
   *
   * @param {baja.Ord} baseOrd
   * @param {baja.Ord} boundOrd
   * @returns {Object}
   * @throws {Error} If an invalid input is provided.
   */
  function validateAndGetOrdParts(baseOrd, boundOrd) {
    if (!baseOrd || !boundOrd || baseOrd.isNull() || boundOrd.isNull()) {
      throw new Error('Invalid input to relativize.');
    }

    //Iterate over schemes
    var boundOrdQueryList = boundOrd.parse();

    //throw an Error if Ord has only a 'station:' or 'bog:'.
    if (boundOrdQueryList.size() === 1 && ['station', 'bog'].contains(boundOrdQueryList.get(0).getSchemeName())) {
      throw new Error('Invalid input to relativize.');
    }
    var boundOrdSlotQuery = boundOrdQueryList.get(1);
    if (boundOrdSlotQuery.getSchemeName() !== 'slot') {
      throw new Error('Invalid input to relativize.');
    }

    //throw an Error if Ord does not start with slot: skip memory: and the following bog:
    var tailQuery = '';
    boundOrdQueryList.getCursor().each(function (query, index) {
      if (index >= 2) {
        tailQuery = tailQuery + '|' + query.toString();
      }
    });
    var baseOrdQueryList = baseOrd.normalize().parse();
    var baseNames = [];
    var isRoot = false;
    baseOrdQueryList.getCursor().each(function (query) {
      if (query.getSchemeName() === 'slot') {
        isRoot = query.getBody() === '/';
        baseNames.push.apply(baseNames, _toConsumableArray(query.getNames()));
      }
    });
    var boundNames = boundOrdSlotQuery.getNames();
    // If boundOrd names are empty like slot: then throw an Error (or)
    // If base component is not a starting point for boundOrd then return boundOrd then throw an Error.
    if ((!boundNames.length || baseNames[0] !== boundNames[0]) && !(isRoot && !baseNames.length)) {
      throw new Error('Invalid input to relativize.');
    }
    return {
      baseNames: baseNames,
      boundNames: boundNames,
      tailQuery: tailQuery
    };
  }

  /**
   * Retrieves all the ords and ord variables from the Px page referenced by the PxInclude, then
   * sets `variables` and `origOrds` on the properties for editing.
   *
   * @param {module:bajaux/model/UxModel} uxModel a UxModel representing a PxInclude
   * @param {module:bajaux/Properties} props
   * @returns {Promise.<module:bajaux/Properties>}
   */
  function processPxIncludeVariablesAndProperties(uxModel, props) {
    var _uxModel$getPropertie = uxModel.getProperties(),
      ord = _uxModel$getPropertie.ord,
      variables = _uxModel$getPropertie.variables;
    if (props.getMetadata("variables").substituteValue !== undefined) {
      return props;
    }
    return fromPxOrd(ord).then(function (_ref29) {
      var uxModel = _ref29.uxModel,
        pxProperties = _ref29.pxProperties;
      return Promise.all([exports.getAllOrdVariables(uxModel), exports.findOrds(uxModel), pxProperties]);
    })["catch"](function () {
      return [[], [], {}];
    }).then(function (_ref30) {
      var _ref31 = _slicedToArray(_ref30, 3),
        variableNames = _ref31[0],
        origOrds = _ref31[1],
        pxProperties = _ref31[2];
      // variables not configured on the PxInclude yet. default them all to empty strings.
      if (variables === baja.Facets.DEFAULT) {
        variables = baja.Facets.make(variableNames.reduce(function (obj, variableName) {
          obj[variableName] = '';
          return obj;
        }, {}));
        props.setValue('variables', variables);
      }
      props.setMetadata('variables', {
        uxFieldEditor: 'nmodule/uxBuilder/rc/fe/VariablesEditor',
        origOrds: origOrds.filter(function (ord) {
          return !ord.isNull();
        }).join('\n')
      });

      // Skip to add PxInclude PxProperty to the node When it already has a property,
      // with the same name as the PxInclude PxProperties.
      var newPxProperties = {};
      Object.entries(pxProperties).forEach(function (_ref32) {
        var _ref33 = _slicedToArray(_ref32, 2),
          key = _ref33[0],
          value = _ref33[1].value;
        if (props.getValue(key) === null) {
          newPxProperties[key] = value;
        }
      });
      return Properties.extend(props, new Properties(newPxProperties));
    });
  }
  function getLinkedPropertyPaths(uxModel) {
    return Object.assign({}, uxModel.getMetadata().linkedPropertyPaths);
  }
  function getPxPropertyOverrideValues(uxModel, pxProperties) {
    return mapObject(getLinkedPropertyPaths(uxModel), function (pxPropertyName) {
      var prop = pxProperties[pxPropertyName];
      return prop && prop.value;
    });
  }
  function shallowClone(uxModel, params) {
    return uxModel.clone(UxModel.$extendParams(params, {
      kids: []
    })).then(function (clone) {
      return clone.clone({
        bindings: clone.getBindingList().getBindings().map(cloneBinding)
      });
    }).then(function (clone) {
      clone.$obj.kids = params && params.kids || uxModel.getKids();
      return clone;
    });
  }

  /**
   * @param {module:bajaux/model/UxModel} uxModel
   * @param {module:nmodule/uxBuilder/rc/ux/sidebars/PropertiesWidget~WidgetNodeChanges} changes
   */
  function cloneModelWithChanges(uxModel, changes) {
    var _changes$widgetChange = changes.widgetChanges,
      widgetChanges = _changes$widgetChange === void 0 ? {} : _changes$widgetChange,
      _changes$bindingChang = changes.bindingChanges,
      bindingChanges = _changes$bindingChang === void 0 ? [] : _changes$bindingChang,
      bindingsToAdd = changes.bindingsToAdd,
      _changes$linkedProper = changes.linkedPropertyPaths,
      linkedPropertyPaths = _changes$linkedProper === void 0 ? {} : _changes$linkedProper;
    var bindings = bindingsToAdd || uxModel.getBindingList().getBindings();
    return exports.withPropertyPathsLinked(uxModel, linkedPropertyPaths).then(function (uxModel) {
      return exports.shallowCloneUxModel(uxModel, {
        bindings: bindings
      });
    }).then(function (newModel) {
      return Promise.all(newModel.getBindingList().getBindings().map(function (newBinding, i) {
        var bindingChangesValueMapToApply = bindingChanges[i];
        return applyValueMapToComponent(newBinding, bindingChangesValueMapToApply);
      })).then(function () {
        Object.assign(newModel.getProperties(), widgetChanges);
        return newModel;
      });
    });
  }

  /**
   * @param {baja.Component} comp
   * @param {object} [valueMap]
   * @returns {Promise}
   */
  function applyValueMapToComponent(comp) {
    var valueMap = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    return Promise.all(Object.entries(valueMap).map(function (_ref34) {
      var _ref35 = _slicedToArray(_ref34, 2),
        slotPath = _ref35[0],
        value = _ref35[1];
      var _getComplexAndSlotFro = getComplexAndSlotFromPath(comp, slotPath),
        complex = _getComplexAndSlotFro.complex,
        slot = _getComplexAndSlotFro.slot;
      var shouldRemove = value === undefined || value === null;
      if (shouldRemove) {
        if (!complex.has(slot)) {
          return Promise.resolve(); // nothing to remove
        } else if (complex.getSlot(slot).isFrozen()) {
          // reset to default value
          return complex.set({
            slot: slot,
            value: baja.lt(complex.getType()).getInstance().get(slot)
          });
        } else {
          return complex.remove(slot);
        }
      } else {
        if (!complex.has(slot)) {
          return complex.add({
            slot: slot,
            value: value.newCopy(true)
          });
        } else {
          return complex.set({
            slot: slot,
            value: value.newCopy(true)
          });
        }
      }
    }));
  }
  return exports;
});
