function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

define(['baja!', 'lex!uxBuilder', 'Promise', 'nmodule/bajaui/rc/ux/PxInclude', 'nmodule/uxBuilder/rc/util/uxBuilderUtils', 'nmodule/uxBuilder/rc/ux/commands/ModifyUxModelCommand'], function (baja, lexs, Promise, PxInclude, uxBuilderUtils, ModifyUxModelCommand) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    uxBuilderLex = _lexs[0];
  var getOriginatingNode = uxBuilderUtils.getOriginatingNode;

  /**
   * API Status: **Private**
   * @exports nmodule/uxBuilder/rc/util/uxBuilderOrdUtils
   */
  var exports = {};

  /**
   * Replace an Ord with a new value.
   * @param {Object} params the object literal for the method's arguments.
   * @param {module:bajaux/model/UxModel} params.model
   * @param {module:bajaux/Widget} params.widget
   * @param {Array.<Object>} params.fromToObjArray
   * @param {String} params.lexKey
   * @returns {Promise}
   */
  exports.visitToReplaceOneOrdWithAnother = function (_ref) {
    var model = _ref.model,
      widget = _ref.widget,
      fromToObjArray = _ref.fromToObjArray,
      lexKey = _ref.lexKey;
    var putOps = [];
    var fromToOrdTextArray = [];
    return model.visit(function (model) {
      var modified = false;
      var changes = {
        widgetChanges: {},
        bindingChanges: []
      };
      if (model.$represents(PxInclude)) {
        var props = model.getProperties();
        Object.keys(props).forEach(function (key) {
          var value = props[key];
          var fromToOrd = getFromOrdToOrd(value, fromToObjArray);
          if (baja.hasType(value, 'baja:Ord') && fromToOrd) {
            var fromOrd = fromToOrd.fromOrd,
              toOrd = fromToOrd.toOrd;
            changes.widgetChanges[key] = toOrd;
            fromToOrdTextArray.push([fromOrd, toOrd]);
            modified = true;
          }
        });
      }
      model.getBindingList().getBindings().forEach(function (binding, index) {
        binding.getSlots().properties().each(function (prop) {
          var value = binding.get(prop);
          var fromToOrd = getFromOrdToOrd(value, fromToObjArray);
          if (value.getType().is('baja:Ord') && fromToOrd) {
            var fromOrd = fromToOrd.fromOrd,
              toOrd = fromToOrd.toOrd;
            changes.bindingChanges[index] = changes.bindingChanges[index] || {};
            changes.bindingChanges[index][prop.getName()] = toOrd;
            fromToOrdTextArray.push([fromOrd, toOrd]);
            modified = true;
          }
        });
      });
      if (modified) {
        return uxBuilderUtils.cloneWithChanges([model], changes) // spied on
        .then(function (_ref2) {
          var _ref3 = _slicedToArray(_ref2, 1),
            cloned = _ref3[0];
          putOps.push({
            parentNode: getOriginatingNode(model).getParent(),
            model: cloned,
            name: model.getName()
          });
        });
      }
    }).then(function () {
      if (putOps.length > 0) {
        var redoKey = lexKey + '.redoText';
        var undoKey = lexKey + '.undoText';
        var redoText = function redoText() {
          return getTextToDisplay(redoKey);
        };
        var undoText = function undoText() {
          return getTextToDisplay(undoKey);
        };
        if (lexKey !== 'commands.relativize') {
          redoText = function redoText() {
            return getTextToDisplay(redoKey, fromToOrdTextArray);
          };
          undoText = function undoText() {
            return getTextToDisplay(undoKey, fromToOrdTextArray);
          };
        }
        return ModifyUxModelCommand.modify(putOps, {
          redoText: redoText,
          undoText: undoText,
          onNewNodes: function onNewNodes() {
            widget.setModified(true);
            return widget.rerender();
          }
        });
      }
    });
  };

  /**
   * @param {baja.Ord} value
   * @param {Array.<Object>} fromToObjArray
   * @returns {Object|undefined}
   */
  function getFromOrdToOrd(value, fromToObjArray) {
    return fromToObjArray.find(function (_ref4) {
      var fromOrd = _ref4.fromOrd,
        toOrd = _ref4.toOrd;
      return toOrd && !toOrd.equivalent(fromOrd) && value.equivalent(fromOrd);
    });
  }

  /**
   * Formats the text to display.
   * @param {String} key
   * @param {Array.<Array.<String>>} [argsArray]
   * @returns {String}
   */
  function getTextToDisplay(key, argsArray) {
    if (!argsArray || !argsArray.length) {
      return uxBuilderLex.get({
        key: key
      });
    }
    var text = '';
    argsArray.forEach(function (args, index) {
      text += uxBuilderLex.get({
        key: key,
        args: args
      });
      if (index + 1 !== argsArray.length) {
        text += '\n';
      }
    });
    return text;
  }
  return exports;
});
