/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

define([], function () {
  'use strict';

  /**
   * API Status: **Private**
   * @exports nmodule/uxBuilder/rc/util/uxBuilderEvents
   */
  var exports = {};

  /** Triggers when an ord replacement request is made.
   *  First parameter is an array of Object, this Object will have 2 properties, fromOrd and toOrd - Array.<{fromOrd: baja.Ord, toOrd: baja.Ord}>
   *  Second parameter is a String, this is the lexicon key of relativize, edit or replace commands.
   *  User should not provide '.redoText' and '.undoText' keys along with the lexicon key.
   */
  exports.ORD_REPLACEMENT_REQUESTED = "ordReplacementRequested";

  /**
   * Triggers when user requests a drop on a UxModelTreeNode.
   * @type {string}
   */
  exports.DROP_REQUESTED = 'dropRequested';

  /**
   * Is triggered when the layout of a widget has changed upon moving or 
   * resizing.
   * @type {string}
   */
  exports.LAYOUT_CHANGED = 'layoutChanged';

  /**
   * Is triggered when a particular UxModelTreeNode "wants" to be selected, either by selecting in
   * the Widget Tree or by clicking in the Px Widget.
   * @type {string}
   */
  exports.SELECTION_REQUESTED = 'selectionRequested';

  /**
   * Is triggered when a particular UxModelTreeNode "wants" to be deselected, either by selecting in
   * the Widget Tree or by clicking in the Px Widget.
   * @type {string}
   */
  exports.DESELECTION_REQUESTED = 'deselectionRequested';

  /**
   * Is triggered when a particular UxModelTreeNode announces that it has been modified, prompting
   * the UxBuilder itself to mark itself modified.
   * @type {string}
   */
  exports.TREE_MODIFIED = 'treeModified';
  return exports;
});
