function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

define(['lex!uxBuilder', 'bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'Promise', 'nmodule/bajaui/rc/ux/FlowPane', 'nmodule/uxBuilder/rc/util/uxBuilderUtils', 'nmodule/uxBuilder/rc/ux/commands/AddBorderCommand', 'nmodule/uxBuilder/rc/ux/commands/AddResponsivePaneCommand', 'nmodule/uxBuilder/rc/ux/commands/DeleteUxModelCommand', 'nmodule/uxBuilder/rc/ux/commands/DuplicateUxModelCommand', 'nmodule/uxBuilder/rc/ux/commands/RemoveBorderCommand', 'nmodule/uxBuilder/rc/ux/commands/RemoveResponsivePaneCommand', 'nmodule/uxBuilder/rc/ux/commands/RenameTreeNodeCommand', 'nmodule/uxBuilder/rc/ux/commands/align/AlignBottomCommand', 'nmodule/uxBuilder/rc/ux/commands/align/AlignCenterHorizontallyCommand', 'nmodule/uxBuilder/rc/ux/commands/align/AlignCenterVerticallyCommand', 'nmodule/uxBuilder/rc/ux/commands/align/AlignLeftCommand', 'nmodule/uxBuilder/rc/ux/commands/align/AlignRightCommand', 'nmodule/uxBuilder/rc/ux/commands/align/AlignTopCommand', 'nmodule/uxBuilder/rc/ux/commands/distribute/DistributeHorizontallyCommand', 'nmodule/uxBuilder/rc/ux/commands/distribute/DistributeVerticallyCommand', 'nmodule/uxBuilder/rc/ux/commands/reorder/MoveDownCommand', 'nmodule/uxBuilder/rc/ux/commands/reorder/MoveToBottomCommand', 'nmodule/uxBuilder/rc/ux/commands/reorder/MoveToTopCommand', 'nmodule/uxBuilder/rc/ux/commands/reorder/MoveUpCommand', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/commands/CopyCommand', 'nmodule/webEditors/rc/wb/commands/CutCommand', 'nmodule/webEditors/rc/wb/commands/PasteCommand', 'nmodule/webEditors/rc/wb/commands/RenameCommand', 'nmodule/webEditors/rc/wb/menu/Separator'], function (lexs, Command, CommandGroup, Promise, FlowPane, uxBuilderUtils, AddBorderCommand, AddResponsivePaneCommand, DeleteUxModelCommand, DuplicateUxModelCommand, RemoveBorderCommand, RemoveResponsivePaneCommand, RenameTreeNodeCommand, AlignBottomCommand, AlignCenterHorizontallyCommand, AlignCenterVerticallyCommand, AlignLeftCommand, AlignRightCommand, AlignTopCommand, DistributeHorizontallyCommand, DistributeVerticallyCommand, MoveDownCommand, MoveToBottomCommand, MoveToTopCommand, MoveUpCommand, typeUtils, feDialogs, CopyCommand, CutCommand, PasteCommand, RenameCommand, Separator) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    uxBuilderLex = _lexs[0];
  var getCommonParentNode = uxBuilderUtils.getCommonParentNode,
    isFreeFormPane = uxBuilderUtils.isFreeFormPane,
    isNullWidget = uxBuilderUtils.isNullWidget,
    isUxModelEditable = uxBuilderUtils.isUxModelEditable,
    isUxModelLocked = uxBuilderUtils.isUxModelLocked,
    makeNewWidgetCommandGroup = uxBuilderUtils.makeNewWidgetCommandGroup,
    reorderKidsForReversibleParentPane = uxBuilderUtils.reorderKidsForReversibleParentPane;

  /**
   * API Status: **Private**
   * @exports nmodule/uxBuilder/rc/util/uxBuilderContextMenu
   */
  var exports = {};

  /**
   * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodes the nodes being
   * right-clicked
   * @param {object} params
   * @param {function} params.editPropertiesFunc
   * @param {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxLayer>} params.pxLayers
   * @param {boolean} [params.readonly] whether the UxBuilder is in readonly mode, disabling certain
   * commands
   * @param {module:nmodule/webEditors/rc/wb/util/TransferWidget} [params.transferWidget] a
   * transfer widget to which the cut/copy/paste commands can delegate
   * @param {boolean} params.preserveIdentities
   * @returns {Promise.<module:bajaux/commands/CommandGroup>}
   */
  exports.makeContextMenuCommandGroupForWidgetNodes = function (nodes, params) {
    var pxLayers = params.pxLayers,
      readonly = params.readonly,
      editPropertiesFunc = params.editPropertiesFunc,
      snapSize = params.snapSize,
      transferWidget = params.transferWidget,
      beforeInsert = params.beforeInsert,
      preserveIdentities = params.preserveIdentities;
    var cmdGroup = new CommandGroup();
    var enabled = nodes.length && allEditable(nodes);
    var locked = anyLocked(nodes, pxLayers);
    var separatorPos = 0;
    var commands;
    var containsNullWidget = nodes.find(function (selectedNode) {
      return isNullWidget(selectedNode.value());
    });
    var addNewWidgetCommandGroup;
    var enablePaste = false;
    if (nodes.length === 1) {
      var selectedNode = nodes[0];
      var uxModel = selectedNode.value();
      var parentNode, name;
      if (isNullWidget(uxModel)) {
        // replacing a nullWidget placeholder with real widget
        parentNode = selectedNode.getParent();
        name = uxModel.getName();
      } else if (isFreeFormPane(uxModel)) {
        // appending new node to a freeform pane; name will be auto-generated
        parentNode = selectedNode;
      }
      if (parentNode) {
        addNewWidgetCommandGroup = makeNewWidgetGroup(parentNode, name, readonly, beforeInsert).then(function (newGroup) {
          return cmdGroup.add(newGroup);
        });
        enablePaste = true;
      }
    }
    return Promise.resolve(addNewWidgetCommandGroup).then(function () {
      var _commands;
      var commonParent = getCommonParentNode(nodes);
      var shareSameFreeFormParent = commonParent && isFreeFormPane(commonParent.value());
      var allParentsAreFlowPanes = nodes.length && nodes.every(function (node) {
        return node.getParent().represents(FlowPane);
      });
      commands = cmdGroup.getChildren();
      separatorPos = commands.length;

      // Reverse the order of the nodes when the parent is a Reversible Pane.
      var orderedNodes = reorderKidsForReversibleParentPane(nodes);
      var cutCommand = new CutCommand(orderedNodes, transferWidget);
      var copyCommand = new CopyCommand(orderedNodes, transferWidget);
      var pasteCommand = new PasteCommand(orderedNodes, transferWidget);
      var duplicateCommand = new DuplicateUxModelCommand(orderedNodes, {
        enabled: enabled && !locked && shareSameFreeFormParent && !readonly,
        snapSize: snapSize
      });
      var deleteCommand = new DeleteUxModelCommand(nodes, {
        enabled: enabled && !locked && !readonly
      });
      cutCommand.setEnabled(!locked && !containsNullWidget && !readonly);
      copyCommand.setEnabled(!containsNullWidget);
      pasteCommand.setEnabled(!locked && enablePaste && !readonly);
      (_commands = commands).push.apply(_commands, [cutCommand, copyCommand, pasteCommand, duplicateCommand, deleteCommand]);
      if (separatorPos !== 0 && commands.length > separatorPos) {
        commands.splice(separatorPos, 0, new Separator());
      }
      separatorPos = commands.length;
      if (editPropertiesFunc) {
        commands.push(new Command({
          module: 'uxBuilder',
          lex: 'WidgetTree.command.editProperties',
          enabled: enabled,
          func: function func() {
            return editPropertiesFunc(nodes);
          }
        }));
      }
      if (separatorPos !== 0 && commands.length > separatorPos) {
        commands.splice(separatorPos, 0, new Separator());
      }

      //Align context menu commands
      var alignCommandGroup = new CommandGroup({
        displayName: uxBuilderLex.get('WidgetTree.command.align.displayName'),
        commands: [new AlignLeftCommand({
          enabled: !readonly,
          transferWidget: transferWidget
        }, nodes, pxLayers), new AlignCenterHorizontallyCommand({
          enabled: !readonly,
          transferWidget: transferWidget
        }, nodes, pxLayers), new AlignRightCommand({
          enabled: !readonly,
          transferWidget: transferWidget
        }, nodes, pxLayers), new AlignTopCommand({
          enabled: !readonly,
          transferWidget: transferWidget
        }, nodes, pxLayers), new AlignCenterVerticallyCommand({
          enabled: !readonly,
          transferWidget: transferWidget
        }, nodes, pxLayers), new AlignBottomCommand({
          enabled: !readonly,
          transferWidget: transferWidget
        }, nodes, pxLayers)]
      });
      commands.push(alignCommandGroup);

      //Distribute context menu commands
      var distributeCommandGroup = new CommandGroup({
        displayName: uxBuilderLex.get('WidgetTree.command.distribute.displayName'),
        commands: [new DistributeVerticallyCommand({
          enabled: !readonly,
          transferWidget: transferWidget
        }, nodes, pxLayers), new DistributeHorizontallyCommand({
          enabled: !readonly,
          transferWidget: transferWidget
        }, nodes, pxLayers)]
      });
      commands.push(distributeCommandGroup);

      // Reorder context menu commands
      var reorderCommandGroup = new CommandGroup({
        displayName: uxBuilderLex.get('WidgetTree.command.contextMenu.description'),
        commands: [new MoveToTopCommand({
          enabled: !readonly
        }, nodes, pxLayers), new MoveUpCommand({
          enabled: !readonly
        }, nodes, pxLayers), new MoveDownCommand({
          enabled: !readonly
        }, nodes, pxLayers), new MoveToBottomCommand({
          enabled: !readonly
        }, nodes, pxLayers)]
      });
      commands.push(reorderCommandGroup);
      var borderCommandGroup = new CommandGroup({
        displayName: uxBuilderLex.get('WidgetTree.command.border.displayName'),
        commands: [new AddBorderCommand(nodes, {
          enabled: !readonly
        }), new RemoveBorderCommand(nodes, {
          enabled: !readonly
        })]
      });
      commands.push(borderCommandGroup);
      if (allParentsAreFlowPanes) {
        var responsiveCommandGroup = new CommandGroup({
          displayName: uxBuilderLex.get('WidgetTree.command.responsive.displayName'),
          commands: [new AddResponsivePaneCommand(nodes, {
            enabled: !readonly
          }), new RemoveResponsivePaneCommand(nodes, {
            enabled: !readonly
          })]
        });
        commands.push(responsiveCommandGroup);
      }

      // Support rename when preserveIdentities is enabled
      if (preserveIdentities) {
        var enableRenameCommand = nodes.length === 1 && isFreeFormPane(commonParent.value()) && !readonly && !locked;
        var renameCommand = new RenameTreeNodeCommand(commonParent, nodes[0]);
        renameCommand.setEnabled(enableRenameCommand);
        commands.push(renameCommand);
      }
      cmdGroup.setChildren(commands);
      return cmdGroup;
    });
  };
  function makeNewWidgetGroup(parentNode, name, readonly, beforeInsert) {
    return makeNewWidgetCommandGroup(parentNode, {
      name: name,
      beforeInsert: beforeInsert
    }).then(function (newGroup) {
      newGroup.getChildren().forEach(function (cmd) {
        cmd.setEnabled(!readonly);
      });
      return newGroup;
    });
  }

  /**
   * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodes
   * @returns {boolean}
   */
  function allEditable(nodes) {
    return nodes.every(function (node) {
      return isUxModelEditable(node.value());
    });
  }

  /**
   * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodes
   * @param {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxLayer>} [pxLayers]
   * @returns {boolean}
   */
  function anyLocked(nodes, pxLayers) {
    return nodes.some(function (node) {
      return isUxModelLocked(node.value(), pxLayers || []);
    });
  }
  return exports;
});
