function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/fe/BoundOrdReplaceEditor
 */

define(["baja!", 'log!nmodule.uxBuilder.rc.fe.BoundOrdReplaceEditor', 'lex!uxBuilder', 'bajaux/events', 'bajaux/spandrel', 'Promise', 'nmodule/webEditors/rc/servlets/userData', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/table/model/Row', 'nmodule/webEditors/rc/wb/table/Table', 'nmodule/webEditors/rc/wb/table/model/TableModel'], function (baja, log, lexs, events, spandrel, Promise, userData, Column, Row, Table, TableModel) {
  'use strict';

  var logSevere = log.severe.bind(log);
  var _Column$flags = Column.flags,
    EDITABLE = _Column$flags.EDITABLE,
    READONLY = _Column$flags.READONLY;
  var _lexs = _slicedToArray(lexs, 1),
    uxBuilderLex = _lexs[0];
  var beforeLabel = uxBuilderLex.get("BoundOrdsEditor.searchReplace.editor.before");
  var afterLabel = uxBuilderLex.get("BoundOrdsEditor.searchReplace.editor.after");
  var searchFor = uxBuilderLex.get("BoundOrdsEditor.searchReplace.editor.searchFor");
  var replaceWith = uxBuilderLex.get("BoundOrdsEditor.searchReplace.editor.replaceWith");
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'uxBuilder/rc',
      keyName: 'BoundOrdReplaceEditor',
      properties: {
        rootCssClass: '-t-BoundOrdReplaceEditor'
      }
    };
  };
  var loadSearches = function loadSearches() {
    var searchListObj = {};
    var replaceListObj = {};
    if (baja.isOffline()) {
      return Promise.resolve([]);
    }
    return userData.getJson("borderOrdReplace").then(function (value) {
      var searchArray = [];
      var replaceArray = [];
      if (value) {
        var searchObj = value;
        searchArray = searchObj.search;
        replaceArray = searchObj.replace;
      }
      searchArray.forEach(function (str) {
        searchListObj[str] = str;
      });
      replaceArray.forEach(function (str) {
        replaceListObj[str] = str;
      });
      return [searchListObj, replaceListObj];
    });
  };

  /**
   * @param {Object} searchListObj
   * @param {String} searchVal
   * @param {Object} replaceListObj
   * @param {String} replaceVal
   * @returns {Promise}
   */
  function saveSearches() {
    var searchListObj = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var searchVal = arguments.length > 1 ? arguments[1] : undefined;
    var replaceListObj = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var replaceVal = arguments.length > 3 ? arguments[3] : undefined;
    var searchObj = {};
    var searchArray = Object.values(searchListObj);
    var replaceArray = Object.values(replaceListObj);
    if (baja.isOffline()) {
      return Promise.resolve([]);
    }
    if (searchVal && !searchArray.includes(searchVal)) {
      searchArray.push(searchVal);
    }
    if (replaceVal && !replaceArray.includes(replaceVal)) {
      replaceArray.push(replaceVal);
    }
    if (replaceArray.length !== 0 || searchArray.length !== 0) {
      searchObj.search = searchArray;
      searchObj.replace = replaceArray;
      return userData.putJson("borderOrdReplace", searchObj);
    }
    return Promise.resolve();
  }

  /**
   * Editor to perform a search and replace on bound ords
   *
   * @class
   * @alias module:nmodule/uxBuilder/rc/fe/BoundOrdReplaceEditor
   * @extends module:bajaux/Widget
   * @since Niagara 4.15
   */
  var BoundOrdReplaceEditor = /*#__PURE__*/function (_spandrel) {
    function BoundOrdReplaceEditor(params) {
      var _this;
      _classCallCheck(this, BoundOrdReplaceEditor);
      _this = _callSuper(this, BoundOrdReplaceEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);

      //TODO $forcePropose is a temporary solution that tells the PopOutCommand to force a change
      // even if the original value of the primary field and the new value are the same.  The issue
      // for this is NCCB-54633.

      // eslint-disable-next-line no-unused-vars
      _this.$forcePropose = true;
      _this.$lastReplace = '';
      _this.$lastSearch = '';
      return _this;
    }
    _inherits(BoundOrdReplaceEditor, _spandrel);
    return _createClass(BoundOrdReplaceEditor, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;
        this.$buildTableCols();
        dom.on(events.MODIFY_EVENT, '', function () {
          _this2.$applyChanges()["catch"](logSevere);
        });
        return _superPropGet(BoundOrdReplaceEditor, "doInitialize", this, 3)(arguments);
      }

      /**
       * Builds the search and replace editor
       * @private
       * @param {Object} state
       * @returns {Promise}
       */
    }, {
      key: "$buildEditor",
      value: function $buildEditor(state) {
        var _this3 = this;
        return this.$loadSearches().then(function () {
          return [spandrel.jsx("div", {
            spandrelKey: "mainLayout"
          }, spandrel.jsx("div", {
            className: "tableContainer"
          }, spandrel.jsx(Table, {
            spandrelKey: "mainTable",
            value: _this3.$buildTableModel(),
            style: "max-height: 40vh; margin-bottom: 10px;",
            properties: {
              fixedHeaders: true
            }
          })), spandrel.jsx("table", {
            className: "-t-BoundOrdsEditor-params",
            spandrelKey: "paramTable"
          }, spandrel.jsx("tr", {
            spandrelKey: "searchRow"
          }, spandrel.jsx("td", {
            className: "-t-BoundOrdsEditor-tableLabel"
          }, searchFor), spandrel.jsx("td", {
            spandrelKey: "searchCell"
          }, spandrel.jsx("any", {
            className: "-t-BoundOrdsEditor-stringVal",
            spandrelKey: "searchVal",
            value: _this3.$lastSearch,
            properties: {
              datalist: _this3.$searchList
            }
          }))), spandrel.jsx("tr", {
            spandrelKey: "replaceRow"
          }, spandrel.jsx("td", {
            className: "-t-BoundOrdsEditor-tableLabel"
          }, replaceWith), spandrel.jsx("td", {
            spandrelKey: "replaceCell"
          }, spandrel.jsx("any", {
            className: "-t-BoundOrdsEditor-stringVal",
            spandrelKey: "replaceVal",
            value: _this3.$lastReplace,
            properties: {
              datalist: _this3.$replaceList
            }
          })))))];
        });
      }

      /**
       * Takes the input value and returns the editor state
       * @param {Array.<Object>} value
       * @returns {Object}
       */
    }, {
      key: "toState",
      value: function toState(value) {
        return {
          selectedOrds: value
        };
      }

      /**
       * Takes the state value of the editor and returns the expected output
       * @param {Object} state
       * @returns {Array.<Object>}
       */
    }, {
      key: "fromState",
      value: function fromState(state) {
        var selectedOrds = state.selectedOrds;
        return selectedOrds;
      }
    }, {
      key: "doSave",
      value: function doSave() {
        var _arguments = arguments,
          _this4 = this;
        return saveSearches(this.$searchList, this.$lastSearch, this.$replaceList, this.$lastReplace).then(function () {
          return _superPropGet(BoundOrdReplaceEditor, "doSave", _this4, 3)(_arguments);
        });
      }

      /**
       * Builds the columns for the preview table
       * @private
       */
    }, {
      key: "$buildTableCols",
      value: function $buildTableCols() {
        var beforeValCol = new Column('beforeVal', {
          displayName: beforeLabel,
          flags: EDITABLE | READONLY
        });
        beforeValCol.setSortable(false);
        beforeValCol.setHidable(false);
        beforeValCol.getValueFor = function (row) {
          return row.$subject.fromOrd;
        };
        var afterValCol = new Column('afterVal', {
          displayName: afterLabel,
          flags: EDITABLE | READONLY
        });
        afterValCol.setSortable(false);
        afterValCol.setHidable(false);
        afterValCol.getValueFor = function (row) {
          return row.$subject.toOrd;
        };
        this.$columns = [beforeValCol, afterValCol];
      }

      /**
       * Builds the table model to show the selected ords
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/table/model/TableModel}
       */
    }, {
      key: "$buildTableModel",
      value: function $buildTableModel() {
        var _this$state = this.state(),
          selectedOrds = _this$state.selectedOrds;
        var rows = selectedOrds.map(function (selectedOrd) {
          return new Row(selectedOrd);
        });
        return new TableModel({
          rows: rows,
          columns: this.$columns
        });
      }

      /**
       * Loads in the previous search and replace values
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$loadSearches",
      value: function $loadSearches() {
        var _this5 = this;
        this.$searchList = {};
        this.$replaceList = {};
        return loadSearches().then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
            searchListObj = _ref2[0],
            replaceListObj = _ref2[1];
          if (searchListObj) {
            _this5.$searchList = searchListObj;
          }
          if (replaceListObj) {
            _this5.$replaceList = replaceListObj;
          }
        });
      }

      /**
       * Applies the changes to the selected ords
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$applyChanges",
      value: function $applyChanges() {
        var _this6 = this;
        var _this$state2 = this.state(),
          selectedOrds = _this$state2.selectedOrds;
        var newSelectedOrds = [];
        return Promise.all([this.$getSearchVal().read(), this.$getReplaceVal().read()]).then(function (_ref3) {
          var _ref4 = _slicedToArray(_ref3, 2),
            searchValue = _ref4[0],
            replaceValue = _ref4[1];
          if (searchValue) {
            _this6.$lastSearch = searchValue;
            _this6.$lastReplace = replaceValue;
            var param = "g";

            //This line escapes special values used by RegExp
            // eslint-disable-next-line no-useless-escape
            searchValue = searchValue.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
            var searchRegx = new RegExp(searchValue, param);
            selectedOrds.forEach(function (_ref5) {
              var fromOrd = _ref5.fromOrd;
              newSelectedOrds.push({
                fromOrd: fromOrd,
                toOrd: baja.Ord.make(fromOrd.encodeToString().replace(searchRegx, replaceValue))
              });
            });
          } else {
            selectedOrds.forEach(function (_ref6) {
              var fromOrd = _ref6.fromOrd;
              newSelectedOrds.push({
                fromOrd: fromOrd,
                toOrd: baja.Ord.make(fromOrd.encodeToString())
              });
            });
          }
          return _this6.state({
            selectedOrds: newSelectedOrds
          });
        });
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/table/Table}
       */
    }, {
      key: "$getTable",
      value: function $getTable() {
        return this.queryWidget("mainLayout/**/mainTable");
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getSearchVal",
      value: function $getSearchVal() {
        return this.queryWidget("mainLayout/**/searchVal");
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getReplaceVal",
      value: function $getReplaceVal() {
        return this.queryWidget("mainLayout/**/replaceVal");
      }
    }]);
  }(spandrel(function (value, state) {
    var self = state.self;
    return self.$buildEditor(state);
  }, {
    strategy: 'niagara'
  }));
  return BoundOrdReplaceEditor;
});
