function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/signingService/rc/wb/mgr/command/ApproveCommand
 * @since Niagara 4.13
 */
define(['baja!', 'baja!signingService:SigningService,signingService:AbstractSigningProfile', 'Promise', 'underscore', 'dialogs', 'nmodule/signingService/rc/signingServiceUtil', 'nmodule/webEditors/rc/fe/feDialogs', 'bajaux/commands/Command', 'nmodule/webEditors/rc/wb/mgr/mgrUtils', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/js/rc/asyncUtils/asyncUtils', 'lex!signingService', 'hbs!nmodule/signingService/rc/wb/mgr/command/ApproveTpl', 'css!nmodule/signingService/rc/signingService'], function (baja, types, Promise, _, dialogs, signingServiceUtil, feDialogs, Command, mgrUtils, fe, OrderedMapEditor, asyncUtils, lexs, tpl) {
  'use strict';

  var getMainTableSelectedSubjects = mgrUtils.getMainTableSelectedSubjects,
    allSettled = asyncUtils.allSettled,
    _lexs = _slicedToArray(lexs, 1),
    signingServiceLex = _lexs[0];

  /**
   * Command for approving session tokens.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/signingService/rc/wb/mgr/command/ApproveCommand
   * @param {module:nmodule/signingService/rc/wb/mgr/SessionTokenManager} manager
   */
  return /*#__PURE__*/function (_Command) {
    function ApproveCommand(manager) {
      _classCallCheck(this, ApproveCommand);
      return _callSuper(this, ApproveCommand, [{
        module: 'signingService',
        lex: 'command.tokenStore.approve',
        enabled: false,
        func: function func() {
          var selectedSubjects = getMainTableSelectedSubjects(manager);
          if (selectedSubjects.length < 1) {
            // shouldn't get here if the button enables/disables correctly, but just in case ...
            throw new Error(signingServiceLex.getSafe('command.tokenStore.approve.no.selection'));
          }
          return signingServiceUtil.getSigningProfiles().then(function (profiles) {
            if (profiles.getSize() < 1) {
              throw new Error(signingServiceLex.getSafe('command.tokenStore.approve.no.valid.profiles'));
            }
            var profileSelector;
            return dialogs.showOkCancel({
              title: signingServiceLex.getSafe('command.tokenStore.approve.confirm.title'),
              content: function content(dialog, dom) {
                dom.html(tpl({
                  approveConfirm: signingServiceLex.getSafe('command.tokenStore.approve.confirm'),
                  enterProfile: signingServiceLex.getSafe('command.tokenStore.approve.enter.profile')
                })).addClass('-t-ApproveCommand');
                return fe.buildFor({
                  dom: dom.find('.-t-profileSelect'),
                  type: OrderedMapEditor,
                  value: profiles,
                  formFactor: 'mini'
                }).then(function (ed) {
                  profileSelector = ed;
                });
              }
            }).ok(function () {
              return profileSelector.read().then(function (profileString) {
                var batch = new baja.comm.Batch();
                var approvePromises = _.map(selectedSubjects, function (subject) {
                  return subject.invoke({
                    slot: 'approve',
                    value: profileString,
                    batch: batch
                  });
                });
                batch.commit();
                return allSettled(approvePromises).then(function (_ref) {
                  var resolved = _ref.resolved,
                    rejected = _ref.rejected;
                  if (rejected.length) {
                    var combinedErrors = _.map(rejected, function (e) {
                      return ' - ' + e.message;
                    }).join('\n');
                    var title = rejected.length === 1 ? signingServiceLex.get('command.tokenStore.approve.one.approval.failed') : signingServiceLex.get({
                      key: 'command.tokenStore.approve.approvals.failed',
                      args: [rejected.length]
                    });
                    var summary = rejected.length === 1 ? signingServiceLex.get('command.tokenStore.approve.one.error.summary') : signingServiceLex.get('command.tokenStore.approve.errors.summary');
                    return feDialogs.error(new Error(combinedErrors), {
                      title: title,
                      messageSummary: summary
                    });
                  }
                });
              });
            });
          });
        }
      }]);
    }
    _inherits(ApproveCommand, _Command);
    return _createClass(ApproveCommand);
  }(Command);
});
