function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/* eslint-env browser */

/**
* API Status: **Private**
* @module nmodule/bajaui/rc/ux/shape/Path
*/

define(['baja!', 'baja!gx:PathGeom,gx:Point', 'nmodule/bajaui/rc/ux/shape/Shape', 'nmodule/gx/rc/baja/Point', 'nmodule/gx/rc/baja/PathGeom'], function (baja, types, Shape, Point, PathGeom) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-Shape ux-Path',
        geom: PathGeom.NULL
      }
    };
  };
  return /*#__PURE__*/function (_Shape) {
    function Path(params) {
      _classCallCheck(this, Path);
      return _callSuper(this, Path, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }
    _inherits(Path, _Shape);
    return _createClass(Path, [{
      key: "renderContents",
      value: function renderContents() {
        var geom = this.properties().getValue('geom'),
          path = document.createElementNS('http://www.w3.org/2000/svg', 'path');
        path.setAttribute('d', generatePathGeom(geom));
        // Add mouse handler class

        return path;
      }
    }, {
      key: "getShapeEl",
      value: function getShapeEl(element) {
        return element.querySelector('path');
      }

      /**
       * 
       * @inheritdoc
       */
    }, {
      key: "$makeHitLayer",
      value: function $makeHitLayer() {
        var geom = this.properties().getValue('geom'),
          path = document.createElementNS('http://www.w3.org/2000/svg', 'path');
        path.setAttribute('d', generatePathGeom(geom));
        path.setAttribute('stroke-width', 8);
        // Add mouse handler class
        path.setAttribute('class', 'hxpx-mouseHandler');
        return path;
      }
    }]);
  }(Shape);

  /**
   * Generate the svg path geom to be painted
   * 
   * @param {gx:PathGeom} geom 
   */
  function generatePathGeom(geom) {
    var segs = geom.$getSegments();
    var lastPoint = Point.DEFAULT,
      lastControlPoint,
      newGeom = new PathGeom();
    segs.forEach(function (s) {
      switch (s.getCommand().toUpperCase()) {
        case 'Z':
          {
            newGeom = newGeom.close();
            break;
          }
        case 'M':
          {
            var p = s.getPoint();
            var newX = p.x(),
              newY = p.y();
            if (s.getRelative()) {
              newX += lastPoint.x();
              newY += lastPoint.y();
            }
            newGeom = newGeom.moveTo(true, newX, newY);
            lastPoint = new Point(newX, newY);
            lastControlPoint = lastPoint;
            break;
          }
        case 'L':
          {
            var _p = s.getPoint();
            var _newX = _p.x(),
              _newY = _p.y();
            if (s.getRelative()) {
              _newX += lastPoint.x();
              _newY += lastPoint.y();
            }
            newGeom = newGeom.lineTo(true, _newX, _newY);
            lastPoint = new Point(_newX, _newY);
            break;
          }
        case 'C':
          {
            var cp1 = s.getCp1(),
              cp2 = s.getCp2(),
              _p2 = s.getEnd();
            var _newX2 = _p2.x(),
              _newY2 = _p2.y(),
              newX1 = cp1.x(),
              newY1 = cp1.y(),
              newX2 = cp2.x(),
              newY2 = cp2.y();
            if (s.getRelative()) {
              _newX2 += lastPoint.x();
              _newY2 += lastPoint.y();
              newX1 += lastPoint.x();
              newY1 += lastPoint.y();
              newX2 += lastPoint.x();
              newY2 += lastPoint.y();
            }
            newGeom = newGeom.curveTo(true, newX1, newY1, newX2, newY2, _newX2, _newY2);
            lastPoint = new Point(_newX2, _newY2);
            lastControlPoint = new Point(newX2, newY2);
            break;
          }
        case 'S':
          {
            var _cp = lastPoint,
              _cp2 = s.getCp2(),
              _p3 = s.getEnd();
            var _newX3 = _p3.x(),
              _newY3 = _p3.y(),
              _newX4 = _cp.x(),
              _newY4 = _cp.y(),
              _newX5 = _cp2.x(),
              _newY5 = _cp2.y();
            if (lastControlPoint) {
              _newX4 += lastPoint.x() - lastControlPoint.x();
              _newY4 += lastPoint.y() - lastControlPoint.y();
            }
            if (s.getRelative()) {
              _newX3 += lastPoint.x();
              _newY3 += lastPoint.y();
              _newX5 += lastPoint.x();
              _newY5 += lastPoint.y();
            }
            newGeom = newGeom.curveTo(true, _newX4, _newY4, _newX5, _newY5, _newX3, _newY3);
            lastPoint = new Point(_newX3, _newY3);
            lastControlPoint = new Point(_newX5, _newY5);
            break;
          }
        case 'Q':
          {
            var cp = s.getCp(),
              _p4 = s.getEnd();
            var _newX6 = _p4.x(),
              _newY6 = _p4.y(),
              _newX7 = cp.x(),
              _newY7 = cp.y();
            if (s.getRelative()) {
              _newX6 += lastPoint.x();
              _newY6 += lastPoint.y();
              _newX7 += lastPoint.x();
              _newY7 += lastPoint.y();
            }
            newGeom = newGeom.quadTo(true, _newX7, _newY7, _newX6, _newY6);
            lastPoint = new Point(_newX6, _newY6);
            lastControlPoint = new Point(_newX7, _newY7);
            break;
          }
        case 'T':
          {
            var _cp3 = lastPoint,
              _p5 = s.getEnd();
            var _newX8 = _p5.x(),
              _newY8 = _p5.y(),
              _newX9 = _cp3.x(),
              _newY9 = _cp3.y();
            if (lastControlPoint) {
              _newX9 += lastPoint.x() - lastControlPoint.x();
              _newY9 += lastPoint.y() - lastControlPoint.y();
            }
            if (s.getRelative()) {
              _newX8 += lastPoint.x();
              _newY8 += lastPoint.y();
            }
            newGeom = newGeom.quadTo(true, _newX9, _newY9, _newX8, _newY8);
            lastPoint = new Point(_newX8, _newY8);
            lastControlPoint = new Point(_newX9, _newY9);
            break;
          }
        case 'H':
          {
            var _newX10 = s.getX(),
              _newY10 = lastPoint.y();
            if (s.getRelative()) {
              _newX10 += lastPoint.x();
            }
            newGeom = newGeom.lineTo(true, _newX10, _newY10);
            lastPoint = new Point(_newX10, _newY10);
            break;
          }
        case 'V':
          {
            var _newX11 = lastPoint.x(),
              _newY11 = s.getY();
            if (s.getRelative()) {
              _newY11 += lastPoint.y();
            }
            newGeom = newGeom.lineTo(true, _newX11, _newY11);
            lastPoint = new Point(_newX11, _newY11);
            break;
          }
        case 'A':
          {
            var _p6 = s.getEnd();
            var _newX12 = _p6.x(),
              _newY12 = _p6.y();
            if (s.getRelative()) {
              _newX12 += lastPoint.x();
              _newY12 += lastPoint.y();
            }
            newGeom = newGeom.arcTo(true, s.getRadiusX(), s.getRadiusY(), s.getXAxisRotation(), s.getLargeArcFlag(), s.getSweepFlag(), _newX12, _newY12);
            lastPoint = new Point(_newX12, _newY12);
            break;
          }
        default:
          {
            throw new Error('Invalid geom');
          }
      }
    });
    return newGeom.encodeToString();
  }
});
