function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/shape/Line
 */
define(['baja!', 'nmodule/bajaui/rc/ux/shape/Shape', 'nmodule/bajaui/rc/ux/shape/shapeUtil', 'baja!gx:Pen,gx:LineGeom', 'bajaux/spandrel', 'Promise', 'nmodule/gx/rc/baja/Pen'], function (baja, Shape, shapeUtil, types, spandrel, Promise, Pen) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-Shape ux-Line',
        geom: baja.$('gx:LineGeom', 'null')
      }
    };
  };

  /**
   * bajaux implementation of Line.
   *
   * @class
   * @alias module:nmodule/bajaui/rc/ux/shape/Line
   * @extends module:nmodule/bajaui/rc/ux/shape/Shape
   */
  return /*#__PURE__*/function (_Shape) {
    function Line(params) {
      _classCallCheck(this, Line);
      return _callSuper(this, Line, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }
    _inherits(Line, _Shape);
    return _createClass(Line, [{
      key: "renderContents",
      value: function renderContents() {
        var properties = this.properties(),
          geom = properties.getValue('geom');
        var elem,
          x1 = geom.x1(),
          x2 = geom.x2(),
          y1 = geom.y1(),
          y2 = geom.y2();
        elem = document.createElementNS('http://www.w3.org/2000/svg', 'line');
        var points = [{
          x: x1,
          y: y1
        }, {
          x: x2,
          y: y2
        }];
        var content = elem;
        var params;
        if (this.$isGradient()) {
          var _shapeUtil$getRotateI = shapeUtil.getRotateInfo({
              points: points
            }),
            rotatedPoints = _shapeUtil$getRotateI.rotatedPoints,
            group = _shapeUtil$getRotateI.group,
            transformParams = _shapeUtil$getRotateI.transformParams;
          if (rotatedPoints) {
            group.insertBefore(elem, group.firstChild);
            content = group;
            params = transformParams;
            points = rotatedPoints;
          }
        }
        this.$transformParams = params;
        elem.setAttribute('x1', points[0].x);
        elem.setAttribute('y1', points[0].y);
        elem.setAttribute('x2', points[1].x);
        elem.setAttribute('y2', points[1].y);
        if (this.$isCrisp()) {
          elem.classList.add('hxpx-crisp');
        }
        return content;
      }
    }, {
      key: "getShapeEl",
      value: function getShapeEl(element) {
        return element.querySelector('line');
      }

      /**
       * If this `Line` is flat and is using a simple pen, but not a gradient,
       * then use a `hxpx-crisp` for drawing the line which results in better display.
       * @private
       * @return {boolean}
       */
    }, {
      key: "$isCrisp",
      value: function $isCrisp() {
        var properties = this.properties(),
          geom = properties.getValue('geom'),
          pen = properties.getValue('pen'),
          brush = properties.getValue('stroke');
        var isGradient = brush && brush.isGradientBrush(),
          flat = isStraightLine(geom),
          simplePen = isSimplePen(pen);
        return flat && simplePen && !isGradient;
      }

      /**
       * Return true if the line has a gradient.
       * @private
       * @return {boolean}
       */
    }, {
      key: "$isGradient",
      value: function $isGradient() {
        var properties = this.properties(),
          brush = properties.getValue('stroke');
        return brush && brush.isGradientBrush();
      }

      /**
       * 
       * @inheritdoc
       */
    }, {
      key: "$makeHitLayer",
      value: function $makeHitLayer() {
        var properties = this.properties(),
          geom = properties.getValue('geom');
        var elem,
          x1 = geom.x1(),
          x2 = geom.x2(),
          y1 = geom.y1(),
          y2 = geom.y2();
        elem = document.createElementNS('http://www.w3.org/2000/svg', 'line');
        elem.setAttribute('x1', x1);
        elem.setAttribute('y1', y1);
        elem.setAttribute('x2', x2);
        elem.setAttribute('y2', y2);
        elem.setAttribute('stroke-width', 8);
        elem.classList.add('hxpx-mouseHandler');
        return elem;
      }
    }]);
  }(Shape);
  function isSimplePen(pen) {
    return pen && !pen.getDash().length && pen.getCap() !== Pen.CAP_ROUND;
  }
  function isStraightLine(geom) {
    return isHorizontalLine(geom) || isVerticalLine(geom);
  }
  function isHorizontalLine(geom) {
    return Math.abs(geom.y1() - geom.y2()) < 1;
  }
  function isVerticalLine(geom) {
    return Math.abs(geom.x1() - geom.x2()) < 1;
  }
});
