function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/* eslint-env browser */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/TransformPane
 * @since Niagara 4.12
 */
define(['baja!', 'baja!bajaui:TransformMode', 'bajaux/spandrel', 'nmodule/bajaui/rc/baja/binding/Binding', 'nmodule/bajaui/rc/ux/Button', 'nmodule/bajaui/rc/ux/Label', 'nmodule/bajaui/rc/ux/Picture', 'nmodule/bajaui/rc/ux/NullWidget', 'nmodule/webEditors/rc/fe/baja/util/typeUtils'], function (baja, types, spandrel, Binding, Button, Label, Picture, NullWidget, typeUtils) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'bajaui',
      keyName: 'TransformPane',
      properties: {
        rootCssClass: 'ux-TransformPane',
        transformMode: baja.$('bajaui:TransformMode', 'none')
      }
    };
  };
  var TRANSFORM_PROP = 'transformMode';
  var transformModeToCss = function transformModeToCss(mode) {
    var tag = mode.getTag();
    switch (tag) {
      case 'rotate90':
        return 'rotate(90deg)';
      case 'rotate180':
        return 'rotate(180deg)';
      case 'rotate270':
        return 'rotate(270deg)';
      case 'flip':
        return 'scale(1, -1)';
      case 'mirror':
        return 'scale(-1, 1)';
      default:
        return '';
    }
  };
  var isSideways = function isSideways(transformMode) {
    return transformMode.getTag() === 'rotate90' || transformMode.getTag() === 'rotate270';
  };
  var isAssignableFrom = typeUtils.isAssignableFrom;
  /**
   * @class
   * @alias module:nmodule/bajaui/rc/ux/TransformPane
   * @extends module:bajaux/Widget
   */
  var TransformPane = /*#__PURE__*/function (_spandrel) {
    function TransformPane(params) {
      _classCallCheck(this, TransformPane);
      return _callSuper(this, TransformPane, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }
    _inherits(TransformPane, _spandrel);
    return _createClass(TransformPane, [{
      key: "doChanged",
      value: function doChanged(name) {
        if (name === TRANSFORM_PROP) {
          return this.rerender();
        }
      }
    }, {
      key: "doLayout",
      value: function doLayout() {
        var transformMode = this.properties().getValue(TRANSFORM_PROP);
        var paneDiv = this.jq();
        var contentDiv = paneDiv.find(".-t-TransformPane-content").first();
        var paneWidth = paneDiv.width();
        var paneHeight = paneDiv.height();
        if (isSideways(transformMode)) {
          contentDiv.height(paneWidth);
          contentDiv.width(paneHeight);
        } else {
          contentDiv.height(paneHeight);
          contentDiv.width(paneWidth);
        }
      }

      /**
       * @private
       * @returns {module:bajaux/model/UxModel~UxModelParams} the default UxModel structure for a brand new TransformPane
       * @since Niagara 4.15
       */
    }, {
      key: "$uxModelDefaults",
      value: function $uxModelDefaults() {
        return {
          kids: [{
            name: 'content',
            type: NullWidget,
            metadata: {
              typeSpec: 'bajaui:Widget'
            }
          }]
        };
      }

      /**
       * Child of TransformPane must be of type Picture or Label or Button or TransformPane or Binding.
       *
       * @private
       * @since Niagara 4.15
       * @param {module:bajaux/model/UxModel} uxModel
       * @returns {boolean}
       */
    }, {
      key: "isChildLegal",
      value: function isChildLegal(uxModel) {
        var type = uxModel.getType();
        return isAssignableFrom(NullWidget, type) || isAssignableFrom(Picture, type) || isAssignableFrom(Label, type) || isAssignableFrom(Button, type) || isAssignableFrom(TransformPane, type);
      }
    }]);
  }(spandrel(function (model, _ref) {
    var properties = _ref.properties;
    var content = model.get('content');
    var transformMode = properties.transformMode;
    return spandrel.jsx("div", {
      className: "-t-TransformPane-wrapper",
      style: {
        transform: transformModeToCss(transformMode)
      }
    }, spandrel.jsx("div", {
      className: "-t-TransformPane-content",
      spandrelSrc: content
    }));
  }));
  return TransformPane;
});
