function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx UxModel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/TitlePane
 */

define(["baja!", "Promise", 'bajaux/spandrel', 'bajaux/Widget', 'bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'bajaux/model/UxModel', 'bajaux/util/CommandButton', 'bajaux/util/CommandButtonGroup', 'nmodule/webEditors/rc/fe/baja/IconEditor', 'nmodule/webEditors/rc/wb/commands/ContextMenuCommand'], function (baja, Promise, spandrel, Widget, Command, CommandGroup, UxModel, CommandButton, CommandButtonGroup, IconEditor, ContextMenuCommand) {
  'use strict';

  var TOOL_BAR = Command.flags.TOOL_BAR;
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'bajaui',
      keyName: 'TitlePane',
      properties: {
        //Using a non-standard root class to maintain compatibility with webEditors's TitlePane.js
        rootCssClass: "TitlePane"
      }
    };
  };

  /**
   * Spandrel friendly title pane
   *
   * @class
   * @alias module:nmodule/bajaui/rc/ux/TitlePane
   * @extends module:bajaux/Widget
   * @since Niagara 4.15
   */
  var TitlePane = /*#__PURE__*/function (_spandrel) {
    function TitlePane(params) {
      var _this;
      _classCallCheck(this, TitlePane);
      _this = _callSuper(this, TitlePane, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      if (_this.$canShowHideIcon()) {
        _this.$closeCommand = _this.$makeHideCommand();
        _this.$contextMenuCommand = new ContextMenuCommand({
          module: 'bajaui',
          lex: 'titlePane.contextMenuCommand',
          makeCommandGroup: function makeCommandGroup() {
            return new CommandGroup({
              commands: [_this.$closeCommand]
            });
          }
        });
      }
      return _this;
    }

    /**
     * @private
     * @returns {module:bajaux/commands/Command}
     */
    _inherits(TitlePane, _spandrel);
    return _createClass(TitlePane, [{
      key: "$makeHideCommand",
      value: function $makeHideCommand() {
        var _this2 = this;
        return new Command({
          module: 'bajaui',
          lex: 'titlePane.contextMenuCommand.hide',
          func: function func() {
            var hideTitlePane = _this2.properties().getValue('hideTitlePane');
            return hideTitlePane();
          }
        });
      }

      /**
       * Builds the title pane
       * @private
       * @param {Object} state the current state of the TitlePane
       * @returns {object}
       */
    }, {
      key: "$buildEditor",
      value: function $buildEditor(state) {
        var commandGroup = state.commandGroup,
          content = state.content,
          _state$displayName = state.displayName,
          displayName = _state$displayName === void 0 ? '' : _state$displayName,
          icon = state.icon,
          self = state.self;
        var haveIcon = !!(icon && icon !== baja.Icon.DEFAULT);
        var toolbar = true;

        // add user provided header commands.
        var headerCommands = this.properties().getValue('headerCommands');
        if (headerCommands) {
          commandGroup = commandGroup ? new CommandGroup({
            commands: commandGroup.getChildren()
          }) : new CommandGroup();
          headerCommands.forEach(function (cmd) {
            return commandGroup.add(cmd);
          });
        }
        return [UxModel.jsx("div", {
          spandrelKey: "titlePaneHeader",
          className: "header"
        }, UxModel.jsx("div", {
          spandrelKey: "headerContents",
          className: "header-contents"
        }, UxModel.jsx("div", {
          className: "tab tab-with-icon",
          spandrelKey: "titlePaneTab"
        }, this.$canShowHideIcon() && UxModel.jsx(CommandButton, {
          spandrelKey: "hideButton",
          className: "hide-button",
          value: this.$contextMenuCommand
        }), haveIcon && UxModel.jsx(IconEditor, {
          spandrelKey: "icon",
          className: "title-icon",
          value: icon
        }), UxModel.jsx("span", {
          className: "displayName"
        }, displayName)), UxModel.jsx("div", {
          className: "controls"
        }), UxModel.jsx("div", {
          className: "commands-outer"
        }, UxModel.jsx(CommandButtonGroup, {
          spandrelKey: "commandGrp",
          className: "commands",
          value: commandGroup,
          properties: {
            toolbar: toolbar
          }
        })))), UxModel.jsx("widget", {
          src: content,
          spandrelKey: "content",
          "class": "content",
          onUxLoad: function onUxLoad(e, ed) {
            return ed === self.$getContentWidget() && self.$setStateFromContent(ed);
          }
        })];
      }

      /**
       * Builds the state for the TitlePane
       * @param {module:bajaux/model/UxModel} uxModel
       * @returns {Object}
       */
    }, {
      key: "toState",
      value: function toState(uxModel) {
        var content = uxModel.get('content');
        var currState = this.state();
        var icon = currState.icon || baja.Icon.DEFAULT;
        var commandGroup = currState.commandGroup || new CommandGroup();
        var moduleName = this.properties().getValue('moduleName'),
          keyName = this.properties().getValue('keyName');

        // A hack to override the base Widget's moduleName and keyName
        // If these are provided as properties of the TitlePane then use it.   
        if (moduleName && keyName) {
          this.$moduleName = moduleName;
          this.$keyName = keyName;
        }
        return {
          commandGroup: commandGroup,
          content: content,
          icon: icon
        };
      }

      /**
       * Return the current value of the TitlePane
       * @param {Object} state
       * @returns {Object}
       */
    }, {
      key: "fromState",
      value: function fromState(state) {
        return state;
      }

      /**
       * Sets the state from the content widget
       * @private
       * @param {module:bajaux/Widget} content
       * @returns {Promise}
       */
    }, {
      key: "$setStateFromContent",
      value: function $setStateFromContent(content) {
        var _this3 = this;
        var moduleName = this.properties().getValue('moduleName'),
          keyName = this.properties().getValue('keyName');
        return Promise.all([this.buildCommandGroup(content), content.toDisplayName(), content.toIcon(), moduleName && keyName && this.toDisplayName(), moduleName && keyName && this.toIcon()]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 5),
            commandGroup = _ref2[0],
            contentDisplayName = _ref2[1],
            contentIcon = _ref2[2],
            displayName = _ref2[3],
            icon = _ref2[4];
          icon = baja.Icon.make(icon || contentIcon);
          displayName = displayName || contentDisplayName;
          _this3.state({
            commandGroup: commandGroup,
            displayName: displayName,
            icon: icon
          });
        });
      }

      /**
       * Override point to allow a TitlePane to configure exactly which commands are shown in its
       * header for a particular widget.  The default behavior is to show all the widget's commands
       * @param {module:bajaux/Widget} widget
       * @returns {Promise.<module:bajaux/commands/CommandGroup>}
       */
    }, {
      key: "buildCommandGroup",
      value: function buildCommandGroup(widget) {
        var commandGrp = widget.getCommandGroup();
        return Promise.resolve(new CommandGroup({
          commands: commandGrp ? commandGrp.getChildren().filter(function (cmd) {
            return cmd.hasFlags(TOOL_BAR);
          }) : []
        }));
      }

      /**
       * Returns the display name element
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getDisplayNameElement",
      value: function $getDisplayNameElement() {
        return this.jq().children('.header').find('.tab').children('.displayName');
      }

      /**
       * Returns the icon widget
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getIconWidget",
      value: function $getIconWidget() {
        return this.queryWidget('titlePaneHeader/**/icon');
      }

      /**
       * Returns the controls element
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getControlsElement",
      value: function $getControlsElement() {
        return this.jq().children('.header').find('.controls');
      }

      /**
       * Returns the command group element
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getCommandsElement",
      value: function $getCommandsElement() {
        return this.jq().children('.header').find('.commands');
      }

      /**
       * Returns the content element
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getContentElement",
      value: function $getContentElement() {
        return this.jq().children('.content');
      }

      /**
       * Returns the CommandButtonGroup
       * @private
       * @returns {module:bajaux/util/CommandButtonGroup}
       */
    }, {
      key: "$getCommandButtonGroup",
      value: function $getCommandButtonGroup() {
        return this.queryWidget('titlePaneHeader/**/commandGrp');
      }

      /**
       * @private
       * Returns the widget that holds the content of the TitlePane
       * @returns {module:bajaux/Widget|undefined}
       */
    }, {
      key: "$getContentWidget",
      value: function $getContentWidget() {
        var contentElement = this.$getContentElement();
        return Widget["in"](contentElement) || Widget["in"](contentElement.children('.bajaux-container').children('.bajaux-widget-container').children('.bajaux-widget'));
      }

      /**
       * @private
       * @returns {boolean}
       */
    }, {
      key: "$canShowHideIcon",
      value: function $canShowHideIcon() {
        return this.properties().getValue('hideTitlePane') instanceof Function;
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getHideCommandButton",
      value: function $getHideCommandButton() {
        return this.queryWidget('titlePaneHeader/**/hideButton');
      }
    }]);
  }(spandrel(function (value, state) {
    var self = state.self;
    return self.$buildEditor(state);
  }, {
    strategy: 'niagara'
  }));
  return TitlePane;
});
