function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx UxModel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/Terrace
 */

define(['baja!', 'baja!bajaui:Orientation', 'bajaux/model/UxModel', 'bajaux/spandrel', 'bajaux/Widget', 'Promise', 'underscore', 'nmodule/bajaui/rc/ux/SplitPane'], function (baja, types, UxModel, spandrel, Widget, Promise, _, SplitPane) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-Terrace',
        orientation: baja.$('bajaui:Orientation', 'vertical'),
        dividerWidth: 6
      }
    };
  };
  var DIVIDERS_MOVED_EVENT = 'Terrace:dividersMoved';
  var ORIGINAL_NAME = Symbol('originalName');
  var $MIN_BOTTOM_HEIGHT_SYMBOL = SplitPane.$MIN_BOTTOM_HEIGHT_SYMBOL;
  var SIDEBAR_MIN_HEIGHT_RATIO = '40';

  /**
   * @class
   * @alias module:nmodule/bajaui/rc/ux/Terrace
   * @extends module:bajaux/spandrel
   */
  return /*#__PURE__*/function (_spandrel) {
    function Terrace(params) {
      _classCallCheck(this, Terrace);
      return _callSuper(this, Terrace, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     * @private
     * @param {Array.<module:bajaux/model/UxModel>} kids
     * @param {String} name
     * @param {Object} params
     * @param {baja.Simple} params.orientation
     * @param {number} params.dividerWidgth
     * @param {Object.<String, SidebarState>} params.states
     * @returns {module:bajaux/spandrel~SpandrelData}
     */
    _inherits(Terrace, _spandrel);
    return _createClass(Terrace, [{
      key: "$buildTerrace",
      value: function $buildTerrace(kids, name, params) {
        var kidsLength = kids.length;
        if (kidsLength === 0) {
          return UxModel.jsx("wbr", null);
        }
        var _kids = _slicedToArray(kids, 1),
          kid = _kids[0];
        var kidsRemaining = kids.slice(1);
        var sidebarName = kid.getName();
        if (kidsLength === 1) {
          return UxModel.jsx("widget", {
            name: name || 'widget',
            src: kid,
            properties: _defineProperty({}, ORIGINAL_NAME, sidebarName)
          });
        }
        var self = this;
        var orientation = params.orientation,
          dividerWidth = params.dividerWidth,
          moveableDivider = params.moveableDivider,
          $ready = params.$ready;
        var visible = true;
        var offsetPercent = 100 / kidsLength;
        if (params.states && params.states[sidebarName]) {
          visible = params.states[sidebarName].visible;
          offsetPercent = params.states[sidebarName].offsetPercent;
        }
        return UxModel.jsx(SplitPane, {
          className: "-t-Terrace-splitPane",
          name: name || 'splitPane',
          lax: true // TODO: 65372
          ,
          properties: _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty({
            orientation: orientation,
            dividerWidth: dividerWidth,
            dividerPosition: offsetPercent
          }, ORIGINAL_NAME, sidebarName), "visible", visible), "moveableDivider", moveableDivider), "$ready", $ready), $MIN_BOTTOM_HEIGHT_SYMBOL, kidsRemaining.length * SIDEBAR_MIN_HEIGHT_RATIO + 'px'),
          onUxPropertyChanged: function onUxPropertyChanged(e, ed, name) {
            if (name === 'dividerPosition') {
              self.trigger(DIVIDERS_MOVED_EVENT, self.$getUserRatios());
            }
          }
        }, UxModel.jsx("widget", {
          name: "widget1",
          src: kid
        }), this.$buildTerrace(kidsRemaining, 'widget2', params));
      }

      /**
       * @private
       * @returns {Array.<module:bajaux/Widget|*>}
       */
    }, {
      key: "$getKidWidgets",
      value: function $getKidWidgets() {
        var splitPaneKidEls = this.jq().find('.-t-SplitPane-kid');
        return splitPaneKidEls.get().filter(function (splitPaneKidEl) {
          return !(Widget["in"](splitPaneKidEl) instanceof SplitPane);
        }).map(function (splitPaneKidEl) {
          return Widget["in"](splitPaneKidEl);
        });
      }

      /**
       * Finds the first instance of the specified widget via its id and returns it.
       * @param {Number|Function} id an id, filter function, or Widget constructor.  A filter function
       * receives a Widget instance and returns a boolean result - the first Widget passing the filter
       * will be returned.  If passing a Widget constructor, the first Widget that is an instance of
       * that constructor will be returned.
       * @returns {module:bajaux/Widget|null}
       */
    }, {
      key: "findChildWidget",
      value: function findChildWidget(id) {
        var kids = this.$getKidWidgets();
        var isFunction = typeof id === 'function';
        if (!isFunction) {
          return kids[id] || null;
        }
        var widget = null;
        if (id.prototype instanceof Widget) {
          var ctor = id;
          id = function id(kid) {
            return kid instanceof ctor;
          };
        }
        kids.forEach(function (kid) {
          if (id(kid) && !widget) {
            widget = kid;
          }
        });
        return widget;
      }

      /**
       * @returns {string}
       * @constructor
       */
    }, {
      key: "$getSplitPanes",
      value:
      /**
       * @private
       * @returns {Array.<module:bajaux/Widget>}
       */
      function $getSplitPanes() {
        return _toConsumableArray(this.jq().find('.ux-SplitPane')).map(Widget["in"]);
      }

      /**
       * Returns the states with updated absolute height percentages.
       *
       * @private
       * @returns {Object.<String, number>}
       */
    }, {
      key: "$getUserRatios",
      value: function $getUserRatios() {
        var ratios = this.$getSplitPanes().map(function (splitPane) {
          var props = splitPane.properties();
          return {
            name: props.getValue(ORIGINAL_NAME),
            dividerRatio: props.getValue('dividerPosition')
          };
        });
        var remainingRatio = 100;
        var userRatios = {};
        ratios.forEach(function (_ref3) {
          var name = _ref3.name,
            dividerRatio = _ref3.dividerRatio;
          var userRatio = dividerRatio * remainingRatio / 100;
          userRatios[name] = userRatio;
          remainingRatio -= userRatio;
        });
        var lastKid = _.last(this.$getKidWidgets());
        userRatios[lastKid.properties().getValue(ORIGINAL_NAME)] = remainingRatio;
        return userRatios;
      }
    }], [{
      key: "DIVIDERS_MOVED_EVENT",
      get: function get() {
        return DIVIDERS_MOVED_EVENT;
      }
    }]);
  }(spandrel(function (uxModel, _ref4) {
    var properties = _ref4.properties,
      self = _ref4.self;
    var orientation = properties.orientation,
      dividerWidth = properties.dividerWidth,
      _properties$states = properties.states,
      states = _properties$states === void 0 ? {} : _properties$states,
      moveableDivider = properties.moveableDivider,
      $ready = properties.$ready;
    var kids = uxModel.getKids();
    // Filter out hidden kids
    var visibleKids = kids.filter(function (kid) {
      var _kid$getProperties = kid.getProperties(),
        visible = _kid$getProperties.visible;
      if (visible === undefined) {
        return true;
      }
      return visible;
    });
    return Promise.all(visibleKids.map(function (kid) {
      return UxModel.make(kid);
    })).then(function (clones) {
      // TODO: cloning until NCCB-65641
      clones.forEach(function (clone, i) {
        clone.toSpandrel = visibleKids[i].toSpandrel;
        clone.$widgetPropertiesApplied = visibleKids[i].$widgetPropertiesApplied;
      });
      return self.$buildTerrace(clones, null, {
        orientation: orientation,
        dividerWidth: dividerWidth,
        states: states,
        moveableDivider: moveableDivider,
        $ready: $ready
      });
    });
  }));
});
