function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author JJ Frankovich
 */

/* global document */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/TabbedPane
 */
define(['baja!', 'baja!bajaui:Align,bajaui:DegradeBehavior,bajaui:Halign,bajaui:Valign', 'bajaux/spandrel', 'bajaux/Widget', 'bajaux/model/UxModel', 'bajaux/model/binding/BindingList', 'jquery', 'Promise', 'underscore', 'nmodule/bajaui/rc/baja/Border', 'nmodule/bajaui/rc/baja/binding/Binding', 'nmodule/bajaui/rc/binding/impl/widgetEvents', 'nmodule/bajaui/rc/ux/BorderPane', 'nmodule/bajaui/rc/ux/EdgePane', 'nmodule/bajaui/rc/ux/FlowPane', 'nmodule/bajaui/rc/ux/Label', 'nmodule/bajaui/rc/ux/LabelPane', 'nmodule/bajaui/rc/ux/NullWidget', 'nmodule/bajaui/rc/ux/TabbedPaneContent', 'nmodule/gx/rc/baja/Insets', 'css!nmodule/bajaui/rc/bajaui'], function (baja, types, spandrel, Widget, UxModel, BindingList, $, Promise, _, Border, Binding, widgetEvents, BorderPane, EdgePane, FlowPane, Label, LabelPane, NullWidget, TabbedPaneContent, Insets) {
  'use strict';

  var DISABLED_TAB_CLASS = 'ux-TabbedPane-tab-disabled';
  var SELECTED_TAB_CLASS = 'ux-TabbedPane-tab-selected';
  var UNSELECTED_TAB_CLASS = 'ux-TabbedPane-tab-unselected';
  var SELECTED_CONTENT_CLASS = '-t-TabbedPane-content-selected';
  var UNSELECTED_CONTENT_CLASS = '-t-TabbedPane-content-unselected';
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'bajaui',
      keyName: 'TabbedPane',
      properties: {
        rootCssClass: 'ux-TabbedPane',
        tabPlacement: baja.$('bajaui:Align', 'top'),
        showSingleTab: true,
        paintFullBorder: true
      }
    };
  };

  /**
   * bajaux implementation of `bajaui:TabbedPane`.
   *
   * @class
   * @alias module:nmodule/bajaui/rc/ux/TabbedPane
   * @extends {module:bajaux/Widget}
   */
  var TabbedPane = /*#__PURE__*/function (_spandrel) {
    function TabbedPane(params) {
      var _this;
      _classCallCheck(this, TabbedPane);
      _this = _callSuper(this, TabbedPane, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$selectedIndex = 0;
      return _this;
    }

    /**
     *
     * @private
     * @param {module:bajaux/model/UxModel} model
     * @param {Object} tabbedPaneProperties properties of the Tabbed Editor
     * @return {Array.<Object>}
     */
    _inherits(TabbedPane, _spandrel);
    return _createClass(TabbedPane, [{
      key: "$getKids",
      value: function $getKids(model, tabbedPaneProperties) {
        var tabPlacement = tabbedPaneProperties.tabPlacement,
          showSingleTab = tabbedPaneProperties.showSingleTab;
        var labelKids = this.$getLabelKids(model, tabPlacement);
        if (labelKids.length === 0) {
          return [];
        }

        //To match workbench, force no border when showSingleTab=false, paintFullBorder=true, and there is a single Tab.
        if (labelKids.length === 1 && !showSingleTab) {
          tabbedPaneProperties.paintFullBorder = false;
        }
        var contentWrapper = this.$getContentWrapper(model, tabbedPaneProperties);
        if (labelKids.length === 1 && !showSingleTab) {
          return [contentWrapper];
        }
        return [{
          name: getTabPlacementName(tabPlacement),
          type: FlowPane,
          kids: labelKids,
          properties: {
            rootCssClass: 'ux-TabbedPane-tabs ux-FlowPane',
            hgap: 0,
            vgap: 0,
            align: baja.$('bajaui:Halign', 'fill'),
            rowAlign: baja.$('bajaui:Valign', 'fill')
          }
        }, contentWrapper];
      }

      /**
       * @private
       * @param {module:bajaux/model/UxModel} model
       * @param {baja.FrozenEnum} tabPlacement
       * @return {Array.<Object>}
       */
    }, {
      key: "$getLabelKids",
      value: function $getLabelKids(model, tabPlacement) {
        var _this2 = this;
        var filteredKids = getFilteredKids(model);
        return _.map(filteredKids, function (kid, index) {
          var disabled = kid.getProperties().enabled === false;
          var showLabelPane = kid.getProperties().visible !== false;
          var model = kid.get('label');
          return _this2.$getLabelWrapper(model, index, disabled, showLabelPane, tabPlacement);
        });
      }

      /**
       * @private
       * @param {module:bajaux/model/UxModel} model
       * @return {Array.<Object>}
       */
    }, {
      key: "$getContentKids",
      value: function $getContentKids(model) {
        var _this3 = this;
        var filteredKids = getFilteredKids(model);
        return _.map(filteredKids, function (kid, index) {
          var model = kid.get('content');
          var contentModel = _this3.$getMainContentWrapper(model, index);
          contentModel.properties.visible = true;
          return contentModel;
        });
      }

      /**
       * @private
       * @param {module:bajaux/model/UxModel} [model]
       * @param {boolean} [forceVisible] forces the supplied model to be visible
       * @return {Object}
       */
    }, {
      key: "$getModelObject",
      value: function $getModelObject(model, forceVisible) {
        var properties = model && model.getProperties() || {};
        if (forceVisible) {
          properties.visible = true;
        }
        return {
          bindings: model && model.getBindingList().getBindings() || [],
          name: 'content',
          type: model && model.getType() || NullWidget,
          properties: properties,
          kids: model && model.getKids() || []
        };
      }

      /**
       * @private
       * @param {module:bajaux/model/UxModel} [model]
       * @param {Number} index
       * @return {Object}
       */
    }, {
      key: "$getMainContentWrapper",
      value: function $getMainContentWrapper(model, index) {
        var selectedClass = this.getSelectedIndex() === index ? SELECTED_CONTENT_CLASS : UNSELECTED_CONTENT_CLASS;
        var properties = {
          margin: Insets.make(0),
          padding: Insets.make(0),
          rootCssClass: 'ux-BorderPane ux-TabbedPane-content ' + selectedClass,
          tabIndex: index
        };
        return {
          properties: properties,
          name: 'content',
          type: BorderPane,
          kids: [this.$getModelObject(model, true)]
        };
      }

      /**
       * @private
       * @param {module:bajaux/model/UxModel} [model]
       * @param {Number} index
       * @param {boolean} disabledLabelPane
       * @param {boolean} showLabelPane
       * @param {baja.FrozenEnum} tabPlacement
       * @return {Object}
       */
    }, {
      key: "$getLabelWrapper",
      value: function $getLabelWrapper(model, index, disabledLabelPane, showLabelPane, tabPlacement) {
        var disabledClass = disabledLabelPane ? DISABLED_TAB_CLASS : '';
        var selectedClass = this.getSelectedIndex() === index ? SELECTED_TAB_CLASS : UNSELECTED_TAB_CLASS;
        var placementTag = tabPlacement.getTag();
        if (placementTag === 'center') {
          placementTag = 'top';
        }
        var properties = {
          margin: Insets.make(0),
          padding: Insets.make(0),
          rootCssClass: ['ux-BorderPane', 'ux-TabbedPane-tab', 'ux-TabbedPane-tab-' + placementTag, selectedClass, disabledClass].join(' '),
          visible: showLabelPane,
          tabIndex: index
        };
        return {
          properties: properties,
          name: 'label',
          type: BorderPane,
          bindings: [new TabSelectedBinding(index)],
          kids: [this.$getModelObject(model)]
        };
      }

      /**
       * @private
       * @param {module:bajaux/model/UxModel} model
       * @param {Object} tabbedPaneProperties properties of the Tabbed Editor
       * @return {Object}
       */
    }, {
      key: "$getContentWrapper",
      value: function $getContentWrapper(model, tabbedPaneProperties) {
        var paintFullBorder = tabbedPaneProperties.paintFullBorder;
        var properties = {
          border: Border.NULL,
          margin: Insets.make(0),
          padding: Insets.make(0),
          rootCssClass: 'ux-BorderPane ux-TabbedPane-content' + (paintFullBorder ? ' ux-TabbedPane-content-paintFullBorder' : '')
        };
        return {
          name: 'center',
          properties: properties,
          type: BorderPane,
          kids: [this.$getContent(model)]
        };
      }

      /**
       * @private
       * @param {module:bajaux/model/UxModel} model
       * @return {Object}
       */
    }, {
      key: "$getContent",
      value: function $getContent(model) {
        return {
          name: 'content',
          type: TabbedPaneContent,
          kids: this.$getContentKids(model)
        };
      }

      /**
       * @return {Number}
       */
    }, {
      key: "getSelectedIndex",
      value: function getSelectedIndex() {
        return this.$selectedIndex;
      }

      /**
       * Sets the selected index in the tabbed pane and shows it.
       * @param selectedIndex
       */
    }, {
      key: "setSelectedIndex",
      value: function setSelectedIndex(selectedIndex) {
        var thisDom = this.jq();

        //change labels
        var flow = thisDom.find(".-t-FlowPane-contents");
        var labels = flow.children();
        if (Array.from(labels[selectedIndex].classList).includes('bajaux-invisible')) {
          return;
        }
        _toConsumableArray(labels).forEach(function (elem, i) {
          var classList = elem.firstChild.classList;
          var selected = selectedIndex === i;
          classList.toggle(SELECTED_TAB_CLASS, selected);
          classList.toggle(UNSELECTED_TAB_CLASS, !selected);
        });

        //change content
        var selectedElem = null;
        var contentChildren = thisDom.find(".-t-TabbedPane-content").find(".-t-TabbedPane-content-wrapper").first().children(".-t-TabbedPane-content-child-content");
        _toConsumableArray(contentChildren).forEach(function (elem, i) {
          var classList = elem.classList;
          var selected = selectedIndex === i;
          classList.toggle(SELECTED_CONTENT_CLASS, selected);
          classList.toggle(UNSELECTED_CONTENT_CLASS, !selected);
          if (selected) {
            selectedElem = elem;
          }
        });
        this.$selectedIndex = selectedIndex;
        var widget = Widget["in"](selectedElem);
        if (widget) {
          //The visibility changes the widget's size so layout needs to be called on newly Visible widget once the
          //other content widgets is  hidden too and full space is available
          widget.layout()["catch"](baja.error);
        }
      }

      /**
       * when adding new kids to a TabbedPane, each one needs to be wrapped in a LabelPane with the
       * label pre-configured to the display name of the kid widget.
       * @private
       * @param {module:bajaux/model/UxModel} parentModel
       * @param {Array.<module:bajaux/model/UxModel>} kidModels
       * @param {module:nmodule/uxBuilder/rc/ux/model/UxBuilderEditContext} cx
       * @returns {Promise.<Array.<module:bajaux/model/UxModel>>}
       */
    }, {
      key: "$newKids",
      value: function $newKids(parentModel, kidModels, cx) {
        var uniqueNames = cx.getUniqueNames(parentModel, kidModels.map(function (m) {
          return 'LabelPane';
        }));
        return Promise.all(kidModels.map(function (kidModel, i) {
          return wrappedInLabelPane(kidModel, uniqueNames[i], cx);
        }));
      }
    }]);
  }(spandrel(function (model, _ref) {
    var properties = _ref.properties,
      rootElement = _ref.rootElement;
    var div = document.createElement('div');
    var selectedIndex = this.$selectedIndex;
    div.classList.add('-t-TabbedPane-content');
    rootElement.classList.add("ux-TabbedPane");
    var filteredKids = getFilteredKids(model);
    var selectedKid = filteredKids[selectedIndex];
    if (selectedKid) {
      var disabled = selectedKid.getProperties().enabled === false;
      var hidden = selectedKid.getProperties().visible === false;
      if (disabled || hidden) {
        var bestSelectedIndex = getBestSelectedIndex(selectedIndex, filteredKids);
        if (bestSelectedIndex === -1) {
          return document.createElement('wbr');
        }
        if (bestSelectedIndex !== selectedIndex) {
          this.$selectedIndex = bestSelectedIndex;
        }
      }
    }
    var kids = this.$getKids(model, properties);
    var modelParams = {
      name: model.getName(),
      type: EdgePane,
      kids: kids
    };
    return UxModel.make(modelParams).then(function (model) {
      return [model.toSpandrel(div)];
    });
  }));
  /**
   * @param {module:bajaux/model/UxModel} kidModel
   * @param {string} name
   * @param {module:nmodule/uxBuilder/rc/ux/model/UxBuilderEditContext} cx
   * @returns {Promise<module:bajaux/model/UxModel>}
   */
  function wrappedInLabelPane(kidModel, name, cx) {
    if (kidModel.$represents(LabelPane)) {
      return Promise.resolve(kidModel);
    }
    return Promise.all([cx.toWidgetDisplayName(kidModel), kidModel.clone({
      name: 'content'
    })]).then(function (_ref2) {
      var _ref3 = _slicedToArray(_ref2, 2),
        displayName = _ref3[0],
        content = _ref3[1];
      return UxModel.make({
        name: name,
        type: LabelPane,
        metadata: {
          pxDataTypeSpec: 'bajaui:LabelPane'
        },
        kids: [{
          name: 'label',
          type: Label,
          metadata: {
            pxDataTypeSpec: 'bajaui:Label'
          },
          properties: {
            text: displayName
          }
        }, content]
      });
    });
  }

  /**
   * @private
   * @inner
   * @param {baja.FrozenEnum} tabPlacement
   * @returns {string} EdgePane cell name for location of Labels
   */
  function getTabPlacementName(tabPlacement) {
    return tabPlacement.getTag() === 'center' ? 'top' : tabPlacement.getTag();
  }

  /**
   * @private
   * @class
   * @extends module:nmodule/bajaui/rc/baja/binding/Binding
   * @memberOf module:nmodule/bajaui/rc/ux/TabbedPane
   * @param {Number} index
   */
  var TabSelectedBinding = /*#__PURE__*/function (_Binding) {
    function TabSelectedBinding(index) {
      var _this4;
      _classCallCheck(this, TabSelectedBinding);
      _this4 = _callSuper(this, TabSelectedBinding);
      _this4.$index = index;

      //Workaround for https://acsjira.honeywell.com/browse/NCCB-47402
      _this4.add({
        slot: 'ord',
        value: baja.Ord.DEFAULT
      });
      _this4.add({
        slot: 'degradeBehavior',
        value: baja.$('bajaui:DegradeBehavior')
      });
      return _this4;
    }

    /**
     *
     * Add event listeners for the widget:
     * - on click, change the tab, even if there is a ValueBinding which would normally consume the click behavior.
     * This is why the addEventListener with useCapture=true is used.
     *
     * @param {module:bajaux/Widget} widget
     */
    _inherits(TabSelectedBinding, _Binding);
    return _createClass(TabSelectedBinding, [{
      key: "addListeners",
      value: function addListeners(widget) {
        var _this5 = this;
        if (widget.isInitialized()) {
          this.$arm(widget);
        } else {
          widget.on('initialized', function () {
            _this5.$arm(widget);
          });
        }
      }

      /**
       * @private
       * @param {module:bajaux/Widget} widget
       */
    }, {
      key: "$arm",
      value: function $arm(widget) {
        var _this6 = this;
        this.$eventListener = function (event) {
          var targetDom = $(event.currentTarget);
          if (targetDom.hasClass(DISABLED_TAB_CLASS) || targetDom.hasClass(SELECTED_TAB_CLASS)) {
            return;
          }
          var tabbedPane = getTabbedPane(targetDom);
          return tabbedPane.setSelectedIndex(_this6.$index);
        };
        getDom(widget).addEventListener('mousedown', this.$eventListener, true);
        widget.on('destroyed', function () {
          getDom(widget).removeEventListener('mousedown', _this6.$eventListener, true);
        });
      }
    }]);
  }(Binding);
  /**
   * @private
   * @inner
   * @param {JQuery} jq An element that is inside a TabbedPane
   * @return {module:nmodule/bajaui/rc/ux/TabbedPane}
   */
  function getTabbedPane(jq) {
    return Widget["in"](jq.closest(".ux-TabbedPane"));
  }

  /**
   *
   * @private
   * @inner
   * @param {module:bajaux/Widget} widget
   * @return {HTMLElement}
   */
  function getDom(widget) {
    return widget.jq()[0];
  }

  /**
   * Filters out the kid named 'tabControl' if it is present.
   * @private
   * @inner
   * @param {module:bajaux/model/UxModel} model
   * @return {Array.<module:bajaux/model/UxModel>}
   */
  function getFilteredKids(model) {
    return _.filter(model.getKids(), function (kid) {
      return kid.getName() !== 'tabControl';
    });
  }

  /**
   * Return the first enabled  and visible tab, or if no tabs are enabled, return the current selection as a fallback.
   * @private
   * @inner
    * @param {Number} selectedIndex
   * @param {Array.<module:bajaux/model/UxModel>} kids
   * @return {number}
   */
  function getBestSelectedIndex(selectedIndex, kids) {
    var visibleIndex = -1;
    for (var i = 0; i < kids.length; i++) {
      var _kids$i$getProperties = kids[i].getProperties(),
        enabled = _kids$i$getProperties.enabled,
        visible = _kids$i$getProperties.visible;
      if (enabled !== false && visible !== false) {
        return i;
      }
      if (visible !== false) {
        visibleIndex = i;
      }
    }
    if (visibleIndex !== -1) {
      return selectedIndex;
    } else {
      return visibleIndex;
    }
  }
  return TabbedPane;
});
