function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/* eslint-env browser */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/SplitPane
 */
define(['baja!', 'baja!bajaui:Orientation', 'log!nmodule.bajaui.rc.ux.SplitPane', 'bajaux/spandrel', 'bajaux/spandrel/logging', 'bajaux/Widget', 'jquery', 'underscore', 'nmodule/bajaui/rc/ux/NullWidget', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/js/rc/jquery/split-pane/split-pane', 'css!nmodule/bajaui/rc/bajaui', 'css!nmodule/js/rc/jquery/split-pane/split-pane'], function (baja, types, log, spandrel, logging, Widget, $, _, NullWidget, asyncUtils) {
  'use strict';

  var MIN_BOTTOM_HEIGHT_SYMBOL = Symbol('minBottomHeight');
  var throttle = _.throttle;
  var waitForTrue = asyncUtils.waitForTrue;
  var devMode = false;
  var debugEnabled = devMode || log.isLoggable('FINEST');
  var logFinest = devMode ? function (msg) {
    return console.log(msg);
  } : log.finest.bind(log);
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'bajaui',
      keyName: 'SplitPane',
      properties: {
        rootCssClass: 'ux-SplitPane',
        dividerWidth: {
          value: 6,
          metadata: {
            min: 0
          }
        },
        moveableDivider: true,
        dividerPosition: {
          value: 50,
          metadata: {
            min: 0,
            max: 100
          }
        },
        orientation: baja.$("bajaui:Orientation", "horizontal"),
        continuousLayout: true
      }
    };
  };

  // split-pane fires a fake window.resize after 100ms
  var FAKE_WINDOW_RESIZE_TIMEOUT = 100;
  var LAYOUT_FPS = 30;

  /**
   * @class
   * @alias module:nmodule/bajaui/rc/ux/SplitPane
   * @extends module:bajaux/Widget
   */
  var SplitPane = /*#__PURE__*/function (_spandrel) {
    function SplitPane(params) {
      var _this;
      _classCallCheck(this, SplitPane);
      _this = _callSuper(this, SplitPane, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$eventsToIgnore = 0;
      _this.$dividerRatio = _this.$configuredDividerPosition();

      // event handling calls this - throttled function separated out so it can be synchronously tested
      _this.$updateDividerPositionProperty = throttle(function () {
        _this.$doUpdateDividerPositionProperty();
      }, 1000 / LAYOUT_FPS, {
        leading: false
      });
      _this.$name = _this.generateId();
      return _this;
    }

    /**
     * @returns {symbol}
     */
    _inherits(SplitPane, _spandrel);
    return _createClass(SplitPane, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        return _superPropGet(SplitPane, "doInitialize", this, 3)(arguments);
      }

      /**
       * When a property changes, a spandrel widget will trigger a re-render and
       * re-layout - so we can sock away values for use on the next layout.
       */
    }, {
      key: "doChanged",
      value: function doChanged(name, value) {
        if (name === 'dividerPosition') {
          this.$dividerRatio = value / 100;
        }
        return _superPropGet(SplitPane, "doChanged", this, 3)([name, value]);
      }
    }, {
      key: "doLayout",
      value: function doLayout() {
        var el = this.jq()[0];
        if (!(el && document.contains(el))) {
          // split-pane relies on client dimension calculations that do not work when the element is detached
          return;
        }
        if (!this.$spInstalled) {
          this.$initSplitPane();
          this.$spInstalled = true;
        }
        this.$moveDivider(this.$dividerRatio);
      }

      /**
       * if the fake window.resize event comes along after the SplitPane is already destroyed, it can
       * throw an error that the unit tests can't recover from. give it a chance to process through
       * before we wipe the dom.
       * @returns {Promise}
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        var _this2 = this;
        return waitForTrue(function () {
          return !_this2.$eventsToIgnore;
        }, FAKE_WINDOW_RESIZE_TIMEOUT)["catch"](function (ignore) {}).then(function () {
          return _superPropGet(SplitPane, "doDestroy", _this2, 3)([]);
        });
      }

      /**
       * @private
       * @returns {module:bajaux/model/UxModel~UxModelParams} the default UxModel structure for a brand new SplitPane
       * @since Niagara 4.15
       */
    }, {
      key: "$uxModelDefaults",
      value: function $uxModelDefaults() {
        return {
          kids: ['widget1', 'widget2'].map(function (name) {
            return {
              name: name,
              type: NullWidget,
              metadata: {
                typeSpec: 'bajaui:Widget'
              }
            };
          })
        };
      }

      /**
       * @private
       * @param {number} percent where to move the divider to, as percent ([0-1])
       */
    }, {
      key: "$moveDivider",
      value: function $moveDivider(percent) {
        var splitPaneJq = this.$getSplitPaneJq();
        splitPaneJq.children().css(this.$isHorizontalLayout() ? 'height' : 'width', '');
        debugEnabled && this.$logIncrement('#$moveDivider: moving divider');
        this.$ignoreNextResizeEvent();
        splitPaneJq.splitPane('firstComponentSize', this.$getSize() * percent - this.$getDividerWidth() / 2);
        debugEnabled && debug(this, '#$moveDivider: finished moving divider (now ' + this.$eventsToIgnore + ')');
      }

      /**
       * apply the position of the divider bar on screen back to the dividerPosition bajaux Property
       * @private
       */
    }, {
      key: "$doUpdateDividerPositionProperty",
      value: function $doUpdateDividerPositionProperty() {
        if (!this.isInitialized()) {
          return;
        }
        var dividerRatio = this.$dividerRatio = this.$getScreenDividerRatio();
        this.properties().setValue('dividerPosition', dividerRatio * 100);
      }

      /**
       * @private
       * @returns {boolean} if the SplitPane is currently in horizontal layout
       * (widgets on left and right of divider). This must query the DOM because
       * it's used for layout calculations and may be called out of sync with the
       * widget's current Properties.
       */
    }, {
      key: "$isHorizontalLayout",
      value: function $isHorizontalLayout() {
        return this.$getSplitPaneJq().hasClass('vertical-percent');
      }

      /**
       * @private
       * @returns {number} divider position as configured on the widget, as
       * percent ([0-1])
       */
    }, {
      key: "$configuredDividerPosition",
      value: function $configuredDividerPosition() {
        return this.properties().getValue('dividerPosition') / 100;
      }

      /**
       * @private
       * @returns {number} divider position as currently placed by the user, as
       * percent ([0-1])
       */
    }, {
      key: "$getScreenDividerRatio",
      value: function $getScreenDividerRatio() {
        var divider = this.$getSplitPaneJq().children('.-t-SplitPane-divider')[0];
        var size = this.$getSize();
        if (!divider || !size) {
          // no value loaded yet, so DOM has not been built yet, which means there is no slider for
          // the user to move. default to the position configured via widget properties.
          // as of NCCB-56408, this should no longer happen.
          return this.$configuredDividerPosition();
        }
        var dividerPosition = this.$isHorizontalLayout() ? divider.offsetLeft : divider.offsetTop;
        var dividerMidpoint = dividerPosition + this.$getDividerWidth() / 2;
        return dividerMidpoint / this.$getSize();
      }

      /**
       * @private
       * @returns {number} configured divider width in pixels
       */
    }, {
      key: "$getDividerWidth",
      value: function $getDividerWidth() {
        return this.properties().getValue('dividerWidth');
      }

      /**
       * @private
       * @returns {number} current width or height of the SplitPane (depending on
       * whether it is in horizontal or vertical layout), in pixels
       */
    }, {
      key: "$getSize",
      value: function $getSize() {
        var splitPaneJq = this.$getSplitPaneJq();
        return this.$isHorizontalLayout() ? splitPaneJq.width() : splitPaneJq.height();
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getSplitPaneJq",
      value: function $getSplitPaneJq() {
        return this.jq().children(".-t-SplitPane-inner");
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getWidget1",
      value: function $getWidget1() {
        return this.queryWidget('wrapper/pane1/widget');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getWidget2",
      value: function $getWidget2() {
        return this.queryWidget('wrapper/pane2/widget');
      }

      //region splitpaneresize event wrangling

      /**
       * initialize the convoluted logic to contend with the way that split-pane.js works. hopefully
       * this is now implemented perfectly and no one will ever need to come back here not ever.
       *
       * the splitpaneresize event is supposed to indicate when the user moves the divider. we need
       * to listen for this so we can update the dividerPosition property. but doing this fires a
       * PROPERTY_CHANGED event, and we need to be sure that listeners for a "user moved divider"
       * event only fire when the user actually moves the divider.
       *
       * split-pane fires a *lot* of fake splitpaneresize events that, on the face of them, are
       * indistinguishable from user-fired events. (search split-pane.js for .trigger() calls.) but by
       * analyzing the way split-pane works, we can predict how many fake events will be triggered,
       * and ignore them so that we only capture user-initiated events.
       *
       * (note the difference between split-pane, the jQuery library, and SplitPane, this bajaux
       * widget.)
       *
       * every split-pane responds to an event in the "resize" category in one of two ways:
       *
       * 1. window.resize
       *   - every split-pane triggers a fake window.resize event ~100ms after it is initialized.
       *   - window.resize itself is only listened for if you are a top-level split-pane, with no
       *     split-pane elements between you and the document
       *   - on a top-level split-pane, window.resize will cause it to fire a splitpaneresize event.
       *   - the window.resize listener is never removed, so initializing a new split-pane will
       *     re-fire it on *all* existing split-panes.
       *
       * 2. splitpaneresize
       *   - split-panes listen for splitpaneresize events on their *direct parents*. this means that
       *     only kids and their kids listen for splitpaneresize - top-level split-panes do not.
       *   - splitpaneresize is triggered in the following scenarios:
       *     - after the window.resize on a top-level split-pane
       *     - after the divider moves, either by a user drag or by a manual call (e.g.
       *       calling .splitPane('firstComponentSize'))
       *     - after a splitpaneresize event is triggered on your parent split-pane. this means that
       *       splitpaneresize events cascade *downwards* instead of bubbling upwards like normal
       *       events. this is what got me spun. if widget1 and widget2 are both SplitPanes they'll
       *       both get splitpaneresize from their parent.
       *
       * if your split-panes look like this the fake events look like this:
       *
       * <!--
       *   after Parent initializes, his fake window.resize triggers a splitpaneresize event on
       *   Parent.
       * -->
       * <SplitPane id="Parent">
       *   <!--
       *     after Kid initializes, his fake window.resize causes Parent to trigger another
       *     splitpaneresize on Parent.
       *     Parent's splitpaneresize then causes Kid to trigger his own splitpaneresize.
       *   -->
       *   <SplitPane id="Kid" name="widget1">
       *     <!--
       *       after Grandkid initializes, his fake window.resize causes Parent to trigger a third
       *       splitpaneresize. this triggers another one on Kid, which triggers one on Grandkid.
       *     -->
       *     <SplitPane id="Grandkid" name="widget1" />
       *   </SplitPane>
       * </SplitPane>
       *
       * in short, this is a mess and here be dragons.
       *
       * @private
       */
    }, {
      key: "$initSplitPane",
      value: function $initSplitPane() {
        var _this3 = this;
        var isTopLevel = !this.jq().closest('.split-pane').length;
        if (isTopLevel) {
          this.$isTopLevel = true;
        }
        debugEnabled && debug(this, '#$initSplitPane: isTopLevel ' + isTopLevel);
        this.$warnOtherSplitPanes();
        debugEnabled && this.$logIncrement('#$initSplitPane: waiting on fake window resize');
        this.$ignoreNextResizeEvent();
        this.$getSplitPaneJq().splitPane();
        this.jq().on('splitpaneresize', function (e) {
          if (_this3.$eventsToIgnore) {
            _this3.$eventsToIgnore--;
            debugEnabled && _this3.$logDecrement('splitpaneresize: decrementing and bailing');
            return false;
          }
          var $ready = _this3.properties().getValue('$ready');
          if ($ready && !$ready(_this3)) {
            debugEnabled && debug(_this3, 'splitpaneresize: not ready');
            return false;
          }
          debugEnabled && debug(_this3, 'splitpaneresize: no fake events left to ignore, updating divider position');
          _this3.$updateDividerPositionProperty();
          return false;
        });
      }

      /**
       * @private
       */
    }, {
      key: "$ignoreNextResizeEvent",
      value: function $ignoreNextResizeEvent() {
        this.$eventsToIgnore++;
      }

      /**
       * @private
       */
    }, {
      key: "$warnOtherSplitPanes",
      value: function $warnOtherSplitPanes() {
        var _this4 = this;
        // note: this is one of the *extremely few* circumstances where an unscoped jQuery search is called for.
        var allSplitPanesEverywhere = _toConsumableArray($('.ux-SplitPane')).map(Widget["in"]);
        allSplitPanesEverywhere.forEach(function (splitPane) {
          if (splitPane !== _this4 && splitPane.$isTopLevel) {
            debugEnabled && splitPane.$logIncrement('I am top-level and will propagate fake ' + 'window.resize event into my whole tree from new SplitPane ' + _this4.$getDebugName());
            warnEveryoneInWholeTree(splitPane, _this4);
          }
        });
      }

      /**
       * @private
       * @param {string} msg
       */
    }, {
      key: "$logIncrement",
      value: function $logIncrement(msg) {
        if (debugEnabled) {
          var count = this.$eventsToIgnore;
          return debug(this, msg + ' (' + count + ' -> ' + (count + 1) + ')');
        }
      }

      /**
       * @private
       * @param {string} msg
       */
    }, {
      key: "$logDecrement",
      value: function $logDecrement(msg) {
        if (debugEnabled) {
          var count = this.$eventsToIgnore;
          return debug(this, msg + ' (' + (count + 1) + ' -> ' + count + ')');
        }
      }

      /**
       * @private
       * @returns {string} purely for debugging this logic in unit tests
       */
    }, {
      key: "$getDebugName",
      value: function $getDebugName() {
        var id = this.jq().attr('id');
        return id ? 'id=' + id : logging.widgetName(this);
      }

      //endregion splitpaneresize event wrangling
    }], [{
      key: "$MIN_BOTTOM_HEIGHT_SYMBOL",
      get: function get() {
        return MIN_BOTTOM_HEIGHT_SYMBOL;
      }
    }]);
  }(spandrel(function (model, _ref) {
    var properties = _ref.properties,
      self = _ref.self;
    var orientation = properties.orientation,
      dividerWidth = properties.dividerWidth,
      moveableDivider = properties.moveableDivider,
      isHorizontal = orientation.getTag() === "horizontal",
      orientationClass = isHorizontal ? "vertical-percent" : "horizontal-percent",
      splitPaneClasses = "-t-SplitPane-inner split-pane ".concat(orientationClass),
      widget1 = model.get('widget1'),
      widget2 = model.get('widget2'),
      minBottomHeight = widget2 ? self.properties().getValue(MIN_BOTTOM_HEIGHT_SYMBOL) : '0px',
      moveableDividerClass = moveableDivider ? "" : "-t-SplitPane-divider-not-moveable";
    return spandrel.jsx("div", {
      spandrelKey: "wrapper",
      className: splitPaneClasses
    }, spandrel.jsx("div", {
      spandrelKey: "pane1",
      className: "split-pane-component",
      style: _defineProperty({}, isHorizontal ? 'marginRight' : 'marginBottom', "".concat(dividerWidth, "px"))
    }, widget1 && spandrel.jsx("div", {
      className: "-t-SplitPane-kid -t-SplitPane-widget1",
      spandrelKey: "widget",
      spandrelSrc: widget1
    })), spandrel.jsx("div", {
      spandrelKey: "divider",
      className: "split-pane-divider -t-SplitPane-divider ".concat(moveableDividerClass),
      style: _defineProperty({}, isHorizontal ? 'width' : 'height', "".concat(dividerWidth, "px"))
    }), spandrel.jsx("div", {
      spandrelKey: "pane2",
      className: "split-pane-component",
      style: {
        minHeight: minBottomHeight
      }
    }, widget2 && spandrel.jsx("div", {
      className: "-t-SplitPane-kid -t-SplitPane-widget2",
      spandrelKey: "widget",
      spandrelSrc: widget2
    })));
  }));
  function debug(splitPane, msg) {
    return logFinest(splitPane.$getDebugName() + ': ' + msg);
  }

  /**
   * Every split-pane triggers a window.resize which will cause every top-level split-pane in the
   * whole page to propagate a fake splitpaneresize through their whole tree of nested panes.
   *
   * @param {module:nmodule/bajaui/rc/ux/SplitPane} splitPane
   */
  function warnEveryoneInWholeTree(splitPane) {
    if (splitPane instanceof SplitPane && splitPane.$spInstalled) {
      debugEnabled && splitPane.$logIncrement('I have split-pane initialized and will receive a fake event');
      splitPane.$ignoreNextResizeEvent();
      warnEveryoneInWholeTree(splitPane.$getWidget1());
      warnEveryoneInWholeTree(splitPane.$getWidget2());
    }
  }
  return SplitPane;
});
