function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/** @jsx spandrel.jsx */
/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/Slider
 */
define(['baja!', 'bajaux/spandrel', 'Promise', 'nmodule/bajaui/rc/binding/impl/widgetEvents', 'nmodule/bajaui/rc/ux/bajauiEvents', 'nmodule/webEditors/rc/fe/ToolTip', 'baja!bajaui:Orientation,gx:Brush'], function (baja, spandrel, Promise, widgetEvents, bajauiEvents, ToolTip, types) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-Slider',
        enabled: true,
        increment: 1,
        max: 100,
        min: 0,
        orientation: baja.$('bajaui:Orientation', 'horizontal'),
        thumbBrush: baja.$('gx:Brush', 'null'),
        trackBrush: baja.$('gx:Brush', 'null'),
        value: 50,
        visible: true
      }
    };
  };

  /**
   * @class
   * @alias module:nmodule/bajaui/rc/ux/Slider
   * @extends {module:bajaux/Widget}
   */
  return /*#__PURE__*/function (_spandrel) {
    function Slider(params) {
      var _this;
      _classCallCheck(this, Slider);
      _this = _callSuper(this, Slider, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$inputId = _this.generateId();
      _this.$wrapperId = _this.generateId();
      return _this;
    }
    _inherits(Slider, _spandrel);
    return _createClass(Slider, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;
        var setDisplay;
        widgetEvents(this, {
          change: function change(e) {
            _this2.properties().setValue('value', parseFloat(_this2.$getSlider().jq().val(), 10));
            _this2.emit(bajauiEvents.ACTION_PERFORMED_EVENT, e && e.type);
            return Promise.resolve();
          },
          mousedown: function mousedown(e) {
            var onCancel = function onCancel(reason) {
              if (reason === "multitouch") {
                _this2.$setInputDisabled(true);
                _this2.$setInputValue(_this2.properties().getValue('value'));
              }
            };
            var obj = ToolTip.create({
              initiatingEvent: e,
              value: _this2.properties().getValue('value'),
              onCancel: onCancel,
              cancelEvents: 'mouseup',
              fixedPosition: false
            });
            setDisplay = obj && obj.setDisplay;
          },
          input: function input() {
            var value = _this2.$getSlider().jq().val();
            setDisplay && setDisplay(value);
          },
          mouseup: function mouseup() {
            var enabled = _this2.properties().getValue('enabled');
            if (enabled) {
              _this2.$setInputDisabled(false);
            }
          }
        });
      }
    }, {
      key: "doLayout",
      value: function doLayout() {
        this.$applyStyles();
      }

      /**
       * 
       * @private
       */
    }, {
      key: "$getSlider",
      value: function $getSlider() {
        return this.queryWidget('wrapper/slider');
      }

      /**
       * @private
       * @param {boolean} disabled
       */
    }, {
      key: "$setInputDisabled",
      value: function $setInputDisabled(disabled) {
        this.$getSlider().jq().prop('disabled', disabled);
      }

      /**
       * @private
       */
    }, {
      key: "$setInputValue",
      value: function $setInputValue(value) {
        this.$getSlider().jq().val(value);
      }

      /**
       * HTML input of type range can be styled only via pseudo-elements.
       * To dynamically style the slider track and thumb, we add an inline 
       * style to each slider.
       * WebKit-based browsers and Firefox are supported.
       * 
       * @private
       */
    }, {
      key: "$applyStyles",
      value: function $applyStyles() {
        var slider = this.$getSlider(),
          sliderContainer = this.jq(),
          props = this.properties(),
          trackBrush = props.getValue('trackBrush'),
          thumbBrush = props.getValue('thumbBrush'),
          orientation = props.getValue('orientation'),
          isSliderVertical = isVertical(orientation.getTag()),
          layout = props.getValue('layout'),
          height = sliderContainer && sliderContainer.innerHeight(),
          width = sliderContainer && sliderContainer.innerWidth(),
          inputId = this.$inputId,
          wrapperId = this.$wrapperId;
        if (slider && layout && sliderContainer) {
          var thumbStyle = getThumbStyle(width, height, thumbBrush, isSliderVertical);
          var trackStyle = getTrackStyle(width, height, trackBrush, isSliderVertical);
          var style = document.createElement('style');
          style.innerHTML = "\n          #".concat(wrapperId, " {\n            width: ").concat(width, "px;\n            height: ").concat(height, "px;\n          }\n          #").concat(inputId, " {\n            ").concat(isSliderVertical ? "width: ".concat(height, "px;\n            height: ").concat(width, "px;\n            transform-origin: left top;\n            transform: rotate(-90deg) translate(").concat(-1 * height, "px, 0);") : "\n            width: ".concat(width, "px;\n            height: ").concat(height, "px;"), "\n          }\n          #").concat(inputId, "::-webkit-slider-thumb {\n            ").concat(thumbStyle, "\n            transform: translate(0, ").concat(-1 * (getTrackWidth() + 1 /** 1px added to fix overflow */), "px);\n          }\n          #").concat(inputId, "::-webkit-slider-runnable-track {\n            ").concat(trackStyle, "\n          }\n          #").concat(inputId, "::-moz-range-thumb {\n            ").concat(thumbStyle, "\n            transform: translate(0, 0);\n          }\n          #").concat(inputId, "::-moz-range-track {\n            ").concat(trackStyle, "\n          }\n        ");
          var inputStyle = sliderContainer.find('style');
          if (inputStyle.length > 0) {
            sliderContainer[0].removeChild(inputStyle[0]);
          }
          sliderContainer[0].appendChild(style);
        }
      }
    }]);
  }(spandrel(function (model, _ref) {
    var properties = _ref.properties,
      rootElement = _ref.rootElement;
    var enabled = properties.enabled,
      increment = properties.increment,
      max = properties.max,
      min = properties.min,
      value = properties.value,
      orientation = properties.orientation;
    var classList = rootElement.classList;
    classList.add('-t-Slider-orientation-' + orientation.getTag());
    return spandrel.jsx("div", {
      "class": "-t-slider-wrapper",
      spandrelKey: "wrapper",
      id: this.$wrapperId
    }, spandrel.jsx("input", {
      type: "range",
      id: this.$inputId,
      disabled: !enabled,
      min: min,
      max: max,
      step: increment,
      value: value,
      spandrelKey: "slider"
    }));
  }));
  function isVertical(orientationTag) {
    return orientationTag === 'vertical';
  }
  function getTrackStyle(width, height, trackBrush, isSliderVertical) {
    var containerWidth = isSliderVertical ? width : height,
      trackWidth = getTrackWidth(),
      // Calculates the position of the track inside the containing div
      trackOffset = (containerWidth - trackWidth) / 2 - trackWidth;
    return "".concat(!trackBrush.isNull() ? "background: ".concat(trackBrush.toString(), ";") : "", "\n      transform: translate(0, ").concat(-1 * Math.floor(trackOffset), "px);");
  }
  function getThumbStyle(width, height, thumbBrush, isSliderVertical) {
    // reduce the height by 1px to adjust for thumb overflow wrt the containing div
    return "".concat(isSliderVertical ? "height: ".concat(width - 1, "px;\n       cursor: ns-resize;") : "height: ".concat(height - 1, "px;\n       cursor: ew-resize;"), "\n      width: 12px;\n      ").concat(!thumbBrush.isNull() ? "background: ".concat(thumbBrush.toString(), ";") : "");
  }
  function getTrackWidth() {
    return 5;
  }
});
