function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/** @jsx UxModel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/ScrollPane
 */
define(['baja!', 'baja!bajaui:ScrollBarPolicy,gx:Brush', 'bajaux/spandrel', 'bajaux/model/UxModel', 'underscore', 'nmodule/bajaui/rc/ux/NullWidget'], function (baja, types, spandrel, UxModel, _, NullWidget) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'bajaui',
      keyName: 'ScrollPane',
      properties: {
        rootCssClass: 'ux-ScrollPane -t-scaled-layout-scroll-container',
        hpolicy: baja.$('bajaui:ScrollBarPolicy', 'asNeeded'),
        vpolicy: baja.$('bajaui:ScrollBarPolicy', 'asNeeded'),
        viewportBackground: baja.$('gx:Brush', 'null'),
        borderPolicy: baja.$('bajaui:ScrollBarPolicy', 'always'),
        scrollLeft: {
          value: 0,
          hidden: true,
          "transient": true
        },
        scrollTop: {
          value: 0,
          hidden: true,
          "transient": true
        }
      }
    };
  };

  /**
   * @class
   * @alias module:nmodule/bajaui/rc/ux/ScrollPane
   * @extends {module:bajaux/Widget}
   */
  return /*#__PURE__*/function (_spandrel) {
    function ScrollPane(params) {
      _classCallCheck(this, ScrollPane);
      return _callSuper(this, ScrollPane, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     * Store the scrollTop/scrollLeft so they can be restored after any child
     * widgets may cause it to scroll around during layout.
     */
    _inherits(ScrollPane, _spandrel);
    return _createClass(ScrollPane, [{
      key: "layoutStarted",
      value: function layoutStarted() {
        var jq = this.jq();
        var el = jq && jq[0];
        var studioWrapper = el.closest(".-t-UxBuilder-PxStudioWrapper");
        if (el && !studioWrapper) {
          var props = this.properties();
          props.setValue('scrollTop', el.scrollTop);
          props.setValue('scrollLeft', el.scrollLeft);
        }
      }
    }, {
      key: "doLayout",
      value: function doLayout() {
        var viewportBackground = this.properties().getValue('viewportBackground');
        if (this.jq() && viewportBackground) {
          viewportBackground.applyBackgroundToElement(this.jq()[0]);
        }
      }

      /**
       * Restore scrollTop/scrollLeft stored in layoutStarted.
       */
    }, {
      key: "layoutFinished",
      value: function layoutFinished() {
        var jq = this.jq();
        var el = jq && jq[0];
        if (el) {
          var props = this.properties();
          el.scrollTop = props.getValue("scrollTop");
          el.scrollLeft = props.getValue("scrollLeft");
        }
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getContentWidget",
      value: function $getContentWidget() {
        return this.queryWidget('*/*');
      }

      /**
       * @private
       * @returns {module:bajaux/model/UxModel~UxModelParams} the default UxModel structure for a brand new ScrollPane
       * @since Niagara 4.15
       */
    }, {
      key: "$uxModelDefaults",
      value: function $uxModelDefaults() {
        return {
          kids: [{
            name: 'content',
            type: NullWidget,
            metadata: {
              typeSpec: 'bajaui:Widget'
            }
          }]
        };
      }
    }]);
  }(spandrel(function (uxModel, _ref) {
    var properties = _ref.properties,
      rootElement = _ref.rootElement;
    var hpolicy = properties.hpolicy,
      vpolicy = properties.vpolicy,
      viewportBackground = properties.viewportBackground,
      borderPolicy = properties.borderPolicy,
      visible = properties.visible;
    var style = rootElement.style;
    style.overflowX = toOverflow(hpolicy);
    style.overflowY = toOverflow(vpolicy);
    viewportBackground.applyBackgroundToElement(rootElement);
    if (isBorderShown(borderPolicy, hpolicy, vpolicy)) {
      rootElement.classList.add('ux-ScrollPane-with-border');
    }
    return UxModel.jsx("div", {
      className: "-t-ScrollPane-wrapper"
    }, UxModel.jsx("widget", {
      src: uxModel.get('content'),
      className: "-t-ScrollPane-content"
      // Override child visibility with parent's.
      ,
      properties: {
        visible: visible
      }
    }));
  }));
  function isBorderShown(borderPolicy, hpolicy, vpolicy) {
    var borderPolicyTag = borderPolicy.getTag();
    if (!borderPolicyTag) {
      return false;
    } else if (borderPolicyTag === "always") {
      return true;
    } else if (borderPolicyTag === "asNeeded") {
      var hpolicyTag = hpolicy.getTag(),
        vpolicyTag = vpolicy.getTag();
      return hpolicyTag === "always" || vpolicyTag === "always";
    }
    return false;
  }
  function toOverflow(scrollBarPolicy) {
    switch (scrollBarPolicy.getTag()) {
      case 'asNeeded':
        return 'auto';
      case 'always':
        return 'scroll';
      case 'never':
        return 'hidden';
      default:
        return '';
    }
  }
});
