function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/** @jsx UxModel.jsx */
/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/PxWidget
 */
define(['baja!', 'log!nmodule.bajaui.rc.ux.PxWidget', 'bajaux/events', 'bajaux/spandrel', 'bajaux/mixin/UxModelSupport', 'bajaux/model/UxModel', 'bajaux/util/SaveCommand', 'niagaraSystemProperties', 'Promise', 'underscore', 'dialogs', 'nmodule/bajaui/rc/binding/impl/WidgetBindingManager', 'nmodule/bajaui/rc/mixin/LayoutHintsSupport', 'nmodule/bajaui/rc/mixin/SpecialPropertySupport', 'nmodule/bajaui/rc/rpc/uxBuilder', 'nmodule/bajaui/rc/util/pxUtils', 'nmodule/bajaui/rc/util/TogglePxEditModeCommand', 'nmodule/bajaui/rc/ux/BaseDashboardPane', 'nmodule/bajaui/rc/ux/NullWidget', 'nmodule/bajaui/rc/ux/WebWidget', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/fe/registry/StationRegistry', 'nmodule/webEditors/rc/fe/registry/NiagaraWidgetManager', 'nmodule/webEditors/rc/wb/profile/profileUtils', 'hbs!bajaux/container/error', 'lex!bajaux,bajaui', 'css!nmodule/bajaui/rc/bajaui'], function (baja, log, events, spandrel, UxModelSupport, UxModel, SaveCommand, niagaraSystemProperties, Promise, _, dialogs, WidgetBindingManager, LayoutHintsSupport, SpecialPropertySupport, uxBuilder, pxUtils, TogglePxEditModeCommand, BaseDashboardPane, NullWidget, WebWidget, asyncUtils, typeUtils, StationRegistry, NiagaraWidgetManager, profileUtils, errorTemplate, lexs) {
  'use strict';

  var extend = _.extend,
    mapObject = _.mapObject,
    once = _.once;
  var SCROLL = LayoutHintsSupport.SCROLL,
    RESTRICT_HORIZONTAL = LayoutHintsSupport.RESTRICT_HORIZONTAL;
  var fromPxOrd = uxBuilder.fromPxOrd;
  var doRequire = asyncUtils.doRequire;
  var applyPxProperties = pxUtils.applyPxProperties,
    substituteOrds = pxUtils.substituteOrds;
  var logSevere = log.severe.bind(log);
  var _lexs = _slicedToArray(lexs, 2),
    bajauxLex = _lexs[0],
    bajauiLex = _lexs[1];
  var PX_FILE_LOAD_DIALOG_DELAY_MS = 3000;
  var isAssignableFrom = typeUtils.isAssignableFrom;

  // avoid circular dependency
  var resolvePxInclude = once(function () {
    return doRequire('nmodule/bajaui/rc/ux/PxInclude');
  });
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-PxWidget ux-fullscreen ux-preferred-size-support ux-layout-mode',
        variables: baja.Facets.DEFAULT,
        editMode: {
          value: false,
          hidden: true,
          readonly: true
        },
        //allow the command bar to be hidden from a BWebWidget by adding a 'hideCommandBar' property.
        hideCommandBar: {
          value: false,
          hidden: true,
          "transient": true,
          readonly: true
        }
      }
    };
  };
  var UX_MEDIA_ERROR_KEY = 'niagara.uxMedia.onError';
  var UX_MEDIA_ERROR_THROW = "throw";
  var UX_MEDIA_ERROR_LOG_ONLY = "logOnly";
  var UX_MEDIA_ERROR_REPLACE_WIDGET = "replaceWidget";
  var UX_MEDIA_ERROR_TYPE = bajauiLex.getSafe("uxMedia.errorType");
  var getStringSystemProperty = function getStringSystemProperty(key, fallback) {
    try {
      var result = niagaraSystemProperties[key];
      if (result) {
        return result.toString();
      }
    } catch (ignore) {}
    return fallback;
  };
  var replaceWidget = function replaceWidget(err, widget) {
    var errString = String(err),
      stack;
    var errorJq = widget.jq();
    if (!err) {
      stack = "";
    } else if (err.stack) {
      stack = String(err.stack);
      //Chrome puts a toString of the error at the top of the stack, FF doesn't
      if (stack.substring(0, errString.length) !== errString) {
        stack = errString + '\n' + stack;
      }
    } else {
      stack = errString;
    }

    //There is no way to press the Show Details in the UxBuilder so show the error as the message,
    //it could help inform the user how to fix the problem.
    var designTime = !!errorJq.closest(".-t-UxBuilder-PxStudioWrapper").length;
    var message = designTime && err && err.message ? err.message : bajauxLex.get("error.message");
    var params = {
      title: bajauxLex.get("error.title"),
      message: message,
      details: bajauxLex.get("error.details"),
      type: UX_MEDIA_ERROR_TYPE,
      moduleName: widget ? widget.$moduleName : "",
      keyName: widget ? widget.$keyName : "",
      stack: stack
    };
    errorJq.empty();
    errorJq.css("min-height", "50px");
    errorJq.css("min-width", "100px");
    var styles = "display: block; text-align: left; overflow: auto;";
    errorJq.html("<div class=\"bajaux-error\" style=\"".concat(styles, "\"> ").concat(errorTemplate(params), " </div>"));
  };

  /**
   * `PxWidget` can display Px data using UxMedia in the browser. It can either resolve an ORD to
   * Px data, or accept a `UxModel` containing a tree of Px widgets directly. It supports the
   * following properties:
   *
   * - `baseOrd`: if passing a `UxModel` directly, this must be given so that bindings know what
   *   ORD to resolve themselves against. If resolving an ORD, that resolved ORD will be used as the
   *   base.
   * - `pxProperties`: if passing a `UxModel` directly, you can also pass
   *   {@link module:nmodule/bajaui/rc/rpc/uxBuilder~PxProperties|PxProperties} to be applied. If
   *   resolving an ORD, the Px Properties from the resolved Px data will be used.
   * - `variables`: if this PxWidget is to display a PxInclude, the `variables` property
   *   (baja.Facets) can be passed for use when performing ORD substitution.
   *
   * @class
   * @alias module:nmodule/bajaui/rc/ux/PxWidget
   * @extends module:bajaux/Widget
   */
  return /*#__PURE__*/function (_spandrel) {
    function PxWidget(params) {
      var _this;
      _classCallCheck(this, PxWidget);
      var _makeWidgetManager = makeWidgetManager({
          postLoad: function postLoad(widget, buildContext) {
            var postLoad = _this.properties().getValue('postLoad');
            if (postLoad) {
              return postLoad(widget, buildContext);
            }
          }
        }),
        widgetManager = _makeWidgetManager.widgetManager,
        bindingManager = _makeWidgetManager.bindingManager;
      params = extend({
        data: {
          manager: widgetManager
        }
      }, params);
      _this = _callSuper(this, PxWidget, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$bindingManager = bindingManager;
      LayoutHintsSupport(_this);
      return _this;
    }

    /**
     * @private
     * @returns {boolean}
     */
    _inherits(PxWidget, _spandrel);
    return _createClass(PxWidget, [{
      key: "$canShowCommandBar",
      value: function $canShowCommandBar() {
        var hx = window.hx;
        if (hx && hx.getProfileInfo) {
          var _hx$getProfileInfo = hx.getProfileInfo(),
            showCommandBarOnUxMediaPages = _hx$getProfileInfo.showCommandBarOnUxMediaPages;
          if (showCommandBarOnUxMediaPages === 'falseForPopups') {
            return !hx.isFullScreen();
          }
          return showCommandBarOnUxMediaPages === 'true';
        }
        return true;
      }
    }, {
      key: "applyLayoutHints",
      value: function applyLayoutHints(_ref) {
        var scroll = _ref[SCROLL];
        if (scroll === RESTRICT_HORIZONTAL) {
          this.jq().children('.-t-PxWidget-content').css('flexGrow', '0');
        }
      }
    }, {
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;
        return Promise.resolve(_superPropGet(PxWidget, "doInitialize", this, 3)(arguments)).then(function () {
          dom.on(events.FAILURE_EVENTS.join(" "), '.-t-PxWidget-content', function () {
            var errorHandle = getStringSystemProperty(UX_MEDIA_ERROR_KEY, UX_MEDIA_ERROR_REPLACE_WIDGET);
            if (errorHandle !== UX_MEDIA_ERROR_THROW) {
              return false;
            }
          });
          dom.on(events.SAVE_EVENT, '.ux-WebWidget', function () {
            if (!_this2.$bindingManager.isAnyBoundWidgetModified()) {
              _this2.setModified(false);
            }
          });
        });
      }
    }, {
      key: "doLoad",
      value: function doLoad(value) {
        return Promise.all([_superPropGet(PxWidget, "doLoad", this, 3)(arguments), this.$makeCommands()]);
      }

      /*
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$makeCommands",
      value: function $makeCommands() {
        var _this3 = this;
        if (!this.$madeCommands) {
          this.$madeCommands = true;
        } else {
          return Promise.resolve();
        }
        return TogglePxEditModeCommand.make(this.$pxSourceOrd, this).then(function (togglePxEditModeCommand) {
          var commandGroup = _this3.getCommandGroup();

          // Show save command only when profileInfo has showCommandBarOnUxMediaPages set to true.
          if (_this3.$canShowCommandBar()) {
            commandGroup.add(new SaveCommand());
            if (togglePxEditModeCommand) {
              commandGroup.add(togglePxEditModeCommand);
            }
          }
        });
      }

      /**
       * When used to view a UxMedia page, PxWidget never loads an actual value, only by ORD.
       * Therefore, `resolve()` simply holds onto the ORD so it can use it to retrieve the associated
       * Px data when `load()` is called.
       * @param {string|baja.Ord} ord
       * @returns {Promise}
       */
    }, {
      key: "resolve",
      value: function resolve(ord) {
        this.$pxSourceOrd = ord;
        return Promise.resolve();
      }
    }, {
      key: "render",
      value: function render() {
        var _arguments = arguments,
          _this4 = this;
        return log.timing(function () {
          return _superPropGet(PxWidget, "render", _this4, 3)(_arguments);
        }, 'FINE', 'Rendered and laid out PxWidget in {}ms');
      }
    }, {
      key: "toDisplayName",
      value: function toDisplayName() {
        var _arguments2 = arguments,
          _this5 = this;
        return profileUtils.resolveCurrentViewItem().then(function (item) {
          if (item && item.displayName) {
            return item.displayName;
          } else {
            return _superPropGet(PxWidget, "toDisplayName", _this5, 3)(_arguments2);
          }
        })["catch"](function () {
          return _superPropGet(PxWidget, "toDisplayName", _this5, 3)(_arguments2);
        });
      }

      /**
       * Returns the Ord backing this widget
       *
       * @returns {baja.Ord|undefined}
       */
    }, {
      key: "getOrd",
      value: function getOrd() {
        var pxSourceOrd = this.$pxSourceOrd;
        return pxSourceOrd && baja.Ord.make(this.$pxSourceOrd);
      }

      /**
       * Returns the TransformOperations of this view
       *
       * @returns {Promise.<Array.<module:nmodule/export/rc/TransformOperation>>}
       */
    }, {
      key: "getTransformOperations",
      value: function getTransformOperations() {
        var _this6 = this;
        return doRequire('nmodule/webEditors/rc/transform/ServletViewTransformOperationProvider').then(function (ServletViewTransformOperationProvider) {
          return new ServletViewTransformOperationProvider().getTransformOperations(_this6);
        });
      }
    }, {
      key: "layoutStarted",
      value: function layoutStarted() {
        this.jq().addClass('ux-layout-mode');
      }
    }, {
      key: "layoutFinished",
      value: function layoutFinished() {
        this.jq().removeClass('ux-layout-mode');
      }
    }, {
      key: "doSave",
      value: function doSave() {
        return this.$bindingManager.saveAllBindings();
      }

      /**
       * @private
       * @param {string|baja.Ord} ord
       * @param {object} properties
       * @returns {Promise.<module:bajaux/model/UxModel>}
       */
    }, {
      key: "$retrievePxData",
      value: function $retrievePxData(ord, _ref2) {
        var _this7 = this;
        var variables = _ref2.variables,
          pxPropertyValues = _ref2.pxPropertyValues;
        return Promise.all([fromPxOrd(ord), resolvePxInclude()]).then(function (_ref3) {
          var _ref4 = _slicedToArray(_ref3, 2),
            _ref4$ = _ref4[0],
            uxModel = _ref4$.uxModel,
            pxProperties = _ref4$.pxProperties,
            PxInclude = _ref4[1];
          // TODO Remove this hack once we figure out a better way to make "widgetOrd"
          _this7.$applyWidgetOrds(uxModel, PxInclude);
          applyPxProperties(uxModel, pxProperties, pxPropertyValues || pxProperties && mapObject(pxProperties, function (_ref5) {
            var value = _ref5.value;
            return value;
          }));
          return substituteOrds(uxModel, variables);
        });
      }

      /**
       * Makes a widgetOrd for a dashboardable webwidget or a PxInclude.
       * The initial value of the model will always be the
       * child of the root.
       *
       * @see BWidgetScheme.makeWidgetOrd
       * @private
       * @param {module:bajaux/model/UxModel} model
       * @param {Function} PxInclude
       */
    }, {
      key: "$applyWidgetOrds",
      value: function $applyWidgetOrds(model, PxInclude) {
        if (this.$hasWidgetType(model, BaseDashboardPane)) {
          updateWidgetOrds(model, {
            type: WebWidget,
            widgetOrd: this.$widgetOrd
          });
        }
        if (this.$hasWidgetType(model, PxInclude)) {
          updateWidgetOrds(model, {
            type: PxInclude
          });
        }
      }

      /**
       * If the PxWidget model has DashboardPane(s), only
       * then update the model with "widgetOrd" property
       *
       * @private
       * @param {module:bajaux/model/UxModel} model
       * @param {Function|Object} type
       * @returns {boolean}
       */
    }, {
      key: "$hasWidgetType",
      value: function $hasWidgetType(model, type) {
        var _this8 = this;
        var kids = model.getKids(),
          widgetType = model.getType();
        if (isAssignableFrom(type, widgetType)) {
          return true;
        } else {
          return kids.some(function (kid) {
            return _this8.$hasWidgetType(kid, type);
          });
        }
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getRootWidget",
      value: function $getRootWidget() {
        return this.queryWidget('root');
      }
    }]);
  }(spandrel(function (model, _ref6) {
    var properties = _ref6.properties,
      self = _ref6.self;
    var pxSourceOrd = self.$pxSourceOrd;
    var baseOrd = pxSourceOrd || properties.baseOrd;
    if (!baseOrd) {
      throw new Error('Must either resolve an ORD or provide baseOrd property');
    }
    var isInclude = properties.isInclude,
      pxPropertyValues = properties.pxPropertyValues;
    self.$bindingManager.setBaseOrd(baseOrd);
    var makeUxModel;
    if (pxSourceOrd) {
      makeUxModel = self.$retrievePxData(pxSourceOrd, properties);
    } else {
      var pxProperties = properties.pxProperties || {};
      applyPxProperties(model, pxProperties, mapObject(pxProperties, function (_ref7) {
        var value = _ref7.value;
        return value;
      }));
      makeUxModel = model;
    }

    // For a PxInclude, $widgetOrd is passed down as a
    // pxPropertyValue of the Px to include. The property
    // will then be used to construct the DashboardPane WebWidget's widgetOrd.
    self.$widgetOrd = pxPropertyValues && pxPropertyValues.$widgetOrd;
    var pxLoadProm = Promise.resolve(makeUxModel).then(function (model) {
      return UxModel.jsx("widget", {
        className: "-t-PxWidget-content hxPx ux-root",
        spandrelKey: "root",
        src: model
      });
    })["catch"](function (err) {
      if (isInclude) {
        logSevere(err);
        return '<span></span>';
      } else {
        throw err;
      }
    });
    dialogs.showLoading(PX_FILE_LOAD_DIALOG_DELAY_MS, pxLoadProm);
    return pxLoadProm;
  }));
  function makeWidgetManager(_ref8) {
    var postLoad = _ref8.postLoad;
    var widgetManager = new NiagaraWidgetManager({
      registry: StationRegistry.getInstance()
    });
    var bindingManager = new WidgetBindingManager();
    bindingManager.$installHooks(widgetManager);
    widgetManager.installHooks({
      instantiated: function instantiated(widget) {
        SpecialPropertySupport(widget);
      },
      preLoad: function preLoad(widget, buildContext) {
        /*
         * NCCB-69069: we want to ensure widgets have UxModelSupport - but only if they actually
         * need it. putting UxModelSupport on a StringEditor won't work - it can't support a UxModel
         * passed to load().
         *
         * to make this decision, wait until a value is about to be loaded: for every widget
         * configured in a Px page, the first value loaded is guaranteed to be a UxModel. therefore,
         * the widget is guaranteed to support loading UxModels, or else it wouldn't display in the
         * Px page in the first place. so we can safely add UxModelSupport.
         *
         * this ensures that any bindings that come along and call .load() on it with a non-UxModel
         * will not break selection in UxBuilder--which depends on the widgets retaining knowledge
         * of their own UxModel--even if they themselves did not declare UxModelSupport.
         */
        if (buildContext.value instanceof UxModel) {
          UxModelSupport(widget);
        }
      },
      postLoad: postLoad,
      error: function error(err, widget) {
        var errorHandle = getStringSystemProperty(UX_MEDIA_ERROR_KEY, UX_MEDIA_ERROR_REPLACE_WIDGET);
        logSevere(err);
        if (errorHandle === UX_MEDIA_ERROR_LOG_ONLY) {
          return;
        }
        if (errorHandle === UX_MEDIA_ERROR_THROW) {
          throw err;
        }
        replaceWidget(err, widget);
      }
    });
    return {
      widgetManager: widgetManager,
      bindingManager: bindingManager
    };
  }

  /**
   * Recursively update WebWidget and PxInclude models with "widgetOrd"
   * property.
   *
   * @param {module:bajaux/model/UxModel} model
   * @param {Object} options
   * @param {Function} options.type
   * @param {string} [options.widgetOrd]
   * @param {string} [options.name]
   */
  function updateWidgetOrds(model, options) {
    var type = options.type,
      widgetOrd = options.widgetOrd,
      name = options.name;
    var kids = model.getKids(),
      widgetType = model.getType(),
      widgetKey = getKeyName(widgetType),
      existingNames = [],
      widgetName = model.getName();
    if (!widgetName) {
      kids.forEach(function (kid) {
        return updateWidgetOrds(kid, options);
      });
      return;
    }
    if (!name) {
      name = widgetName;
    }
    name = getWidgetName(widgetKey, name, existingNames);
    if (isAssignableFrom(type, widgetType)) {
      var newWidgetOrd = baja.Ord.make('widget:/' + name);
      if (widgetOrd) {
        newWidgetOrd = baja.Ord.make(widgetOrd + '/root/' + name);
      }
      Object.assign(model.getProperties(), {
        $widgetOrd: newWidgetOrd
      });
    } else {
      kids.forEach(function (kid) {
        var kidType = kid.getType();
        var kidKey = getKeyName(kidType);
        var kidName = kid.getName();
        kidName = getWidgetName(kidKey, kidName, existingNames);
        if (!isAssignableFrom(NullWidget, kidType)) {
          return updateWidgetOrds(kid, {
            type: type,
            widgetOrd: widgetOrd,
            name: name + '/' + kidName
          });
        }
      });
    }
  }

  /**
   * @param {Function} Constructor
   * @returns {String}
   */
  function getKeyName(Constructor) {
    return new Constructor().$keyName || 'Widget';
  }

  /**
   * Get the widget name based on the desired name the existing names used by the other kids.
   * When a name is already taken, try the name again with a numeric suffix.
   * For example, if 'Label' is already taken, try the name 'Label1', then 'Label2' and so on.
   *
   * @param {string} widgetKey
   * @param {string} name
   * @param {Object} existingNames an object used as a map for keeping track of existing names.
   * @param {Number} [index=0] defaults to zero
   * @returns {string}
   */
  function getWidgetName(widgetKey, name, existingNames) {
    var index = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
    if (!isNaN(parseInt(name, 10))) {
      name = widgetKey;
    }
    if (index > 0) {
      name = name + index;
    }
    if (existingNames[name]) {
      index++;
      return getWidgetName(widgetKey, name, existingNames, index);
    }
    existingNames[name] = true;
    return name;
  }
});
