function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/** @jsx spandrel.jsx */

define(['baja!', 'baja!bajaui:Halign,bajaui:Valign,gx:Brush', 'underscore', 'bajaux/events', 'bajaux/spandrel', 'jquery', 'nmodule/bajaui/rc/baja/LayoutDimension', 'nmodule/bajaui/rc/mixin/LayoutHintsSupport', 'nmodule/gx/rc/baja/Brush', 'nmodule/js/rc/asyncUtils/asyncUtils'], function (baja, types, _, events, spandrel, $, LayoutDimension, LayoutHintsSupport, Brush, asyncUtils) {
  'use strict';

  var PROPERTY_CHANGED = events.PROPERTY_CHANGED;
  var ABS = LayoutDimension.ABS,
    PERCENT = LayoutDimension.PERCENT,
    PREF = LayoutDimension.PREF;
  var SCROLL = LayoutHintsSupport.SCROLL,
    RESTRICT_HORIZONTAL = LayoutHintsSupport.RESTRICT_HORIZONTAL;
  var KID_CLASSES = '-t-FlowPane-child-content ux-preferred-size-support ' + 'ux-use-preferred-height ux-use-preferred-min-height ux-use-preferred-max-height';
  var doRequire = asyncUtils.doRequire;
  var once = _.once;
  //To overcome cyclic dependency between ResponsivePane and FlowPane.
  var requireResponsivePane = once(function () {
    return doRequire('nmodule/bajaui/rc/ux/ResponsivePane');
  });
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'bajaui',
      keyName: 'FlowPane',
      properties: {
        rootCssClass: 'ux-FlowPane',
        align: baja.$('bajaui:Halign', 'left'),
        rowAlign: baja.$('bajaui:Valign', 'center'),
        hgap: {
          value: 4,
          typeSpec: 'baja:Integer'
        },
        vgap: {
          value: 4,
          typeSpec: 'baja:Integer'
        },
        background: Brush.NULL
      }
    };
  };
  return /*#__PURE__*/function (_spandrel) {
    function FlowPane(params) {
      var _this;
      _classCallCheck(this, FlowPane);
      _this = _callSuper(this, FlowPane, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      // a FlowPane must have its horizontal scrolling restricted in order for
      // flexbox to allow wrapping to work. otherwise it just expands
      // horizontally instead of wrapping.
      LayoutHintsSupport(_this, _defineProperty({}, SCROLL, RESTRICT_HORIZONTAL));
      return _this;
    }
    _inherits(FlowPane, _spandrel);
    return _createClass(FlowPane, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        dom.on(PROPERTY_CHANGED, '.-t-FlowPane-child-content', function (e, ed, name, value) {
          if (e.target.parentElement !== this) {
            // only process events from a direct child of this FlowPane.
            return;
          }
          if (name === 'visible') {
            $(this).toggleClass('bajaux-invisible', value === false);
          }
        });
        return _superPropGet(FlowPane, "doInitialize", this, 3)(arguments);
      }
    }, {
      key: "doLayout",
      value: function doLayout() {
        var wrapper = this.queryWidget('wrapper');
        if (wrapper) {
          var background = this.properties().getValue('background');
          background.applyBackgroundToElement(wrapper.jq()[0]);
        }
      }
    }]);
  }(spandrel(function (model, _ref) {
    var properties = _ref.properties;
    var align = properties.align,
      background = properties.background,
      hgap = properties.hgap,
      rowAlign = properties.rowAlign,
      vgap = properties.vgap;
    var kids = model.getKids();
    return requireResponsivePane().then(function (responsivePane) {
      var flowKids = [];
      kids.forEach(function (kid, i) {
        var kidProperties = kid.getProperties();
        var forceNewRow = kidProperties.forceNewRow,
          visible = kidProperties.visible;
        var className = getKidClass(kid, responsivePane) + (visible === false ? ' bajaux-invisible' : '');
        if (i > 0 && forceNewRow) {
          flowKids.push(spandrel.jsx("div", {
            className: "-t-FlowPane-hard-break"
          }));
        }
        flowKids.push(spandrel.jsx("div", {
          className: className,
          style: getKidStyle(properties, kidProperties)
        }, spandrel.jsx("div", {
          spandrelSrc: kid
        })));
      });
      return spandrel.jsx("div", {
        spandrelKey: "wrapper",
        className: "-t-FlowPane-wrapper",
        $init: function $init(el) {
          return background.applyBackgroundToElement(el);
        }
      }, spandrel.jsx("div", {
        spandrelKey: "content",
        className: "-t-FlowPane-contents",
        style: {
          margin: '-' + vgap / 2 + 'px -' + hgap / 2 + 'px',
          justifyContent: toJustifyContent(align.getTag()),
          alignItems: toAlignItems(rowAlign.getTag())
        }
      }, flowKids));
    });
  }));

  /**
   * @param {module:bajaux/model/UxModel} kid
   * @param {module:nmodule/bajaui/rc/ux/ResponsivePane} responsivePane
   * @returns {string}
   */
  function getKidClass(kid, responsivePane) {
    var _kid$getProperties = kid.getProperties(),
      maxWidth = _kid$getProperties.maxWidth,
      minWidth = _kid$getProperties.minWidth;
    var className = KID_CLASSES;
    if (kid.getType() !== responsivePane) {
      className += ' ux-use-preferred-flex-basis';
    }
    if (!maxWidth || !minWidth) {
      return className;
    }
    if (maxWidth.getUnit() === PREF) {
      className += ' ux-use-preferred-max-width';
    }
    if (minWidth.getUnit() === PREF) {
      className += ' ux-use-preferred-min-width';
    }
    return className;
  }

  /**
   * @param properties
   * @param kidProperties
   * @returns {object}
   */
  function getKidStyle(properties, kidProperties) {
    var align = properties.align,
      hgap = properties.hgap,
      vgap = properties.vgap;
    var maxWidth = kidProperties.maxWidth,
      minWidth = kidProperties.minWidth;
    var padding = '0 ' + hgap / 2 + 'px';
    var margin = vgap / 2 + 'px 0';
    if (!maxWidth || !minWidth) {
      return {
        padding: padding,
        margin: margin
      };
    }
    var maxUnit = maxWidth.getUnit();
    var maxValue = maxWidth.getValue();
    var minUnit = minWidth.getUnit();
    var minValue = minWidth.getValue();
    return {
      padding: padding,
      margin: margin,
      flexBasis: maxUnit === ABS ? maxValue + 'px' : maxUnit === PERCENT ? maxValue + '%' : '',
      flexGrow: align.getTag() === 'fill' && maxUnit !== ABS && 1,
      minWidth: minUnit === ABS ? minValue + 'px' : minUnit === PERCENT ? minValue + '%' : 'min-content'
    };
  }
  function toJustifyContent(halignTag) {
    switch (halignTag) {
      case 'right':
        return 'flex-end';
      case 'center':
        return 'center';
      case 'left':
      case 'fill':
        return 'flex-start';
    }
  }
  function toAlignItems(rowAlignTag) {
    switch (rowAlignTag) {
      case 'top':
        return 'flex-start';
      case 'center':
        return 'center';
      case 'bottom':
        return 'flex-end';
      case 'fill':
        return 'stretch';
    }
  }
});
