function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author JJ Frankovich
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/ConstrainedPane
 */
define(['baja!', 'baja!gx:Size', 'bajaux/spandrel', 'nmodule/bajaui/rc/mixin/PreferredSizeSupport', 'nmodule/bajaui/rc/ux/NullWidget', 'css!nmodule/bajaui/rc/bajaui'], function (baja, types, spandrel, PreferredSizeSupport, NullWidget) {
  'use strict';

  var maxDimension = baja.Integer.MAX_VALUE.valueOf(),
    widgetDefaults = function widgetDefaults() {
      return {
        moduleName: 'bajaui',
        keyName: 'ConstrainedPane',
        properties: {
          rootCssClass: 'ux-ConstrainedPane',
          minSize: baja.$('gx:Size', 0, 0),
          maxSize: baja.$('gx:Size', maxDimension, maxDimension)
        }
      };
    };

  /**
   * bajaux implementation of `bajaui:ConstrainedPane`.
   * Only Certain Widgets like GridPane, FlowPane, and non-center cells of EdgePane currently enforce clamping the
   * size of the widget in workbench, so UxMedia currently has clamping for just those widgets.
   *
   * @class
   * @alias module:nmodule/bajaui/rc/ux/ConstrainedPane
   * @extends {module:bajaux/Widget}
   */
  var ConstrainedPane = /*#__PURE__*/function (_spandrel) {
    function ConstrainedPane(params) {
      var _this;
      _classCallCheck(this, ConstrainedPane);
      _this = _callSuper(this, ConstrainedPane, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      PreferredSizeSupport(_this);
      return _this;
    }
    _inherits(ConstrainedPane, _spandrel);
    return _createClass(ConstrainedPane, [{
      key: "getPreferredSize",
      value: function getPreferredSize() {
        var props = this.properties();
        var minSize = props.getValue('minSize');
        var maxSize = props.getValue('maxSize');
        var minWidth = minSize.getWidth();
        var minHeight = minSize.getHeight();
        var maxWidth = maxSize.getWidth();
        var maxHeight = maxSize.getHeight();
        return {
          maxWidth: maxWidth,
          maxHeight: maxHeight,
          minWidth: Math.min(minWidth, maxWidth),
          minHeight: Math.min(minHeight, maxHeight)
        };
      }
    }, {
      key: "doLayout",
      value: function doLayout() {
        this.applySize(this.jq()[0]);
      }

      /**
       * @private
       * @returns {module:bajaux/model/UxModel~UxModelParams} the default UxModel structure for a brand new ConstrainedPane
       * @since Niagara 4.15
       */
    }, {
      key: "$uxModelDefaults",
      value: function $uxModelDefaults() {
        return {
          kids: [{
            name: 'content',
            type: NullWidget,
            metadata: {
              typeSpec: 'bajaui:Widget'
            }
          }]
        };
      }
    }]);
  }(spandrel(function (model, _ref) {
    var properties = _ref.properties;
    var visible = properties.visible;
    return spandrel.jsx("div", {
      className: "-t-ConstrainedPane-content",
      spandrelSrc: model.get('content'),
      style: {
        visibility: visible === false && 'hidden'
      }
    });
  }));
  return ConstrainedPane;
});
