function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */
/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/CanvasPane
 */
define(['baja!', 'baja!bajaui:Halign,bajaui:ScaleMode,bajaui:Valign,gx:Brush,gx:Size', 'bajaux/events', 'bajaux/spandrel', 'nmodule/bajaui/rc/baja/Layout', 'nmodule/bajaui/rc/mixin/LayoutHintsSupport', 'nmodule/bajaui/rc/util/pxUtils', 'nmodule/bajaui/rc/util/ScaledLayout'], function (baja, types, events, spandrel, Layout, LayoutHintsSupport, pxUtils, ScaledLayout) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'bajaui',
      keyName: 'CanvasPane',
      properties: {
        rootCssClass: 'ux-CanvasPane',
        viewSize: baja.$('gx:Size', 100, 100),
        scale: baja.$('bajaui:ScaleMode', 'none'),
        minScaleFactor: 0,
        maxScaleFactor: 0,
        halign: baja.$('bajaui:Halign', 'center'),
        valign: baja.$('bajaui:Valign', 'center'),
        background: baja.$('gx:Brush', 'null')
      }
    };
  };
  var PROPERTY_CHANGED = events.PROPERTY_CHANGED;

  /**
   * @class
   * @alias module:nmodule/bajaui/rc/ux/CanvasPane
   * @extends module:bajaux/Widget
   */
  return /*#__PURE__*/function (_spandrel) {
    function CanvasPane(params) {
      var _this;
      _classCallCheck(this, CanvasPane);
      _this = _callSuper(this, CanvasPane, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      LayoutHintsSupport(_this);
      return _this;
    }
    _inherits(CanvasPane, _spandrel);
    return _createClass(CanvasPane, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;
        dom.on(PROPERTY_CHANGED, function (e, ed, propName) {
          if (propName === 'layout' && _this2.$isMyDirectKid(ed)) {
            applyLayoutToWidget(ed);
          }
        });

        // uncomment to debug
        // dom.on('click', (e) => {
        //   const viewPanePoint = this.$getPositionRelativeToViewPane(e);
        //   const documentPoint = this.$getPositionRelativeToDocument(viewPanePoint);
        //   console.log(this.jq()[0],
        //     'event', e.pageX, e.pageY,
        //     'viewPane', viewPanePoint,
        //     'document (should be same as event)', documentPoint);
        // });

        return _superPropGet(CanvasPane, "doInitialize", this, 3)(arguments);
      }

      /**
       * @private
       * @param {module:bajaux/Widget} widget
       * @returns {boolean} true if the widget is one of this CanvasPane's kids, and not a deeper
       * descendent
       */
    }, {
      key: "$isMyDirectKid",
      value: function $isMyDirectKid(widget) {
        return widget.jq().parent()[0] === this.$getViewPaneElement()[0];
      }
    }, {
      key: "doLayout",
      value: function doLayout() {
        var jq = this.jq();
        var wrapper = jq.children('.-t-CanvasPane-viewPane-wrapper');
        var viewPane = wrapper.children('.-t-CanvasPane-viewPane');
        var _this$properties$toVa = this.properties().toValueMap(),
          viewSize = _this$properties$toVa.viewSize,
          halign = _this$properties$toVa.halign,
          valign = _this$properties$toVa.valign,
          scale = _this$properties$toVa.scale,
          minScaleFactor = _this$properties$toVa.minScaleFactor,
          maxScaleFactor = _this$properties$toVa.maxScaleFactor;
        var halignTag = halign.getTag();
        var innerWidth = viewSize.getWidth() || 1;
        var innerHeight = viewSize.getHeight() || 1;
        var _pxUtils$getApplyZoom = pxUtils.getApplyZoomOffsetInfo(scale.getTag(), jq),
          applyZoomOffsetWidth = _pxUtils$getApplyZoom.applyZoomOffsetWidth,
          applyZoomOffsetHeight = _pxUtils$getApplyZoom.applyZoomOffsetHeight;
        var scaledLayout = this.$scaledLayout = ScaledLayout.scale(wrapper, jq, {
          innerWidth: innerWidth,
          innerHeight: innerHeight,
          halign: halignTag,
          valign: valign.getTag(),
          scale: scale.getTag(),
          minScaleFactor: minScaleFactor,
          maxScaleFactor: maxScaleFactor,
          applyZoomOffsetWidth: applyZoomOffsetWidth,
          applyZoomOffsetHeight: applyZoomOffsetHeight
        });
        wrapper.css({
          width: scaledLayout.getScaledWidth() + 'px',
          height: scaledLayout.getScaledHeight() + 'px'
        });
        var transformCss = scaledLayout.getTransformCss();
        viewPane.css({
          transform: transformCss.transform,
          // CanvasPane is flex-flow: column, so transform-origin Y should always be 50%
          transformOrigin: toOriginPercent(halignTag) + ' 50%'
        });
      }
    }, {
      key: "applyLayoutHints",
      value: function applyLayoutHints() {
        return false;
      }

      /**
       * Converts a physical point or area on the screen into coordinates that are relative to the
       * CanvasPane's viewPane. The resulting values can be converted into a `bajaui:Layout` and
       * assigned to a widget on that CanvasPane. That widget then will be positioned in such a way
       * that it sits at the same screen position as the input object.
       *
       * - for Event input: "i want to put my widget right where my mouse is"
       * - for Layout input: "if my Widget has x/y set to Layout.PERCENT, i want to convert it to
       *   Layout.ABS so it stays put"
       * - for Rectangle input: "i have a rectangle painted on the screen showing where this Widget
       *   *should* go - i want to set its `layout` property so it visually fits that rectangle"
       *
       * @private
       * @param {JQuery.Event|module:nmodule/bajaui/rc/baja/Layout|module:nmodule/bajaui/rc/baja/Layout~Rectangle} e
       * @returns {{x: number, y: number}|module:nmodule/bajaui/rc/baja/Layout~Rectangle} coordinates
       * relative to the viewPane, for calculating `layout` property of positioned widgets (note that
       * these are _not_ rounded to integers)
       */
    }, {
      key: "$getPositionRelativeToViewPane",
      value: function $getPositionRelativeToViewPane(e) {
        if (baja.hasType(e, 'bajaui:Layout')) {
          /** @type module:nmodule/bajaui/rc/baja/Layout */
          var layout = e;
          var viewSize = this.properties().getValue('viewSize');
          var x = layout.getX();
          var y = layout.getY();
          return {
            x: layout.getXUnit() === Layout.ABS ? x : viewSize.getWidth() * x / 100,
            y: layout.getYUnit() === Layout.ABS ? y : viewSize.getHeight() * y / 100
          };
        }
        if (typeof e.w === 'number') {
          var topLeft = this.$getPositionRelativeToViewPane({
            pageX: e.x,
            pageY: e.y
          });
          var bottomRight = this.$getPositionRelativeToViewPane({
            pageX: e.x + e.w,
            pageY: e.y + e.h
          });
          return {
            x: topLeft.x,
            y: topLeft.y,
            w: bottomRight.x - topLeft.x,
            h: bottomRight.y - topLeft.y
          };
        }
        var pageX = e.pageX,
          pageY = e.pageY;
        var _this$$getViewPaneLay = this.$getViewPaneLayoutInfo(),
          left = _this$$getViewPaneLay.left,
          top = _this$$getViewPaneLay.top,
          scaleX = _this$$getViewPaneLay.scaleX,
          scaleY = _this$$getViewPaneLay.scaleY;
        var absX = pageX - left;
        var absY = pageY - top;

        // with scaling unapplied
        var descaledX = absX / scaleX;
        var descaledY = absY / scaleY;
        return {
          x: descaledX,
          y: descaledY
        };
      }

      /**
       * @private
       * @param {{ x: number, y: number }} point a point relative to the CanvasPane itself (0,0 = top left of viewPane)
       * @returns {{ x: number, y: number }} the corresponding point relative to the document
       */
    }, {
      key: "$getPositionRelativeToDocument",
      value: function $getPositionRelativeToDocument(point) {
        // screen pixels from top left of viewPane
        var scaledLayout = this.$scaledLayout;
        if (!scaledLayout) {
          throw new Error('cannot calculate position before layout() is called');
        }
        var _this$$getViewPaneLay2 = this.$getViewPaneLayoutInfo(),
          left = _this$$getViewPaneLay2.left,
          top = _this$$getViewPaneLay2.top,
          scaleX = _this$$getViewPaneLay2.scaleX,
          scaleY = _this$$getViewPaneLay2.scaleY;
        return {
          x: left + point.x * scaleX,
          y: top + point.y * scaleY
        };
      }

      /**
       * Info about where the view pane is on screen, and what scaling is applied.
       * @private
       */
    }, {
      key: "$getViewPaneLayoutInfo",
      value: function $getViewPaneLayoutInfo() {
        var _this$$getViewPaneRec = this.$getViewPaneRect(),
          left = _this$$getViewPaneRec.left,
          top = _this$$getViewPaneRec.top,
          width = _this$$getViewPaneRec.width,
          height = _this$$getViewPaneRec.height;
        var viewSize = this.properties().getValue('viewSize');
        var scaleX = width / viewSize.getWidth();
        var scaleY = height / viewSize.getHeight();
        return {
          left: left,
          top: top,
          width: width,
          height: height,
          scaleX: scaleX,
          scaleY: scaleY
        };
      }

      /**
       * @private
       * @returns {DOMRect} position of viewPane relative to document
       */
    }, {
      key: "$getViewPaneRect",
      value: function $getViewPaneRect() {
        return this.$getViewPaneElement()[0].getBoundingClientRect();
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getViewPaneElement",
      value: function $getViewPaneElement() {
        return this.jq().children('.-t-CanvasPane-viewPane-wrapper').children('.-t-CanvasPane-viewPane');
      }
    }]);
  }(spandrel(function (model, _ref) {
    var properties = _ref.properties,
      rootElement = _ref.rootElement;
    var viewSize = properties.viewSize,
      background = properties.background,
      halign = properties.halign,
      valign = properties.valign;
    var style = rootElement.style;
    var justifyContent = toFlexAlign(halign.getTag());
    style.alignItems = toFlexAlign(valign.getTag());
    style.justifyContent = justifyContent;
    background.applyBackgroundToElement(rootElement);
    var width = viewSize.getWidth() + 'px';
    var height = viewSize.getHeight() + 'px';
    return spandrel.jsx("div", {
      spandrelKey: "wrapper",
      className: "-t-CanvasPane-viewPane-wrapper -t-scaled-layout-scroll-container",
      style: {
        width: width,
        height: height,
        justifyContent: justifyContent
      }
    }, spandrel.jsx("div", {
      spandrelKey: "viewPane",
      className: "-t-CanvasPane-viewPane",
      style: {
        width: width,
        height: height
      }
    }, model.getKids().map(function (kid) {
      var _kid$getProperties = kid.getProperties(),
        layout = _kid$getProperties.layout;
      var kidStyle = (layout || Layout.DEFAULT).toCss();
      // NCCB-60629 Added the 'ux-scaled-layout-support' class to this div
      return spandrel.jsx("div", {
        className: "-t-CanvasPane-child bajaux-widget-container ux-preferred-size-ignore ux-scaled-layout-support",
        style: kidStyle,
        spandrelSrc: kid
      });
    })));
  }));
  function applyLayoutToWidget(widget) {
    var layout = widget.properties().getValue('layout');
    widget.jq().css(layout.toCss());
  }
  function toFlexAlign(tag) {
    switch (tag) {
      case 'top':
      case 'left':
        return 'flex-start';
      case 'center':
        return 'center';
      case 'bottom':
      case 'right':
      case 'fill':
        return 'flex-end';
    }
  }
  function toOriginPercent(tag) {
    switch (tag) {
      case 'left':
        return '0';
      case 'center':
      case 'fill':
        return '50%';
      case 'right':
        return '100%';
    }
  }
});
