function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/util/UserDataOptionsCommand
 */

define(['Promise', 'bajaux/commands/Command', 'nmodule/bajaui/rc/util/UserDataOptions', 'nmodule/webEditors/rc/fe/feDialogs'], function (Promise, Command, UserDataOptions, feDialogs) {
  'use strict';

  /**
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/bajaui/rc/util/UserDataOptionsCommand
   */
  return /*#__PURE__*/function (_Command) {
    /**
     * 
     * @param {object} params
     * @param {String} [params.lex='UserDataOptionsCommand']
     * @param {String} [params.module='bajaux']
     * @param {String} [params.icon]
     * @param {String} [params.displayName]
     * @param {String} [params.description]
     * @param {*} params.type a constructor that extends @link{module:nmodule/bajaui/rc/util/UserDataOptions}
     * @param {module:nmodule/bajaui/rc/util/UserDataOptionsCommand~UserOptionOwnerView} [params.view] the owner view of this command that consumes the options
     */
    function UserDataOptionsCommand(params) {
      _classCallCheck(this, UserDataOptionsCommand);
      return _callSuper(this, UserDataOptionsCommand, [{
        module: params.module || 'bajaui',
        lex: params.lex || 'UserDataOptionsCommand',
        description: params.description,
        displayName: params.displayName,
        icon: params.icon,
        func: function func() {
          var type = params.type,
            view = params.view;
          return type.make().then(function (options) {
            var _options$$toProps = options.$toProps(),
              comp = _options$$toProps.comp,
              params = _options$$toProps.params;
            return feDialogs.props(comp, params).then(function (resultComp) {
              if (!resultComp) {
                return;
              }
              // Overwrite the options with the props and call save
              var newOptions = Object.assign(options, UserDataOptions.$toObject(resultComp));
              return Promise["try"](function () {
                if (view && typeof view.applyUserOptions === 'function') {
                  return view.applyUserOptions(newOptions);
                }
              }).then(function () {
                return newOptions.saveToUserData();
              });
            });
          });
        }
      }]);
    }
    _inherits(UserDataOptionsCommand, _Command);
    return _createClass(UserDataOptionsCommand);
  }(Command);

  /**
   * Interface for a View which can get notified of an options change.
   * @interface module:nmodule/bajaui/rc/util/UserDataOptionsCommand~UserOptionOwnerView
   */

  /**
   * Apply options to the view
   * @function
   * @name mmodule:nmodule/bajaui/rc/util/UserDataOptionsCommand~UserOptionOwnerView#applyUserOptions 
   * @param {Object} newOptions
   */
});
