function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _readOnlyError(r) { throw new TypeError('"' + r + '" is read-only'); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/util/UserDataOptions
 */

define(['baja!', 'lex!bajaui', 'nmodule/webEditors/rc/servlets/userData'], function (baja, lexs, userData) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    BAJAUI_LEX = _lexs[0];

  /**
   * UserDataOptions provides an abstraction for any feature that needs key-value pair stored 
   * in the user data storage. 
   * This class is expected to be always extended.
   * @example
   *  const defaultOptions = () => ({
   *    options: {
   *      isFuzzy: { value: true, displayName: 'Is it fuzzy?' },
   *      foo: { value: 'bar' },
   *      percent: { value:0, properties: { min: 0, max: 100 }}
   *    }
   *  });
   * 
   *  class TestUserDataOptions extends UserDataOptions {
   *    constructor(params = {}) {
   *      super({ params, defaults: defaultOptions() }); 
   *    }
   * 
   *    static make() {
   *      return UserDataOptions.make('TestOptions', { ctor: TestUserDataOptions });
   *    }
   *  }
   * 
   *  // Make the options 
   *  const options = TestUserDataOptions.make()
   *  // Save to user data
   *  options.save()
   *  // Set an option
   *  options.isFuzzy = false;
   *  // Convenience to get an option
   *  options.getFoo(); // returns 'bar'
   * 
   * @class
   * @alias module:nmodule/bajaui/rc/util/UserDataOptions
   */
  return /*#__PURE__*/function () {
    /**
     * @param {object} [params] 
     * @param {object} [params.params]
     * @param {object} [params.defaults]
     */
    function UserDataOptions(_ref) {
      var _this = this;
      var _ref$params = _ref.params,
        params = _ref$params === void 0 ? {} : _ref$params,
        _ref$defaults = _ref.defaults,
        defaults = _ref$defaults === void 0 ? {} : _ref$defaults;
      _classCallCheck(this, UserDataOptions);
      var options = defaults.options;
      Object.keys(options).forEach(function (key) {
        var defaultValue = options[key].value;
        var value = defaultValue;
        if (params && params.hasOwnProperty(key)) {
          value = params[key];
        }
        _this.$defineProperty(key, value);
      });
      this.$defaults = defaults;
    }

    /**
     * 
     * @param {String} userDataKey 
     * @param {object} params 
     * @param {*} params.ctor
     * @returns {Promise.<module:nmodule/bajaui/rc/util/UserDataOptions>}
     */
    return _createClass(UserDataOptions, [{
      key: "saveToUserData",
      value:
      /**
       * 
       * @returns {Promise}
       */
      function saveToUserData() {
        return userData.putJson(this.$userDataKey, this.$toUserData());
      }

      /**
       * @private
       * @returns {baja.Component}
       */
    }, {
      key: "$toComponent",
      value: function $toComponent() {
        var _this2 = this;
        var comp = baja.$('baja:Component');
        var options = this.$defaults.options;
        Object.entries(options).forEach(function (_ref2) {
          var _ref3 = _slicedToArray(_ref2, 2),
            key = _ref3[0],
            option = _ref3[1];
          var value = _this2[key],
            displayName = option.displayName,
            properties = option.properties,
            flags = option.flags;
          comp.add({
            slot: key,
            value: value,
            cx: {
              displayName: displayName
            }
          });
          if (properties) {
            comp.setFacets({
              slot: key,
              facets: baja.Facets.make(properties)
            });
          }
          if (flags) {
            comp.setFlags({
              slot: key,
              flags: flags
            });
          }
        });
        return comp;
      }

      /**
       * 
       * @param {baja.Component} comp
       * @returns {object} 
       */
    }, {
      key: "$toUserData",
      value:
      /**
       * @private
       * @returns {Object} JSON object
       */
      function $toUserData() {
        return baja.bson.encodeValue(this.$toComponent());
      }

      /**
       * @private
       * @returns {object}
       */
    }, {
      key: "$toProps",
      value: function $toProps() {
        var title = this.$defaults.title;
        var params = {
            title: title
          },
          comp = this.$toComponent();
        return {
          comp: comp,
          params: params
        };
      }

      /**
       * @private
       * @param {String} propName 
       * @param {*} value
       */
    }, {
      key: "$defineProperty",
      value: function $defineProperty(propName, value) {
        var _this3 = this;
        var _propName = '$' + propName;
        Object.defineProperty(this, propName, {
          get: function get() {
            return _this3[_propName];
          },
          set: function set(val) {
            _this3[_propName] = val;
          }
        });
        this[_propName] = value; // Set the value first
        this['get' + propName.charAt(0).toUpperCase() + propName.slice(1)] = function () {
          return _this3[_propName];
        };
      }
    }], [{
      key: "make",
      value: function make(userDataKey) {
        var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var Ctor = params.ctor;
        var make = function make(userDataComp) {
          var options = new Ctor(userDataComp && UserDataOptions.$toObject(userDataComp));
          options.$userDataKey = userDataKey;
          return options;
        };
        if (!userDataKey) {
          throw new Error(BAJAUI_LEX.get('UserDataOptions.noKey.error'));
        }
        return userData.getJson(userDataKey).then(function (userData) {
          if (!userData) {
            return make();
          }
          return baja.bson.decodeAsync(userData).then(function (userDataComp) {
            return make(userDataComp);
          });
        });
      }
    }, {
      key: "$toObject",
      value: function $toObject(comp) {
        if (!baja.hasType(comp, 'baja:Component')) {
          return {};
        } else {
          var options = {};
          comp.getSlots().dynamic().each(function (slot) {
            options[slot.getName()] = comp.get(slot);
          });
          return options;
        }
      }
    }]);
  }();
});
