function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/* global niagara */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/util/TogglePxEditModeCommand
 */

define(['baja!', 'Promise', 'bajaux/commands/ToggleCommand', 'nmodule/webEditors/rc/servlets/views', 'nmodule/webEditors/rc/wb/profile/profileUtils'], function (baja, Promise, ToggleCommand, views, profileUtils) {
  'use strict';

  var getViewQuery = profileUtils.getViewQuery;

  /**
   * Remove the "/uxBuilder" from the ViewId.
   * @param {baja.Ord} ord
   * @returns {baja.Ord}
   */
  function _removeUxBuilderFromViewId(ord) {
    ord = ord.normalize();
    var viewQuery = getViewQuery(ord);
    var viewId = viewQuery && viewQuery.getViewId();
    if (viewId && viewId.endsWith("/uxBuilder")) {
      viewId = viewId.substring(0, viewId.length - "/uxBuilder".length);
      return baja.Ord.make({
        base: ord,
        child: "view:" + viewId
      }).normalize();
    }
    return ord;
  }

  /**
   * @param {baja.Ord} ord
   * @returns {Promise<{selected: boolean, ord: baja.Ord}|undefined>|{selected: boolean, ord: baja.Ord}}
   */
  function toHyperlinkOrd(ord) {
    ord = ord.normalize();
    var viewQuery = getViewQuery(ord);
    var viewId = viewQuery && viewQuery.getViewId();
    var isFile = ord.parse().get('file') !== null;
    if (isFile) {
      if (viewId === "uxBuilder:UxBuilder" || viewId === "pxEditor:PxEditor") {
        return {
          selected: true,
          ord: profileUtils.getOrdWithoutViewQuery(ord)
        };
      }
      return {
        selected: false,
        ord: baja.Ord.make({
          base: ord,
          child: "view:uxBuilder:UxBuilder"
        }).normalize()
      };
    }
    if (viewId && viewId.endsWith("/uxBuilder")) {
      return {
        selected: true,
        ord: _removeUxBuilderFromViewId(ord)
      };
    } else if (viewId) {
      viewId = viewId + "/uxBuilder";
      return {
        selected: false,
        ord: baja.Ord.make({
          base: ord,
          child: "view:" + viewId
        }).normalize()
      };
    }
    return profileUtils.resolveCurrentViewId().then(function (viewId) {
      if (viewId) {
        viewId = viewId + "/uxBuilder";
        return {
          selected: false,
          ord: baja.Ord.make({
            base: ord,
            child: "view:" + viewId
          }).normalize()
        };
      } else {
        return views.listViews(ord).then(function (views) {
          var viewItem = views[0];
          var viewQuery = profileUtils.getViewQuery(baja.Ord.make(viewItem.ord));
          if (viewQuery) {
            var _viewId = viewQuery.getViewId();
            _viewId = _viewId + "/uxBuilder";
            return {
              selected: false,
              ord: baja.Ord.make({
                base: ord,
                child: "view:" + _viewId
              }).normalize()
            };
          }
        });
      }
    });
  }

  /**
   * @param {baja.Ord} ord the ord to hyperlink to
   * @param {boolean} [selected] set to `true` to cause this command to be pre-selected.
   * @class
   * @extends module:bajaux/commands/ToggleCommand
   * @alias module:nmodule/bajaui/rc/util/TogglePxEditModeCommand
   */
  return /*#__PURE__*/function (_ToggleCommand) {
    function TogglePxEditModeCommand(ord, selected) {
      _classCallCheck(this, TogglePxEditModeCommand);
      return _callSuper(this, TogglePxEditModeCommand, [{
        module: 'bajaui',
        lex: 'commands.px.uxBuilderMode',
        selected: selected,
        func: function func() {
          return niagara.env.hyperlink(ord);
        }
      }]);
    }

    /**
     *
     * Makes and adds the command to the Widget's Command group if it should be available.
     * Only one attempt per widget will be made.
     * @param {baja.Ord|String} [ord]
     * @param {module:bajaux/Widget} widget
     * @returns {Promise.<module:nmodule/bajaui/rc/util/TogglePxEditModeCommand|undefined>}
     */
    _inherits(TogglePxEditModeCommand, _ToggleCommand);
    return _createClass(TogglePxEditModeCommand, null, [{
      key: "make",
      value: function make(ord, widget) {
        //exclude the command for PxIncludes and the PxWidget when its being rendered by the UxBuilder
        //(the UxBuilder.js has its own command)
        if (!ord) {
          return Promise.resolve();
        }
        if (widget.properties().getValue('editMode') || widget.properties().getValue('isInclude')) {
          return Promise.resolve();
        }
        ord = baja.Ord.make(ord);
        return Promise.resolve(toHyperlinkOrd(ord)).then(function (_ref) {
          var selected = _ref.selected,
            ord = _ref.ord;
          return profileUtils.isDirectViewIdAvailable(ord).then(function (available) {
            if (available) {
              return new TogglePxEditModeCommand(ord, selected);
            }
          });
        });
      }

      /**
       * Remove the "/uxBuilder" from the ViewId.
       * @param {baja.Ord} ord
       * @returns {baja.Ord}
       */
    }, {
      key: "removeUxBuilderFromViewId",
      value: function removeUxBuilderFromViewId(ord) {
        return _removeUxBuilderFromViewId(ord);
      }
    }]);
  }(ToggleCommand);
});
