function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

define(['baja!', 'baja!bajaui:Layout,bajaui:LayerStatus', 'lex!bajaui', 'log!nmodule.bajaui.rc.rpc.uxBuilder', 'bajaux/model/UxModel', 'jquery', 'Promise', 'underscore', 'nmodule/bajaui/rc/baja/binding/Binding', 'nmodule/bajaui/rc/ux/NullWidget', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/js/rc/csrf/csrfUtil', 'nmodule/webEditors/rc/fe/registry/StationRegistry', 'nmodule/webEditors/rc/wb/profile/profileUtils'], function (baja, types, lexs, log, UxModel, $, Promise, _, Binding, NullWidget, asyncUtils, csrfUtil, StationRegistry, profileUtils) {
  'use strict';

  var compact = _.compact,
    constant = _.constant,
    difference = _.difference,
    flatten = _.flatten,
    memoize = _.memoize,
    uniq = _.uniq;
  var _lexs = _slicedToArray(lexs, 1),
    bajauiLex = _lexs[0];
  var logInfo = log.info.bind(log);
  var doRequire = asyncUtils.doRequire;
  var getOrdWithoutViewQuery = profileUtils.getOrdWithoutViewQuery;
  var KIDS = 'k';
  var NAME = 'n';
  var ORD = 'o';
  var PROPERTIES = 'p';
  var TARGETS = 'ta';
  var TYPE_SPEC = 't';
  var PX_DATA_TYPE_SPEC = 'pxt';
  var VALUE = 'v';
  var SEPARATOR = String.fromCharCode(65533);

  /**
   * Posts the changes of the px file to the servlet to be saved.
   * @param {baja.Ord} baseOrd the ord of the PX file being saved
   * @param {Object} json the structure of the PX file in JSON format
   * @returns {Promise}
   */
  function postToServlet(baseOrd, json) {
    var jsonStr = JSON.stringify(json);
    return Promise.resolve($.ajax('/uxBuilder/ux/data/' + baja.SlotPath.escape(String(baseOrd)), {
      method: 'POST',
      headers: {
        'x-niagara-csrfToken': csrfUtil.getCsrfToken()
      },
      contentType: 'application/json',
      data: jsonStr
    }))["catch"](function (e) {
      //TODO a hack for the HTML formatted error message until something better can be done
      var el = $('<div></div>');
      el.html(e.responseText);
      var errorText = el.find("title")[0].innerText;
      throw new Error(errorText);
    });
  }

  /**
   * API Status: **Private**
   * @exports nmodule/bajaui/rc/rpc/uxBuilder
   */
  var exports = {};
  var lastWbContainerInitialize;

  /**
   * Returns the key used to memoize the servlet calls.
   *
   * @param {baja.Ord} ord
   * @param {boolean} editMode
   * @param {boolean} xml
   * @returns {String}
   */
  function getMemoizeKey(ord, editMode, xml) {
    return String(ord) + SEPARATOR + editMode + xml;
  }

  /**
   * It will check if the Ord is similar without view params, this will help with px file save.
   *
   * @param {baja.Ord} cacheOrd
   * @param {baja.Ord} ord
   * @returns {boolean}
   */
  function isOrdSameWithoutViewParams(ord, cacheOrd) {
    cacheOrd = baja.Ord.make(cacheOrd.split(SEPARATOR)[0]);
    ord = baja.Ord.make(ord);
    return cacheOrd.equals(ord) || getOrdWithoutViewQuery(cacheOrd).equals(getOrdWithoutViewQuery(ord));
  }

  /**
   * @private
   * @param {baja.Ord} ord
   */
  exports.$removeFromServletMemoizeCache = function (ord) {
    if (exports.$retrieveFromServlet.cache) {
      var foundCache = Object.keys(exports.$retrieveFromServlet.cache).filter(function (cacheOrd) {
        return isOrdSameWithoutViewParams(ord, cacheOrd);
      });
      if (foundCache.length) {
        foundCache.forEach(function (cache) {
          return delete exports.$retrieveFromServlet.cache[cache];
        });
      }
    }
  };

  /**
   * @param {string|baja.Ord} ord
   * @param {boolean} [editMode=false] if the calling program is in edit mode or not
   * @param {boolean} [xml=false] set to true to return the xml data instead of json.
   * @returns {Promise.<module:nmodule/bajaui/rc/rpc/uxBuilder~ModelInfo|String>} a ModelInfo will be resolved when xml is false,
   * and a string will be resolved when xml is true.
   */
  exports.fromPxOrd = function (ord) {
    var editMode = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    var xml = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    return log.timing(function () {
      //clear cache if a WebWidget has been reused incase a px page has been changed
      if (window.$wbContainerInitialize && lastWbContainerInitialize !== window.$wbContainerInitialize) {
        lastWbContainerInitialize = window.$wbContainerInitialize;
        exports.$retrieveFromServlet.cache = {};
      }
      return exports.$retrieveFromServlet(ord, editMode, xml);
    }, 'FINE', 'Retrieved UxBuilderServlet data from {} in {}ms', ord).then(function (contents) {
      return log.timing(function () {
        return xml ? contents : exports.$pxJsonToModelInfo(contents, editMode);
      }, 'FINE', 'Converted UxBuilderServlet data from {} to UxModel in {}ms', ord);
    });
  };

  /**
   * @private
   * @param {string|baja.Ord} ord
   * @param {boolean} [editMode]
   * @param {boolean} [xml]
   * @returns {Promise.<object>}
   */
  exports.$retrieveFromServlet = memoize(function (ord, editMode, xml) {
    var type = xml ? 'xml' : 'data';
    return $.get('/uxBuilder/ux/' + type + '/' + baja.SlotPath.escape(String(ord)) + (editMode ? '?editMode=' + editMode : ''))["catch"](function (err) {
      var msg = err.responseText || bajauiLex.get('uxBuilderServlet.couldNotRetrievePxData');
      throw new Error(msg);
    });
  }, getMemoizeKey);

  /**
   * @private
   * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxDocumentEncoding} json
   * @param {boolean} editMode
   * @returns {Promise.<module:nmodule/bajaui/rc/rpc/uxBuilder~ModelInfo>}
   */
  exports.$pxJsonToModelInfo = function (_ref, editMode) {
    var _ref$pxReadonly = _ref.pxReadonly,
      pxReadonly = _ref$pxReadonly === void 0 ? false : _ref$pxReadonly,
      props = _ref.props,
      layers = _ref.layers,
      content = _ref.content,
      _ref$typeMap = _ref.typeMap,
      typeMap = _ref$typeMap === void 0 ? {} : _ref$typeMap;
    var types = scanForTypes(content);
    if (props) {
      types = types.concat(flatten(props.map(scanForTypes)));
    }
    types = difference(uniq(types), getWidgetTypeSpecs(typeMap));
    return baja.importTypes(types).then(function () {
      return toUxModelData(content, typeMap, editMode, true);
    }).then(function (modelData) {
      return Promise.all([UxModel.make(modelData), props && decodePxProperties(props), layers && decodeLayers(layers)]).then(function (_ref2) {
        var _ref3 = _slicedToArray(_ref2, 3),
          uxModel = _ref3[0],
          pxProperties = _ref3[1],
          layers = _ref3[2];
        return {
          pxReadonly: pxReadonly,
          uxModel: uxModel,
          modelData: modelData,
          pxProperties: pxProperties || {},
          layers: layers || []
        };
      });
    });
  };

  /**
   * Saves the structure to a PX file
   * @param {Object} obj the Object Literal for the method's arguments
   * @param {baja.Ord} obj.baseOrd the ord of the PX file to be saved
   * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} obj.uxModelTreeNode the tree node representing the structure to be saved.
   * @param {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxLayer>} obj.pxLayers the updated layers of the PX file
   * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxProperties} obj.pxProperties the updated Px properties of the PX file
   * @param {boolean} obj.preserveIdentities
   * @returns {Promise}
   */
  exports.save = function (_ref4) {
    var baseOrd = _ref4.baseOrd,
      uxModelTreeNode = _ref4.uxModelTreeNode,
      pxLayers = _ref4.pxLayers,
      pxProperties = _ref4.pxProperties,
      preserveIdentities = _ref4.preserveIdentities;
    return uxModelTreeNode.encodeToJson().then(function (content) {
      var json = {};
      json.content = content;
      json.layers = encodeLayers(pxLayers);
      json.props = encodeProperties(pxProperties);
      json.preserveIdentities = preserveIdentities;
      return log.timing(function () {
        return postToServlet(baseOrd, json);
      }, 'FINE', 'Saved changes to {} in {}ms', baseOrd);
    });
  };

  /**
   * Decode the supplied properties into the metaProperties information
   * @param {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding>} properties
   * @returns {Promise.<module:nmodule/bajaui/rc/rpc/uxBuilder~MetaProperties>} resolves to an object that holds all the information about the
   * properties of a widget
   * @since Niagara 4.15
   */
  exports.decodeMetaProperties = function (properties) {
    var promises = [];
    var metaProperties = {};
    properties.forEach(function (property) {
      promises.push(decodeValue(property).then(function (value) {
        var name = property.n,
          flags = property.f,
          typeSpec = property.t,
          facets = property.ft;
        var readonly = !!(flags && flags.includes('r'));
        var hidden = !!(flags && flags.includes('h'));
        var _transient = !!(flags && flags.includes('t'));
        var userDefined3 = !!(flags && flags.includes('3'));
        metaProperties[name] = {
          name: name,
          value: value,
          typeSpec: typeSpec,
          metadata: facets,
          readonly: readonly,
          hidden: hidden,
          "transient": _transient,
          userDefined3: userDefined3
        };
      }));
    });
    return Promise.all(promises).then(function () {
      if (metaProperties.enabled === undefined) {
        metaProperties.enabled = {
          name: 'enabled',
          value: true,
          typeSpec: 'baja:Boolean'
        };
      }
      if (metaProperties.visible === undefined) {
        metaProperties.visible = {
          name: 'visible',
          value: true,
          typeSpec: 'baja:Boolean'
        };
      }
      if (metaProperties.layout === undefined) {
        metaProperties.layout = {
          name: 'layout',
          value: baja.$('bajaui:Layout'),
          typeSpec: 'bajaui:Layout'
        };
      }
      return metaProperties;
    });
  };

  /**
   * Encodes the layer information correctly
   * @param {Array<Object>}pxLayers the layers that need to be encoded
   * @return {Array<Object>} an array of objects containing the name and the bson encode status of the layers
   */
  function encodeLayers(pxLayers) {
    var jsonLayers = [];
    pxLayers.forEach(function (layer) {
      var jsonLayer = {};
      jsonLayer.n = layer.name;
      jsonLayer.status = layer.status.encodeToString();
      jsonLayers.push(jsonLayer);
    });
    return jsonLayers;
  }

  /**
   * Encodes the PxProperties correctly
   * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxProperties} pxProperties the PxProperties that have been defined.
   * @returns {Array<Object>} an array of objects containing the encoded pxProperties
   */
  function encodeProperties(pxProperties) {
    var encodedProperties = [];
    Object.keys(pxProperties).forEach(function (key) {
      var encodedProperty = {};
      var encodedTargets = [];
      var property = pxProperties[key];
      var value = property.value;
      var targets = property.targets;
      targets.forEach(function (target) {
        encodedTargets.push({
          o: new baja.SlotPath(target).toString()
        });
      });
      encodedProperty.n = key;
      encodedProperty.t = value.getType().getTypeSpec();
      encodedProperty.v = baja.bson.encodeValue(value);
      encodedProperty.ta = encodedTargets;
      encodedProperties.push(encodedProperty);
    });
    return encodedProperties;
  }

  /**
   * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding} widgetNode
   * @param {object} typeMap
   * @param {boolean} editMode
   * @param {boolean} root is this the root node of the PX page
   * @returns {Promise.<object>} resolves to a config object used to construct a `UxModel`
   */
  function toUxModelData(widgetNode, typeMap, editMode, root) {
    var name = widgetNode[NAME],
      _widgetNode$KIDS = widgetNode[KIDS],
      kids = _widgetNode$KIDS === void 0 ? [] : _widgetNode$KIDS,
      _widgetNode$PROPERTIE = widgetNode[PROPERTIES],
      properties = _widgetNode$PROPERTIE === void 0 ? [] : _widgetNode$PROPERTIE,
      typeSpec = widgetNode[TYPE_SPEC],
      pxDataTypeSpec = widgetNode[PX_DATA_TYPE_SPEC];
    var metadata = {};
    var props = properties.concat(kids.filter(isSimple)).concat(kids.filter(isStruct));
    return Promise.all([resolveJsWidget(typeSpec, typeMap), exports.decodeMetaProperties(props), decodeKids(kids, typeMap, editMode)]).then(function (_ref5) {
      var _ref6 = _slicedToArray(_ref5, 3),
        type = _ref6[0],
        metaProperties = _ref6[1],
        _ref6$ = _ref6[2],
        widgets = _ref6$.widgets,
        bindings = _ref6$.bindings;
      var properties = decodeWidgetProperties(metaProperties);
      if (editMode && (!root || typeSpec !== 'bajaui:NullWidget')) {
        //When in editMode (unless it is the root node, and the incoming typeSpec != `bajaui:NullWidget`)
        //the metadata typeSpec and pxDataTypeSpec is set here so that the displayName, icon, and
        //widget properties can be pulled from that Type. The NullWidget Type doesn't have the proper
        //information needed to match the PxEditor's Widget Tree for the original type.
        metadata.typeSpec = typeSpec;
        metadata.pxDataTypeSpec = pxDataTypeSpec || typeSpec;
      }
      return {
        name: name,
        type: type,
        properties: properties,
        kids: widgets,
        bindings: bindings,
        metadata: metadata,
        metaProperties: metaProperties
      };
    });
  }

  /**
   * Decode child components of a Px node. Widgets will be decoded to UxModel
   * children, and bindings will be decoded to their actual Component instances.
   *
   * @param {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding>} kids
   * @param {object} typeMap
   * @param {boolean} editMode
   * @returns {{ widgets: Array.<object>, bindings: Array.<baja.Component> }}
   */
  function decodeKids(kids, typeMap, editMode) {
    var widgets = [];
    var bindings = [];
    // we must do these in sequential order so slot order is respected.
    return kids.reduce(function (prom, kid) {
      return prom.then(function () {
        var typeSpec = kid[TYPE_SPEC];
        var type = baja.lt(kid[TYPE_SPEC]);
        var mapObj = typeMap[typeSpec];
        if (mapObj && mapObj.w || type && type.is('bajaui:Widget')) {
          return toUxModelData(kid, typeMap, editMode, false).then(function (obj) {
            return widgets.push(obj);
          });
        }
        if (mapObj && mapObj.b || type && type.is('bajaui:Binding')) {
          return decodeValue(kid).then(function (comp) {
            if (comp instanceof Binding) {
              comp.getName = constant(kid.n);
              bindings.push(comp);
            }
          });
        }
      });
    }, Promise.resolve()).then(function () {
      return {
        widgets: widgets,
        bindings: bindings
      };
    });
  }

  /**
   * @param {string} typeSpec
   * @param {object} typeMap
   * @returns {Promise.<Function>} resolves to the appropriate Widget constructor
   */
  function resolveJsWidget(typeSpec, typeMap) {
    var id = typeMap[typeSpec];
    return Promise.resolve(id && doRequire(id.js, id.dg)).then(function (Widget) {
      if (Widget) {
        return Widget;
      }
      return StationRegistry.getInstance().resolveFirst(typeSpec, {
        hasAll: ['bajaux:IJavaScriptWidget']
      });
    }).then(function (Widget) {
      if (!Widget) {
        throw new Error('No bajaux:IJavaScriptWidget agent found for ' + typeSpec);
      }
      if (Widget === NullWidget) {
        logInfo('No bajaux:IJavaScriptWidget agent found for ' + typeSpec);
      }
      return Widget;
    });
  }

  /**
   * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~MetaProperties} properties
   * @returns {object} resolves to a properties object to be applied to a widget
   */
  function decodeWidgetProperties(properties) {
    var props = {};
    Object.keys(properties).forEach(function (key) {
      props[key] = properties[key].value;
    });
    return props;
  }

  /**
   * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding} valueNode
   * @returns {Promise.<baja.Value>}
   */
  function decodeValue(valueNode) {
    return isSimple(valueNode) ? decodeSimple(valueNode) : decodeComplex(valueNode);
  }

  /**
   * @param {baja.Value} valueNode
   * @returns {baja.TypeSpec}
   */
  function getTypeSpecFromValueNode(valueNode) {
    var typeSpec = valueNode[TYPE_SPEC];
    return baja.lt(typeSpec);
  }

  /**
   * @param {baja.Value} valueNode
   * @returns {boolean}
   */
  function isSimple(valueNode) {
    var type = getTypeSpecFromValueNode(valueNode);
    return type && type.is('baja:Simple');
  }

  /**
   * @param {baja.Value} valueNode
   * @returns {boolean}
   */
  function isStruct(valueNode) {
    var type = getTypeSpecFromValueNode(valueNode);
    return type && type.is('baja:Struct');
  }

  /**
   * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding} complexNode
   * @returns {Promise.<baja.Complex>}
   */
  function decodeComplex(complexNode) {
    var _complexNode$KIDS = complexNode[KIDS],
      kids = _complexNode$KIDS === void 0 ? [] : _complexNode$KIDS,
      _complexNode$PROPERTI = complexNode[PROPERTIES],
      properties = _complexNode$PROPERTI === void 0 ? [] : _complexNode$PROPERTI,
      typeSpec = complexNode[TYPE_SPEC];
    var obj = {};
    return kids.concat(properties).reduce(function (prom, valueNode) {
      return prom.then(function () {
        return decodeValue(valueNode);
      }).then(function (value) {
        obj[valueNode[NAME]] = value;
      });
    }, Promise.resolve()).then(function () {
      return baja.$(typeSpec, obj);
    });
  }

  /**
   * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding} simpleNode
   * @returns {Promise.<baja.Simple>}
   */
  function decodeSimple(_ref7) {
    var value = _ref7[VALUE],
      typeSpec = _ref7[TYPE_SPEC];
    return Promise.resolve(baja.$(typeSpec).decodeAsync(value));
  }

  /**
   * @param {Array.<Object>} props
   * @returns {Promise.<Object>} resolves to the property values with an Object that maps the
   * properties name to an object containing the type / targets.
   */
  function decodePxProperties(props) {
    return Promise.all(props.map(function (prop) {
      var name = prop[NAME],
        typeSpec = prop[TYPE_SPEC],
        value = prop[VALUE],
        targets = prop[TARGETS];
      return Promise.all([name, baja.$(typeSpec).decodeAsync(value), targets.map(function (_ref8) {
        var ord = _ref8[ORD];
        return ord.replace(/^slot:/, '').split('/');
      })]);
    })).then(function (resultVals) {
      var result = {};
      resultVals.forEach(function (_ref9) {
        var _ref10 = _slicedToArray(_ref9, 3),
          name = _ref10[0],
          value = _ref10[1],
          targets = _ref10[2];
        result[name] = {
          value: value,
          targets: targets
        };
      });
      return result;
    });
  }

  /**
   * Decodes the layer information.
   * @param {Array.<Object>} layers
   * @returns {Promise.<Array.<Object>>} PxLayer(s) name and status values in an object.
   */
  function decodeLayers(layers) {
    return Promise.resolve(layers && layers.map(function (layer) {
      return {
        name: layer.n,
        status: baja.$('bajaui:LayerStatus', layer.status)
      };
    }));
  }

  /**
   * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding} valueNode
   * @returns {Array.<string>} all type specs found in the value node
   */
  function scanForTypes(valueNode) {
    var typeSpec = valueNode[TYPE_SPEC],
      _valueNode$PROPERTIES = valueNode[PROPERTIES],
      properties = _valueNode$PROPERTIES === void 0 ? [] : _valueNode$PROPERTIES,
      _valueNode$KIDS = valueNode[KIDS],
      kids = _valueNode$KIDS === void 0 ? [] : _valueNode$KIDS;
    return compact(flatten([typeSpec, properties.map(scanForTypes), kids.map(scanForTypes)]));
  }

  /**
   * @param {Object} typeMap
   * @returns {Array.<string>}
   */
  function getWidgetTypeSpecs(typeMap) {
    return Object.keys(typeMap).filter(function (typeSpec) {
      var obj = typeMap[typeSpec];
      return obj && obj.w;
    });
  }

  /**
   * Encoding of a Px document as provided by `UxBuilderServlet`.
   *
   * @typedef {object} module:nmodule/bajaui/rc/rpc/uxBuilder~PxDocumentEncoding
   * @property {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxPropertyEncoding>} [props] - encoding of Px properties
   * @property {module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding} content - encoding of the root widget
   * @property {object} typeMap - mapping of type specs to RequireJS info `module:nmodule/bajaui/rc/rpc/uxBuilder~RequireJSEncoding`
   * @property {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxLayerEncoding>} [layers] - encoding of Px Layers
   */

  /**
   * Encoding of a RequireJS info provided by `UxBuilderServlet`.
   *
   * @typedef {object} module:nmodule/bajaui/rc/rpc/uxBuilder~RequireJSEncoding
   * @property {String} [js] - encoding of RequireJS id
   * @property {Array.<Array.<String>>} [dg] - the RequireJS IDs necessary to preload before loading this JavaScript resource
   */

  /**
   * Encoding of a Px Property in a Px file.
   *
   * @typedef {object} module:nmodule/bajaui/rc/rpc/uxBuilder~PxPropertyEncoding
   * @property {string} n - Px Property name
   * @property {string} t - Px Property type spec
   * @property {string} v - string encoding of value
   * @property {Array.<{ o: string }>} ta - array of ORDs (SlotPaths) this property maps to
   */

  /**
   * Encoding of a PxLayer in a Px file, as sent down as raw JSON from the UxBuilderServlet.
   *
   * @private
   * @typedef {object} module:nmodule/bajaui/rc/rpc/uxBuilder~PxLayerEncoding
   * @property {string} n - PxLayer name
   * @property {string} status - PxLayer status
   */

  /**
   * Encoding of a PxLayer in a Px file.
   *
   * @typedef {object} module:nmodule/bajaui/rc/rpc/uxBuilder~PxLayer
   * @property {string} name - PxLayer name
   * @property {baja.FrozenEnum} status - PxLayer status (`bajaui:LayerStatus`)
   */

  /**
   * Encoding of a Baja value in a Px file.
   *
   * @typedef {object} module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding
   * @property {string} [n] - component name (never present for root widget)
   * @property {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding>} p  - component properties
   * @property {string} t - widget type spec
   * @property {string} [pxt] - the data type of the widget contained in a wrapper widget, used by the UxBuilder
   * to get the proper displayName, navIcon, and properties
   * @property {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding>} k - encoding of child components
   */

  /**
   * Model information extracted from a px Ord will be represented as ModelInfo.
   *
   * @typedef module:nmodule/bajaui/rc/rpc/uxBuilder~ModelInfo
   * @property {module:bajaux/model/UxModel} uxModel
   * @property {Object.<string, module:nmodule/bajaui/rc/rpc/uxBuilder~PxProperty>} pxProperties
   * @property {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxLayer>} layers
   */

  /**
   * Encoding of a PxProperty.
   *
   * @typedef {object} module:nmodule/bajaui/rc/rpc/uxBuilder~PxProperty
   * @property {baja.Value} value the value of the property
   * @property {Array.<Array.<String>>} targets array of slot paths leading to the widgets linked to
   * this PxProperty
   */

  /**
   * PxProperties encoded as a map, from the PxProperty name to the PxProperty encoding.
   * @typedef {Object.<string, module:nmodule/bajaui/rc/rpc/uxBuilder~PxProperty>} module:nmodule/bajaui/rc/rpc/uxBuilder~PxProperties
   */

  /**
   * The meta information of the properties for a Widget, encoded by the name of the property.  The
   * key to the property is the name of the property.
   *
   * @typedef {object} module:nmodule/bajaui/rc/rpc/uxBuilder~MetaProperties
   * @property {Object.<string, module:nmodule/bajaui/rc/rpc/uxBuilder~MetaProperty>}
   */

  /**
   * The meta information about a property
   * @typedef {object} module:nmodule/bajaui/rc/rpc/uxBuilder~MetaProperty
   * @property {string} name the name of the property
   * @property {baja.Value} value the value of the property
   * @property {baja.Value} [defaultValue] the default value of the property
   * @property {string} typeSpec the type spec for the property
   * @property {string} [moduleName] the name of the module
   * @property {object} [metadata] the metadata for the property (holds facet information)
   * @property {boolean} hidden property should be hidden
   * @property {boolean} readonly property is readonly
   * @property {boolean} transient property is transient
   * @property {boolean} userDefined3 user defined flag 3.  Properties of the content of a WebWidget
   * having this set to true, but this being true does not mean the property came from the content of a WebWidget.
   * @property {boolean} webWidgetProperty property was created from the content of a WebWidget
   */

  return exports;
});
