function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/baja/binding/LoadBinding
 */
define(['baja!', 'Promise', 'underscore', 'nmodule/bajaui/rc/baja/binding/Binding'], function (baja, Promise, _, Binding) {
  'use strict';

  /**
   * Abstract bajaux implementation of a generic Binding which calls Load if it's the first LoadBinding on the Widget.
   * This can be used for Bindings which need to call `Widget.load()` on their WebWidget like `bajaui:TableBinding`.
   *
   * This class is made abstract since Niagara 4.15 to handle type confusion and overwrite,
   * when type extensions share the same parent constructor.
   *
   * @abstract
   * @class
   * @alias module:nmodule/bajaui/rc/baja/binding/LoadBinding
   * @extends module:nmodule/bajaui/rc/baja/binding/Binding
   */
  return /*#__PURE__*/function (_Binding) {
    function LoadBinding() {
      _classCallCheck(this, LoadBinding);
      return _callSuper(this, LoadBinding, arguments);
    }
    _inherits(LoadBinding, _Binding);
    return _createClass(LoadBinding, [{
      key: "$isPrimaryBinding",
      value:
      /**
       * Determines whether this binding is the first bound LoadBinding on the parent.
       * If the Widget has `ICollectionSupport`, then use the first bound LoadBounding as the primary
       * so that there is a main Widget.load Callback for the other LoadBindings to run after.
       *
       * @private
       * @returns {boolean}
       */
      function $isPrimaryBinding() {
        var hasCollectionSupport = this.$hasICollectionSupport();
        var firstLoadBinding = this.getBindingList().getBindings().filter(function (b) {
          return b instanceof LoadBinding && (!hasCollectionSupport || b.isBound());
        })[0];
        return firstLoadBinding === this;
      }

      /**
       *
       * @private
       * @returns {boolean}
       */
    }, {
      key: "$hasICollectionSupport",
      value: function $hasICollectionSupport() {
        var widget = this.getWidget();
        return widget && _.isFunction(widget.$hasICollectionSupport) && widget.$hasICollectionSupport();
      }

      /**
       * Determines whether or not this binding is degraded
       * @returns {boolean} true if degraded, false if not.
       */
    }, {
      key: "isDegraded",
      value: function isDegraded() {
        return !this.isBound();
      }

      /**
       * Updates the value in the bound widget if this is the primary LoadBinding
       * and the value is different than the value loaded in.
       * Secondary LoadBindings will wait for the primary load to finish,
       * then each secondary LoadBinding will resolve and load (one at a time).
       *
       * @returns {Promise} resolves if target not changed or value loaded
       */
    }, {
      key: "targetChanged",
      value: function targetChanged() {
        var widget = this.getWidget();
        var target = this.getOrdTarget();
        if (!this.isBound() || widget.isDestroyed()) {
          return Promise.resolve();
        }
        var targetValue = target.getObject();
        var isTargetValueDifferent = targetValue !== widget.value();
        var isPrimary = this.$isPrimaryBinding();
        if (!isPrimary && this.$hasICollectionSupport() && _.isFunction(widget.$extraLoad) && !this.$secondaryLoadSetup) {
          this.$secondaryLoadSetup = true;
          return widget.$extraLoad(target);
        }
        if (!isPrimary || !isTargetValueDifferent) {
          return Promise.resolve();
        }
        return widget.load(targetValue);
      }

      /**
       * Saves the widget's current value if this is the primary LoadBinding and
       * the widget has been modified.
       * @returns {Promise} resolves on save or if no save operation needed
       */
    }, {
      key: "save",
      value: function save() {
        var widget = this.getWidget(),
          isWidgetSaveOk = widget.isModified() && this.$isPrimaryBinding();
        return Promise.resolve(isWidgetSaveOk && widget.save());
      }
    }]);
  }(Binding);
});
