function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 */

/**
 * @private
 * @module nmodule/bajaui/rc/baja/Layout
 */

define(['baja!'], function (baja) {
  'use strict';

  /** @alias Layout.ABS */
  var ABS = 0;

  /** @alias Layout.PERCENT */
  var PERCENT = 1;

  /** @alias Layout.PREF */
  var PREF = 2;

  /**
   * Encodes to a string format a portion of the parameter values.
   * @private
   * @param {number} value
   * @param {number} unit
   * @param {boolean} [canBePref=false]
   * @throws {Error} if unable to encode provided parameters.
   * @returns {string}
   */
  function encodeLayoutStringPart(value, unit) {
    var canBePref = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    if (unit === ABS) {
      return String(value);
    } else if (unit === PERCENT) {
      return value + "%";
    } else if (unit === PREF && canBePref) {
      return "pref";
    } else {
      throw new Error("String part value not valid.");
    }
  }

  /**
   * Parses an item of an encoded string to debug information.
   * Only allows for pref format if pref is true.
   *
   * @private
   * @param {String} str Examples: 100, 100%, pref
   *
   * @param {boolean} [canBePref=false]
   * @throws {Error} if unable to decode provided format.
   * @returns {Object} an object with numeric <code>value<code> and <code>unit</code> properties.
   */
  function decodeLayoutStringPart(str) {
    var canBePref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    var data = {};
    if (canBePref && str === "pref") {
      data.unit = PREF;
    } else if (isNaN(str)) {
      if (str[str.length - 1] === "%") {
        var testNumber = str.substr(0, str.length - 1);
        if (isNaN(testNumber)) {
          throw new Error("Invalid format when decoding string part " + str);
        } else {
          data.value = parseFloat(testNumber);
          data.unit = PERCENT;
        }
      } else {
        throw new Error("Invalid format when decoding string part " + str);
      }
    } else {
      data.value = parseFloat(str);
      data.unit = ABS;
    }
    return data;
  }
  var FILL_VALUES = {
    x: 0,
    y: 0,
    w: 100,
    h: 100,
    xUnit: ABS,
    yUnit: ABS,
    wUnit: PERCENT,
    hUnit: PERCENT
  };

  /**
   * Representation of a `bajaui:Layout`.
   * @alias module:nmodule/bajaui/rc/baja/Layout
   */
  var Layout = /*#__PURE__*/function (_baja$Simple) {
    /**
     * Creates a {@link:module:nmodule/bajaui/rc/baja/Layout} object.
     *
     * @param {module:nmodule/bajaui/rc/baja/Layout~Rectangle | null} obj an obj with params listed below. Defaults to fill
     * object if no parameters given.
     * @param {boolean} [obj.fill]
     * @param {Layout.ABS | Layout.PERCENT} [obj.xUnit] x unit type
     * @param {Layout.ABS | Layout.PERCENT} [obj.yUnit] y unit type
     * @param {Layout.ABS | Layout.PERCENT | Layout.PREF} [obj.wUnit] width
     * unit type
     * @param {Layout.ABS | Layout.PERCENT | Layout.PREF} [obj.hUnit] height unit
     * type
     */
    function Layout() {
      var _this;
      var obj = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      _classCallCheck(this, Layout);
      _this = _callSuper(this, Layout);
      if (!obj || obj.fill) {
        obj = FILL_VALUES;
      }
      var x = obj.x || 0;
      var y = obj.y || 0;
      var w = obj.w || 0;
      var h = obj.h || 0;
      var xUnit = obj.xUnit || ABS;
      var yUnit = obj.yUnit || ABS;
      var wUnit = obj.wUnit || ABS;
      var hUnit = obj.hUnit || ABS;
      if (!isXY(xUnit)) {
        throw new Error('invalid xUnit');
      }
      if (!isXY(yUnit)) {
        throw new Error('invalid yUnit');
      }
      if (!isWH(wUnit)) {
        throw new Error('invalid wUnit');
      }
      if (!isWH(hUnit)) {
        throw new Error('invalid hUnit');
      }
      _this.$x = x;
      _this.$y = y;
      _this.$w = w;
      _this.$h = h;
      _this.$xUnit = xUnit;
      _this.$yUnit = yUnit;
      _this.$wUnit = wUnit;
      _this.$hUnit = hUnit;
      return _this;
    }

    /**
     * Creates and returns a new Layout object.
     *
     * Refer to constructor for obj description.
     *
     * @param {object|null} obj
     * @returns {Layout}
     */
    _inherits(Layout, _baja$Simple);
    return _createClass(Layout, [{
      key: "make",
      value: function make() {
        return Layout.make.apply(Layout, arguments);
      }

      /**
       * Creates and returns a new Layout object with absolute fields as type.
       *
       * @param {number} x the x position value
       * @param {number} y the y position value
       * @param {number} w the width value
       * @param {number} h the height value
       * @returns {module:nmodule/bajaui/rc/baja/Layout}
       */
    }, {
      key: "getX",
      value:
      /**
       * Gets the current x value
       * @returns {number}
       */
      function getX() {
        return this.$x;
      }

      /**
       * Gets the current y value
       * @returns {number}
       */
    }, {
      key: "getY",
      value: function getY() {
        return this.$y;
      }

      /**
       * Gets the current x unit
       * @returns { Layout.ABS | Layout.PERCENT }
       */
    }, {
      key: "getXUnit",
      value: function getXUnit() {
        return this.$xUnit;
      }

      /**
       * Gets the current y unit
       * @returns { Layout.ABS | Layout.PERCENT }
       */
    }, {
      key: "getYUnit",
      value: function getYUnit() {
        return this.$yUnit;
      }

      /**
       * Gets the current width value
       * @returns {number}
       */
    }, {
      key: "getWidth",
      value: function getWidth() {
        return this.$w;
      }

      /**
       * Gets the current height value
       * @returns {number}
       */
    }, {
      key: "getHeight",
      value: function getHeight() {
        return this.$h;
      }

      /**
       * Gets the current width unit
       * @returns { Layout.ABS | Layout.PERCENT | Layout.PREF }
       */
    }, {
      key: "getWidthUnit",
      value: function getWidthUnit() {
        return this.$wUnit;
      }

      /**
       * Gets the current width unit
       * @returns { Layout.ABS | Layout.PERCENT | Layout.PREF }
       */
    }, {
      key: "getHeightUnit",
      value: function getHeightUnit() {
        return this.$hUnit;
      }

      /**
       * @param {number} dx
       * @param {number} dy
       * @returns {module:nmodule/bajaui/rc/baja/Layout} layout with x/y transposed by the input
       * values. They will not be transposed if their corresponding units are not `Layout.ABS`.
       * @since Niagara 4.15
       */
    }, {
      key: "translate",
      value: function translate(dx, dy) {
        var clone = this.$clone();
        if (clone.$xUnit === ABS) {
          clone.$x += dx;
        }
        if (clone.$yUnit === ABS) {
          clone.$y += dy;
        }
        return clone;
      }

      /**
       * @param {number} x
       * @param {number} y
       * @returns {module:nmodule/bajaui/rc/baja/Layout} layout with x/y set to the specified numbers,
       * and x/y units set to `Layout.ABS`.
       * @since Niagara 4.15
       */
    }, {
      key: "moveTo",
      value: function moveTo(x, y) {
        var clone = this.$clone();
        clone.$x = x;
        clone.$xUnit = ABS;
        clone.$y = y;
        clone.$yUnit = ABS;
        return clone;
      }

      /**
       * @private
       * @returns {module:nmodule/bajaui/rc/baja/Layout}
       */
    }, {
      key: "$clone",
      value: function $clone() {
        if (this === Layout.FILL) {
          return new Layout();
        }
        return this.decodeFromString(this.encodeToString());
      }

      /**
       * Decodes a `Layout` from a string.
       *
       * @param {String} str
       * @returns {Layout}
       */
    }, {
      key: "decodeFromString",
      value: function decodeFromString(str) {
        if (str === "fill") {
          return Layout.FILL;
        } else {
          var parts = str.split(",");
          var xData = decodeLayoutStringPart(parts[0]);
          var yData = decodeLayoutStringPart(parts[1]);
          var widthData = decodeLayoutStringPart(parts[2], true);
          var heightData = decodeLayoutStringPart(parts[3], true);
          return new Layout({
            x: xData.value,
            xUnit: xData.unit,
            y: yData.value,
            yUnit: yData.unit,
            w: widthData.value,
            wUnit: widthData.unit,
            h: heightData.value,
            hUnit: heightData.unit
          });
        }
      }

      /**
       * Encodes this `Layout` to a string.
       *
       * @returns {String}
       */
    }, {
      key: "encodeToString",
      value: function encodeToString() {
        if (this === Layout.FILL) {
          return "fill";
        } else {
          var xPart = encodeLayoutStringPart(this.getX(), this.getXUnit()) + ",";
          var yPart = encodeLayoutStringPart(this.getY(), this.getYUnit()) + ",";
          var widthPart = encodeLayoutStringPart(this.getWidth(), this.getWidthUnit(), true) + ",";
          var heightPart = encodeLayoutStringPart(this.getHeight(), this.getHeightUnit(), true);
          return xPart + yPart + widthPart + heightPart;
        }
      }

      /**
       * Returns a CSS object with `left`, `top`, `width` and `height` properties.
       * `width` and `height` will only be included if they are not set to `PREF`.
       * @returns {object}
       */
    }, {
      key: "toCss",
      value: function toCss() {
        var css = {
          left: this.getX() + (this.getXUnit() === ABS ? 'px' : '%'),
          top: this.getY() + (this.getYUnit() === ABS ? 'px' : '%'),
          width: '',
          height: ''
        };
        var widthUnit = this.getWidthUnit();
        var heightUnit = this.getHeightUnit();
        if (widthUnit !== PREF) {
          css.width = this.getWidth() + (widthUnit === ABS ? 'px' : '%');
        }
        if (heightUnit !== PREF) {
          css.height = this.getHeight() + (heightUnit === ABS ? 'px' : '%');
        }
        return css;
      }
    }], [{
      key: "make",
      value: function make(obj) {
        if (!obj || obj.fill) {
          return Layout.FILL;
        }
        return new Layout(obj);
      }
    }, {
      key: "makeAbs",
      value: function makeAbs(x, y, w, h) {
        return new Layout({
          x: x,
          y: y,
          w: w,
          h: h,
          xUnit: ABS,
          yUnit: ABS,
          wUnit: ABS,
          hUnit: ABS
        });
      }
    }]);
  }(baja.Simple);
  Layout.ABS = ABS;
  Layout.PERCENT = PERCENT;
  Layout.PREF = PREF;
  Layout.FILL = new Layout();
  Layout.DEFAULT = Layout.FILL;
  function isXY(n) {
    return n === ABS || n === PERCENT;
  }
  function isWH(n) {
    return n === ABS || n === PERCENT || n === PREF;
  }
  return Layout;
});

/**
 * Structure representing a rectangle. The values can be in any units. `Layout` itself accepts
 * additional information to specify the units.
 *
 * @typedef module:nmodule/bajaui/rc/baja/Layout~Rectangle
 * @property {number} x x position
 * @property {number} y y position
 * @property {number} w width
 * @property {number} h height
 */
