function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module  module:nmodule/xprotect/rc/xprotect/XProtectVideoStream
 */
define(['lex!videoDriver', 'log!nmodule.xprotect.rc.xprotect.XProtectVideoStream', 'underscore', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/videoDriver/rc/fe/playback/PlaybackMixin', 'nmodule/videoDriver/rc/fe/utils/videoDriverUtils', 'nmodule/videoDriver/rc/live/VideoFeedMixin', 'nmodule/videoDriver/rc/live/stream/StreamConfigurationMixin', 'nmodule/videoDriver/rc/rpc/rpc', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/xprotect/rc/xprotect/XProtectCamera', 'nmodule/xprotect/rc/xprotect/XProtectCameraSession', 'nmodule/xprotect/rc/xprotect/XProtectSession', 'nmodule/xprotect/rc/xprotect/xprotectUtils', 'css!nmodule/xprotect/rc/xprotect'], function (lexs, log, _, asyncUtils, PlaybackMixin, videoDriverUtils, VideoFeedMixin, StreamConfigurationMixin, rpc, BaseEditor, XProtectCamera, XProtectCameraSession, XProtectSession, xprotectUtils) {
  "use strict";

  var _lexs = _slicedToArray(lexs, 1),
    videoDriverLex = _lexs[0];
  var logFine = log.fine.bind(log);
  var logSevere = log.severe.bind(log);
  var CONNECTION_TIMEOUT_MILLIS = 10000;
  var isString = _.isString;
  var fitRatio = videoDriverUtils.fitRatio,
    getPlaybackSpeedFactor = videoDriverUtils.getPlaybackSpeedFactor;
  var getFps = xprotectUtils.getFps,
    getJpegCompressionLevel = xprotectUtils.getJpegCompressionLevel,
    getPixelMultiplier = xprotectUtils.getPixelMultiplier;
  var BANDWIDTH_DISPLAY_CHANGE_EVENT = StreamConfigurationMixin.BANDWIDTH_DISPLAY_CHANGE_EVENT;
  var CONNECTION_STATUS_CHANGED_EVENT = VideoFeedMixin.CONNECTION_STATUS_CHANGED_EVENT,
    STREAM_DATA_RECEIVED_EVENT = VideoFeedMixin.STREAM_DATA_RECEIVED_EVENT,
    TIMESTAMP_CHANGED_EVENT = VideoFeedMixin.TIMESTAMP_CHANGED_EVENT;
  var tpl = function tpl() {
    return " <canvas class=\"canvasElement videoInsert\" />";
  };

  /**
   * Bajaux Widget for LiveVideo via XPMobileSDK
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @mixes module:nmodule/videoDriver/rc/fe/playback/PlaybackMixin
   * @alias module:nmodule/xprotect/rc/xprotect/XProtectVideoStream
   * @implements module:nmodule/videoDriver/rc/fe/playback/PlaybackController
   * @mixes module:nmodule/videoDriver/rc/live/VideoFeedMixin
   * @mixes module:nmodule/videoDriver/rc/fe/playback/PlaybackMixin
   * @mixes module:nmodule/videoDriver/rc/live/stream/StreamConfigurationMixin
   */
  var XProtectVideoStream = /*#__PURE__*/function (_BaseEditor) {
    function XProtectVideoStream() {
      var _this;
      _classCallCheck(this, XProtectVideoStream);
      _this = _callSuper(this, XProtectVideoStream, arguments);
      PlaybackMixin(_this);
      StreamConfigurationMixin(_this);
      VideoFeedMixin(_this);
      return _this;
    }

    /**
     * @param {JQuery} dom
     * @returns {Promise}
     */
    _inherits(XProtectVideoStream, _BaseEditor);
    return _createClass(XProtectVideoStream, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        dom.html(tpl());
        dom.addClass('XProtectVideoStream');
      }

      /**
       * @param {baja.Component} value - a `nvideo:VideoCamera` instance
       * @param {object} [params]
       * @param {boolean} [params.fullLoad] if true, the camera must be fully
       * connected, logged in, and streaming before `load()` will resolve.
       * Otherwise, the widget will show the connecting/logging-in process to the
       * user.
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(value) {
        var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          fullLoad = _ref.fullLoad;
        // don't wait for the camera to initialize - just kick it off. this will
        // allow the widget to display while the "connected" and "logged in"
        // status updates come through.
        var promise = this.$initializeCamera(value)["catch"](logSevere);
        this.$cameraInitialized = promise;
        if (fullLoad) {
          return promise;
        }
      }

      /**
       * Updates the dimensions of the video stream to match the dimensions of
       * the widget.
       */
    }, {
      key: "doLayout",
      value: function doLayout() {
        var camera = this.$camera;
        if (!camera) {
          return;
        }
        return camera.changeStream(this.$getFitDimensions(this.value()));
      }

      /**
       * Get a reference to the loaded XProtect camera and get it ready for
       * streaming.
       *
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$initializeCamera",
      value: function $initializeCamera(camera) {
        var _this2 = this;
        var cameraId = 0,
          cameraType = camera.getType();

        // Conditional check for camera id as
        // MilestoneCamera's id is stored in cameraGuid and
        // XProtectCamera's id is stored in cameraId.
        if (cameraType.is('nmilestone:MilestoneCamera')) {
          cameraId = camera.get('videoDeviceId').get('cameraGuid');
        } else if (cameraType.is('xprotect:XProtectCamera')) {
          cameraId = camera.get('videoDeviceId').get('cameraId');
        }
        return rpc.getConnectionParams(camera).then(function (_ref2) {
          var uri = _ref2.uri,
            username = _ref2.username,
            password = _ref2.password,
            authType = _ref2.authType;
          return XProtectSession.connect({
            url: uri,
            username: username,
            password: password,
            authType: authType,
            onStatusChanged: function onStatusChanged(status) {
              return _this2.$setVideoConnectionStatus(status);
            }
          });
        }).then(function (session) {
          var jq = _this2.jq();
          var canvas = jq.find('.canvasElement');
          var _this2$$getFitDimensi = _this2.$getFitDimensions(camera),
            width = _this2$$getFitDimensi.width,
            height = _this2$$getFitDimensi.height;
          var cameraSession = new XProtectCameraSession({
            session: session,
            cameraId: cameraId,
            streamProperties: {
              width: width,
              height: height,
              compressionLevel: _this2.$getCompression(),
              fps: _this2.$getFps(),
              pixelMultiplier: _this2.$getPixelMultiplier()
            }
          });
          cameraSession.on(XProtectCameraSession.TIMESTAMP_EVENT, function (timestamp) {
            _this2.$setVideoTimestamp(timestamp);
            //wait for the first timestamp update to know we are fully successful
            _this2.$setVideoConnectionStatus(XProtectSession.CONNECTION_SUCCESSFUL);
          });
          cameraSession.on(XProtectCameraSession.BANDWIDTH_EVENT, function (display) {
            return _this2.emit(BANDWIDTH_DISPLAY_CHANGE_EVENT, display);
          });
          _this2.$camera = new XProtectCamera({
            cameraSession: cameraSession,
            canvas: canvas
          });
        });
      }

      /**
       * Given the camera's preferred aspect ratio, get the correct dimensions to
       * initialize the camera stream to maximize the space in this widget's DOM
       * element.
       *
       * @private
       * @param {baja.Component} camera a `videoDriver:VideoCamera`
       * @returns {{width: number, height: number}}
       */
    }, {
      key: "$getFitDimensions",
      value: function $getFitDimensions(camera) {
        var jq = this.jq();
        var canvas = this.jq().find('.canvasElement');
        var aspectRatio = camera.get('videoPreferences').get('preferredAspectRatio');
        // a canvas won't scale down, which can inflate the calculated dimensions.
        // so hide it while we calculate.
        canvas.hide();

        // if css rules mean the dom has an area of 0, default to 320x240 so we
        // can display *something*
        var videoContainer = jq.closest('.videoContainer');
        var width = videoContainer.width() || jq.width() || 320;
        var height = videoContainer.height() || jq.height() || 240;
        canvas.show();
        return fitRatio(aspectRatio, {
          width: width,
          height: height
        });
      }
    }, {
      key: "$getFps",
      value: function $getFps() {
        var preferredFrameRate = this.$getPreference('preferredFrameRate');
        return getFps(preferredFrameRate);
      }
    }, {
      key: "$getCompression",
      value: function $getCompression() {
        var preferredCompression = this.$getPreference('preferredCompression');
        return getJpegCompressionLevel(preferredCompression);
      }
    }, {
      key: "$getPixelMultiplier",
      value: function $getPixelMultiplier() {
        var preferredResolution = this.$getPreference('preferredResolution');
        return getPixelMultiplier(preferredResolution);
      }
    }, {
      key: "$getPreference",
      value: function $getPreference(name) {
        var camera = this.value();
        return camera.get('videoPreferences').get(name);
      }

      /**
       * @returns {number}
       * @see module:nmodule/videoDriver/rc/live/VideoFeedMixin
       */
    }, {
      key: "getVideoTimestamp",
      value: function getVideoTimestamp() {
        return this.$lastTimestamp;
      }

      /**
       * Sets current video timestamp and emits `TIMESTAMP_CHANGED_EVENT`. Also
       * emits `STREAM_DATA_RECEIVED_EVENT` because in Milestone, every video
       * frame comes with a timestamp whether in playback mode or not.
       * @private
       * @param {number} timestamp
       */
    }, {
      key: "$setVideoTimestamp",
      value: function $setVideoTimestamp(timestamp) {
        this.$lastTimestamp = timestamp;
        this.emit(STREAM_DATA_RECEIVED_EVENT);
        this.emit(TIMESTAMP_CHANGED_EVENT);
      }

      /**
       * @returns {String}
       * @see module:nmodule/videoDriver/rc/live/VideoFeedMixin
       */
    }, {
      key: "getVideoConnectionStatus",
      value: function getVideoConnectionStatus() {
        return this.$videoConnectionStatus;
      }

      /**
       * Sets current connection status and fires `CONNECTION_STATUS_CHANGED_EVENT`
       * (possibly asynchronously).
       * @private
       * @param {String} status
       * @returns {Promise|*}
       */
    }, {
      key: "$setVideoConnectionStatus",
      value: function $setVideoConnectionStatus(status) {
        var _this3 = this;
        if (status === XProtectSession.READY_FOR_VIDEO) {
          return asyncUtils.waitInterval(CONNECTION_TIMEOUT_MILLIS).then(function () {
            if (!_this3.$lastTimestamp) {
              _this3.$setVideoConnectionStatus(XProtectSession.CONNECTION_TIMED_OUT);
            }
          });
        }
        this.$videoConnectionStatus = videoDriverLex.get(status);
        this.emit(CONNECTION_STATUS_CHANGED_EVENT);
      }

      /**
       * @returns {boolean}
       * @see module:nmodule/videoDriver/rc/live/VideoFeedMixin
       */
    }, {
      key: "isVideoStreaming",
      value: function isVideoStreaming() {
        return !!this.$lastTimestamp;
      }

      /**
       * Closes the camera connection.
       * @returns {*}
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        var camera = this.$camera;
        if (camera) {
          camera.destroy();
        }
        return this.getChildEditors().destroyAll();
      }

      /**
       * @returns {baja.Component} the currently loaded camera
       * @see module:nmodule/videoDriver/rc/fe/playback/PlaybackMixin
       */
    }, {
      key: "getCamera",
      value: function getCamera() {
        return this.value();
      }

      /**
       * Change the current playback type and speed.
       * @param {object} params
       * @param {string} [params.type] a `BPlaybackTypeEnum` tag
       * @param {number} [params.speed] playback speed, from 1 to 10
       * @see module:nmodule/videoDriver/rc/fe/playback/PlaybackMixin
       */
    }, {
      key: "doPlayback",
      value: function doPlayback(_ref3) {
        var _this4 = this;
        var type = _ref3.type,
          speed = _ref3.speed,
          timestamp = _ref3.timestamp;
        logFine("XProtectVideoStream#playback - type: ".concat(type, ", speed: ").concat(speed));
        this.$cameraInitialized.then(function () {
          var camera = _this4.$camera;
          if (type === 'live') {
            return camera.live();
          } else {
            return camera.play({
              speed: getPlaybackSpeedFactor(type, speed),
              timestamp: timestamp
            });
          }
        })["catch"](logSevere);
      }

      /**
       * @param {module:nmodule/videoDriver/rc/live/stream/StreamSettings} settings
       * @see module:nmodule/videoDriver/rc/live/stream/StreamConfigurationMixin
       */
    }, {
      key: "applyStreamSettings",
      value: function applyStreamSettings() {
        var _this5 = this;
        var settings = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        var preferredResolution = settings.preferredResolution,
          preferredFrameRate = settings.preferredFrameRate,
          preferredCompression = settings.preferredCompression;
        var streamProperties = {};
        if (isString(preferredResolution)) {
          streamProperties.pixelMultiplier = getPixelMultiplier(preferredResolution);
        }
        if (isString(preferredFrameRate)) {
          streamProperties.fps = getFps(preferredFrameRate);
        }
        if (isString(preferredCompression)) {
          streamProperties.compressionLevel = getJpegCompressionLevel(preferredCompression);
        }
        return this.$cameraInitialized.then(function () {
          var camera = _this5.$camera;
          return camera && camera.changeStream(streamProperties);
        });
      }
    }]);
  }(BaseEditor);
  return XProtectVideoStream;
});
