function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016, Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/bql/rc/fe/filter/NumericFilterEditor
 */
define(['baja!', 'baja!bql:FloatFilter,bql:DoubleFilter', 'lex!workbench', 'jquery', 'Promise', 'bajaux/events', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/NumericEditor', 'nmodule/webEditors/rc/fe/fe', 'bajaux/mixin/batchSaveMixin', 'bajaux/mixin/subscriberMixIn', 'nmodule/bql/rc/fe/filter/saveUtil', 'hbs!nmodule/bql/rc/fe/filter/templates/RangeFilterEditor', 'css!nmodule/bql/rc/bql'], function (baja, types, lexs, $, Promise, events, Widget, BaseEditor, NumericEditor, fe, batchSaveMixin, subscriberMixin, saveUtil, template) {
  "use strict";

  var MIN_FLAG_CLASS = "minFlag",
    MIN_VALUE_CLASS = "minValue",
    MAX_FLAG_CLASS = "maxFlag",
    MAX_VALUE_CLASS = "maxValue",
    MIN_FLAG_SELECTOR = "." + MIN_FLAG_CLASS,
    MIN_VALUE_SELECTOR = "." + MIN_VALUE_CLASS,
    MAX_FLAG_SELECTOR = "." + MAX_FLAG_CLASS,
    MAX_VALUE_SELECTOR = "." + MAX_VALUE_CLASS,
    ENABLE_EVENT = events.ENABLE_EVENT,
    DISABLE_EVENT = events.DISABLE_EVENT,
    MODIFY_EVENT = events.MODIFY_EVENT,
    INITIALIZE_EVENT = events.INITIALIZE_EVENT,
    LOAD_EVENT = events.LOAD_EVENT,
    READONLY_EVENT = events.READONLY_EVENT,
    WRITABLE_EVENT = events.WRITABLE_EVENT,
    DESTROY_EVENT = events.DESTROY_EVENT,
    lex = lexs[0],
    save = saveUtil.save;

  /**
   * Initializes the 'Min' Boolean editor
   * @param dom
   * @see module:nmodule/webEditors/rc/fe/baja/BooleanEditor
   * @returns {Promise} Promise resolved with the editor
   */
  function initMinFlagEditor(dom) {
    var text = lex.get('filter.min');
    return fe.buildFor({
      dom: $(MIN_FLAG_SELECTOR, dom),
      value: false,
      properties: {
        trueText: text,
        falseText: text
      },
      formFactor: 'mini'
    });
  }

  /**
   * Initializes the 'Min' value NumericEditor
   * @param dom
   * @see module:nmodule/webEditors/rc/fe/baja/NumericEditor
   * @returns {Promise} Promise resolved with the editor
   */
  function initMinValueEditor(dom) {
    return fe.buildFor({
      dom: $(MIN_VALUE_SELECTOR, dom),
      value: 0,
      type: NumericEditor,
      formFactor: 'mini',
      enabled: false
    });
  }

  /**
   * Initializes the 'Max' Boolean editor
   * @param dom
   * @see module:nmodule/webEditors/rc/fe/baja/BooleanEditor
   * @returns {Promise} Promise resolved with the editor
   */
  function initMaxFlagEditor(dom) {
    var text = lex.get('filter.max');
    return fe.buildFor({
      dom: $(MAX_FLAG_SELECTOR, dom),
      value: false,
      properties: {
        trueText: text,
        falseText: text
      },
      formFactor: 'mini'
    });
  }

  /**
   * Initializes the 'Max' value NumericEditor
   * @param dom
   * @see module:nmodule/webEditors/rc/fe/baja/NumericEditor
   * @returns {Promise} Promise resolved with the editor
   */
  function initMaxValueEditor(dom) {
    return fe.buildFor({
      dom: $(MAX_VALUE_SELECTOR, dom),
      value: 0,
      type: NumericEditor,
      formFactor: 'mini',
      enabled: false
    });
  }

  /**
   * NumericFilterEditor is a field editor for a bql:DoubleFilter/bql:FloatFilter instance
   * @class
   * @alias module:nmodule/bql/rc/fe/filter/NumericFilterEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   */
  var NumericFilterEditor = function NumericFilterEditor() {
    BaseEditor.apply(this, arguments);
    batchSaveMixin(this);
    subscriberMixin(this);
  };
  NumericFilterEditor.prototype = Object.create(BaseEditor.prototype);
  NumericFilterEditor.prototype.constructor = NumericFilterEditor;

  /**
   * Returns a reference to the BooleanEditor for the filter's 'minEnabled' property
   * @private
   * @returns {BooleanEditor} nmodule/webEditors/rc/fe/baja/BooleanEditor
   */
  NumericFilterEditor.prototype.$getMinFlag = function () {
    return Widget["in"](this.jq().find(MIN_FLAG_SELECTOR));
  };

  /**
   * Returns a reference to the NumericEditor for the filter's 'minValue' property
   * @private
   * @returns {NumericEditor} nmodule/webEditors/rc/fe/baja/NumericEditor
   */
  NumericFilterEditor.prototype.$getMinValue = function () {
    return Widget["in"](this.jq().find(MIN_VALUE_SELECTOR));
  };

  /**
   * Returns a reference to the BooleanEditor for the filter's 'maxEnabled' property
   * @private
   * @returns {BooleanEditor} nmodule/webEditors/rc/fe/baja/BooleanEditor
   */
  NumericFilterEditor.prototype.$getMaxFlag = function () {
    return Widget["in"](this.jq().find(MAX_FLAG_SELECTOR));
  };

  /**
   * Returns a reference to the NumericEditor for the filter's 'maxValue' property
   * @private
   * @returns {NumericEditor} nmodule/webEditors/rc/fe/baja/NumericEditor
   */
  NumericFilterEditor.prototype.$getMaxValue = function () {
    return Widget["in"](this.jq().find(MAX_VALUE_SELECTOR));
  };

  /**
   * Initializes the DOM with BooleanEditor fields for the filter's 'minEnabled' and 'maxEnabled' properties,
   * and NumericEditor fields for the filter's 'minValue' and 'maxValue' properties
   * @param dom The jQuery DOM element to be initialized
   * @see module:nmodule/webEditors/rc/fe/baja/NumericEditor
   * @see module:nmodule/webEditors/rc/fe/baja/BooleanEditor
   * @returns {Promise}
   */
  NumericFilterEditor.prototype.doInitialize = function (dom) {
    var that = this;
    dom.html(template({
      minFlag: MIN_FLAG_CLASS,
      minValue: MIN_VALUE_CLASS,
      maxFlag: MAX_FLAG_CLASS,
      maxValue: MAX_VALUE_CLASS
    }));
    dom.addClass("NumericFilterEditor");

    //prevent child editors from bubbling events
    dom.on([ENABLE_EVENT, DISABLE_EVENT, READONLY_EVENT, WRITABLE_EVENT, INITIALIZE_EVENT, LOAD_EVENT, DESTROY_EVENT].join(' '), MIN_FLAG_SELECTOR + "," + MIN_VALUE_SELECTOR + "," + MAX_FLAG_SELECTOR + "," + MAX_VALUE_SELECTOR, false);
    dom.on(MODIFY_EVENT, MIN_FLAG_SELECTOR + "," + MIN_VALUE_SELECTOR + "," + MAX_FLAG_SELECTOR + "," + MAX_VALUE_SELECTOR, function () {
      that.setModified(true);
      return false;
    });
    return Promise.all([initMinFlagEditor(dom), initMinValueEditor(dom), initMaxFlagEditor(dom), initMaxValueEditor(dom)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 4),
        minFlagEd = _ref2[0],
        minValueEd = _ref2[1],
        maxFlagEd = _ref2[2],
        maxValueEd = _ref2[3];
      minFlagEd.jq().on(MODIFY_EVENT, function () {
        minValueEd.setEnabled(minFlagEd.$getCheckbox().is(':checked'));
      });
      maxFlagEd.jq().on(MODIFY_EVENT, function () {
        maxValueEd.setEnabled(maxFlagEd.$getCheckbox().is(':checked'));
      });
    });
  };

  /**
   * Loads the editor with a bql:FloatFilter or bql:DoubleFilter
   * @param filter An instance of bql:FloatFilter or bql:DoubleFilter
   * @returns {Promise} Promise resolved when the editor has been loaded with the filter
   */
  NumericFilterEditor.prototype.doLoad = function (filter) {
    if (!(baja.hasType(filter, 'bql:FloatFilter') || baja.hasType(filter, 'bql:DoubleFilter'))) {
      return Promise.reject(new Error('editor must be loaded with bql:FloatFilter or bql:DoubleFilter'));
    }
    var minFlag = this.$getMinFlag(),
      minValue = this.$getMinValue(),
      maxFlag = this.$getMaxFlag(),
      maxValue = this.$getMaxValue();
    return Promise.all([minFlag.load(filter.getMinEnabled()), minValue.load(filter.getMinValue()), maxFlag.load(filter.getMaxEnabled()), maxValue.load(filter.getMaxValue())]).then(function () {
      minValue.setEnabled(filter.getMinEnabled());
      maxValue.setEnabled(filter.getMaxEnabled());
    });
  };

  /**
   * Reads the current value of the filter
   * @returns {Promise} Promise resolved with a new instance of a bql:FloatFilter or bql:DoubleFilter
   * with properties set to the values read from the corresponding editor fields.
   */
  NumericFilterEditor.prototype.doRead = function () {
    var that = this;
    return this.getChildEditors().readAll().then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 4),
        minEnabled = _ref4[0],
        minValue = _ref4[1],
        maxEnabled = _ref4[2],
        maxValue = _ref4[3];
      var isFloat = baja.hasType(that.value(), 'bql:FloatFilter');
      return baja.$(isFloat ? 'bql:FloatFilter' : 'bql:DoubleFilter', {
        minEnabled: minEnabled,
        minValue: minValue.valueOf(),
        maxEnabled: maxEnabled,
        maxValue: maxValue.valueOf()
      });
    });
  };

  /**
   * Saves the current editor values to the loaded filter
   * @param filter bql:FloatFilter or bql:DoubleFilter instance returned by NumericFilterEditor#read()
   * @param params Extra params passed to doSave()
   * @returns {Promise} Promise resolved with the filter initially loaded into the editor
   */
  NumericFilterEditor.prototype.doSave = function (filter, params) {
    return save(this, filter, params);
  };

  /**
   * Sets the child editors' readonly status
   * @param readonly Boolean flag indicating readonly status
   * @returns {Promise} Promise
   */
  NumericFilterEditor.prototype.doReadonly = function (readonly) {
    return this.getChildEditors().setAllReadonly(readonly);
  };

  /**
   * Sets the child editors' enabled status
   * @param enabled Boolean flag indicating enabled status
   * @returns {Promise} Promise
   */
  NumericFilterEditor.prototype.doEnabled = function (enabled) {
    var minFlag = this.$getMinFlag(),
      minValue = this.$getMinValue(),
      maxFlag = this.$getMaxFlag(),
      maxValue = this.$getMaxValue();
    return this.getChildEditors().setAllEnabled(enabled).then(function () {
      return Promise.all([minFlag.read(), maxFlag.read()]).then(function (_ref5) {
        var _ref6 = _slicedToArray(_ref5, 2),
          minEnabled = _ref6[0],
          maxEnabled = _ref6[1];
        return Promise.all([minValue.setEnabled(enabled && minEnabled), maxValue.setEnabled(enabled && maxEnabled)]);
      });
    });
  };

  /**
   * Destroys the child editors
   * @returns {Promise} Promise
   */
  NumericFilterEditor.prototype.doDestroy = function () {
    this.jq().removeClass('NumericFilterEditor');
    return this.getChildEditors().destroyAll();
  };
  return NumericFilterEditor;
});
