function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/bql/rc/fe/DynamicTimeRangeDialogEditor
 */
define(['baja!baja:AbsTime,baja:AbsTimeRange,baja:TimeRange,baja:Time,baja:Weekday,bql:DynamicTimeRangeType', 'hbs!nmodule/bql/rc/fe/dynamicTimeRangeDialogEditorStructure', 'lex!webEditors', 'bajaux/events', 'bajaux/Properties', 'bajaux/Widget', 'jquery', 'Promise', 'nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor', 'nmodule/webEditors/rc/fe/config/ComplexCompositeBuilder'], function (types, dynamicTimeRangeDialogEditorStructure, lexs, events, Properties, Widget, $, Promise, ComplexCompositeEditor, ComplexCompositeBuilder) {
  "use strict";

  var MODIFY_EVENT = events.MODIFY_EVENT,
    TIMEZONE_PROPERTY = "TimeZone";

  /**
   * A DynamicTimeRangeDialogEditor is the editor for bql:DynamicTimeRange.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/fe/bql/DynamicTimeRangeDialogEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor
   */

  var DynamicTimeRangeDialogEditor = function DynamicTimeRangeDialogEditor() {
    var that = this;
    ComplexCompositeEditor.apply(this, arguments);
    that.validators().add(function (diff) {
      var comp = that.value().newCopy();
      return diff.apply(comp).then(function () {
        return startBeforeEnd(comp);
      });
    });
  };
  DynamicTimeRangeDialogEditor.prototype = Object.create(ComplexCompositeEditor.prototype);
  DynamicTimeRangeDialogEditor.prototype.constructor = DynamicTimeRangeDialogEditor;

  /**
   * Return all the properties of the Custom Complex that allows editing of DynamicTimeRange
   * @returns {string[]}
   */
  DynamicTimeRangeDialogEditor.prototype.getSlotFilter = function () {
    return ['startFixed', 'startTime', 'endFixed', 'endTime'];
  };

  /**
   * Build the sub editor dom
   * @private
   * @returns {jQuery}
   */
  DynamicTimeRangeDialogEditor.prototype.$buildSubEditorDom = function (key) {
    return $('.js-' + key, this.jq());
  };

  /**
   * initialize the dom and register all event handlers
   * @param {jQuery} dom
   * @returns {Promise}
   */
  DynamicTimeRangeDialogEditor.prototype.doInitialize = function (dom) {
    var that = this,
      div = $("<div></div>");
    dom.on(MODIFY_EVENT, '.slot-startFixed, .slot-endFixed', function () {
      that.$checkTimeEditors();
    });
    div.html(dynamicTimeRangeDialogEditorStructure());
    that.jq().append(div);
    //doing this last allows squelching of the premature modify event
    return ComplexCompositeEditor.prototype.doInitialize.apply(this, arguments);
  };

  /**
   * Load the current value and setup any dependant slot interactions
   * @returns {Promise}
   * @param value {baja.Value}
   */
  DynamicTimeRangeDialogEditor.prototype.doLoad = function () {
    var that = this;
    return ComplexCompositeEditor.prototype.doLoad.apply(this, arguments).then(function () {
      return that.$checkTimeEditors();
    });
  };

  /**
   * Ensure that the value is valid time range
   * @inner
   * @param {baja.Component} value
   */
  function startBeforeEnd(value) {
    var startFixed = value.get("startFixed"),
      endFixed = value.get("endFixed"),
      startTime = value.get('startTime'),
      endTime = value.get('endTime');
    if (startFixed && endFixed && startTime.getJsDate().getTime() > endTime.getJsDate().getTime()) {
      throw new Error(lexs[0].get("AbsTimeRangeEditor.startAfterEnd"));
    }
  }

  /**
   * Return the Start Time editor.
   * @private
   * @returns {module:bajaux/Widget}
   */
  DynamicTimeRangeDialogEditor.prototype.$getStartTimeEditor = function () {
    return Widget["in"](this.jq().find('td.slot-startTime'));
  };

  /**
   * Return the End Time editor.
   * @private
   * @returns {module:bajaux/Widget}
   */
  DynamicTimeRangeDialogEditor.prototype.$getEndTimeEditor = function () {
    return Widget["in"](this.jq().find('td.slot-endTime'));
  };

  /**
   * Return the Start Fixed editor.
   * @private
   * @returns {module:bajaux/Widget}
   */
  DynamicTimeRangeDialogEditor.prototype.$getStartFixedEditor = function () {
    return Widget["in"](this.jq().find('td.slot-startFixed'));
  };

  /**
   * Return the End Fixed editor.
   * @private
   * @returns {module:bajaux/Widget}
   */
  DynamicTimeRangeDialogEditor.prototype.$getEndFixedEditor = function () {
    return Widget["in"](this.jq().find('td.slot-endFixed'));
  };
  DynamicTimeRangeDialogEditor.prototype.makeBuilder = function () {
    var that = this,
      builder = ComplexCompositeEditor.prototype.makeBuilder.call(that);
    builder.getConfigFor = function (key) {
      return ComplexCompositeBuilder.prototype.getConfigFor.call(builder, key).then(function (config) {
        if (key === "startTime" || key === "endTime") {
          config.properties = Properties.extend(config.properties, {
            TimeZone: that.properties().getValue(TIMEZONE_PROPERTY)
          });
        }
        return config;
      });
    };
    return builder;
  };

  /**
   * Setup any interdependency between the checkboxes and the other editors
   * @returns {Promise}
   */
  DynamicTimeRangeDialogEditor.prototype.$checkTimeEditors = function () {
    var that = this,
      startTimeEditor = that.$getStartTimeEditor(),
      endTimeEditor = that.$getEndTimeEditor(),
      startFixedEditor = that.$getStartFixedEditor(),
      endFixedEditor = that.$getEndFixedEditor();
    return Promise.all([startFixedEditor.read(), endFixedEditor.read()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        startEnabled = _ref2[0],
        endEnabled = _ref2[1];
      return Promise.all([startTimeEditor.setEnabled(startEnabled), endTimeEditor.setEnabled(endEnabled)]);
    });
  };
  return DynamicTimeRangeDialogEditor;
});
