function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/*eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/provisioningNiagara/rc/wb/jobBuilder/CheckedNavTree
 * @since Niagara 4.14
 */

define(['jquery', 'Promise', 'nmodule/webEditors/rc/wb/tree/NavTree'], function ($, Promise, NavTree) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-CheckedNavTree NavTree'
      }
    };
  };

  /**
   * @class
   * @alias module:nmodule/provisioningNiagara/rc/wb/jobBuilder/CheckedNavTree
   * @extends {module:nmodule/webEditors/rc/wb/tree/NavTree}
   */
  return /*#__PURE__*/function (_NavTree) {
    function CheckedNavTree(params) {
      _classCallCheck(this, CheckedNavTree);
      return _callSuper(this, CheckedNavTree, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }
    _inherits(CheckedNavTree, _NavTree);
    return _createClass(CheckedNavTree, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this = this;
        _superPropGet(CheckedNavTree, "doInitialize", this, 3)(arguments);
        var hideRoot = !!this.properties().getValue('hideRoot');
        // Prevents adding an empty checkbox if hideRoot = true
        if (!hideRoot) {
          // Add a checkbox to every node after the "expand" button
          var button = this.$getButton();
          var id = this.generateId();
          var displayLabel = this.$getDisplayElement();
          displayLabel.attr('for', id);
          $('<input type="checkbox" class="-t-CheckedNavTree-checkbox">').attr('id', id).insertAfter(button);
          dom.on('change', '.-t-CheckedNavTree-checkbox', function (e) {
            _this.$handleNodeChecked(e);
            return false;
          });
        }
      }
    }, {
      key: "doLoad",
      value: function doLoad(node) {
        var _this2 = this;
        return _superPropGet(CheckedNavTree, "doLoad", this, 3)(arguments).then(function () {
          return _this2.$expandAll();
        });
      }

      /**
       * @private
       * @returns {Promise} 
       */
    }, {
      key: "$expandAll",
      value: function $expandAll() {
        var _this3 = this;
        var node = this.value();
        if (!node.mayHaveKids()) {
          return;
        }
        return node.getKids().then(function (kids) {
          if (kids.length === 0) {
            return;
          }
          return Promise.all(kids.map(function (kid) {
            var kidTree = _this3.$getKidEditorFor(kid);
            return kidTree && kidTree.expand().then(function () {
              return kidTree.$expandAll();
            });
          }));
        });
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getCheckbox",
      value: function $getCheckbox() {
        return this.jq().children('.-t-CheckedNavTree-checkbox');
      }

      /**
       * @private
       * @param {Event} e 
       */
    }, {
      key: "$handleNodeChecked",
      value: function $handleNodeChecked(e) {
        var checked = e.currentTarget.checked;
        $(e.currentTarget).parent().find('.-t-CheckedNavTree-checkbox').prop('checked', checked);
      }

      /**
       * Toggles this node and {module:nmodule/provisioningNiagara/rc/wb/jobBuilder/CheckedNavTree~$handleNodeChecked} 
       * will toggle all the children.
       * @param {boolean} checked
       * @private
       */
    }, {
      key: "$toggle",
      value: function $toggle(checked) {
        var checkbox = this.$getCheckbox();
        checkbox.length === 1 && checkbox.prop('checked', checked);
      }

      /**
       * Recursively checks every node in the tree
       * @private
       */
    }, {
      key: "$checkAll",
      value: function $checkAll() {
        this.$toggle(true);
        var allKids = this.$getKids();
        allKids.forEach(function (kid) {
          return kid.$checkAll();
        });
      }

      /**
       * Recursively unchecks every node in the tree
       * @private
       */
    }, {
      key: "$uncheckAll",
      value: function $uncheckAll() {
        this.$toggle(false);
        var allKids = this.$getKids();
        allKids.forEach(function (kid) {
          return kid.$uncheckAll();
        });
      }
    }]);
  }(NavTree);
});
