function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/provisioningNiagara/rc/wb/fe/InstallCertEditor
 */

define(["baja!", 'baja!provisioningNiagara:InstallCertificatePolicyEnum', 'lex!provisioningNiagara', 'bajaux/spandrel', 'underscore', 'nmodule/platCrypto/rc/CertConstants', 'nmodule/platCrypto/rc/rpc/certManagement', 'nmodule/webEditors/rc/util/ListSelection', 'nmodule/platCrypto/rc/wb/cert/util/certColumns', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/table/model/Row', 'nmodule/webEditors/rc/wb/table/Table', 'nmodule/webEditors/rc/wb/table/model/TableModel'], function (baja, types, lexs, spandrel, _, CertConstants, certManagement, ListSelection, certColumns, Column, Row, Table, TableModel) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    provisioningNiagaraLex = _lexs[0];
  var INSTALL_UNIQUE_LABEL = provisioningNiagaraLex.get("InstallCertificateStepDialog.installUnique");
  var REPLACE_LABEL = provisioningNiagaraLex.get("InstallCertificateStepDialog.replace");
  var DONT_INSTALL_LABEL = provisioningNiagaraLex.get("InstallCertificateStepDialog.dontInstall");
  var ALIAS_EXISTS_LABEL = provisioningNiagaraLex.get("InstallCertificateStepDialog.ifAliasExists");
  var CERTIFICATES_LABEL = provisioningNiagaraLex.get("InstallCertificateStepDialog.label.certificates");
  var getStoreColumns = certColumns.getStoreColumns;
  var ICON_SECURITY_LOW = CertConstants.ICON_SECURITY_LOW,
    ICON_SECURITY_HIGH = CertConstants.ICON_SECURITY_HIGH,
    ICON_SECURITY_MEDIUM = CertConstants.ICON_SECURITY_MEDIUM,
    ICON_SECURITY_HIGH_PARTIAL_CHAIN = CertConstants.ICON_SECURITY_HIGH_PARTIAL_CHAIN;
  var getCertIcon = function getCertIcon(_ref) {
    var valid = _ref.valid,
      selfSigned = _ref.selfSigned,
      fullChain = _ref.fullChain;
    if (!valid) {
      return ICON_SECURITY_LOW;
    }
    if (!selfSigned) {
      if (fullChain) {
        return ICON_SECURITY_HIGH;
      } else {
        return ICON_SECURITY_HIGH_PARTIAL_CHAIN;
      }
    }
    return ICON_SECURITY_MEDIUM;
  };
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: "-t-InstallCertEditor"
      }
    };
  };

  /**
   * Editor for selecting certificate to install using provisioning job.
   *
   * @class
   * @alias module:nmodule/provisioningNiagara/rc/wb/fe/InstallCertEditor
   * @extends module:bajaux/Widget
   * @since Niagara 4.14
   */
  var InstallCertEditor = /*#__PURE__*/function (_spandrel) {
    function InstallCertEditor(params) {
      _classCallCheck(this, InstallCertEditor);
      return _callSuper(this, InstallCertEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     * Sets the selected item on the certificate table.
     * @param {Object} value
     * @returns {Promise}
     */
    _inherits(InstallCertEditor, _spandrel);
    return _createClass(InstallCertEditor, [{
      key: "doLoad",
      value: function doLoad(value) {
        var _this = this;
        return _superPropGet(InstallCertEditor, "doLoad", this, 3)(arguments).then(function () {
          var table = _this.$getCertsTable();
          var selection = table.$getSelection();
          selection.setExclusiveFilter(function () {
            return true;
          });
          var alias = _this.state().alias;
          var selectedIndex = _.findIndex(_this.$certs, {
            alias: alias
          });
          selection.select(selectedIndex !== -1 ? selectedIndex : 0);
        });
      }

      /**
       * @private
       * @param {Object} [params]
       * @param {String} [params.name] name of the radio button group
       * @param {String} [params.id] unique id for the input element
       * @param {String} [params.tag]
       * @param {String} [params.label] label to be shown for the radio button
       * @returns {Object}
       */
    }, {
      key: "$makeToggleButton",
      value: function $makeToggleButton(params) {
        var _this2 = this;
        var name = params.name,
          id = params.id,
          tag = params.tag,
          label = params.label;
        var _this$state = this.state(),
          replaceMethodTag = _this$state.replaceMethodTag;
        return spandrel.jsx("div", {
          className: "-t-InstallCertEditor-RadioButton"
        }, spandrel.jsx("input", {
          type: "radio",
          id: id,
          name: name,
          checked: replaceMethodTag === tag,
          onClick: function onClick() {
            return _this2.state({
              replaceMethodTag: tag
            });
          }
        }), spandrel.jsx("label", {
          "for": id
        }, label));
      }

      /**
       * @param {Object} value object format of step
       * @returns {Promise.<Object>}
       */
    }, {
      key: "toState",
      value: function toState(value) {
        var _this3 = this;
        return certManagement.getCertStoreData('userTrustStore').then(function (result) {
          _this3.$certs = result.certs || [];
          return {
            replaceMethodTag: value.installPolicy.getTag(),
            alias: value.alias
          };
        });
      }

      /**
       * @param {Object} state
       * @returns {Object}
       */
    }, {
      key: "fromState",
      value: function fromState(state) {
        var table = this.$getCertsTable();
        var selectedIdx = table.$getSelection().$anchor;
        return {
          alias: this.$certs[selectedIdx].alias,
          installPolicy: baja.$('provisioningNiagara:InstallCertificatePolicyEnum', state.replaceMethodTag)
        };
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/table/Table}
       */
    }, {
      key: "$getCertsTable",
      value: function $getCertsTable() {
        return this.queryWidget('InstallCertEditor-layout/**/table');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getRadioButtonGroup",
      value: function $getRadioButtonGroup() {
        return this.jq().find(".-t-InstallCertEditor-RadioButtonGroup");
      }
    }]);
  }(spandrel(function (value, _ref2) {
    var self = _ref2.self;
    var tableModel = new TableModel({
      columns: getStoreColumns(),
      rows: self.$certs.map(function (cert) {
        return new Row(cert, getCertIcon(cert));
      })
    });
    var name = self.generateId();
    var installUniqueId = self.generateId();
    var replaceId = self.generateId();
    var dontInstallId = self.generateId();
    return [spandrel.jsx("div", {
      className: "-t-InstallCertEditor-layout",
      spandrelKey: "InstallCertEditor-layout"
    }, spandrel.jsx("label", {
      className: "-t-InstallCertEditor-certificates-label"
    }, CERTIFICATES_LABEL, " "), spandrel.jsx(Table, {
      spandrelKey: "table",
      value: tableModel
    }), spandrel.jsx("label", {
      className: "-t-InstallCertEditor-replaceAlias"
    }, ALIAS_EXISTS_LABEL, " "), spandrel.jsx("div", {
      className: "-t-InstallCertEditor-RadioButtonGroup"
    }, self.$makeToggleButton({
      name: name,
      id: installUniqueId,
      tag: "installUnique",
      label: INSTALL_UNIQUE_LABEL
    }), self.$makeToggleButton({
      name: name,
      id: replaceId,
      tag: "replace",
      label: REPLACE_LABEL
    }), self.$makeToggleButton({
      name: name,
      id: dontInstallId,
      tag: "dontInstall",
      label: DONT_INSTALL_LABEL
    })))];
  }, {
    strategy: 'niagara'
  }));
  return InstallCertEditor;
});
