function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 * @author Sai Komaravolu
 */

define(['baja!', 'baja!batchJob:NetworkJobStage,provisioningNiagara:ForEachStationStage', 'Promise', 'underscore', 'nmodule/webEditors/rc/baja/PasswordStrength', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/servlets/resolveServerSide', 'nmodule/webEditors/rc/servlets/password'], function (baja, types, Promise, _, PasswordStrength, compUtils, resolveServerSide, password) {
  'use strict';

  /**
   * API Status: **Private**
   * @exports nmodule/provisioningNiagara/rc/util/provisioningNiagaraUtils
   * @since Niagara 4.14
   */
  var exports = {};
  var toObject = function toObject(object) {
    return compUtils.toObject(object, {
      copy: true
    });
  };

  /**
   * Adds the "initial" to the "stages" of provisioningNiagara:NiagaraNetworkJob
   *
   * @param {baja.Component} niagaraNetworkJob
   * @returns {Promise}
   */
  exports.initInitialStage = function (niagaraNetworkJob) {
    var stages = niagaraNetworkJob.get('stages');
    if (stages.get('initial')) {
      return Promise.resolve();
    }
    return stages.add({
      slot: 'initial',
      value: baja.$('batchJob:NetworkJobStage')
    });
  };

  /**
   * Adds the "forEachStation" to the "stages" of provisioningNiagara:NiagaraNetworkJobPrototype
   *
   * @param {baja.Component} niagaraNetworkJobPrototype
   * @returns {Promise}
   */
  exports.initForEachStationStage = function (niagaraNetworkJobPrototype) {
    var stages = niagaraNetworkJobPrototype.get('stages');
    if (stages.get('forEachStation')) {
      return Promise.resolve();
    }
    return stages.add({
      slot: 'forEachStation',
      value: baja.$('provisioningNiagara:ForEachStationStage')
    });
  };

  /**
   * @param {baja.Component} niagaraNetworkJobPrototype
   * @returns {Promise}
   */
  exports.initStages = function (niagaraNetworkJobPrototype) {
    return Promise.all([exports.initInitialStage(niagaraNetworkJobPrototype), exports.initForEachStationStage(niagaraNetworkJobPrototype)]);
  };

  /**
   * Will do a clean slate and saves array of batchJob:JobStep,
   * to the initial or forEachStation stage of the NiagaraNetworkJob
   *
   * @param {Array.<baja.Component>} stepsArray
   * @param {baja.Component} jobStage
   * @returns {Promise}
   */
  exports.saveStepsToStage = function (stepsArray, jobStage) {
    var steps = jobStage.get('steps');
    return Promise.all(steps.getSlots().toArray().map(function (slot) {
      return steps.remove(slot);
    })).then(function () {
      return Promise.all(stepsArray.map(function (step) {
        return steps.add({
          slot: 'step?',
          value: step
        });
      }));
    });
  };

  /**
   * Save the JobSteps to initial and forEachStation folders.
   *
   * @param {Array.<baja.Component>}stepsArray
   * @param {baja.Component} jobPrototype
   * @return {Promise.<Array.<baja:Component>>}
   */
  exports.saveStepsToJob = function (stepsArray, jobPrototype) {
    var initStages = exports.initStages,
      $addStepsToStagesAndReorder = exports.$addStepsToStagesAndReorder,
      $removeStepsFromStages = exports.$removeStepsFromStages;
    var $makeStageObject = function $makeStageObject(oldSteps, newSteps, stage) {
      return {
        oldSteps: oldSteps,
        newSteps: newSteps,
        stage: stage
      };
    };
    return initStages(jobPrototype).then(function () {
      var stages = jobPrototype.get('stages'),
        initialStage = stages.get('initial'),
        forEachStationStage = stages.get('forEachStation'),
        newInitialStageArray = [],
        newStationStageArray = [];

      //Prepare old steps and new steps with corresponding job step types
      stepsArray.forEach(function (jobStep) {
        if (baja.hasType(jobStep, 'batchJob:NetworkJobStep')) {
          newInitialStageArray.push(jobStep);
        } else if (baja.hasType(jobStep, 'batchJob:DeviceJobStep')) {
          newStationStageArray.push(jobStep);
        }
      });
      var oldInitialStageArray = initialStage.get('steps').getSlots().toValueArray(),
        oldStationStageArray = forEachStationStage.get('steps').getSlots().toValueArray();

      //Remove steps and add-reorder steps
      var initialStageObject = $makeStageObject(oldInitialStageArray, newInitialStageArray, initialStage);
      var stationStageObject = $makeStageObject(oldStationStageArray, newStationStageArray, forEachStationStage);
      //Remove the steps first, later add and reorder steps
      return $removeStepsFromStages([initialStageObject, stationStageObject]).then(function () {
        return $addStepsToStagesAndReorder([initialStageObject, stationStageObject]);
      });
    });
  };

  /**
   * @private
   * @param {Array.<{oldSteps: Array.<baja.Component>, newSteps: Array.<baja.Component>, stage: baja.Component}>} stageObjectArray
   * @returns {Promise}
   */
  exports.$addStepsToStagesAndReorder = function (stageObjectArray) {
    return Promise.all(stageObjectArray.map(function (stageObject) {
      var oldSteps = stageObject.oldSteps,
        newSteps = stageObject.newSteps,
        stage = stageObject.stage;
      var steps = stage.get('steps');
      return Promise.all(newSteps.map(function (step) {
        if (oldSteps.includes(step)) {
          return Promise.resolve(step.getPropertyInParent());
        } else {
          return steps.add({
            slot: 'step?',
            value: step
          });
        }
      })).then(function (dynamicProperties) {
        return exports.$reorderJobStepsInStages(dynamicProperties, stage);
      });
    }));
  };

  /**
   * @private
   * @param {Array.<{oldSteps: Array.<baja.Component>, newSteps: Array.<baja.Component>, stage: baja.Component}>} stageObjectArray
   * @returns {Promise}
   */
  exports.$removeStepsFromStages = function (stageObjectArray) {
    return Promise.all(stageObjectArray.map(function (stageObject) {
      var oldSteps = stageObject.oldSteps,
        newSteps = stageObject.newSteps,
        stage = stageObject.stage;
      var steps = stage.get('steps');
      return Promise.all(oldSteps.map(function (oldStep) {
        if (!newSteps.includes(oldStep)) {
          return steps.remove(oldStep);
        }
      }));
    }));
  };

  /**
   * @private
   * @param {Array.<baja.Property>} dynamicProperties
   * @param {baja.Component} jobStage
   * @returns {Promise}
   */
  exports.$reorderJobStepsInStages = function (dynamicProperties, jobStage) {
    if (!dynamicProperties.length) {
      return Promise.resolve();
    }
    return jobStage.get('steps').reorder(dynamicProperties);
  };

  /**
   *
   * @param {module:nmodule/batchJob/rc/baja/ValueList} devices
   * @param {baja.Component} jobPrototype
   * @returns {Promise}
   */
  exports.saveStationsToJob = function (devices, jobPrototype) {
    return jobPrototype.set({
      slot: 'devicesToProcess',
      value: devices
    });
  };

  /**
   * Check to see if a parent child combination is legal based on types. Any results are memoized.
   * @param {String|Type} parentType
   * @param {String|Type} childType
   * @returns {Promise}
   */
  exports.isParentLegal = function (parentType, childType) {
    return exports.$isParentLegal(parentType, childType);
  };

  /**
   * @private
   */
  exports.$isParentLegal = _.memoize(function (parentType, childType) {
    return baja.importTypes([parentType.toString(), childType.toString()]).then(function () {
      return resolveServerSide.isParentLegal(baja.$(parentType), baja.$(childType));
    });
  }, function (parentType, childType) {
    return parentType.toString() + childType.toString();
  });

  /**
   * Checks if the value is compatible for the `propertyType`, if it is not, then returns
   * a new instance of the `propertyType`.
   * @param {baja.Value} value
   * @param {baja.DefaultSimple} propertyType a `baja:TypeSpec`.
   * @returns {baja.Value}
   */
  exports.getCompatibleValueForSetProperty = function (value, propertyType) {
    if (value.getType().toString() !== propertyType.valueOf()) {
      if (value.getType().toString() === 'baja:UnrestrictedFolder' && baja.lt(propertyType).isComponent() && value.getType().isComponent() && sameProperties(value, propertyType)) {
        value = baja.$(propertyType, toObject(value));
      } else {
        value = baja.$(propertyType);
      }
    }
    return value;
  };
  function sameProperties(value, propertyType) {
    var a = value.getSlots().properties().toArray().map(function (slot) {
      return slot.getName();
    }).join(';');
    var b = baja.$(propertyType.valueOf()).getSlots().properties().toArray().map(function (slot) {
      return slot.getName();
    }).join(';');
    return a === b;
  }

  // region password support

  /**
   * @param {boolean} isFips
   * @returns {Promise<baja.Struct>}
   */
  function getPasswordStrengthFromRpc(isFips) {
    return password.getPasswordStrength(isFips);
  }

  /**
   * @param {string} encodedPasswordStrength
   * @returns {Promise.<baja.Component>}
   */
  function decodePasswordStrength(encodedPasswordStrength) {
    return baja.bson.decodeAsync(JSON.parse(encodedPasswordStrength)).then(function (passwordStrength) {
      if (passwordStrength instanceof PasswordStrength) {
        return passwordStrength;
      }
      return baja.$('baja:PasswordStrength');
    });
  }

  /**
   * Calls the password strength RPC and return the default and FIPS password strengths
   * @returns {Promise<Object>} An object that contains the password strengths in this format
   * {defaultPasswordStrength: <module:nmodule/webEditors/rc/baja/PasswordStrength>, fipsPasswordStrength: <module:nmodule/webEditors/rc/baja/PasswordStrength>}
   */
  function callPasswordStrengthsRpc() {
    return Promise.all([getPasswordStrengthFromRpc(false), getPasswordStrengthFromRpc(true)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        encodedDefaultPasswordStrength = _ref2[0],
        encodedFipsPasswordStrength = _ref2[1];
      return Promise.all([decodePasswordStrength(encodedDefaultPasswordStrength), decodePasswordStrength(encodedFipsPasswordStrength)]);
    }).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 2),
        encodedDefaultPasswordStrength = _ref4[0],
        encodedFipsPasswordStrength = _ref4[1];
      return {
        defaultPasswordStrength: encodedDefaultPasswordStrength,
        fipsPasswordStrength: encodedFipsPasswordStrength
      };
    });
  }

  /**
   * Returns both the default and FIPS password strengths for validation
   * @returns {Promise<Object>} An object that contains the password strengths in this format
   * {defaultPasswordStrength: <module:nmodule/webEditors/rc/baja/PasswordStrength>, fipsPasswordStrength: <module:nmodule/webEditors/rc/baja/PasswordStrength>}
   */
  exports.getPasswordStrengths = _.once(callPasswordStrengthsRpc);

  /**
   * Validates a password to make sure it meets the strength rules
   * @param {module:nmodule/webEditors/rc/baja/PasswordStrength} password the password to validate
   * @param {Boolean} validateFips should this be validated agains fips
   * @returns {Promise} promise to be resolved if password is valid.
   * If rejected, it will be rejected with an array of error strings describing
   * the `PasswordStrength` configuration. Join the array, map to divs,
   * whatever your app needs.
   */
  exports.validatePasswordStrength = function (password, validateFips) {
    return exports.getPasswordStrengths().then(function (_ref5) {
      var defaultPasswordStrength = _ref5.defaultPasswordStrength,
        fipsPasswordStrength = _ref5.fipsPasswordStrength;
      if (validateFips) {
        return fipsPasswordStrength.validatePassword(password.valueOf());
      }
      return defaultPasswordStrength.validatePassword(password.valueOf());
    });
  };

  // endregion password support

  return exports;
});
