function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/provisioningNiagara/rc/baja/RobotStepFactory
 */

define(['baja!', 'baja!provisioningNiagara:RobotJobStep,provisioningNiagara:RobotStepFactory', 'lex!provisioningNiagara', 'nmodule/batchJob/rc/baja/UxJobStepFactory', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/links/OrdChooser'], function (baja, types, lexs, UxJobStepFactory, feDialogs, OrdChooser) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    provisioningNiagaraLex = _lexs[0];

  /**
   * A 'provisioningNiagara:RobotJobStep' factory implementation
   * @since Niagara 4.14
   * @class
   * @alias module:nmodule/provisioningNiagara/rc/baja/RobotStepFactory
   * @extends module:nmodule/batchJob/rc/baja/UxJobStepFactory
   */
  return /*#__PURE__*/function (_UxJobStepFactory) {
    function RobotStepFactory() {
      _classCallCheck(this, RobotStepFactory);
      return _callSuper(this, RobotStepFactory, [{
        module: 'provisioningNiagara',
        lex: 'RobotStepFactory'
      }]);
    }

    /**
     * Resolves to a 'provisioningNiagara:RobotJobStep'
     * @param {Object} params the parameters passed to the makeStep function\
     * @returns {Promise.<baja.Component|undefined>}
     */
    _inherits(RobotStepFactory, _UxJobStepFactory);
    return _createClass(RobotStepFactory, [{
      key: "makeStep",
      value: function makeStep(params) {
        return this.$makeStep();
      }

      /**
       * Edits a 'provisioningNiagara:FileCopyStep' and resolves to a new step value
       * @param {Object} params
       * @param {baja.Component} params.step an instance of 'provisioningNiagara:RemovePlatformUserStep'
       * @returns {Promise<baja.Component|undefined>}
       */
    }, {
      key: "editStep",
      value: function editStep(_ref) {
        var step = _ref.step;
        var values = {
          robotOrd: step.get('robotOrd')
        };
        return this.$makeStep(values);
      }

      /**
       * Prompts the user for the necessary provisioning robot and uses that ord to make a new step
       * of the type specified by the implementing class
       * @private
       * @param {Object} values
       */
    }, {
      key: "$makeStep",
      value: function $makeStep(values) {
        values = values || {};
        var robotOrd = values.robotOrd || baja.Ord.make();
        return this.$selectOrd(robotOrd).then(function (newOrd) {
          if (!newOrd || newOrd.isNull()) {
            return;
          }
          var step = baja.$('provisioningNiagara:RobotJobStep');
          step.setFactoryType(baja.$('baja:TypeSpec', 'provisioningNiagara:RobotStepFactory'));
          step.setRobotOrd(newOrd);
          return step;
        });
      }

      /**
       * Allows the user to select the template file they want
       * @private
       * @param {baja.Ord} ord the starting ord
       * @returns {Promise<baja.Ord>}
       */
    }, {
      key: "$selectOrd",
      value: function $selectOrd(ord) {
        var _this = this;
        return feDialogs.showFor({
          title: provisioningNiagaraLex.get('RobotStepFactory.displayName'),
          summary: provisioningNiagaraLex.get('RobotStepFactory.description'),
          value: ord,
          type: OrdChooser,
          formFactor: 'compact',
          properties: {
            selectFilter: function selectFilter(selected) {
              return _this.$selectFilter(selected);
            },
            rootNode: 'station:|slot:',
            forceOrdType: 'handle'
          }
        });
      }
    }, {
      key: "$selectFilter",
      value: function $selectFilter(selected) {
        if (!selected || selected.isNull()) {
          throw new Error(provisioningNiagaraLex.get('RobotJobStep.chooser.error'));
        }
        return selected.resolve({
          base: baja.station
        }).then(function (target) {
          var targetObj = target.getObject();
          var isComponentSelected = baja.hasType(targetObj, 'baja:Component');
          if (!isComponentSelected || targetObj.getType().getTypeSpec() !== 'provisioningNiagara:ProvisioningRobot') {
            throw new Error(provisioningNiagaraLex.get('RobotJobStep.chooser.error'));
          }
        });
      }
    }]);
  }(UxJobStepFactory);
});
